﻿Copyright (c) (2014) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Fluke 190II 4Ch (1yr) VER RS-232 /5502,O_CAL+VID+WG
DATE:                  2014-09-02 08:28:33
AUTHOR:                Fluke
REVISION:              $Revision: 8725 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       260
CONFIGURATION:         Fluke 5502A
CONFIGURATION:         Fluke Ocal (600MHz,VID,WG)
=============================================================================
#
#  Procedure Author:
#        VY, CAD, DAC
#
#  This procedure contains tests whose Test Uncertainty Ratios are less
#  than 4:1, based on 5520A (1 year) specifications.
#
#        AC VOLTAGE ACCURACY (HF) & BANDWIDTH TEST
#               900 mV @ 1 MHz;    TUR 2.0566
#
#  Source:
#        Fluke 190 Series II ScopeMeter®
#          190-062, 190-102, 190-202, 190-104, 190-204
#          Service Manual PN 4822 872 05405, July 2011, Rev. 4, March 2013
#
#        Tektronix THS3000 Series Oscilloscopes
#          Performance Verification and Adjustments
#          Technical Reference
#          077-0606-00
#
#  Compatibility:
#        MET/CAL 8.1.4 or later
#
#  Required Equipment:
#        Adapter, dual banana plug to BNC(f), Pomona 1269
#        Adapter, dual BNC(f) to BNC(m), Fluke PM 9093, 3 ea
#        Termination, feedthrough, BNC, 50 Ω, Fluke PM 9585
#        Cable, 50 Ω, BNC(m)-(m), Pomona 2249-C-6, 1 ea.
#        Cable, USB Type A (Host) to USB MINI Type B (Device)
#
#        Accessories supplied with UUT
#        - Power Adapter, 119-7900-00
#        - THS0301 Voltage Probe (200 MHz, 10:1), any color
#
# This procedure is intended for use with MET/CAL® calibration software;
# the terms and conditions set forth in your MET/CAL license apply to this
# procedure.
#
# Due to Fluke's policy of continuously updating our products, this procedure
# may contain minor differences in methods used and/or specifications to
# those found in the manual or other documentation. While every effort has
# been made to ensure that this procedure is accurate, Fluke cannot be held
# responsible for the consequences of error or omissions found within this
# procedure.
#
# The copyright in this procedure is owned by Fluke Corporation.
#
#  Global String Variables
#        @ModelNum       - Model number
#        @Manufacturer   - Manufacturer's name
#        @FirmwareRev    - Firmware version
#        @FirmwareDate   - Firmware date
#        @ErrorMsg       - Message of error
#        @MeasMode       - Guardbanding method used
#        @Chan           - Name of Channel under tested
#        @Input          - Name of Channel calibrator input connected
#        @BW_Setup       - Channel bandwidth limit setup
#        @Cmd            - Command string sent to UUT
#        @Range          - Channel Scope range
#        @Reading        - Channel reading type
#        @Timebase       - UUT timebase setting
#        @HPos           - UUT horizontal (Trigger) position
#        @Nominal        - Nominal value of test
#
#  Global String Variables:
#        @Wait           - Measurement delay value (seconds)
#        @Bandwidth      - UUT ScopeMeter Bandwidth (60, 100, 200 or 500 MHz)
#        @NumChan        - Number of Scope Channel of UUT
#        @BitNum         - Bit number of status byte to be checked
#        @Status         - Status byte of one instrument status returned
#        @Error          - Flag of error status
#        @Abort          - Flag of status whether the procedure is aborted
#        @DC_Coupling    - Channel coupling mode (1 = DC, 0 = AC)
#        @SysAcc         - System accuracy
#        @VertDiv        - Vertical division value of test signal
#        @Ampl           - Amplitude value of test signal
#        @Freq           - Frequency value of test signal
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  5502A        Reset
  1.003  O_CAL        Mode = LeveledSine
  1.003  O_CAL        +Frequency = 600 MHz; Voltage = 600 mVpp;
  1.004  O_CAL        Mode = WaveGen; Waveform = Sine; OutputImp = 1 MOhm
  1.004  O_CAL        +Frequency = 16.00 Hz; Voltage = 600 mVpp
  1.005  O_CAL        Mode = Video; Format = NTSC; Field = Even
  1.005  O_CAL        +Amplitude = +100 %; LineMarker = 262
  1.006  ENDIF

  1.007  ASK-   R   Q N              P J                          F        V

  1.008  IF           NOT(VERSIONCHECK("8.1.4"))
  1.009  END
  1.010  ENDIF

  1.011  CALL         Sub Display Copyright
  1.012  CALL         Sub High Voltage Safety Warning
  1.013  CALL         Sub Fluke 190II Connection RS-232 /USB
  1.014  JMPL         END                          @Abort

# Setup UUT RS232 communication.
  1.015  LABEL        RS232_SETUP
  1.016  PORT         [CLR][REOPEN][P1200,N,8,1,X]

  1.017  HEAD         UUT IDENTIFICATION
  1.018  CALL         Sub Fluke ScopeMeter Query Identification RS-232
  1.019  CALL         Sub IEEE-488.2 Identification Query Check Response
  1.020  JMPL         END                          @Abort
  1.021  CALL         Sub Fluke 190II Check Firmware Revision
  1.022  JMPL         END                          @Abort

  1.023  CALL         Sub Fluke 190II Preliminary Instructions
  1.024  CALL         Sub Fluke 190II Get Bandwidth & Number of Channels

  1.025  HEAD         INITIAL INFORMATION
  1.026  CALL         Sub Select Failed Test Mode
  1.027  CALL         Sub Select Guardbanding & Ver Method (No NTHROW)

  1.028  HEAD         TEST CONDITIONS
  1.029  DISP         - Warm-up time requirement: 30 minutes
  1.029  DISP         - Ambient temperature:      18 °C to 28 °C.
  1.029  DISP         - Relative humidity:        less than 90 %.

  1.030  CALL         Sub Fluke 190II VER Required Equipment
  1.031  CALL         Sub Fluke ScopeMeter Display Tests RS-232

  1.032  MATH         @Chan = "A"
  1.033  CALL         Sub Fluke 190II (1 yr) Vertical Acc VER RS-232 /5502
  1.034  MATH         @Chan = "B"
  1.035  CALL         Sub Fluke 190II (1 yr) Vertical Acc VER RS-232 /5502
  1.036  MATH         @Chan = "C"
  1.037  CALL         Sub Fluke 190II (1 yr) Vertical Acc VER RS-232 /5502
  1.038  MATH         @Chan = "D"
  1.039  CALL         Sub Fluke 190II (1 yr) Vertical Acc VER RS-232 /5502

  1.040  MATH         @Chan = "A"
  1.041  CALL         Sub Fluke 190II (1 yr) DCV Acc VER RS-232 /5502
  1.042  MATH         @Chan = "B"
  1.043  CALL         Sub Fluke 190II (1 yr) DCV Acc VER RS-232 /5502
  1.044  MATH         @Chan = "C"
  1.045  CALL         Sub Fluke 190II (1 yr) DCV Acc VER RS-232 /5502
  1.046  MATH         @Chan = "D"
  1.047  CALL         Sub Fluke 190II (1 yr) DCV Acc VER RS-232 /5502

  1.048  MATH         @Chan = "A"
  1.049  CALL         Sub Fluke 190II (1 yr) ACV DC Coup Acc VER RS-232 /5502
  1.050  MATH         @Chan = "B"
  1.051  CALL         Sub Fluke 190II (1 yr) ACV DC Coup Acc VER RS-232 /5502
  1.052  MATH         @Chan = "C"
  1.053  CALL         Sub Fluke 190II (1 yr) ACV DC Coup Acc VER RS-232 /5502
  1.054  MATH         @Chan = "D"
  1.055  CALL         Sub Fluke 190II (1 yr) ACV DC Coup Acc VER RS-232 /5502

  1.056  MATH         @Chan = "A"
  1.057  CALL         Sub Fluke 190II (1 yr) ACV AC Coup Acc VER RS-232 /5502
  1.058  MATH         @Chan = "B"
  1.059  CALL         Sub Fluke 190II (1 yr) ACV AC Coup Acc VER RS-232 /5502
  1.060  MATH         @Chan = "C"
  1.061  CALL         Sub Fluke 190II (1 yr) ACV AC Coup Acc VER RS-232 /5502
  1.062  MATH         @Chan = "D"
  1.063  CALL         Sub Fluke 190II (1 yr) ACV AC Coup Acc VER RS-232 /5502

  1.064  MATH         @Chan = "A"
  1.065  CALL         Sub Fluke 190II (1 yr) V Peak Meas VER RS-232 /5502
  1.066  MATH         @Chan = "B"
  1.067  CALL         Sub Fluke 190II (1 yr) V Peak Meas VER RS-232 /5502
  1.068  MATH         @Chan = "C"
  1.069  CALL         Sub Fluke 190II (1 yr) V Peak Meas VER RS-232 /5502
  1.070  MATH         @Chan = "D"
  1.071  CALL         Sub Fluke 190II (1 yr) V Peak Meas VER RS-232 /5502

  1.072  MATH         @Chan = "A"
  1.073  CALL         Sub Fluke 190II (1 yr) Freq Meas VER RS-232 /O_CAL+WG
  1.074  MATH         @Chan = "B"
  1.075  CALL         Sub Fluke 190II (1 yr) Freq Meas VER RS-232 /O_CAL+WG
  1.076  MATH         @Chan = "C"
  1.077  CALL         Sub Fluke 190II (1 yr) Freq Meas VER RS-232 /O_CAL+WG
  1.078  MATH         @Chan = "D"
  1.079  CALL         Sub Fluke 190II (1 yr) Freq Meas VER RS-232 /O_CAL+WG

  1.080  MATH         @Chan = "A"
  1.081  CALL         Sub Fluke 190II (1 yr) Phase Meas VER RS-232 /O_CAL+WG
  1.082  MATH         @Chan = "B"
  1.083  CALL         Sub Fluke 190II (1 yr) Phase Meas VER RS-232 /O_CAL+WG
  1.084  MATH         @Chan = "C"
  1.085  CALL         Sub Fluke 190II (1 yr) Phase Meas VER RS-232 /O_CAL+WG
  1.086  MATH         @Chan = "D"
  1.087  CALL         Sub Fluke 190II (1 yr) Phase Meas VER RS-232 /O_CAL+WG

  1.088  MATH         @Chan = "A"
  1.089  CALL         Sub Fluke 190II (1 yr) A Time Base VER RS-232 /O_CAL

  1.090  MATH         @Chan = "A"
  1.091  CALL         Sub Fluke 190II (1 yr) Trigger Sens VER RS-232 /O_CAL
  1.092  JMPL         BANDWIDTH_A

  1.093  LABEL        TRIG_SENS_B
  1.094  MATH         @Chan = "B"
  1.095  CALL         Sub Fluke 190II (1 yr) Trigger Sens VER RS-232 /O_CAL
  1.096  JMPL         BANDWIDTH_B

  1.097  LABEL        TRIG_SENS_C
  1.098  MATH         @Chan = "C"
  1.099  CALL         Sub Fluke 190II (1 yr) Trigger Sens VER RS-232 /O_CAL
  1.100  JMPL         BANDWIDTH_C

  1.101  LABEL        TRIG_SENS_D
  1.102  MATH         @Chan = "D"
  1.103  CALL         Sub Fluke 190II (1 yr) Trigger Sens VER RS-232 /O_CAL
  1.104  JMPL         BANDWIDTH_D

  1.105  LABEL        BANDWIDTH_A
  1.106  MATH         @Chan = "A"
  1.107  CALL         Sub Fluke 190II (1 yr) Bandwidth VER RS-232 /O_CAL
  1.108  JMPL         A_VIDEO

  1.109  LABEL        BANDWIDTH_B
  1.110  MATH         @Chan = "B"
  1.111  CALL         Sub Fluke 190II (1 yr) Bandwidth VER RS-232 /O_CAL
  1.112  JMPL         TRIG_SENS_C

  1.113  LABEL        BANDWIDTH_C
  1.114  MATH         @Chan = "C"
  1.115  CALL         Sub Fluke 190II (1 yr) Bandwidth VER RS-232 /O_CAL
  1.116  JMPL         TRIG_SENS_D

  1.117  LABEL        BANDWIDTH_D
  1.118  MATH         @Chan = "D"
  1.119  CALL         Sub Fluke 190II (1 yr) Bandwidth VER RS-232 /O_CAL
  1.120  JMPL         PROBE

  1.121  LABEL        A_VIDEO
  1.122  MATH         @Chan = "A"
  1.123  CALL         Sub Fluke 190II (1 yr) A Video VER RS-232 /O_CAL+VID
  1.124  JMPL         TRIG_SENS_B

  1.125  LABEL        PROBE
  1.126  CALL         Sub Fluke 190II Probe VER RS-232

  1.127  LABEL        END

  1.128  IF           @Abort
  1.129  RSLT         =
  1.130  HEAD         {V E R I F I C A T I O N   A B O R T E D !}
  1.131  ENDIF

  1.132  END
