﻿Copyright (c) (2016) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 190II Check Firmware Revision
DATE:                  2016-05-09 13:11:32
AUTHOR:                Fluke
REVISION:              $Revision: 15955 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       82
=============================================================================
#
#  Procedure Author:
#        VY
#
#  Source:
#        Fluke 190 Series II ScopeMeter®
#          190-062, 190-102, 190-202, 190-104, 190-204
#          Service Manual PN 4822 872 05405, February 2013, Rev. 2, 2/15
#
#        Tektronix THS3000 Series Oscilloscopes
#          Performance Verification and Adjustments
#          Technical Reference
#          077-0606-00
#
#  Compatibilty:
#        MET/CAL 8.0 or later
#
# This procedure is intended for use with MET/CAL® calibration software; the
# terms and conditions set forth in your MET/CAL license apply to this
# procedure.
#
# Due to Fluke's policy of continuously updating our products, this procedure
# may contain minor differences in methods used and/or specifications to
# those found in the manual or other documentation. While every effort has
# been made to ensure that this procedure is accurate, Fluke cannot be held
# responsible for the consequences of error or omissions found within this
# procedure.
#
# The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

# Firmware revision strings have the following forms:
# Released:     Vxx.xx
# Demo:         Dxx.xx.xxxx
# Preliminary:  Pxx.xx.xxxx

  1.001  MATH         @Abort = (LEN(@FirmwareRev) < 6)

  1.002  IF           @Abort
  1.003  DISP         Cannot extract firmware revision from returned string:
  1.003  DISP         "[V @FirmwareRev]"
  1.004  END
  1.005  ENDIF

  1.006  MATH         Prefix       = SUB(@FirmwareRev, 1, 1)
  1.007  MATH         @FirmwareNum = SUB(@FirmwareRev, 2, 5)

# The released firmware version of 190 series II starts from V09.00.
  1.008  IF           ZCMPI(Prefix, "V")
  1.009  MATH         @Abort = (@FirmwareNum < 9.0)

# Only demo revisions D09.00.0404 or above are supported by this procedure.
  1.010  ELSEIF       ZCMPI(Prefix, "D") || ZCMPI(Prefix, "P")
  1.011  MATH         SubRev = FLD(@FirmwareRev, 3, ".")
  1.012  MATH         @Abort = (@FirmwareNum < 10) && (SubRev < 404)

  1.013  ELSE
  1.014  DISP         Unrecognized firmware prefix in:  [V @FirmwareRev]
  1.015  MATH         @Abort = 1
  1.016  ENDIF

  1.017  IF           @Abort
  1.018  DISP         The firmware revision of the UUT cannot be supported by
  1.018  DISP         this procedure.
  1.018  DISP
  1.018  DISP         Contact with Fluke to upgrade it to latest.
  1.018  DISP
  1.018  DISP         Press Advance to abort the procedure now.
  1.019  ENDIF

  1.020  END
