﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 190II Connection RS-232 /USB
DATE:                  2015-11-23 14:35:10
AUTHOR:                Fluke
REVISION:              $Revision: 13569 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       86
=============================================================================
#
#  Procedure Author:
#        VY
#
#  Models covered:
#        Fluke 190 Series II ScopeMeter®
#          190-062, 190-102, 190-202, 190-104, 190-204, 190-502
#        Tektronix THS3000 Series Oscilloscopes
#          THS3014, THS3024
#
# Compatibility:
#        MET/CAL 8.0 or later
#
# Required Equipment:
#        Cable, USB Type A (Host) to USB MINI Type B (Device)
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  OPBR         -z Has the UUT USB driver been installed on the PC?
  1.002  MATH         @Abort = NOT(MEM1)

  1.003  IF           @Abort
  1.004  DISP         Connect the UUT to an available PC USB port via a cable
  1.004  DISP         of USB Type A (Host) to USB MINI Type B (Device).

  1.005  DISP         Install the USB driver according to the wizard
  1.005  DISP         instruction once "Found New Hardware" wizard appears.
  1.005  DISP
  1.005  DISP         Note: It may need 15 minutes while system automatically
  1.005  DISP         search the driver for device from Windows update.
  1.005  DISP
  1.005  DISP         After the driver succefully installed, set the MET/CAL
  1.005  DISP         "Default Serial Port" to the actual COM port number that
  1.005  DISP         Windows assigned and then run the procedure again.
  1.005  DISP
  1.005  DISP         Press "Advance" to termninate the procedure now.
  1.006  END
  1.007  ENDIF

# Get the current MET/CAL default serial port setting.
  1.008  MATH         Port = INI("startup", "port")

  1.009  OPBR         -z The MET/CAL "Default Serial Port" is currently
  1.009  OPBR         [V Port].
  1.009  OPBR
  1.009  OPBR         Is this the serial port that Windows automatically
  1.009  OPBR         assigned to the UUT when it was connected to the PC?
  1.009  OPBR
  1.009  OPBR         Check the setting of "Ports (COM & LPT)" in device
  1.009  OPBR         manager of CONTROL PANEL in the PC operating system
  1.009  OPBR         to get the current COM port number assigned.
  1.010  MATH         @Abort = NOT(MEM1)

  1.011  IF           @Abort
  1.012  DISP         Select "Terminate" and perform the following:
  1.012  DISP         - From the menu bar, select
  1.012  DISP         [32] "Configure"=>"Default Serial Port"
  1.012  DISP         - Select the serial port that Windows assigned to the
  1.012  DISP         [32] UUT when it was connected to the PC.
  1.013  END
  1.014  ENDIF

  1.015  END
