﻿Copyright (c) (2016) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 190II Get Bandwidth & Number of Channels
DATE:                  2016-05-09 13:11:40
AUTHOR:                Fluke
REVISION:              $Revision: 15955 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       56
=============================================================================
#
#  Procedure Author:
#        DAC
#
#  Source:
#        Fluke 190 Series II ScopeMeter®
#          190-062, 190-102, 190-202, 190-104, 190-204
#          Service Manual PN 4822 872 05405, February 2013, Rev. 2, 2/15
#
#        Tektronix THS3000 Series Oscilloscopes
#          Performance Verification and Adjustments
#          Technical Reference
#          077-0606-00
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

# Tektronix THS3000 is "THS30BC", where "B" x 100 is the bandwidth in MHz
# Fluke 190 Series II is "190-BBC", where "BB" x 10 is the bandwidth in MHz.
# "C" is the number of channels.

  1.001  IF           ZCMP(SUB(@ModelNum, 1, 3), "THS")
  1.002  MATH         @Bandwidth = SUB(@ModelNum, 6, 1) * 100
  1.003  ELSE
  1.004  MATH         @Bandwidth = SUB(@ModelNum, 5, 2) * 10
  1.005  ENDIF

  1.006  MATH         @Bandwidth = @Bandwidth * 1E+6
  1.007  MATH         @NumChan   = SUB(@ModelNum, 7, 1)

  1.008  END
