﻿Copyright (c) (2015) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Fluke 190II Preliminary Instructions
DATE:                  2015-12-23 08:17:51
AUTHOR:                Fluke
REVISION:              $Revision: 14074 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       63
=============================================================================
#
#  Procedure Author:
#        DAC, GMO
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Required Equipment:
#        - Power Adapter, BC190 (Fluke 190 Series II), or
#        - Power Adapter, 119-7900-00 (Tektronix THS3000)
#
# This procedure is intended for use with MET/CAL® calibration software;
# the terms and conditions set forth in your MET/CAL license apply to this
# procedure.
#
# Due to Fluke's policy of continuously updating our products, this procedure
# may contain minor differences in methods used and/or specifications to
# those found in the manual or other documentation. While every effort has
# been made to ensure that this procedure is accurate, Fluke cannot be held
# responsible for the consequences of error or omissions found within this
# procedure.
#
# The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           ZCMP(SUB(@ModelNum, 1, 3), "THS")
  1.002  MATH         PowerAdapter = "119-7900-00"
  1.003  MATH         Button       = "UTILITY"
  1.004  ELSE
  1.005  MATH         PowerAdapter = "BC190"
  1.006  MATH         Button       = "USER"
  1.007  ENDIF

  1.008  HEAD         PRELIMINARY INSTRUCTIONS
  1.009  DISP         [32]           IMPORTANT! PLEASE NOTE!!
  1.009  DISP
  1.009  DISP         Throughout this procedure, the UUT MUST be powered
  1.009  DISP         by the [V PowerAdapter] battery charger.
  1.009  DISP
  1.009  DISP         The battery pack must be installed.

  1.010  DISP         Prior to verification, the UUT must be reset.
  1.010  DISP         Reset the UUT using the following procedure:
  1.010  DISP
  1.010  DISP         - Press and release the power button to turn UUT off
  1.010  DISP         - PRESS AND HOLD the [V Button] button
  1.010  DISP         - Press and release the power button to turn UUT on
  1.010  DISP         - WAIT until the UUT has BEEPED TWICE, then release
  1.010  DISP         [32] the [V Button] button

  1.011  HEAD
  1.012  END
