﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 190II Probe VER RS-232
DATE:                  2015-11-23 14:35:36
AUTHOR:                Fluke
REVISION:              $Revision: 13569 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       2
NUMBER OF LINES:       107
=============================================================================
#
#  Procedure Author:
#        VY
#
#  Models covered:
#        Fluke 190 Series II ScopeMeter®
#          190-062, 190-102, 190-202, 190-104, 190-204, 190-502
#        Tektronix THS3000 Series Oscilloscopes
#          THS3014, THS3024
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
# Subprocedures:
#        Sub Fluke ScopeMeter Send Command RS-232
#
# Required Files:
#        190II_red_probe_test.jpg
#        THS3000_red_probe_test.png
#
# This procedure is intended for use with MET/CAL® calibration software; the
# terms and conditions set forth in your MET/CAL license apply to this
# procedure.
#
# Due to Fluke's policy of continuously updating our products, this procedure
# may contain minor differences in methods used and/or specifications to
# those found in the manual or other documentation. While every effort has
# been made to ensure that this procedure is accurate, Fluke cannot be held
# responsible for the consequences of error or omissions found within this
# procedure.
#
# The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  MATH         THS3000 = ZCMPI(SUB(@ModelNum, 1, 3), "THS")

  1.002  RSLT         =
  1.003  HEAD         {PROBE CALIBRATION GENERATOR TEST}
  1.004  MATH         @Cmd = "DS"
  1.005  CALL         Sub Fluke ScopeMeter Send Command RS-232
# Set UUT to local operation.
  1.006  MATH         @Cmd = "GL"
  1.007  CALL         Sub Fluke ScopeMeter Send Command RS-232
  1.008  OPBR         -z The following test of the UUT Probe Calibration
  1.008  OPBR         Generator is a FUNCTIONAL TEST only and has no
  1.008  OPBR         quantitative parameters.
  1.008  OPBR
  1.008  OPBR         Do you wish to test the Probe Calibration Generator
  1.008  OPBR         at this time?

  1.009  IF           NOT(MEM1)
  1.010  RSLT         = Not Tested

  1.011  ELSE
  1.012  DISP         To test the Probe Calibration Generator, connect a
  1.012  DISP         VPS210 probe as shown in the following picture, then
  1.012  DISP         proceed as instructed in the following steps.
  1.013  HEAD         -2 [7][D250][7][D250][7][D250][7][D250][7][D250]

  1.014  IF           THS3000
  1.015  PIC          THS3000_red_probe_test.png
  1.016  ELSE
  1.017  PIC          190II_red_probe_test.jpg
  1.018  ENDIF

# Press "A" button.
  1.019  MATH         @Cmd = "KY 11"
  1.020  CALL         Sub Fluke ScopeMeter Send Command RS-232
# Press "F3" button (PROBE A).
  1.021  MATH         @Cmd = "KY 31"
  1.022  CALL         Sub Fluke ScopeMeter Send Command RS-232
# Press "F1" button (PROBE CAL...).
  1.023  MATH         @Cmd = "KY 35"
  1.024  CALL         Sub Fluke ScopeMeter Send Command RS-232
# Press "F4" button (YES).
  1.025  MATH         @Cmd = "KY 32"
  1.026  CALL         Sub Fluke ScopeMeter Send Command RS-232

  1.027  DISP         Verify that the UUT shows the square wave, (the lower
  1.027  DISP         half of the screen is covered with operating
  1.027  DISP         instructions), adjust the trimmer screw in the probe
  1.027  DISP         housing until a pure square wave is displayed.
  1.027  DISP
  1.027  DISP         Press UUT F4 (CONTINUE) button to start the calibration,
  1.027  DISP         wait several seconds until the message "Calibration has
  1.027  DISP         been completed successfully" is displayed.
  1.028  EVAL   -s "Calibration Generator OK": Are the requirements met?

# Press "F4" button (CLOSE).
  2.001  MATH         @Cmd = "KY 32"
  2.002  CALL         Sub Fluke ScopeMeter Send Command RS-232
  2.003  ENDIF

  2.004  HEAD
  2.005  HEAD         -2
  2.006  END
