﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 190II Setup Channel RS-232
INSTRUMENT:            Sub Fluke 190II Setup Range RS-232
INSTRUMENT:            Sub Fluke 190II Setup Cursor RS-232
INSTRUMENT:            Sub Fluke 190II Setup Reading RS-232
INSTRUMENT:            Sub Fluke 190II Setup Timebase & Pos RS-232
DATE:                  2015-11-23 14:34:25
AUTHOR:                Fluke
REVISION:              $Revision: 13569 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       6
NUMBER OF LINES:       963
=============================================================================
#
#  Procedure Author:
#        VY, CAD
#
#  Models covered:
#        Fluke 190 Series II ScopeMeter®
#          190-062, 190-102, 190-104, 190-202, 190-204, 190-502
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
# This procedure is intended for use with MET/CAL® calibration software; the
# terms and conditions set forth in your MET/CAL license apply to this
# procedure.
#
# Due to Fluke's policy of continuously updating our products, this procedure
# may contain minor differences in methods used and/or specifications to
# those found in the manual or other documentation. While every effort has
# been made to ensure that this procedure is accurate, Fluke cannot be held
# responsible for the consequences of error or omissions found within this
# procedure.
#
# The copyright in this procedure is owned by Fluke Corporation.
#
#  GLOBAL VARIABLE USE:
#    @Chan          - Name of Channel under tested
#    @Input         - Name of Channel calibrator input connected
#    @BW_Setup      - Channel bandwidth limit setup
#    @DC_Coupling   - Channel coupling mode (1 is DC cupled, 0 AC coupled)
#    @Cmd           - Command string sent to UUT
#    @Range         - Channel Scope range
#    @Reading       - Channel reading type
#    @Timebase      - UUT timebase setting
#    @HPos          - UUT horizontal (Trigger) position
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         SETUP_CHANNEL                PSUBI("Channel")
  1.002  JMPL         SETUP_RANGE                  PSUBI("Range")
  1.003  JMPL         SETUP_CURSOR                 PSUBI("Cursor")
  1.004  JMPL         SETUP_READING                PSUBI("Reading")
  1.005  JMPL         SETUP_TIMEBASE_and_POSITION   PSUBI("Timebase & Pos")
  1.006  DISP         Error ScopeMeter Utilities:  Subprocedure not found!
  1.007  END

  1.008  EVAL   Increment Step Number

# =====  Sub Fluke 190II Setup Channel RS-232  ==============================

  2.001  LABEL        SETUP_CHANNEL
# Reset the UUT to default.
  2.002  MATH         @Cmd = "DS"
  2.003  CALL         Sub Fluke ScopeMeter Send Command RS-232
  2.004  WAIT         -t 3 UUT Initializing...

# Initialize the time base range and scope range variable.
  2.005  MATH         @Timebase = "Auto"; @Range = "Auto"

  2.006  IF           ZCMPI(@Input, "A&B&C&D")
  2.007  MATH         @Cmd = "PS"
  2.008  CALL         Sub Fluke ScopeMeter Send Command RS-232

  2.009  IF           @DC_Coupling

  2.010  IF           ZCMPI(@BW_Setup, "FULL BW")
  2.011  PORT         #0[32][10][0][2][128][0][128]
  2.011  PORT         [32][20][0][2][128][0][128]
  2.011  PORT         [32][210][0][2][128][0][128]
  2.011  PORT         [160][220][0][2][128][0][128][13]
  2.012  ELSEIF       ZCMPI(@BW_Setup, "20 kHz")
  2.013  PORT         #0[32][10][0][2][128][1][129]
  2.013  PORT         [32][20][0][2][128][1][129]
  2.013  PORT         [32][210][0][2][128][1][129]
  2.013  PORT         [160][220][0][2][128][1][129][13]
  2.014  ELSE         ; BW = 20 MHz
  2.015  PORT         #0[32][10][0][2][128][2][130]
  2.015  PORT         [32][20][0][2][128][2][130]
  2.015  PORT         [32][210][0][2][128][2][130]
  2.015  PORT         [160][220][0][2][128][2][130][13]
  2.016  ENDIF

  2.017  ELSE         ; AC_Coupling

  2.018  IF           ZCMPI(@BW_Setup, "FULL BW")
  2.019  PORT         #0[32][10][0][2][192][0][192]
  2.019  PORT         [32][20][0][2][192][0][192]
  2.019  PORT         [32][210][0][2][192][0][192]
  2.019  PORT         [160][220][0][2][192][0][192][13]
  2.020  ELSEIF       ZCMPI(@BW_Setup, "20 kHz")
  2.021  PORT         #0[32][10][0][2][192][1][193]
  2.021  PORT         [32][20][0][2][192][1][193]
  2.021  PORT         [32][210][0][2][192][1][193]
  2.021  PORT         [160][220][0][2][192][1][193][13]
  2.022  ELSE         ; BW = 20 MHz
  2.023  PORT         #0[32][10][0][2][192][2][194]
  2.023  PORT         [32][20][0][2][192][2][194]
  2.023  PORT         [32][210][0][2][192][2][194]
  2.023  PORT         [160][220][0][2][192][2][194][13]
  2.024  ENDIF

  2.025  ENDIF

  2.026  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

# Set Channel A, B, C, D Probe to 1:1.
  2.027  MATH         @Cmd = "PS"
  2.028  CALL         Sub Fluke ScopeMeter Send Command RS-232
  2.029  PORT         #0[32][11][0][1][2][2]
  2.029  PORT         [32][21][0][1][2][2]
  2.029  PORT         [32][211][0][1][2][2]
  2.029  PORT         [160][221][0][1][2][2][13]
  2.030  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

# Set Channel A, B, C, D Vertical Position to center.
  2.031  MATH         @Cmd = "PS"
  2.032  CALL         Sub Fluke ScopeMeter Send Command RS-232
  2.033  PORT         #0[32][13][0][2][0][0][0]
  2.033  PORT         [32][23][0][2][0][0][0]
  2.033  PORT         [32][213][0][2][0][0][0]
  2.033  PORT         [160][223][0][2][0][0][0][13]
  2.034  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

  2.035  ELSE         ; Individual channel turned on

  2.036  IF           ZCMPI(@Input, "A")
# Channel A General Setting.
  2.037  MATH         @Cmd = "PS"
  2.038  CALL         Sub Fluke ScopeMeter Send Command RS-232

  2.039  IF           @DC_Coupling

  2.040  IF           ZCMPI(@BW_Setup, "FULL BW")
  2.041  PORT         #0[160][10][0][2][128][0][128][13]
  2.042  ELSEIF       ZCMPI(@BW_Setup, "20 kHz")
  2.043  PORT         #0[160][10][0][2][128][1][129][13]
  2.044  ELSE         ; BW = 20 MHz
  2.045  PORT         #0[160][10][0][2][128][2][130][13]
  2.046  ENDIF

  2.047  ELSE         ; AC_Coupling

  2.048  IF           ZCMPI(@BW_Setup, "FULL BW")
  2.049  PORT         #0[160][10][0][2][192][0][192][13]
  2.050  ELSEIF       ZCMPI(@BW_Setup, "20 kHz")
  2.051  PORT         #0[160][10][0][2][192][1][193][13]
  2.052  ELSE         ; BW = 20 MHz
  2.053  PORT         #0[160][10][0][2][192][2][194][13]
  2.054  ENDIF

  2.055  ENDIF

  2.056  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

# Set Channel A Probe to 1:1.
  2.057  MATH         @Cmd = "PS"
  2.058  CALL         Sub Fluke ScopeMeter Send Command RS-232
  2.059  PORT         #0[160][11][0][1][2][2][13]
  2.060  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

# Set Channel A Vertical Position to center.
  2.061  MATH         @Cmd = "PS"
  2.062  CALL         Sub Fluke ScopeMeter Send Command RS-232
  2.063  PORT         #0[160][13][0][2][0][0][0][13]
  2.064  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

# Set Trigger Source to Channel A.
  2.065  MATH         @Cmd = "PS"
  2.066  CALL         Sub Fluke ScopeMeter Send Command RS-232
  2.067  PORT         #0[160][102][0][1][0][0][13]
  2.068  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

  2.069  ELSEIF       ZCMPI(@Input, "B")
  2.070  MATH         @Cmd = "PS"
  2.071  CALL         Sub Fluke ScopeMeter Send Command RS-232

  2.072  IF           @DC_Coupling

  2.073  IF           ZCMPI(@BW_Setup, "FULL BW")
  2.074  PORT         #0[160][20][0][2][128][0][128][13]
  2.075  ELSEIF       ZCMPI(@BW_Setup, "20 kHz")
  2.076  PORT         #0[160][20][0][2][128][1][129][13]
  2.077  ELSE         ; BW = 20 MHz
  2.078  PORT         #0[160][20][0][2][128][2][130][13]
  2.079  ENDIF

  2.080  ELSE         ; AC_Coupling

  2.081  IF           ZCMPI(@BW_Setup, "FULL BW")
  2.082  PORT         #0[160][20][0][2][192][0][192][13]
  2.083  ELSEIF       ZCMPI(@BW_Setup, "20 kHz")
  2.084  PORT         #0[160][20][0][2][192][1][193][13]
  2.085  ELSE         ; BW = 20 MHz
  2.086  PORT         #0[160][20][0][2][192][2][194][13]
  2.087  ENDIF

  2.088  ENDIF

  2.089  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

# Set Channel B Probe to 1:1.
  2.090  MATH         @Cmd = "PS"
  2.091  CALL         Sub Fluke ScopeMeter Send Command RS-232
  2.092  PORT         #0[160][21][0][1][2][2][13]
  2.093  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

# Set Channel B Vertical Position to center.
  2.094  MATH         @Cmd = "PS"
  2.095  CALL         Sub Fluke ScopeMeter Send Command RS-232
  2.096  PORT         #0[160][23][0][2][0][0][0][13]
  2.097  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

# Set Trigger Source to Channel B.
  2.098  MATH         @Cmd = "PS"
  2.099  CALL         Sub Fluke ScopeMeter Send Command RS-232
  2.100  PORT         #0[160][102][0][1][1][1][13]
  2.101  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

  2.102  ELSEIF       ZCMPI(@Input, "C")
  2.103  MATH         @Cmd = "PS"
  2.104  CALL         Sub Fluke ScopeMeter Send Command RS-232

  2.105  IF           @DC_Coupling

  2.106  IF           ZCMPI(@BW_Setup, "FULL BW")
  2.107  PORT         #0[160][210][0][2][128][0][128][13]
  2.108  ELSEIF       ZCMPI(@BW_Setup, "20 kHz")
  2.109  PORT         #0[160][210][0][2][128][1][129][13]
  2.110  ELSE         ; BW = 20 MHz
  2.111  PORT         #0[160][210][0][2][128][2][130][13]
  2.112  ENDIF

  2.113  ELSE         ; AC_Coupling

  2.114  IF           ZCMPI(@BW_Setup, "FULL BW")
  2.115  PORT         #0[160][210][0][2][192][0][192][13]
  2.116  ELSEIF       ZCMPI(@BW_Setup, "20 kHz")
  2.117  PORT         #0[160][210][0][2][192][1][193][13]
  2.118  ELSE         ; BW = 20 MHz
  2.119  PORT         #0[160][210][0][2][192][2][194][13]
  2.120  ENDIF

  2.121  ENDIF

  2.122  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

# Set Channel C Probe to 1:1.
  2.123  MATH         @Cmd = "PS"
  2.124  CALL         Sub Fluke ScopeMeter Send Command RS-232
  2.125  PORT         #0[160][211][0][1][2][2][13]
  2.126  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

# Set Channel C Vertical Position to center.
  2.127  MATH         @Cmd = "PS"
  2.128  CALL         Sub Fluke ScopeMeter Send Command RS-232
  2.129  PORT         #0[160][213][0][2][0][0][0][13]
  2.130  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

# Set Trigger Source to Channel C.
  2.131  MATH         @Cmd = "PS"
  2.132  CALL         Sub Fluke ScopeMeter Send Command RS-232
  2.133  PORT         #0[160][102][0][1][2][2][13]
  2.134  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

  2.135  ELSEIF       ZCMPI(@Input, "D")
  2.136  MATH         @Cmd = "PS"
  2.137  CALL         Sub Fluke ScopeMeter Send Command RS-232

  2.138  IF           @DC_Coupling

  2.139  IF           ZCMPI(@BW_Setup, "FULL BW")
  2.140  PORT         #0[160][220][0][2][128][0][128][13]
  2.141  ELSEIF       ZCMPI(@BW_Setup, "20 kHz")
  2.142  PORT         #0[160][220][0][2][128][1][129][13]
  2.143  ELSE         ; BW = 20 MHz
  2.144  PORT         #0[160][220][0][2][128][2][130][13]
  2.145  ENDIF

  2.146  ELSE         ; AC_Coupling

  2.147  IF           ZCMPI(@BW_Setup, "FULL BW")
  2.148  PORT         #0[160][220][0][2][192][0][192][13]
  2.149  ELSEIF       ZCMPI(@BW_Setup, "20 kHz")
  2.150  PORT         #0[160][220][0][2][192][1][193][13]
  2.151  ELSE         ; BW = 20 MHz
  2.152  PORT         #0[160][220][0][2][192][2][194][13]
  2.153  ENDIF

  2.154  ENDIF

  2.155  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

# Set Channel D Probe to 1:1.
  2.156  MATH         @Cmd = "PS"
  2.157  CALL         Sub Fluke ScopeMeter Send Command RS-232
  2.158  PORT         #0[160][221][0][1][2][2][13]
  2.159  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

# Set Channel D Vertical Position to center.
  2.160  MATH         @Cmd = "PS"
  2.161  CALL         Sub Fluke ScopeMeter Send Command RS-232
  2.162  PORT         #0[160][223][0][2][0][0][0][13]
  2.163  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

# Set Trigger Source to Channel D.
  2.164  MATH         @Cmd = "PS"
  2.165  CALL         Sub Fluke ScopeMeter Send Command RS-232
  2.166  PORT         #0[160][102][0][1][3][3][13]
  2.167  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232
  2.168  ENDIF        ; ZCMPI(@Input, "A")

# Turn off the channel A once channel B, C, or D is turned on.
  2.169  IF           NOT(ZCMPI(@Input, "A"))
  2.170  MATH         @Cmd = "PS"
  2.171  CALL         Sub Fluke ScopeMeter Send Command RS-232

  2.172  IF           @DC_Coupling

  2.173  IF           ZCMPI(@BW_Setup, "FULL BW")
  2.174  PORT         #0[160][10][0][2][0][0][0][13]
  2.175  ELSEIF       ZCMPI(@BW_Setup, "20 kHz")
  2.176  PORT         #0[160][10][0][2][0][1][1][13]
  2.177  ELSE         ; BW = 20 MHz
  2.178  PORT         #0[160][10][0][2][0][2][2][13]
  2.179  ENDIF

  2.180  ELSE         ; AC_Coupling

  2.181  IF           ZCMPI(@BW_Setup, "FULL BW")
  2.182  PORT         #0[160][10][0][2][64][0][64][13]
  2.183  ELSEIF       ZCMPI(@BW_Setup, "20 kHz")
  2.184  PORT         #0[160][10][0][2][64][1][65][13]
  2.185  ELSE         ; BW = 20 MHz
  2.186  PORT         #0[160][10][0][2][64][2][66][13]
  2.187  ENDIF

  2.188  ENDIF

  2.189  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232
  2.190  ENDIF

  2.191  ENDIF        ; ZCMPI(@Input, "A&B&C&D")

  2.192  END

  2.193  EVAL   Increment Step Number


# =====  Sub Fluke 190II Setup Range RS-232  ================================

  3.001  LABEL        SETUP_RANGE

  3.002  IF           ZCMPI(@Range, "Auto") && ZCMPI(@Timebase, "Auto")
# Activate the timebase ranging, trigger mode ranging, trigger level ranging,
# and amplitude ranging on all channels.
  3.003  MATH         @Cmd = "PS"
  3.004  CALL         Sub Fluke ScopeMeter Send Command RS-232
  3.005  PORT         #0[160][115][0][1][127][127][13]
  3.006  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

  3.007  ELSEIF       ZCMPI(@Range, "Auto") && NOT(ZCMPI(@Timebase, "Auto"))
# Activate amplitude ranging on all channels, trigger mode ranging and trigger
# level ranging, only the timebase ranging are inactive.
  3.008  MATH         @Cmd = "PS"
  3.009  CALL         Sub Fluke ScopeMeter Send Command RS-232
  3.010  PORT         #0[160][115][0][1][111][111][13]
  3.011  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

  3.012  ELSE         ; Manual scope range
  3.013  MATH         @Cmd = "PS"
  3.014  CALL         Sub Fluke ScopeMeter Send Command RS-232

  3.015  IF           ZCMPI(@Timebase, "Auto")
# Activate the timebase ranging, trigger mode ranging and trigger level
# ranging, only amplitude ranging on all channels are inactive.
  3.016  PORT         #0[160][115][0][1][112][112][13]
  3.017  ELSE         ; Manual timebase range
# Firstly deactivate the amplitude ranging on all channels and also deactivate
# the timebase ranging, only the trigger mode ranging and trigger level
# ranging are active.
  3.018  PORT         #0[160][115][0][1][96][96][13]
  3.019  ENDIF

  3.020  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

  3.021  MATH         @Cmd = "PS"
  3.022  CALL         Sub Fluke ScopeMeter Send Command RS-232

  3.023  IF           ZCMPI(@Input, "A&B&C&D")

# Set Channel A, B, C, and D Scope Range to desired.
  3.024  IF           ZCMPI(@Range, "2 mV/div")
  3.025  PORT         #0[32][14][0][5][0][0][0][16][253][13]
  3.025  PORT         [32][24][0][5][0][0][0][16][253][13]
  3.025  PORT         [32][214][0][5][0][0][0][16][253][13]
  3.025  PORT         [160][224][0][5][0][0][0][16][253][13][13]
  3.026  ELSEIF       ZCMPI(@Range, "5 mV/div")
  3.027  PORT         #0[32][14][0][5][0][0][0][4][254][2]
  3.027  PORT         [32][24][0][5][0][0][0][4][254][2]
  3.027  PORT         [32][214][0][5][0][0][0][4][254][2]
  3.027  PORT         [160][224][0][5][0][0][0][4][254][2][13]
  3.028  ELSEIF       ZCMPI(@Range, "10 mV/div")
  3.029  PORT         #0[32][14][0][5][0][0][0][8][254][6]
  3.029  PORT         [32][24][0][5][0][0][0][8][254][6]
  3.029  PORT         [32][214][0][5][0][0][0][8][254][6]
  3.029  PORT         [160][224][0][5][0][0][0][8][254][6][13]
  3.030  ELSEIF       ZCMPI(@Range, "20 mV/div")
  3.031  PORT         #0[32][14][0][5][0][0][0][16][254][14]
  3.031  PORT         [32][24][0][5][0][0][0][16][254][14]
  3.031  PORT         [32][214][0][5][0][0][0][16][254][14]
  3.031  PORT         [160][224][0][5][0][0][0][16][254][14][13]
  3.032  ELSEIF       ZCMPI(@Range, "50 mV/div")
  3.033  PORT         #0[32][14][0][5][0][0][0][4][255][3]
  3.033  PORT         [32][24][0][5][0][0][0][4][255][3]
  3.033  PORT         [32][214][0][5][0][0][0][4][255][3]
  3.033  PORT         [160][224][0][5][0][0][0][4][255][3][13]
  3.034  ELSEIF       ZCMPI(@Range, "100 mV/div")
  3.035  PORT         #0[32][14][0][5][0][0][0][8][255][7]
  3.035  PORT         [32][24][0][5][0][0][0][8][255][7]
  3.035  PORT         [32][214][0][5][0][0][0][8][255][7]
  3.035  PORT         [160][224][0][5][0][0][0][8][255][7][13]
  3.036  ELSEIF       ZCMPI(@Range, "200 mV/div")
  3.037  PORT         #0[32][14][0][5][0][0][0][16][255][15]
  3.037  PORT         [32][24][0][5][0][0][0][16][255][15]
  3.037  PORT         [32][214][0][5][0][0][0][16][255][15]
  3.038  PORT         [160][224][0][5][0][0][0][16][255][15][13]
  3.039  ELSEIF       ZCMPI(@Range, "500 mV/div")
  3.040  PORT         #0[32][14][0][5][0][0][0][4][0][4]
  3.040  PORT         [32][24][0][5][0][0][0][4][0][4]
  3.040  PORT         [32][214][0][5][0][0][0][4][0][4]
  3.040  PORT         [160][224][0][5][0][0][0][4][0][4][13]
  3.041  ELSEIF       ZCMPI(@Range, "1 V/div")
  3.042  PORT         #0[32][14][0][5][0][0][0][8][0][8]
  3.042  PORT         [32][24][0][5][0][0][0][8][0][8]
  3.042  PORT         [32][214][0][5][0][0][0][8][0][8]
  3.042  PORT         [160][224][0][5][0][0][0][8][0][8][13]
  3.043  ELSEIF       ZCMPI(@Range, "2 V/div")
  3.044  PORT         #0[32][14][0][5][0][0][0][16][0][16]
  3.044  PORT         [32][24][0][5][0][0][0][16][0][16]
  3.044  PORT         [32][214][0][5][0][0][0][16][0][16]
  3.044  PORT         [160][224][0][5][0][0][0][16][0][16][13]
  3.045  ELSEIF       ZCMPI(@Range, "5 V/div")
  3.046  PORT         #0[32][14][0][5][0][0][0][4][1][5]
  3.046  PORT         [32][24][0][5][0][0][0][4][1][5]
  3.046  PORT         [32][214][0][5][0][0][0][4][1][5]
  3.046  PORT         [160][224][0][5][0][0][0][4][1][5][13]
  3.047  ELSEIF       ZCMPI(@Range, "10 V/div")
  3.048  PORT         #0[32][14][0][5][0][0][0][8][1][9]
  3.048  PORT         [32][24][0][5][0][0][0][8][1][9]
  3.048  PORT         [32][214][0][5][0][0][0][8][1][9]
  3.048  PORT         [160][224][0][5][0][0][0][8][1][9][13]
  3.049  ELSEIF       ZCMPI(@Range, "20 V/div")
  3.050  PORT         #0[32][14][0][5][0][0][0][16][1][17]
  3.050  PORT         [32][24][0][5][0][0][0][16][1][17]
  3.050  PORT         [32][214][0][5][0][0][0][16][1][17]
  3.050  PORT         [160][224][0][5][0][0][0][16][1][17][13]
  3.051  ELSEIF       ZCMPI(@Range, "50 V/div")
  3.052  PORT         #0[32][14][0][5][0][0][0][4][2][6]
  3.052  PORT         [32][24][0][5][0][0][0][4][2][6]
  3.052  PORT         [32][214][0][5][0][0][0][4][2][6]
  3.052  PORT         [160][224][0][5][0][0][0][4][2][6][13]
  3.053  ELSEIF       ZCMPI(@Range, "100 V/div")
  3.054  PORT         #0[32][14][0][5][0][0][0][8][2][10]
  3.054  PORT         [32][24][0][5][0][0][0][8][2][10]
  3.054  PORT         [32][214][0][5][0][0][0][8][2][10]
  3.054  PORT         [160][224][0][5][0][0][0][8][2][10][13]
  3.055  ELSE
  3.056  DISP         The scope range setting is incompatible with the UUT.
  3.056  DISP
  3.056  DISP         Press "Terminate" to abort the procedure.
  3.057  ENDIF

  3.058  ELSE         ; Individual channel Scope Range

  3.059  IF           ZCMPI(@Input, "A")
# Set Channel A Scope Range to desired.

  3.060  IF           ZCMPI(@Range, "2 mV/div")
  3.061  PORT         #0[160][14][0][5][0][0][0][16][253][13][13]
  3.062  ELSEIF       ZCMPI(@Range, "5 mV/div")
  3.063  PORT         #0[160][14][0][5][0][0][0][4][254][2][13]
  3.064  ELSEIF       ZCMPI(@Range, "10 mV/div")
  3.065  PORT         #0[160][14][0][5][0][0][0][8][254][6][13]
  3.066  ELSEIF       ZCMPI(@Range, "20 mV/div")
  3.067  PORT         #0[160][14][0][5][0][0][0][16][254][14][13]
  3.068  ELSEIF       ZCMPI(@Range, "50 mV/div")
  3.069  PORT         #0[160][14][0][5][0][0][0][4][255][3][13]
  3.070  ELSEIF       ZCMPI(@Range, "100 mV/div")
  3.071  PORT         #0[160][14][0][5][0][0][0][8][255][7][13]
  3.072  ELSEIF       ZCMPI(@Range, "200 mV/div")
  3.073  PORT         #0[160][14][0][5][0][0][0][16][255][15][13]
  3.074  ELSEIF       ZCMPI(@Range, "500 mV/div")
  3.075  PORT         #0[160][14][0][5][0][0][0][4][0][4][13]
  3.076  ELSEIF       ZCMPI(@Range, "1 V/div")
  3.077  PORT         #0[160][14][0][5][0][0][0][8][0][8][13]
  3.078  ELSEIF       ZCMPI(@Range, "2 V/div")
  3.079  PORT         #0[160][14][0][5][0][0][0][16][0][16][13]
  3.080  ELSEIF       ZCMPI(@Range, "5 V/div")
  3.081  PORT         #0[160][14][0][5][0][0][0][4][1][5][13]
  3.082  ELSEIF       ZCMPI(@Range, "10 V/div")
  3.083  PORT         #0[160][14][0][5][0][0][0][8][1][9][13]
  3.084  ELSEIF       ZCMPI(@Range, "20 V/div")
  3.085  PORT         #0[160][14][0][5][0][0][0][16][1][17][13]
  3.086  ELSEIF       ZCMPI(@Range, "50 V/div")
  3.087  PORT         #0[160][14][0][5][0][0][0][4][2][6][13]
  3.088  ELSEIF       ZCMPI(@Range, "100 V/div")
  3.089  PORT         #0[160][14][0][5][0][0][0][8][2][10][13]
  3.090  ELSE
  3.091  DISP         The scope range setting is incompatible with the UUT.
  3.091  DISP
  3.091  DISP         Press "Terminate" to abort the procedure.
  3.092  ENDIF

  3.093  ELSEIF       ZCMPI(@Input, "B")
# Set Channel B Scope Rang to desired.

  3.094  IF           ZCMPI(@Range, "2 mV/div")
  3.095  PORT         #0[160][24][0][5][0][0][0][16][253][13][13]
  3.096  ELSEIF       ZCMPI(@Range, "5 mV/div")
  3.097  PORT         #0[160][24][0][5][0][0][0][4][254][2][13]
  3.098  ELSEIF       ZCMPI(@Range, "10 mV/div")
  3.099  PORT         #0[160][24][0][5][0][0][0][8][254][6][13]
  3.100  ELSEIF       ZCMPI(@Range, "20 mV/div")
  3.101  PORT         #0[160][24][0][5][0][0][0][16][254][14][13]
  3.102  ELSEIF       ZCMPI(@Range, "50 mV/div")
  3.103  PORT         #0[160][24][0][5][0][0][0][4][255][3][13]
  3.104  ELSEIF       ZCMPI(@Range, "100 mV/div")
  3.105  PORT         #0[160][24][0][5][0][0][0][8][255][7][13]
  3.106  ELSEIF       ZCMPI(@Range, "200 mV/div")
  3.107  PORT         #0[160][24][0][5][0][0][0][16][255][15][13]
  3.108  ELSEIF       ZCMPI(@Range, "500 mV/div")
  3.109  PORT         #0[160][24][0][5][0][0][0][4][0][4][13]
  3.110  ELSEIF       ZCMPI(@Range, "1 V/div")
  3.111  PORT         #0[160][24][0][5][0][0][0][8][0][8][13]
  3.112  ELSEIF       ZCMPI(@Range, "2 V/div")
  3.113  PORT         #0[160][24][0][5][0][0][0][16][0][16][13]
  3.114  ELSEIF       ZCMPI(@Range, "5 V/div")
  3.115  PORT         #0[160][24][0][5][0][0][0][4][1][5][13]
  3.116  ELSEIF       ZCMPI(@Range, "10 V/div")
  3.117  PORT         #0[160][24][0][5][0][0][0][8][1][9][13]
  3.118  ELSEIF       ZCMPI(@Range, "20 V/div")
  3.119  PORT         #0[160][24][0][5][0][0][0][16][1][17][13]
  3.120  ELSEIF       ZCMPI(@Range, "50 V/div")
  3.121  PORT         #0[160][24][0][5][0][0][0][4][2][6][13]
  3.122  ELSEIF       ZCMPI(@Range, "100 V/div")
  3.123  PORT         #0[160][24][0][5][0][0][0][8][2][10][13]
  3.124  ELSE
  3.125  DISP         The scope range setting is incompatible with the UUT.
  3.125  DISP
  3.125  DISP         Press "Terminate" to abort the procedure.
  3.126  ENDIF

  3.127  ELSEIF       ZCMPI(@Input, "C")
# Set Channel C Scope Range to desired.

  3.128  IF           ZCMPI(@Range, "2 mV/div")
  3.129  PORT         #0[160][214][0][5][0][0][0][16][253][13][13]
  3.130  ELSEIF       ZCMPI(@Range, "5 mV/div")
  3.131  PORT         #0[160][214][0][5][0][0][0][4][254][2][13]
  3.132  ELSEIF       ZCMPI(@Range, "10 mV/div")
  3.133  PORT         #0[160][214][0][5][0][0][0][8][254][6][13]
  3.134  ELSEIF       ZCMPI(@Range, "20 mV/div")
  3.135  PORT         #0[160][214][0][5][0][0][0][16][254][14][13]
  3.136  ELSEIF       ZCMPI(@Range, "50 mV/div")
  3.137  PORT         #0[160][214][0][5][0][0][0][4][255][3][13]
  3.138  ELSEIF       ZCMPI(@Range, "100 mV/div")
  3.139  PORT         #0[160][214][0][5][0][0][0][8][255][7][13]
  3.140  ELSEIF       ZCMPI(@Range, "200 mV/div")
  3.141  PORT         #0[160][214][0][5][0][0][0][16][255][15][13]
  3.142  ELSEIF       ZCMPI(@Range, "500 mV/div")
  3.143  PORT         #0[160][214][0][5][0][0][0][4][0][4][13]
  3.144  ELSEIF       ZCMPI(@Range, "1 V/div")
  3.145  PORT         #0[160][214][0][5][0][0][0][8][0][8][13]
  3.146  ELSEIF       ZCMPI(@Range, "2 V/div")
  3.147  PORT         #0[160][214][0][5][0][0][0][16][0][16][13]
  3.148  ELSEIF       ZCMPI(@Range, "5 V/div")
  3.149  PORT         #0[160][214][0][5][0][0][0][4][1][5][13]
  3.150  ELSEIF       ZCMPI(@Range, "10 V/div")
  3.151  PORT         #0[160][214][0][5][0][0][0][8][1][9][13]
  3.152  ELSEIF       ZCMPI(@Range, "20 V/div")
  3.153  PORT         #0[160][214][0][5][0][0][0][16][1][17][13]
  3.154  ELSEIF       ZCMPI(@Range, "50 V/div")
  3.155  PORT         #0[160][214][0][5][0][0][0][4][2][6][13]
  3.156  ELSEIF       ZCMPI(@Range, "100 V/div")
  3.157  PORT         #0[160][214][0][5][0][0][0][8][2][10][13]
  3.158  ELSE
  3.159  DISP         The scope range setting is incompatible with the UUT.
  3.159  DISP
  3.159  DISP         Press "Terminate" to abort the procedure.
  3.160  ENDIF

  3.161  ELSEIF       ZCMPI(@Input, "D")
# Set Channel D Scope Range to desired.

  3.162  IF           ZCMPI(@Range, "2 mV/div")
  3.163  PORT         #0[160][224][0][5][0][0][0][16][253][13][13]
  3.164  ELSEIF       ZCMPI(@Range, "5 mV/div")
  3.165  PORT         #0[160][224][0][5][0][0][0][4][254][2][13]
  3.166  ELSEIF       ZCMPI(@Range, "10 mV/div")
  3.167  PORT         #0[160][224][0][5][0][0][0][8][254][6][13]
  3.168  ELSEIF       ZCMPI(@Range, "20 mV/div")
  3.169  PORT         #0[160][224][0][5][0][0][0][16][254][14][13]
  3.170  ELSEIF       ZCMPI(@Range, "50 mV/div")
  3.171  PORT         #0[160][224][0][5][0][0][0][4][255][3][13]
  3.172  ELSEIF       ZCMPI(@Range, "100 mV/div")
  3.173  PORT         #0[160][224][0][5][0][0][0][8][255][7][13]
  3.174  ELSEIF       ZCMPI(@Range, "200 mV/div")
  3.175  PORT         #0[160][224][0][5][0][0][0][16][255][15][13]
  3.176  ELSEIF       ZCMPI(@Range, "500 mV/div")
  3.177  PORT         #0[160][224][0][5][0][0][0][4][0][4][13]
  3.178  ELSEIF       ZCMPI(@Range, "1 V/div")
  3.179  PORT         #0[160][224][0][5][0][0][0][8][0][8][13]
  3.180  ELSEIF       ZCMPI(@Range, "2 V/div")
  3.181  PORT         #0[160][224][0][5][0][0][0][16][0][16][13]
  3.182  ELSEIF       ZCMPI(@Range, "5 V/div")
  3.183  PORT         #0[160][224][0][5][0][0][0][4][1][5][13]
  3.184  ELSEIF       ZCMPI(@Range, "10 V/div")
  3.185  PORT         #0[160][224][0][5][0][0][0][8][1][9][13]
  3.186  ELSEIF       ZCMPI(@Range, "20 V/div")
  3.187  PORT         #0[160][224][0][5][0][0][0][16][1][17][13]
  3.188  ELSEIF       ZCMPI(@Range, "50 V/div")
  3.189  PORT         #0[160][224][0][5][0][0][0][4][2][6][13]
  3.190  ELSEIF       ZCMPI(@Range, "100 V/div")
  3.191  PORT         #0[160][224][0][5][0][0][0][8][2][10][13]
  3.192  ELSE
  3.193  DISP         The scope range setting is incompatible with the UUT.
  3.193  DISP
  3.193  DISP         Press "Terminate" to abort the procedure.
  3.194  ENDIF

  3.195  ENDIF        ; ZCMPI(@Input, "A")

  3.196  ENDIF        ; ZCMPI(@Input, "A&B&C&D")

  3.197  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232
  3.198  ENDIF        ; ZCMPI(@Range, "Auto") && ZCMPI(@Timebase, "Auto")

  3.199  END

  3.200  EVAL   Increment Step Number


# =====  Sub Fluke 190II Setup Cursor RS-232  ===============================

  4.001  LABEL        SETUP_CURSOR
# Here only define the Single Vertical Cursor in average mode per procedure
# requirement.
  4.002  MATH         @Cmd = "PS"
  4.003  CALL         Sub Fluke ScopeMeter Send Command RS-232

  4.004  IF           ZCMPI(@Chan, "A")
  4.005  PORT         #0[160][70][0][7][128][1][0][0][0][0][0][129][13]
  4.006  ELSEIF       ZCMPI(@Chan, "B")
  4.007  PORT         #0[160][70][0][7][128][1][1][0][0][0][0][130][13]
  4.008  ELSEIF       ZCMPI(@Chan, "C")
  4.009  PORT         #0[160][70][0][7][128][1][2][0][0][0][0][131][13]
  4.010  ELSEIF       ZCMPI(@Chan, "D")
  4.011  PORT         #0[160][70][0][7][128][1][3][0][0][0][0][132][13]
  4.012  ENDIF

  4.013  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232
  4.014  END

  4.015  EVAL   Increment Step Number


# =====  Sub Fluke 190II Setup Reading RS-232  ==============================

  5.001  LABEL        SETUP_READING

  5.002  IF           ZCMPI(@Input, "A&B&C&D")
  5.003  MATH         @Cmd = "PS"
  5.004  CALL         Sub Fluke ScopeMeter Send Command RS-232

  5.005  IF           ZCMPI(@Reading, "DC Volts Mean")
  5.006  PORT         #0[32][51][0][5][128][1][1][1][1][132]
  5.007  PORT         [32][52][0][5][128][2][1][1][1][133]
  5.008  PORT         [32][56][0][5][128][3][1][1][1][134]
  5.009  PORT         [160][57][0][5][128][4][1][1][1][135][13]
  5.010  ELSEIF       ZCMPI(@Reading, "AC Volts Rms")
  5.011  PORT         #0[32][51][0][5][128][1][2][1][1][133]
  5.012  PORT         [32][52][0][5][128][2][2][1][1][134]
  5.013  PORT         [32][56][0][5][128][3][2][1][1][135]
  5.014  PORT         [160][57][0][5][128][4][2][1][1][136][13]
  5.015  ELSEIF       ZCMPI(@Reading, "AC Volts Peak to Peak")
  5.016  PORT         #0[32][51][0][5][128][1][4][1][1][135]
  5.017  PORT         [32][52][0][5][128][2][4][1][1][136]
  5.018  PORT         [32][56][0][5][128][3][4][1][1][137]
  5.019  PORT         [160][57][0][5][128][4][4][1][1][138][13]
  5.020  ELSEIF       ZCMPI(@Reading, "Frequency")
  5.021  PORT         #0[32][51][0][5][128][1][11][10][8][158]
  5.022  PORT         [32][52][0][5][128][2][11][10][8][159]
  5.023  PORT         [32][56][0][5][128][3][11][10][8][160]
  5.024  PORT         [160][57][0][5][128][4][11][10][8][161][13]
  5.025  ELSEIF       ZCMPI(@Reading, "Phase")
  5.026  PORT         #0[32][51][0][5][128][1][14][11][9][163]
  5.027  PORT         [32][52][0][5][128][2][14][11][9][164]
  5.028  PORT         [32][56][0][5][128][3][14][11][9][165]
  5.029  PORT         [160][57][0][5][128][4][14][11][9][166][13]
  5.030  ENDIF

  5.031  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

  5.032  ELSE         ; Individual channel Scope Reading

  5.033  IF           ZCMPI(@Input, "A")
  5.034  MATH         @Cmd = "PS"
  5.035  CALL         Sub Fluke ScopeMeter Send Command RS-232

  5.036  IF           ZCMPI(@Reading, "DC Volts Mean")
  5.037  PORT         #0[160][51][0][5][128][1][1][1][1][132][13]
  5.038  ELSEIF       ZCMPI(@Reading, "AC Volts Rms")
  5.039  PORT         #0[160][51][0][5][128][1][2][1][1][133][13]
  5.040  ELSEIF       ZCMPI(@Reading, "AC Volts Peak to Peak")
  5.041  PORT         #0[160][51][0][5][128][1][4][1][1][135][13]
  5.042  ELSEIF       ZCMPI(@Reading, "Frequency")
  5.043  PORT         #0[160][51][0][5][128][1][11][10][8][158][13]
  5.044  ELSEIF       ZCMPI(@Reading, "Phase")
  5.045  PORT         #0[160][51][0][5][128][1][14][11][9][163][13]
  5.046  ENDIF

  5.047  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

  5.048  ELSEIF       ZCMPI(@Input, "B")
  5.049  MATH         @Cmd = "PS"
  5.050  CALL         Sub Fluke ScopeMeter Send Command RS-232

  5.051  IF           ZCMPI(@Reading, "DC Volts Mean")
  5.052  PORT         #0[160][52][0][5][128][2][1][1][1][133][13]
  5.053  ELSEIF       ZCMPI(@Reading, "AC Volts Rms")
  5.054  PORT         #0[160][52][0][5][128][2][2][1][1][134][13]
  5.055  ELSEIF       ZCMPI(@Reading, "AC Volts Peak to Peak")
  5.056  PORT         #0[160][52][0][5][128][2][4][1][1][136][13]
  5.057  ELSEIF       ZCMPI(@Reading, "Frequency")
  5.058  PORT         #0[160][52][0][5][128][2][11][10][8][159][13]
  5.059  ELSEIF       ZCMPI(@Reading, "Phase")
  5.060  PORT         #0[160][52][0][5][128][2][14][11][9][164][13]
  5.061  ENDIF

  5.062  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

  5.063  ELSEIF       ZCMPI(@Input, "C")
  5.064  MATH         @Cmd = "PS"
  5.065  CALL         Sub Fluke ScopeMeter Send Command RS-232

  5.066  IF           ZCMPI(@Reading, "DC Volts Mean")
  5.067  PORT         #0[160][56][0][5][128][3][1][1][1][134][13]
  5.068  ELSEIF       ZCMPI(@Reading, "AC Volts Rms")
  5.069  PORT         #0[160][56][0][5][128][3][2][1][1][135][13]
  5.070  ELSEIF       ZCMPI(@Reading, "AC Volts Peak to Peak")
  5.071  PORT         #0[160][56][0][5][128][3][4][1][1][137][13]
  5.072  ELSEIF       ZCMPI(@Reading, "Frequency")
  5.073  PORT         #0[160][56][0][5][128][3][11][10][8][160][13]
  5.074  ELSEIF       ZCMPI(@Reading, "Phase")
  5.075  PORT         #0[160][56][0][5][128][3][14][11][9][165][13]
  5.076  ENDIF

  5.077  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

  5.078  ELSEIF       ZCMPI(@Input, "D")
  5.079  MATH         @Cmd = "PS"
  5.080  CALL         Sub Fluke ScopeMeter Send Command RS-232

  5.081  IF           ZCMPI(@Reading, "DC Volts Mean")
  5.082  PORT         #0[160][57][0][5][128][4][1][1][1][135][13]
  5.083  ELSEIF       ZCMPI(@Reading, "AC Volts Rms")
  5.084  PORT         #0[160][57][0][5][128][4][2][1][1][136][13]
  5.085  ELSEIF       ZCMPI(@Reading, "AC Volts Peak to Peak")
  5.086  PORT         #0[160][57][0][5][128][4][4][1][1][138][13]
  5.087  ELSEIF       ZCMPI(@Reading, "Frequency")
  5.088  PORT         #0[160][57][0][5][128][4][11][10][8][161][13]
  5.089  ELSEIF       ZCMPI(@Reading, "Phase")
  5.090  PORT         #0[160][57][0][5][128][4][14][11][9][166][13]
  5.091  ENDIF

  5.092  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232
  5.093  ENDIF

  5.094  ENDIF        ; ZCMPI(@Input, "A&B&C&D")

  5.095  END

  5.096  EVAL   Increment Step Number


# =====  Sub Fluke 190II Setup Timebase & Pos RS-232  =======================

  6.001  LABEL        SETUP_TIMEBASE_and_POSITION

  6.002  IF           ZCMPI(@Timebase, "Auto") && ZCMPI(@Range, "Auto")
# Activate the timebase ranging, trigger mode ranging, trigger level ranging,
# and amplitude ranging on all channels.
  6.003  MATH         @Cmd = "PS"
  6.004  CALL         Sub Fluke ScopeMeter Send Command RS-232
  6.005  PORT         #0[160][115][0][1][127][127][13]
  6.006  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

  6.007  ELSEIF       ZCMPI(@Timebase, "Auto") && NOT(ZCMPI(@Range, "Auto"))
# Activate the timebase ranging, trigger mode ranging and trigger level
# ranging, only amplitude ranging on all channels are inactive.
  6.008  MATH         @Cmd = "PS"
  6.009  CALL         Sub Fluke ScopeMeter Send Command RS-232
  6.010  PORT         #0[160][115][0][1][112][112][13]
  6.011  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

  6.012  ELSE         ; Manual timebase range
  6.013  MATH         @Cmd = "PS"
  6.014  CALL         Sub Fluke ScopeMeter Send Command RS-232

  6.015  IF           ZCMPI(@Range, "Auto")
# Activate amplitude ranging on all channels, trigger mode ranging and trigger
# level ranging, only the timebase ranging are inactive.
  6.016  PORT         #0[160][115][0][1][111][111][13]
  6.017  ELSE
# Deactivate the timebase ranging and also amplitude ranging on all channels,
# only the trigger mode ranging and trigger level ranging are active.
  6.018  PORT         #0[160][115][0][1][96][96][13]
  6.019  ENDIF

  6.020  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232

  6.021  MATH         @Cmd = "PS"
  6.022  CALL         Sub Fluke ScopeMeter Send Command RS-232

  6.023  IF           ZCMPI(@HPos, "2 div")
# Set timebase to desired and horizontal (trigger) position to 2 div by the
# relevant timebase scale.

  6.024  IF           ZCMPI(@Timebase, "1 ns/div")
  6.025  PORT         #0[32][111][0][5][0][0][0][12][247][3]
  6.026  PORT         [160][113][0][5][255][255][255][254][247][241][13]
  6.027  ELSEIF       ZCMPI(@Timebase, "2 ns/div")
  6.028  PORT         #0[32][111][0][5][0][0][0][24][247][15]
  6.029  PORT         [160][113][0][5][255][255][255][252][247][239][13]
  6.030  ELSEIF       ZCMPI(@Timebase, "5 ns/div")
  6.031  PORT         #0[32][111][0][5][0][0][0][6][248][254]
  6.032  PORT         [160][113][0][5][255][255][255][255][248][244][13]
  6.033  ELSEIF       ZCMPI(@Timebase, "10 ns/div")
  6.034  PORT         #0[32][111][0][5][0][0][0][12][248][4]
  6.035  PORT         [160][113][0][5][255][255][255][254][248][243][13]
  6.036  ELSEIF       ZCMPI(@Timebase, "20 ns/div")
  6.037  PORT         #0[32][111][0][5][0][0][0][24][248][16]
  6.038  PORT         [160][113][0][5][255][255][255][252][248][241][13]
  6.039  ELSEIF       ZCMPI(@Timebase, "40 ns/div")
  6.040  PORT         #0[32][111][0][5][0][0][0][48][248][40]
  6.041  PORT         [160][113][0][5][255][255][255][248][248][237][13]
  6.042  ELSEIF       ZCMPI(@Timebase, "100 ns/div")
  6.043  PORT         #0[32][111][0][5][0][0][0][12][249][5]
  6.044  PORT         [160][113][0][5][255][255][255][254][249][244][13]
  6.045  ELSEIF       ZCMPI(@Timebase, "200 ns/div")
  6.046  PORT         #0[32][111][0][5][0][0][0][24][249][17]
  6.047  PORT         [160][113][0][5][255][255][255][252][249][242][13]
  6.048  ELSEIF       ZCMPI(@Timebase, "400 ns/div")
  6.049  PORT         #0[32][111][0][5][0][0][0][48][249][41]
  6.050  PORT         [160][113][0][5][255][255][255][248][249][238][13]
  6.051  ELSEIF       ZCMPI(@Timebase, "1 us/div")
  6.052  PORT         #0[32][111][0][5][0][0][0][12][250][6]
  6.053  PORT         [160][113][0][5][255][255][255][254][250][245][13]
  6.054  ELSEIF       ZCMPI(@Timebase, "2 us/div")
  6.055  PORT         #0[32][111][0][5][0][0][0][24][250][18]
  6.056  PORT         [160][113][0][5][255][255][255][252][250][243][13]
  6.057  ELSEIF       ZCMPI(@Timebase, "4 us/div")
  6.058  PORT         #0[32][111][0][5][0][0][0][48][250][42]
  6.059  PORT         [160][113][0][5][255][255][255][248][250][239][13]
  6.060  ELSEIF       ZCMPI(@Timebase, "10 us/div")
  6.061  PORT         #0[32][111][0][5][0][0][0][12][251][7]
  6.062  PORT         [160][113][0][5][255][255][255][254][251][246][13]
  6.063  ELSEIF       ZCMPI(@Timebase, "20 us/div")
  6.064  PORT         #0[32][111][0][5][0][0][0][24][251][19]
  6.065  PORT         [160][113][0][5][255][255][255][252][251][244][13]
  6.066  ELSEIF       ZCMPI(@Timebase, "40 us/div")
  6.067  PORT         #0[32][111][0][5][0][0][0][48][251][43]
  6.068  PORT         [160][113][0][5][255][255][255][248][251][240][13]
  6.069  ELSEIF       ZCMPI(@Timebase, "100 us/div")
  6.070  PORT         #0[32][111][0][5][0][0][0][12][252][8]
  6.071  PORT         [160][113][0][5][255][255][255][254][252][247][13]
  6.072  ELSEIF       ZCMPI(@Timebase, "200 us/div")
  6.073  PORT         #0[32][111][0][5][0][0][0][24][252][20]
  6.074  PORT         [160][113][0][5][255][255][255][252][252][245][13]
  6.075  ELSEIF       ZCMPI(@Timebase, "400 us/div")
  6.076  PORT         #0[32][111][0][5][0][0][0][48][252][44]
  6.077  PORT         [160][113][0][5][255][255][255][248][252][241][13]
  6.078  ELSEIF       ZCMPI(@Timebase, "1 ms/div")
  6.079  PORT         #0[32][111][0][5][0][0][0][12][253][9]
  6.080  PORT         [160][113][0][5][255][255][255][254][253][248][13]
  6.081  ELSEIF       ZCMPI(@Timebase, "2 ms/div")
  6.082  PORT         #0[32][111][0][5][0][0][0][24][253][21]
  6.083  PORT         [160][113][0][5][255][255][255][252][253][246][13]
  6.084  ELSEIF       ZCMPI(@Timebase, "4 ms/div")
  6.085  PORT         #0[32][111][0][5][0][0][0][48][253][45]
  6.086  PORT         [160][113][0][5][255][255][255][248][253][242][13]
  6.087  ELSEIF       ZCMPI(@Timebase, "10 ms/div")
  6.088  PORT         #0[32][111][0][5][0][0][0][12][254][10]
  6.089  PORT         [160][113][0][5][255][255][255][254][254][249][13]
  6.090  ELSEIF       ZCMPI(@Timebase, "20 ms/div")
  6.091  PORT         #0[32][111][0][5][0][0][0][24][254][22]
  6.092  PORT         [160][113][0][5][255][255][255][252][254][247][13]
  6.093  ELSEIF       ZCMPI(@Timebase, "40 ms/div")
  6.094  PORT         #0[32][111][0][5][0][0][0][48][254][46]
  6.095  PORT         [160][113][0][5][255][255][255][248][254][243][13]
  6.096  ELSEIF       ZCMPI(@Timebase, "100 ms/div")
  6.097  PORT         #0[32][111][0][5][0][0][0][12][255][11]
  6.098  PORT         [160][113][0][5][255][255][255][254][255][250][13]
  6.099  ELSEIF       ZCMPI(@Timebase, "200 ms/div")
  6.100  PORT         #0[32][111][0][5][0][0][0][24][255][23]
  6.101  PORT         [160][113][0][5][255][255][255][252][255][248][13]
  6.102  ELSEIF       ZCMPI(@Timebase, "400 ms/div")
  6.103  PORT         #0[32][111][0][5][0][0][0][48][255][47]
  6.104  PORT         [160][113][0][5][255][255][255][248][255][244][13]
  6.105  ELSEIF       ZCMPI(@Timebase, "1 s/div")
  6.106  PORT         #0[32][111][0][5][0][0][0][12][0][12]
  6.107  PORT         [160][113][0][5][255][255][255][254][0][251][13]
  6.108  ELSEIF       ZCMPI(@Timebase, "2 s/div")
  6.109  PORT         #0[32][111][0][5][0][0][0][24][0][24]
  6.110  PORT         [160][113][0][5][255][255][255][252][0][249][13]
  6.111  ELSEIF       ZCMPI(@Timebase, "4 s/div")
  6.112  PORT         #0[32][111][0][5][0][0][0][48][0][48]
  6.113  PORT         [160][113][0][5][255][255][255][248][0][245][13]
  6.114  ELSE
  6.115  DISP         The timebase setting is incompatible with the UUT.
  6.115  DISP
  6.115  DISP         Press "Terminate" to abort the procedure.
  6.116  ENDIF

  6.117  ELSEIF       ZCMPI(@HPos, "799 us") && ZCMPI(@Timebase, "1 us/div")
# Specically defined for Timebase Test.
  6.118  PORT         #0[32][111][0][5][0][0][0][12][250][6]
  6.119  PORT         [160][113][0][5][0][0][3][31][250][28][13]

  6.120  ELSEIF       ZCMPI(@HPos, "7990 us") && ZCMPI(@Timebase, "10 us/div")
# Specically defined for Timebase Test.
  6.121  PORT         #0[32][111][0][5][0][0][0][12][251][7]
  6.122  PORT         [160][113][0][5][0][0][31][54][250][79][13]

  6.123  ELSEIF       ZCMPI(@HPos, "1 div") && ZCMPI(@Timebase, "20 us/div")
# Specically defined for Video Test.
  6.124  PORT         #0[32][111][0][5][0][0][0][24][251][19]
  6.125  PORT         [160][113][0][5][255][255][255][254][251][246][13]

  6.126  ELSE
  6.127  DISP         Undefined timebase and trigger postion setting by
  6.127  DISP         this procedure.
  6.127  DISP
  6.127  DISP         Press "Terminate" to abort the procedure.
  6.128  ENDIF

  6.129  CALL         Sub Fluke ScopeMeter Check Acknowledge RS-232
  6.130  ENDIF        ; ZCMPI(@Timebase, "Auto") && ZCMPI(@Range, "Auto")

  6.131  END
