﻿Copyright (c) (2013) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Fluke 190II Trigger Sens. Adjust RS-232 /O_CAL
DATE:                  2013-12-17 11:51:18
AUTHOR:                Fluke
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       105
CONFIGURATION:         Fluke Ocal
=============================================================================
#
#  Procedure Author:
#        VY, DAC
#
#  Models covered:
#        Fluke 190 Series II ScopeMeter®
#          190-062, 190-102, 190-202, 190-104, 190-204, 190-502
#        Tektronix THS3000 Series Oscilloscopes
#          THS3014, THS3024
#
#  Compatibility:
#        MET/CAL 8.1.4 and later
#
#  Global Variables:
#        @Input    - Input label
#        @Ampl     - Nominal desired calibrator amplitude (Vpp)
#        @BitNum   - Bit number to determine UUT trigger status in sub
#        @Freq     - Calibrator frequency
#        @Status   - UUT trigger status from subprocedure
#        @VertDiv  - Desired number of UUT display divisions
#        @Cmd      - Remote command sent to UUT
#
#  Local Variables:
#        QueryCmd  - Command to query channel measurement
#        Counter   - Maximum number of attempts to try to trigger
#        Amplitude - Initial 5520A output amplitude
#        NewAmpl   - Computed 5520A output amplitude
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           ZCMPI(@Input, "A")
  1.002  MATH         QueryCmd = "QM 11"
  1.003  ELSEIF       ZCMPI(@Input, "B")
  1.004  MATH         QueryCmd = "QM 21"
  1.005  ELSEIF       ZCMPI(@Input, "C")
  1.006  MATH         QueryCmd = "QM 31"
  1.007  ELSE
  1.008  MATH         QueryCmd = "QM 41"
  1.009  ENDIF

  1.010  MATH         Amplitude = BASE(@Ampl);  Frequency = BASE(@Freq)
# Set @BitNum to "triggered" status bit value.
  1.011  MATH         @BitNum = 12
# Set number of times to dither output, attempting to trigger.
# Copy desired nominal amplitude to local register for manipulation.
  1.012  MATH         Counter = 4; NewAmpl = Amplitude

  1.013  DO
  1.014  MATH         Counter = Counter - 1
  1.015  O_CAL        Mode = LeveledSine
  1.015  O_CAL        +Voltage = [V NewAmpl] Vpp; Frequency = [V @Freq]
# Check instrument status for "triggered" status in sub (triggered bit is 12).
  1.016  CALL         Sub Fluke ScopeMeter Instrument Status RS-232

  1.017  IF           NOT(@Status)
  1.018  MATH         @Cmd = QueryCmd
  1.019  CALL         Sub Fluke ScopeMeter Query Measurement RS-232
# Multiply desired Vpp value times ratio of actual (Vrms converted to Vpp).
  1.020  MATH         NewAmpl = Amplitude * (NewAmpl / (MEM * (2 * SQRT(2))))

  1.021  IF           NewAmpl > 5.5
  1.022  OPBR         -z The amplitude required to achieve
  1.022  OPBR         [V @VertDiv] divisions on the UUT display exceeds
  1.022  OPBR         the capability of the calibrator.
  1.022  OPBR
  1.022  OPBR         Do you wish to RETRY?

  1.023  IF           MEM1
  1.024  MATH         Counter = 4; NewAmpl = Amplitude
  1.025  ENDIF

  1.026  ENDIF        ; NewAmpl > 5.5

  1.027  IF           Counter < 0
  1.028  DISP         The UUT MUST be triggered, displaying a stable trace
  1.028  DISP         (some jitter is allowed).
  1.028  DISP         The UUT is triggered if the [V @Input]| in the UUT
  1.028  DISP         status line ("Trig: [V @Input]|") is black.
  1.028  DISP
  1.028  DISP         If not, press the UUT "TRIGGER" key, adjusting the
  1.028  DISP         UUT trigger level (using the up and down arrow keys)
  1.028  DISP         until it is.
  1.029  OPBR         -z Is the UUT triggered?
  1.030  MATH         @Status = MEM1
# Press "CLEAR" button to close the softkey menu.
  1.031  MATH         @Cmd = "KY 34"
  1.032  CALL         Sub Fluke ScopeMeter Send Command RS-232
  1.033  ENDIF        ; Counter < 0

  1.034  ENDIF        ; NOT(@Status)

  1.035  UNTIL        @Status || (NewAmpl > 5.5) || Counter < 0

  1.036  END
