﻿Fluke Calibration                                           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke ScopeMeter Error Message
DATE:                  2014-09-03 08:14:54
AUTHOR:                Fluke
REVISION:              $Revision: 13867 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       65
=============================================================================
#
#  Procedure Author:
#        DAC, VY
#
#  Models covered:
#        Fluke 93, 95, 97, 97/AUTO ScopeMeter®
#        Fluke 91, 92, 96, 99 ScopeMeter® SERIES II
#        Fluke 98 Automotive ScopeMeter®
#        Fluke 12x ScopeMeter®
#        Fluke 19x ScopeMeter®
#        Fluke 19xB, 19xC ScopeMeter®
#        Fluke 2x5C ScopeMeter®
#        Fluke 43, 43B Power Analyzer
#        Fluke 190 series II ScopeMeter®
#
#  Compatibilty:
#        5700/CAL or MET/CAL 7.20 SP1 (7.20x) and later
#
# This procedure is intended for use with MET/CAL® calibration software; the
# terms and conditions set forth in your MET/CAL license apply to this
# procedure.
#
# Due to Fluke's policy of continuously updating our products, this procedure
# may contain minor differences in methods used and/or specifications to
# those found in the manual or other documentation. While every effort has
# been made to ensure that this procedure is accurate, Fluke cannot be held
# responsible for the consequences of error or omissions found within this
# procedure.
#
# The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

# Based on the acknowledge response sent by the Test Tool, this procedure
# identifies the error for presentation to the operator.

  1.001  IF           MEM == 1
  1.002  MATH         @ErrorMsg = "Syntax Error"
  1.003  ELSEIF       MEM == 2
  1.004  MATH         @ErrorMsg = "Execution Error"
  1.005  ELSEIF       MEM == 3
  1.006  MATH         @ErrorMsg = "Synchronization Error"
  1.007  ELSEIF       MEM == 4
  1.008  MATH         @ErrorMsg = "Communication Error"
  1.009  ELSEIF       MEM == 5
  1.010  MATH         @ErrorMsg = "Device Dependent Error"
  1.011  ELSEIF       MEM == 6
  1.012  MATH         @ErrorMsg = "Test Failure"
  1.013  ELSE
  1.014  MATH         @ErrorMsg = "Unknown Error! Acknowledge Response is "
  1.015  MATH         @ErrorMsg = @ErrorMsg & MEM
  1.016  ENDIF

  1.017  MATH         @Error = 1
  1.018  END
