﻿Fluke Calibration                                           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke ScopeMeter Send Command RS-232
DATE:                  2013-12-10 12:23:13
AUTHOR:                Fluke
REVISION:              $Revision: 13867 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       67
=============================================================================
#
#  Procedure Author:
#        VY
#
#  Models covered:
#        Fluke 93, 95, 97, 97/AUTO ScopeMeter®
#        Fluke 91, 92, 96, 99 ScopeMeter® SERIES II
#        Fluke 98 Automotive ScopeMeter®
#        Fluke 12x ScopeMeter®
#        Fluke 19x ScopeMeter®
#        Fluke 19xB, 19xC ScopeMeter®
#        Fluke 2x5C ScopeMeter®
#        Fluke 43, 43B Power Analyzer
#
#  Compatibility:
#        5700/CAL or MET/CAL 7.20 SP1 (7.20x) and later
#
# Subprocedures:
#        Sub Fluke ScopeMeter Error Message
#
# Required Files:
#        None
#
# This procedure is intended for use with MET/CAL® calibration software; the
# terms and conditions set forth in your MET/CAL license apply to this
# procedure.
#
# Due to Fluke's policy of continuously updating our products, this procedure
# may contain minor differences in methods used and/or specifications to
# those found in the manual or other documentation. While every effort has
# been made to ensure that this procedure is accurate, Fluke cannot be held
# responsible for the consequences of error or omissions found within this
# procedure.
#
# The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

# This subprocedure sends the command (in @Cmd) to the Test Tool then checks
# its acknowledge response (0 = OK), (>0 = Error).

  1.001  DO
  1.002  PORT         [CLR][V @Cmd][13][I]

  1.003  IF           MEM > 0
  1.004  CALL         Sub Fluke ScopeMeter Error Message
  1.005  OPBR         -z [V @ErrorMsg]
  1.005  OPBR
  1.005  OPBR         Do you wish to RESEND the command?
  1.006  MATH         Repeat = MEM1
  1.007  ELSE
  1.008  MATH         @Error = 0; @ErrorMsg = ""; Repeat = 0
  1.009  ENDIF

  1.010  UNTIL        NOT(Repeat)

  1.011  END
