﻿Fluke Calibration                                           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke ScopeMeter Query Identification RS-232
INSTRUMENT:            Sub Fluke ScopeMeter Query Measurement RS-232
INSTRUMENT:            Sub Fluke ScopeMeter Instrument Status RS-232
INSTRUMENT:            Sub Fluke ScopeMeter Check Acknowledge RS-232
DATE:                  2013-12-10 12:23:13
AUTHOR:                Fluke
REVISION:              $Revision: 13867 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       5
NUMBER OF LINES:       222
=============================================================================
#
#  Procedure Author:
#        DAC, VY
#
#  Models covered:
#        Fluke 93, 95, 97, 97/AUTO ScopeMeter®
#        Fluke 91, 92, 96, 99 ScopeMeter® SERIES II
#        Fluke 98 Automotive ScopeMeter®
#        Fluke 12x ScopeMeter®
#        Fluke 19x ScopeMeter®
#        Fluke 19xB, 19xC ScopeMeter®
#        Fluke 2x5C ScopeMeter®
#        Fluke 43, 43B Power Analyzer
#        Fluke 190 series II ScopeMeter®
#
#  Compatibilty:
#        5700/CAL or MET/CAL 7.20 SP1 (7.20x) and later
#
# Subprocedures:
#        Sub Fluke ScopeMeter Send Command RS-232
#        Sub Fluke ScopeMeter Error Message
#
# Required Files:
#        None
#
# This procedure is intended for use with MET/CAL® calibration software; the
# terms and conditions set forth in your MET/CAL license apply to this
# procedure.
#
# Due to Fluke's policy of continuously updating our products, this procedure
# may contain minor differences in methods used and/or specifications to
# those found in the manual or other documentation. While every effort has
# been made to ensure that this procedure is accurate, Fluke cannot be held
# responsible for the consequences of error or omissions found within this
# procedure.
#
# The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         QUERY_IDENTIFICATION         PSUBI("Identification")
  1.002  JMPL         QUERY_MEASUREMENT            PSUBI("Query Measurement")
  1.003  JMPL         INSTRUMENT_STATUS            PSUBI("Instrument Status")
  1.004  JMPL         CHK_ACKNOWLEDGE              PSUBI("Check Acknowledge")
  1.005  DISP         Error ScopeMeter Utilities:  Subprocedure not found!
  1.006  END

  1.007  EVAL   Increment Line Number

# ====== Sub Fluke ScopeMeter Query Identification RS-232 ==================

# This subprocedure queries the Test Tool for its configuration information.

  2.001  LABEL        QUERY_IDENTIFICATION
  2.002  MATH         @Cmd = "ID"
  2.003  CALL         Sub Fluke ScopeMeter Send Command RS-232

  2.004  IF           NOT(@Error)
  2.005  PORT         [I$]

# Some ScopeMeters return an ID string with 2 or more consecutive whitespace.
# Example:
#
# "ScopeMeter  96B Series II; V8.20; 96005-07; English V8.05; ; UHM V1.0"
#
# This screws up parsing using the MATH FLD function.
# Convert multiple whitespace to single whitespace.
  2.006  MATH         DoubleSpace = FIND(MEM2, "  ", 1)

  2.007  WHILE        DoubleSpace
  2.008  MATH         MEM2 = REPL("  ", " ", MEM2)
  2.009  MATH         DoubleSpace = FIND(MEM2, "  ", 1)
  2.010  ENDW

# Parse ID response into fields based on semicolon separator.
# Field 1: Manufacturer and model
# Field 2: Firmware version
# Field 3: Firmware date
# Field 4: Supported languages.
  2.011  MATH         MfrModel      = STRIP(FLD(MEM2, 1, ";"))
  2.012  MATH         @FirmwareRev  = STRIP(FLD(MEM2, 2, ";"))
  2.013  MATH         @FirmwareDate = STRIP(FLD(MEM2, 3, ";"))
  2.014  MATH         Language      = STRIP(FLD(MEM2, 4, ";"))

# Parse MfrModel subfield based on white space separator.
# Field 1: Manufacturer
# Field 2: Model number; "model" for Series I units
# Field 3: Model number (Series I), "Series" for Series II units
  2.015  MATH         @Manufacturer = FLD(MfrModel, 1, " ")
  2.016  MATH         @ModelNum     = FLD(MfrModel, 2, " ")
  2.017  MATH         ModelFld3     = FLD(MfrModel, 3, " ")

  2.018  MATH         @Series_I = 0; @Series_II = 0

# Series I ScopeMeters send:
#   "ScopeMeter model <model #> ; <firmware> ; <date>
  2.019  IF           ZCMPI(@ModelNum, "model")
  2.020  MATH         @Series_I = 1
  2.021  MATH         @ModelNum = ModelFld3

# Series II ScopeMeters send:
#   "ScopeMeter <model #> Series II; <firmware>; <date>; <language>; ...
  2.022  ELSEIF       FINDI(ModelFld3, "Series II", 1)
  2.023  MATH         @Series_II = 1
  2.024  MATH         @ModelNum = @ModelNum & " Series II"
  2.025  ENDIF

# Deletes leading zero, e.g., 043, if present.
  2.026  IF           ZCMP(SUB(@ModelNum, 1, 1), "0")
  2.027  MATH         @ModelNum = SUB(@ModelNum, 2, LEN(@ModelNum))
  2.028  ENDIF

  2.029  MATH         FirmwareRev = "Firmware Version: " & @FirmwareRev
  2.030  RSLT         =
  2.031  HEAD         {INSTALLED INSTRUMENT FIRMWARE}
  2.032  RSLT         =
  2.033  RSLT         = [V FirmwareRev]

  2.034  DISP         Manufacturer : [V @Manufacturer]
  2.034  DISP         Model        : [V @ModelNum]
  2.034  DISP         Firmware Rev.: [V @FirmwareRev]
  2.034  DISP         Firmware Date: [V @FirmwareDate]
  2.035  ENDIF

  2.036  END

  2.037  EVAL   Increment Line Number

# ====== Sub Fluke ScopeMeter Query Measurement RS-232 =====================

# These subprocedures check the queried measurement value of Input A (B)
# for invalid (9.91e37) or overload (9.9e37 or -9.9e37).  If 5x invalid or
# overload then result is fail.
#
# @Cmd must contain the Query Measurement command (e.g., QM 11) when
# this subprocedure is called.
#
# @Wait = number of seconds to delay before taking measurement

  3.001  LABEL        QUERY_MEASUREMENT
  3.002  MATH         @Error = 0; @ErrorMsg = ""
# Set invalid/overload measurement counter.
  3.003  MATH         Counter = 5

  3.004  DO

  3.005  IF           @Wait > 1
  3.006  WAIT         -t [V @Wait] System settling...
  3.007  ELSE
  3.008  WAIT         [D1000]
  3.009  ENDIF

  3.010  CALL         Sub Fluke ScopeMeter Send Command RS-232

  3.011  IF           @Error
  3.012  END
  3.013  ELSE
# Read measurement.
  3.014  PORT         [I]
  3.015  MATH         Counter = Counter - 1
  3.016  ENDIF

# Repeat if invalid reading or overload condition.
  3.017  UNTIL        (Counter <= 0) || (ABS(MEM) < 1E+10)

  3.018  END

  3.019  EVAL   Increment Line Number

# ====== Sub Fluke ScopeMeter Instrument Status RS-232 =====================

# This procedure checks the ScopeMeter status byte. The bit number to be
# checked must be set in the main procedure in register (@BitNum).

  4.001  LABEL        INSTRUMENT_STATUS
  4.002  MATH         @Cmd = "IS"
  4.003  CALL         Sub Fluke ScopeMeter Send Command RS-232

  4.004  IF           NOT(@Error)
# Read instrument status.
  4.005  PORT         [I]
  4.006  MATH         @Status = BIT(@BitNum, MEM)
  4.007  ENDIF

  4.008  END

  4.009  EVAL   Increment Line Number

# ====== Sub Fluke ScopeMeter Check Acknowledge RS-232 ======================

  5.001  LABEL        CHK_ACKNOWLEDGE
# This procedure checks the Test Tool acknowledge response (0 = OK),
# (>0 = Error). If an abnormal acknowledge response is received from the Test
# Tool, then the error is identified for representation to the operator.

  5.002  LABEL        CHECK_ACKNOWLEDGE
  5.003  MATH         @Error = 0; @ErrorMsg = ""
# Read acknowledge response.
  5.004  PORT         [I]

  5.005  IF           MEM > 0
  5.006  MATH         @Error = 1
  5.007  CALL         Sub Fluke ScopeMeter Error Message
  5.008  DISP         [V @ErrorMsg]
  5.008  DISP
  5.008  DISP         Press "Terminate" to abort the procedure.
  5.009  ENDIF

  5.010  END
