﻿Fluke Calibration                                           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke ScopeMeter Display Tests RS-232
DATE:                  2012-11-02 11:42:34
AUTHOR:                Fluke
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       5
NUMBER OF LINES:       89
=============================================================================
#
#  Procedure Author:
#        DFM, VY, CAD
#
#  Models covered:
#        Fluke 43, 43B Power Quality Analyzer, 12x, 19x ScopeMeter®
#        Fluke 190 series II ScopeMeter®
#
#  Compatibility:
#        MET/CAL or 5500/CAL 7.20C or later
#
#  Subprocedures:
#        Sub Fluke ScopeMeter Send Command RS-232
#
#  Required Files:
#        19x_default_display.png
#        19x_max_bright_display.png
#        19x_max_dark_display.png
#
# Required Equipment:
#        None
#
# The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  RSLT         =
  1.002  HEAD         {BACKLIGHT POWER SAVE TEST}
  1.003  TARGET
  1.004  DISP         Alternately remove and apply the battery charger power,
  1.004  DISP         verifying that the backlight is dimmed when the battery
  1.004  DISP         charger power is removed.
  1.005  EVAL   -s " Backlight dims" : Is the backlight dimmed?

  2.001  DO
  2.002  MATH         @BitNum = 6
  2.003  CALL         Sub Fluke ScopeMeter Instrument Status RS-232

  2.004  IF           NOT(@Status)
  2.005  DISP         Ensure the battery charger is reconnected to the UUT,
  2.005  DISP         then select "Advance" to continue.
  2.006  ENDIF

  2.007  UNTIL        @Status

  2.008  RSLT         =
  2.009  HEAD         {DISPLAY TESTS}
  2.010  HEAD         -2 Maximum Darkness
# Select Maintenance mode for display tests.
  2.011  MATH         @Cmd = "EM"
  2.012  CALL         Sub Fluke ScopeMeter Send Command RS-232
  2.013  MATH         @Cmd = "MAINTENANCE"
  2.014  CALL         Sub Fluke ScopeMeter Send Command RS-232
  2.015  TARGET
  2.016  MATH         @Cmd = "CL 100"
  2.017  CALL         Sub Fluke ScopeMeter Send Command RS-232
  2.018  PICE         -s " Maximum Darkness" : 19x_max_dark_display.png

  3.001  HEAD         -2 Default Brightness
  3.002  TARGET
  3.003  MATH         @Cmd = "CL 110"
  3.004  CALL         Sub Fluke ScopeMeter Send Command RS-232
  3.005  PICE         -s " Default Brightness" : 19x_default_display.png

  4.001  HEAD         -2 Maximum Brightness
  4.002  TARGET
  4.003  MATH         @Cmd = "CL 120"
  4.004  CALL         Sub Fluke ScopeMeter Send Command RS-232
  4.005  PICE         -s " Maximum Brightness" : 19x_max_bright_display.png
# Set UUT to normal operating mode.
  5.001  MATH         @Cmd = "EO"
  5.002  CALL         Sub Fluke ScopeMeter Send Command RS-232

  5.003  HEAD         -2
  5.004  END
