﻿Fluke Calibration                                           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 45 (1 yr) AC Voltage VER RS-232 /5502
INSTRUMENT:            Sub Fluke 45 (1 yr) Frequency VER RS-232 /5502
INSTRUMENT:            Sub Fluke 45 (1 yr) Resistance VER RS-232 /5502
DATE:                  2014-03-10 14:09:54
AUTHOR:                Fluke Corporation
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       23
NUMBER OF LINES:       308
CONFIGURATION:         Fluke 5502E
=============================================================================
#
#  Procedure Author:
#        DAC, DFM, VY
#
#  This procedure contains tests whose Test Uncertainty Ratios are less
#  than 4:1, based on 5502E 1 year specifications.
#
#        AC VOLTAGE:
#          300 mV Range, 15 mV @ 1 kHz; TUR 3.7143
#
#        RESISTANCE:
#           30 MΩ Range,  30 MΩ; TUR 2.4000
#          300 MΩ Range, 300 MΩ; TUR 3.7500
#
#  Source:
#        Fluke 45, Dual Display Multimeter Service Manual
#        PN 609203, March 1999 Rev.1, 1/04
#
#  Compatibility:
#        MET/CAL 8.1.7 or later
#
#  Additional Equipment Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         AC_VOLTAGE                   PSUBI("AC Voltage")
  1.002  JMPL         FREQUENCY                    PSUBI("Frequency")
  1.003  JMPL         RESISTANCE                   PSUBI("Resistance")
  1.004  DISP         Subprocedure not found!
  1.005  END

  1.006  EVAL   Increment test number

#======  Sub Fluke 45 (1 yr) AC Voltage VER RS-232 /5502  ===================

  2.001  LABEL        AC_VOLTAGE
  2.002  RSLT         =
  2.003  HEAD         {AC VOLTAGE}
  2.004  RSLT         =
  2.005  HEAD         -2{300 mV Range}
  2.006  TARGET       -p
  2.007  MATH         @UUTCommand = "VAC;RATE M;RANGE 1"
  2.008  CALL         Sub Fluke 45 Send Command RS-232
  2.009  JMPL         END                     @Abort
  2.010  5502E        +Voltage = 0.00 mV
  2.011  TARGET       -m
  2.012  CALL         Sub Fluke 45 Query Measurement RS-232
  2.013  JMPL         END                     @Abort
  2.014  MATH         MEM = MEM / 1E-3
  2.015  MEMCX  300   0.00mV         +0.75U

  3.001  5502E        +Voltage = 15.00 mV; Frequency = 1 kHz
  3.002  TARGET       -m
  3.003  CALL         Sub Fluke 45 Query Measurement RS-232
  3.004  JMPL         END                     @Abort
  3.005  MATH         MEM = MEM / 1E-3
  3.006  MEMCX  300   15.00mV        0.2% 0.10U    1kHz
#! WARNING: Test Tol 0.00013, Sys Tol 3.5e-005 V, TUR 3.7143 (< 4.00).

  4.001  5502E        +Voltage = 15.00 mV; Frequency = 100 kHz
  4.002  TARGET       -m
  4.003  CALL         Sub Fluke 45 Query Measurement RS-232
  4.004  JMPL         END                     @Abort
  4.005  MATH         MEM = MEM / 1E-3
  4.006  MEMCX  300   15.00mV        5% 0.50U      100kHz

  5.001  5502E        +Voltage = 300.00 mV; Frequency = 1 kHz
  5.002  TARGET       -m
  5.003  CALL         Sub Fluke 45 Query Measurement RS-232
  5.004  JMPL         END                     @Abort
  5.005  MATH         MEM = MEM / 1E-3
  5.006  MEMCX  300   300.00mV       0.2% 0.10U    1kHz

  6.001  5502E        +Voltage = 300.00 mV; Frequency = 100 kHz
  6.002  TARGET       -m
  6.003  CALL         Sub Fluke 45 Query Measurement RS-232
  6.004  JMPL         END                     @Abort
  6.005  MATH         MEM = MEM / 1E-3
  6.006  MEMCX  300   300.00mV       5% 0.50U      100kHz

  7.001  RSLT         =
  7.002  HEAD         -2{3 V Range}
  7.003  TARGET       -p
  7.004  MATH         @UUTCommand = "VAC;RATE M;RANGE 2"
  7.005  CALL         Sub Fluke 45 Send Command RS-232
  7.006  JMPL         END                     @Abort
  7.007  5502E        +Voltage = 3.0000 V; Frequency = 1 kHz
  7.008  TARGET       -m
  7.009  CALL         Sub Fluke 45 Query Measurement RS-232
  7.010  JMPL         END                     @Abort
  7.011  MEMCX  3     3.0000V        0.2% 0.0010U  1kHz

  8.001  RSLT         =
  8.002  HEAD         -2{30 V Range}
  8.003  TARGET       -p
  8.004  MATH         @UUTCommand = "VAC;RATE M;RANGE 3"
  8.005  CALL         Sub Fluke 45 Send Command RS-232
  8.006  JMPL         END                     @Abort
  8.007  5502E        +Voltage = 30.000 V; Frequency = 1 kHz
  8.008  TARGET       -m
  8.009  CALL         Sub Fluke 45 Query Measurement RS-232
  8.010  JMPL         END                     @Abort
  8.011  MEMCX  30    30.000V        0.2% 0.010U   1kHz

  9.001  RSLT         =
  9.002  HEAD         -2{300 V Range}
  9.003  TARGET       -p
  9.004  MATH         @UUTCommand = "VAC;RATE M;RANGE 4"
  9.005  CALL         Sub Fluke 45 Send Command RS-232
  9.006  JMPL         END                     @Abort
  9.007  5502E        +Voltage = 300.00 V; Frequency = 1 kHz
  9.008  TARGET       -m
  9.009  CALL         Sub Fluke 45 Query Measurement RS-232
  9.010  JMPL         END                     @Abort
  9.011  MEMCX  300   300.00V        0.2% 0.10U    1kHz

 10.001  RSLT         =
 10.002  HEAD         -2{750 V Range}
 10.003  TARGET       -p
 10.004  MATH         @UUTCommand = "VAC;RATE M;RANGE 5"
 10.005  CALL         Sub Fluke 45 Send Command RS-232
 10.006  JMPL         END                     @Abort
 10.007  5502E        +Voltage = 750.0 V; Frequency = 1 kHz
 10.008  TARGET       -m
 10.009  CALL         Sub Fluke 45 Query Measurement RS-232
 10.010  JMPL         END                     @Abort
 10.011  MEMCX  750   750.0V         0.2% 1.0U     1kHz

 11.001  HEAD         -2
 11.002  5502E        Standby
 11.003  HEAD
 11.004  END

 11.005  EVAL   Increment test number

#======  Sub Fluke 45 (1 yr) Frequency VER RS-232 /5502  ====================

 12.001  LABEL        FREQUENCY
 12.002  RSLT         =
 12.003  HEAD         {FREQUENCY}
 12.004  TARGET       -p
 12.005  MATH         @UUTCommand = "FREQ;RATE M;RANGE 2"
 12.006  CALL         Sub Fluke 45 Send Command RS-232
 12.007  JMPL         END                     @Abort
 12.008  5502E        +Frequency = 9.000 kHz; Voltage = 1 V
 12.009  TARGET       -m
 12.010  CALL         Sub Fluke 45 Query Measurement RS-232
 12.011  JMPL         END                     @Abort
 12.012  MATH         MEM = MEM / 1E+3
 12.013  MEMCX  10    9.0000kHz      0.05% 0.0001U 1V

 13.001  HEAD         -2
 13.002  5502E        Standby
 13.003  HEAD
 13.004  END

 13.005  EVAL   Increment test number

#======  Sub Fluke 45 (1 yr) Resistance VER RS-232 /5502  ===================

 14.001  LABEL        RESISTANCE
 14.002  RSLT         =
 14.003  HEAD         {RESISTANCE}
 14.004  RSLT         =
 14.005  JMPL         300_kO_RANGE

 14.006  LABEL        300_Ω_RANGE
 14.007  HEAD         -2{300 Ω Range}
 14.008  TARGET       -p
 14.009  PIC          5502e_45_4w
 14.010  MATH         @UUTCommand = "OHMS;RATE M;RANGE 1"
 14.011  CALL         Sub Fluke 45 Send Command RS-232
 14.012  JMPL         END                     @Abort
 14.013  5502E        +Resistance =   0.00 Ohms; LeadCompensation = 2Wire
 14.014  WAIT         -t 3 System Settling...
 14.015  TARGET       -m
 14.016  CALL         Sub Fluke 45 Query Measurement RS-232
 14.017  JMPL         END                     @Abort
 14.018  MEMCX  300   0.00Z          +0.04U

 15.001  5502E        +Resistance = 300.00 Ohms; LeadCompensation = 2Wire
 15.002  TARGET       -m
 15.003  CALL         Sub Fluke 45 Query Measurement RS-232
 15.004  JMPL         END                     @Abort
 15.005  MEMCX  300   300.00Z        0.05% 0.04U

 16.001  RSLT         =
 16.002  HEAD         -2{3 kΩ Range}
 16.003  TARGET       -p
 16.004  MATH         @UUTCommand = "OHMS;RATE M;RANGE 2"
 16.005  CALL         Sub Fluke 45 Send Command RS-232
 16.006  JMPL         END                     @Abort
 16.007  5502E        +Resistance = 0.0000 kOhms; LeadCompensation = 2Wire
 16.008  TARGET       -m
 16.009  CALL         Sub Fluke 45 Query Measurement RS-232
 16.010  JMPL         END                     @Abort
 16.011  MATH         MEM = MEM / 1E+3
 16.012  MEMCX  3     0.0000kZ       +0.0002U

 17.001  5502E        +Resistance = 3.0000 kOhms; LeadCompensation = 2Wire
 17.002  TARGET       -m
 17.003  CALL         Sub Fluke 45 Query Measurement RS-232
 17.004  JMPL         END                     @Abort
 17.005  MATH         MEM = MEM / 1E+3
 17.006  MEMCX  3     3.0000kZ       0.05% 0.0002U

 18.001  RSLT         =
 18.002  HEAD         -2{30 kΩ Range}
 18.003  TARGET       -p
 18.004  MATH         @UUTCommand = "OHMS;RATE M;RANGE 3"
 18.005  CALL         Sub Fluke 45 Send Command RS-232
 18.006  JMPL         END                     @Abort
 18.007  5502E        +Resistance = 30.000 kOhms; LeadCompensation = 2Wire
 18.008  TARGET       -m
 18.009  CALL         Sub Fluke 45 Query Measurement RS-232
 18.010  JMPL         END                     @Abort
 18.011  MATH         MEM = MEM / 1E+3
 18.012  MEMCX  30    30.000kZ       0.05% 0.002U
 19.001  JMPL         END

 19.002  LABEL        300_kO_RANGE
 19.003  RSLT         =
 19.004  HEAD         -2{300 kΩ Range}
 19.005  TARGET       -p
 19.006  MATH         @UUTCommand = "OHMS;RATE M;RANGE 4"
 19.007  CALL         Sub Fluke 45 Send Command RS-232
 19.008  JMPL         END                     @Abort
 19.009  5502E        +Resistance = 300.00 kOhms
 19.010  TARGET       -m
 19.011  CALL         Sub Fluke 45 Query Measurement RS-232
 19.012  JMPL         END                     @Abort
 19.013  MATH         MEM = MEM / 1E+3
 19.014  MEMCX  300   300.00kZ       0.05% 0.02U

 20.001  RSLT         =
 20.002  HEAD         -2{3 MΩ Range}
 20.003  TARGET       -p
 20.004  MATH         @UUTCommand = "OHMS;RATE M;RANGE 5"
 20.005  CALL         Sub Fluke 45 Send Command RS-232
 20.006  JMPL         END                     @Abort
 20.007  5502E        +Resistance = 3.0000 MOhms
 20.008  TARGET       -m
 20.009  CALL         Sub Fluke 45 Query Measurement RS-232
 20.010  JMPL         END                     @Abort
 20.011  MATH         MEM = MEM / 1E+6
 20.012  MEMCX  3     3.0000MZ       0.06% 0.0002U

 21.001  RSLT         =
 21.002  HEAD         -2{30 MΩ Range}
 21.003  TARGET       -p
 21.004  MATH         @UUTCommand = "OHMS;RATE M;RANGE 6"
 21.005  CALL         Sub Fluke 45 Send Command RS-232
 21.006  JMPL         END                     @Abort
 21.007  5502E        +Resistance = 30.000 MOhms
 21.008  TARGET       -m
 21.009  CALL         Sub Fluke 45 Query Measurement RS-232
 21.010  JMPL         END                     @Abort
 21.011  MATH         MEM = MEM / 1E+6
 21.012  MEMCX  30    30.000MZ       0.25% 0.003U

 22.001  RSLT         =
 22.002  HEAD         -2{300 MΩ Range}
 22.003  TARGET       -p
 22.004  MATH         @UUTCommand = "OHMS;RATE M;RANGE 7"
 22.005  CALL         Sub Fluke 45 Send Command RS-232
 22.006  JMPL         END                     @Abort
 22.007  5502E        +Resistance = 300.0 MOhms
 22.008  TARGET       -m
 22.009  CALL         Sub Fluke 45 Query Measurement RS-232
 22.010  JMPL         END                     @Abort
 22.011  MATH         MEM = MEM / 1E+6
 22.012  MEMCX  300   300.0MZ        2%

 23.001  5502E        Standby
 23.002  JMPL         300_Ω_RANGE

 23.003  LABEL        END
 23.004  HEAD         -2
 23.005  HEAD
 23.006  5502E        Standby
 23.007  END
