﻿Copyright (c) (2014) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Fluke 45 (1 yr) DC Voltage VER RS-232 /5502
DATE:                  2014-03-10 07:33:14
AUTHOR:                Fluke Corporation
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       11
NUMBER OF LINES:       170
CONFIGURATION:         Fluke 5502E
=============================================================================
#
#  Procedure Author:
#        DAC, DFM, VY
#
#  This procedure contains tests whose Test Uncertainty Ratios are less
#  than 4:1, based on 5502E 1 year specifications.
#
#        DC VOLTAGE:
#          100 mV Range, 0.000 mV; TUR 2.0000
#          100 mV Range, 90.000 mV; TUR 3.3929
#
#  Source:
#        Fluke 45, Dual Display Multimeter Service Manual
#        PN 609203, March 1999 Rev.1, 1/04
#
#  Compatibility:
#        MET/CAL 8.1.7 or later
#
#  Additional Equipment Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  RSLT         =
  1.002  HEAD         {DC VOLTAGE}
  1.003  RSLT         =
  1.004  HEAD         -2{100 mV Range}
  1.005  TARGET       -p
  1.006  PIC          5502e_45_2w
  1.007  MATH         @UUTCommand = "TRIGGER 3;VDC;RATE S;RANGE 1"
  1.008  CALL         Sub Fluke 45 Send Command RS-232
  1.009  JMPL         END                     @Abort
  1.010  5502E        +Voltage = 0.000 mV
  1.011  TARGET       -m
  1.012  CALL         Sub Fluke 45 Query Measurement RS-232
  1.013  JMPL         END                     @Abort
  1.014  MATH         MEM = MEM / 1E-3
  1.015  MEMCX  100   0.000mV        0.025% 0.006U
#! WARNING: Test Tol 6e-006, Sys Tol 3e-006 V, TUR 2.0000 (< 4.00).

  2.001  MATH         @UUTCommand = "VDC;RATE S;RANGE 1"
  2.002  CALL         Sub Fluke 45 Send Command RS-232
  2.003  JMPL         END                     @Abort
  2.004  5502E        +Voltage = 90.000 mV
  2.005  TARGET       -m
  2.006  CALL         Sub Fluke 45 Query Measurement RS-232
  2.007  JMPL         END                     @Abort
  2.008  MATH         MEM = MEM / 1E-3
  2.009  MEMCX  100   90.000mV       0.025% 0.006U
#! WARNING: Test Tol 2.85e-005, Sys Tol 8.4e-006 V, TUR 3.3929 (< 4.00).

  3.001  RSLT         =
  3.002  HEAD         -2{1000 mV Range}
  3.003  TARGET       -p
  3.004  MATH         @UUTCommand = "VDC;RATE S;RANGE 2"
  3.005  CALL         Sub Fluke 45 Send Command RS-232
  3.006  JMPL         END                     @Abort
  3.007  5502E        +Voltage = 900.00 mV
  3.008  TARGET       -m
  3.009  CALL         Sub Fluke 45 Query Measurement RS-232
  3.010  JMPL         END                     @Abort
  3.011  MATH         MEM = MEM / 1E-3
  3.012  MEMCX  1000  900.00mV       0.025% 0.06U

  4.001  RSLT         =
  4.002  HEAD         -2{300 mV Range}
  4.003  TARGET       -p
  4.004  MATH         @UUTCommand = "VDC;RATE M;RANGE 1"
  4.005  CALL         Sub Fluke 45 Send Command RS-232
  4.006  JMPL         END                     @Abort
  4.007  5502E        +Voltage = 0.00 mV
  4.008  WAIT         -t 2 System settling...
  4.009  TARGET       -m
  4.010  CALL         Sub Fluke 45 Query Measurement RS-232
  4.011  JMPL         END                     @Abort
  4.012  MATH         MEM = MEM / 1E-3
  4.013  MEMCX  300   0.00mV         0.025% 0.02U

  5.001  MATH         @UUTCommand = "VDC;RATE M;RANGE 1"
  5.002  CALL         Sub Fluke 45 Send Command RS-232
  5.003  JMPL         END                     @Abort
  5.004  5502E        +Voltage = 300.00 mV
  5.005  TARGET       -m
  5.006  CALL         Sub Fluke 45 Query Measurement RS-232
  5.007  JMPL         END                     @Abort
  5.008  MATH         MEM = MEM / 1E-3
  5.009  MEMCX  300   300.00mV       0.025% 0.02U

  6.001  RSLT         =
  6.002  HEAD         -2{3V Range}
  6.003  TARGET       -p
  6.004  MATH         @UUTCommand = "VDC;RATE M;RANGE 2"
  6.005  CALL         Sub Fluke 45 Send Command RS-232
  6.006  JMPL         END                     @Abort
  6.007  5502E        +Voltage = 3.0000 V
  6.008  TARGET       -m
  6.009  CALL         Sub Fluke 45 Query Measurement RS-232
  6.010  JMPL         END                     @Abort
  6.011  MEMCX  3     3.0000V        250P% 0.0002U

  7.001  5502E        +Voltage = -3.0000 V
  7.002  TARGET       -m
  7.003  CALL         Sub Fluke 45 Query Measurement RS-232
  7.004  MEMCX  3     -3.0000V       250P% 0.0002U

  8.001  RSLT         =
  8.002  HEAD         -2{30 V Range}
  8.003  TARGET       -p
  8.004  MATH         @UUTCommand = "VDC;RATE M;RANGE 3"
  8.005  CALL         Sub Fluke 45 Send Command RS-232
  8.006  JMPL         END                     @Abort
  8.007  5502E        +Voltage = 30.000 V
  8.008  TARGET       -m
  8.009  CALL         Sub Fluke 45 Query Measurement RS-232
  8.010  JMPL         END                     @Abort
  8.011  MEMCX  30    30.000V        0.025% 0.002U

  9.001  RSLT         =
  9.002  HEAD         -2{300 V Range}
  9.003  TARGET       -p
  9.004  MATH         @UUTCommand = "VDC;RATE M;RANGE 4"
  9.005  CALL         Sub Fluke 45 Send Command RS-232
  9.006  JMPL         END                     @Abort
  9.007  5502E        +Voltage = 300.00 V
  9.008  TARGET       -m
  9.009  CALL         Sub Fluke 45 Query Measurement RS-232
  9.010  JMPL         END                     @Abort
  9.011  MEMCX  300   300.00V        0.025% 0.02U

 10.001  RSLT         =
 10.002  HEAD         -2{1000 V Range}
 10.003  TARGET       -p
 10.004  MATH         @UUTCommand = "VDC;RATE M;RANGE 5"
 10.005  CALL         Sub Fluke 45 Send Command RS-232
 10.006  JMPL         END                     @Abort
 10.007  5502E        +Voltage = 1000.0 V
 10.008  TARGET       -m
 10.009  CALL         Sub Fluke 45 Query Measurement RS-232
 10.010  JMPL         END                     @Abort
 10.011  MEMCX  1000  1000.0V        0.025% 0.2U

 11.001  LABEL        END
 11.002  HEAD         -2
 11.003  5502E        Standby
 11.004  HEAD
 11.005  END
