﻿Fluke Calibration                                           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 45 (1 yr) Diode Test & Continuity VER RS-232
DATE:                  2014-03-10 14:47:49
AUTHOR:                Fluke
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       4
NUMBER OF LINES:       93
=============================================================================
#
#  Procedure Author:
#        DAC, DFM, VY
#
#  Source:
#        Fluke 45, Dual Display Multimeter Service Manual
#        PN 609203, March 1999 Rev.1, 1/04
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Additional Equipment Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  RSLT         =
  1.002  HEAD         {DIODE TEST}
  1.003  TARGET

  1.004  LABEL        DIODE_TEST
  1.005  DISP         Short the UUT V Ω Diode and COM terminals together.
  1.006  MATH         @UUTCommand = "DIODE;RATE M"
  1.007  CALL         Sub Fluke 45 Send Command RS-232
  1.008  JMPL         END                     @Abort
  1.009  TARGET       -m
  1.010  CALL         Sub Fluke 45 Query Measurement RS-232
  1.011  JMPL         END                     @Abort
  1.012  MEMCX        0.0000V        0.0008U

# Get the Continity data while the short is applied.
  2.001  JMPL         CONTINUITY

# Get new data if Repeat or Cancel is selected.
  2.002  TARGET
  2.003  JMPL         DIODE_TEST

  2.004  LABEL        DIODE_TEST_OPEN
  2.005  MATH         @UUTCommand = "DIODE;RATE M"
  2.006  CALL         Sub Fluke 45 Send Command RS-232
  2.007  JMPL         END                     @Abort
  2.008  PORT         *TRG;VAL1?[I$][I!]
# 45 sends "+1E+9" when front panel indicates "OL".
  2.009  EVAL   -e ZCMPI(MEM2, "+1E+9") : Open

  3.001  JMPL         CONTINUITY_EVALUATION

# Get new data if Repeat or Cancel is selected.
  3.002  TARGET
  3.003  JMPL         DIODE_TEST

  3.004  LABEL        CONTINUITY
  3.005  HEAD         CONTINUITY
  3.006  MATH         @UUTCommand = "CONT"
  3.007  CALL         Sub Fluke 45 Send Command RS-232
  3.008  JMPL         END                     @Abort
  3.009  OPBR         -z Is UUT emitting a tone?
  3.010  MATH         L[1] = MEM1
  3.011  DISP         Remove the short.
  3.012  OPBR         -z Is tone off and OL displayed?
  3.013  MATH         L[2] = MEM1
  3.014  JMPL         DIODE_TEST_OPEN

  3.015  LABEL        CONTINUITY_EVALUATION
  3.016  RSLT         =
  3.017  EVAL   -e L[1] && L[2] : CONTINUITY

  4.001  LABEL        END
  4.002  HEAD
  4.003  END
