﻿Fluke Calibration                                           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 45 (1 yr) VER RS-232 /5502
DATE:                  2014-03-24 13:28:09
AUTHOR:                Fluke Corporation
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       147
CONFIGURATION:         Fluke 5502E
=============================================================================
#
#  Procedure Author:
#        DAC, DFM, VY
#
#  This procedure contains tests whose Test Uncertainty Ratios are less
#  than 4:1, based on 5502E 1 year specifications.
#
#        DC VOLTAGE:
#          100 mV Range,  0 mV; TUR 2.0000
#          100 mV Range, 90 mV; TUR 3.3929
#
#        AC VOLTAGE:
#          300 mV Range, 15 mV @ 1 kHz; TUR 3.7143
#
#        RESISTANCE:
#           30 MΩ Range,  30 MΩ; TUR 2.4000
#          300 MΩ Range, 300 MΩ; TUR 3.7500
#
#        DC CURRENT:
#          10 A Range, 10 A; TUR 3.8462
#
#  Source:
#        Fluke 45, Dual Display Multimeter Service Manual
#        PN 609203, March 1999 Rev.1, 1/04
#
#  Compatibility:
#        MET/CAL 8.1.7 or later
#
#  Additional Equipment Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  5502E        Reset
  1.003  ENDIF

  1.004  ASK-   R   Q N              P                            F        V

  1.005  IF           NOT(VERSIONCHECK("8.1.7"))
  1.006  END
  1.007  ENDIF

  1.008  CALL         Sub Display Copyright
  1.009  CALL         Sub High Voltage Safety Warning
  1.010  CALL         Sub Select Failed Test Mode
  1.011  CALL         Sub Select Guardbanding & Ver Method

  1.012  HEAD         TEST CONDITIONS
  1.013  DISP         One hour warm-up time requirement.
  1.013  DISP         Ambient temperature: 18 °C - 28 °C
  1.013  DISP         Relative humidity: less than 90 %

  1.014  HEAD         EQUIPMENT SETUP

  1.015  IF           ZCMPI(@CalDev, "Fluke 5502A")
  1.016  CALL         Sub UUT RS-232 Connection DTE DB9 (m) /5502A
  1.017  ELSEIF       ZCMPI(@CalDev, "Fluke 5502E")
  1.018  CALL         Sub UUT RS-232 Connection DTE DB9 (m) /5502E
  1.019  ELSEIF       ZCMPI(@CalDev, "Fluke 5520A")
  1.020  CALL         Sub UUT RS-232 Connection DTE DB9 (m) /5520
  1.021  ELSEIF       ZCMPI(@CalDev, "Fluke 5522A")
  1.022  CALL         Sub UUT RS-232 Connection DTE DB9 (m) /5520
  1.023  ELSE
  1.024  DISP         Unsupported calibrator: "[V @CalDev]"
  1.024  DISP
  1.024  DISP         @CalDev must be one of:
  1.024  DISP
  1.024  DISP         [32] "Fluke 5502A"
  1.024  DISP         [32] "Fluke 5502E"
  1.024  DISP         [32] "Fluke 5520A"
  1.024  DISP         [32] "Fluke 5522A"
  1.025  END
  1.026  ENDIF

  1.027  CALL         Sub Fluke 45 Setup RS-232

  1.028  MATH         @UUT_Manufacturer  = "FLUKE"
  1.029  MATH         @UUT_Model         = "45"
  1.030  MATH         @UUT_AssetNum      = UUT()

  1.031  IF           NOT(EMPTY(@UUT_AssetNum))
  1.032  MATH         @UUT_SerialNum = SN(@UUT_AssetNum)
  1.033  ENDIF

  1.034  CALL         Sub Fluke 45 Query Identification RS-232
  1.035  JMPL         END                     @Abort
  1.036  CALL         Sub IEEE-488.2 Identification Query Check Response
  1.037  JMPL         END                     @Abort

  1.038  DISP         ***************************************************
  1.038  DISP         To reduce noise pickup by test leads, particularly
  1.038  DISP         during high Ohms verification, use shielded test
  1.038  DISP         cables between the Fluke 5502 and Fluke 45.
  1.038  DISP         ***************************************************

  1.039  CLEAR        *RST;LOCS[10][I!]
  1.040  JMPL         DIODE_TEST

  1.041  LABEL        DC_VOLTAGE
  1.042  CALL         Sub Fluke 45 (1 yr) DC Voltage VER RS-232 /5502
  1.043  JMPL         AC_VOLTAGE

  1.044  LABEL        DIODE_TEST
  1.045  CALL         Sub Fluke 45 (1 yr) Diode Test & Continuity VER RS-232
  1.046  JMPL         DC_VOLTAGE

  1.047  LABEL        AC_VOLTAGE
  1.048  CALL         Sub Fluke 45 (1 yr) AC Voltage VER RS-232 /5502
  1.049  CALL         Sub Fluke 45 (1 yr) Frequency VER RS-232 /5502
  1.050  CALL         Sub Fluke 45 (1 yr) Resistance VER RS-232 /5502
  1.051  CALL         Sub Fluke 45 (1 yr) 100 mA DC VER RS-232 /5502
  1.052  CALL         Sub Fluke 45 (1 yr) 10 A DC VER RS-232 /5502
  1.053  CALL         Sub Fluke 45 (1 yr) 100 mA AC VER RS-232 /5502
  1.054  CALL         Sub Fluke 45 (1 yr) 10 A AC VER RS-232 /5502

  1.055  LABEL        END

  1.056  IF           @Abort
  1.057  HEAD         V E R I F I C A T I O N   A B O R T E D !
  1.058  ENDIF

  1.059  END
