﻿Copyright (c) (2014) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Fluke 45 Setup RS-232
INSTRUMENT:            Sub Fluke 45 Query Identification RS-232
INSTRUMENT:            Sub Fluke 45 Send Command RS-232
INSTRUMENT:            Sub Fluke 45 Query Measurement RS-232
INSTRUMENT:            Sub Fluke 45 Query Response RS-232
DATE:                  2014-03-10 10:12:33
AUTHOR:                Fluke
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       6
NUMBER OF LINES:       149
=============================================================================
#
#  Procedure Author:
#        VY
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Required Equipment:
#        None
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         SETUP_RS-232                 PSUBI("Setup")
  1.002  JMPL         QUERY_IDENTIFICATION         PSUBI("Identification")
  1.003  JMPL         SEND_COMMAND                 PSUBI("Send Command")
  1.004  JMPL         QUERY_MEASUREMENT            PSUBI("Query Measurement")
  1.005  JMPL         QUERY_RESPONSE               PSUBI("Query Response")
  1.006  DISP         Subprocedure not found!
  1.007  END

  1.008  EVAL   Increment test number

# ====== Sub Fluke 45 RS-232 Setup ===========================================

  2.001  LABEL        SETUP_RS-232
  2.002  DISP         To select the proper RS-232C parameters on Fluke 45:
  2.002  DISP
  2.002  DISP         Press 2ND, then RATE to select "bAud".
  2.002  DISP         Use the up and down arrow keys to make selections.
  2.002  DISP         Select 9600 baud and press AUTO.
  2.002  DISP         Select no Parity and press AUTO.
  2.002  DISP         Select OFF Echo and press AUTO.
  2.003  PORT         [P9600,N,8,1,X][T15000][OTERM LF][TERM LF]
  2.004  MATH         @UUTCommand = "REMS"
  2.005  CALL         Sub Fluke 45 Send Command RS-232

  2.006  END

  2.007  EVAL   Increment test number

# ====== Sub Fluke 45 Query Identification ===================================

  3.001  LABEL        QUERY_IDENTIFICATION

  3.002  DO
  3.003  PORT         [T15000]*IDN?[I$]
  3.004  MATH         QueryResponse = MEM2
  3.005  CALL         Sub Fluke 45 Check Acknowledge RS-232

  3.006  IF           @Abort
  3.007  OPBR         -z Do you wish to retry?
  3.008  MATH         LoopAgain = MEM1
  3.009  ELSE
  3.010  MATH         LoopAgain = 0
  3.011  MATH         MEM2 = QueryResponse
  3.012  CALL         Sub IEEE-488.2 Identification Query Parse Response
  3.013  ENDIF

  3.014  UNTIL        NOT(LoopAgain)

  3.015  END

  3.016  EVAL   Increment test number

# ====== Sub Fluke 45 Send Command ===========================================

  4.001  LABEL        SEND_COMMAND
# backup MEM1 for it may stand for the nominal of test.
  4.002  MATH         BackupMEM1 = MEM1

  4.003  DO
  4.004  PORT         [T15000][V @UUTCommand]
  4.005  CALL         Sub Fluke 45 Check Acknowledge RS-232

  4.006  IF           @Abort
  4.007  OPBR         -z Do you wish to retry?
  4.008  MATH         LoopAgain = MEM1
  4.009  ELSE
  4.010  MATH         LoopAgain = 0
  4.011  ENDIF

  4.012  UNTIL        NOT(LoopAgain)

# Restore MEM1.
  4.013  MATH         MEM1 = BackupMEM1
  4.014  END

  4.015  EVAL   Increment test number

# ====== Sub Fluke 45 Query Measurement ======================================

  5.001  LABEL        QUERY_MEASUREMENT
# backup MEM1 for it may stand for the nominal of test.
  5.002  MATH         BackupMEM1 = MEM1

  5.003  DO
  5.004  PORT         [T15000]*TRG;VAL1?[I]
  5.005  CALL         Sub Fluke 45 Check Acknowledge RS-232

  5.006  IF           @Abort
  5.007  OPBR         -z Do you wish to retry?
  5.008  MATH         LoopAgain = MEM1
  5.009  ELSE
  5.010  MATH         LoopAgain = 0
  5.011  ENDIF

  5.012  UNTIL        NOT(LoopAgain)

# Restore MEM1.
  5.013  MATH         MEM1 = BackupMEM1
  5.014  END

  5.015  EVAL   Increment test number

# =====  Sub Fluke 45 Query Response RS-232  ================================

  6.001  LABEL        QUERY_RESPONSE

  6.002  DO
  6.003  PORT         [T15000][V @QueryCommand][I$]
  6.004  MATH         @Response = MEM2
  6.005  CALL         Sub Fluke 45 Check Acknowledge RS-232

  6.006  IF           @Abort
  6.007  OPBR         -z Do you wish to retry?
  6.008  MATH         LoopAgain = MEM1
  6.009  ELSE
  6.010  MATH         LoopAgain = 0
  6.011  ENDIF

  6.012  UNTIL        NOT(LoopAgain)

  6.013  END
