﻿Copyright (c) (2014) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub UUT RS-232 Connection DTE DB9 (m) /5520
DATE:                  2014-08-20 09:18:12
AUTHOR:                Fluke
REVISION:              $Revision: 8604 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       60
=============================================================================
#
#  Procedure Author:
#        DAC
#
#  Compatibility:
#        5500/CAL or MET/CAL 7.01 SP2 or later
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
#  This subprocedure can be called to display the correct RS-232 connection
#  for the following configuration:
#
#    Reference:  Fluke 5520A or 5522A
#
#    UUT:        Data Terminal Equipment (DTE) compatible DB9 (m)
#                RS-232 port.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  MATH         MEM2 = INI("startup", "port")
  1.002  MATH         @Error = ZCMPI(MEM2, "None")

  1.003  IF           @Error
  1.004  DISP         "port = [MEM2]" in the MET/CAL initialization file.
  1.004  DISP
  1.004  DISP         1. Terminate procedure.
  1.004  DISP         2. Select TOOLS=>Configure Default Serial Port...
  1.004  DISP         3. Set "Serial Port" to COM port to which UUT will be
  1.004  DISP         [32]  connected.
  1.005  ELSEIF       ZCMPI(MEM2, "COM5520") || ZCMPI(MEM2, "COM5522")
  1.006  DISP         Connect UUT to port labeled "Serial 2 to UUT" on
  1.006  DISP         rear panel of 552xA, using a DB9 (f) to DB9 (m)
  1.006  DISP         straight through cable.
  1.007  ELSE
  1.008  DISP         Connect UUT to [MEM2] using a DB9 (f) to DB9 (f)
  1.008  DISP         null-modem cable.
  1.009  ENDIF

  1.010  END
