﻿Copyright (c) (2015) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Fluke 2635A HYDRA (1 year) VER RS-232 /5502,DMM
DATE:                  2015-10-15 15:25:30
AUTHOR:                Fluke Calibration
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       210
CONFIGURATION:         Fluke 5502E
CONFIGURATION:         Digital Multimeter
=============================================================================
#
#  Procedure Author(s):
#        VY, DAC, ND
#
#  Source(s):
#        Fluke
#
#        HYDRA
#        2620A Data Acquisition Unit
#        2625A Data Logger
#        2635A Data Bucket
#        Service Manual
#        PN 889589, MAY 1991 Rev. 2, 4/93
#
#        HYDRA
#        2620A DATA ACQUISTION UNIT
#        2625A DATA LOGGER
#        2635A DATA BUCKET
#        Service Manual
#        PN 202231
#        February 1997
#
#        2635A HYDRA Series II Data Bucket
#        User Manual
#        Part No. 686698, November 1997 *
#
#       * The tolerances used by this procedure were taken from the published
#         specifications table.
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

# The following statements are included to force the main procedure header to
# include CONFIGURATION lines for the references used in the subprocedures.
  1.001  IF           0
  1.002  5502E        Reset
  1.003  IEEE         [@DMM]
  1.004  ENDIF

  1.005  ASK-   R   Q N              P                            A        W

  1.006  IF           NOT(VERSIONCHECK("8.1.4"))
  1.007  END
  1.008  ENDIF

  1.009  CALL         Sub Display Copyright
  1.010  CALL         Sub High Voltage Safety Warning

  1.011  HEAD         TEST CONDITIONS
  1.012  DISP         Warm-up time requirement: at least 1/2 hour.
  1.012  DISP         Ambient temperature: 18 °C - 28 °C
  1.012  DISP         Relative humidity: less than 70 %

  1.013  HEAD         SETUP PROCEDURE EXECUTION PARAMETERS
  1.014  CALL         Sub Select Failed Test Mode
  1.015  CALL         Sub Select Guardbanding & Ver Method (No NTHROW)

  1.016  CALL         Sub Fluke HYDRA Input Configuration VER

  1.017  HEAD         PRELIMINARY INSTRUCTIONS
  1.018  TARGET
# Setup UUT RS-232 communication.
  1.019  CALL         Sub UUT RS-232 Connection DTE DB9 (m) /5502E
  1.020  CALL         Sub Fluke HYDRA Setup RS-232

# Query UUT name and firmware version to make sure correct UUT is connected.
  1.021  CALL         Sub Fluke HYDRA Query Identification RS-232
  1.022  JMPL         END                          @Abort
  1.023  CALL         Sub IEEE-488.2 Identification Query Check Response
  1.024  JMPL         END                          @Abort
  1.025  CALL         Sub Fluke HYDRA Check Firmware Revision

  1.026  IF           @SeriesII
  1.027  DISP         UUT is a [V @ModelNum] II, not a [V @UUT_Model].
  1.027  DISP
  1.027  DISP         Select the correct procedure.
  1.028  END
  1.029  ENDIF

# Check the UUT temperature configuration, set it to Celsiur scale and
# enable temperature open thermocouple detection by procedure test request,
# record the original setting for restored before the procedure ended. This
# configuration can only be changed by remote command and can not be changed
# even if UUT is reset or powered off and on again.
  1.030  MATH         @QueryCommand = "TEMP_CONFIG?"
  1.031  CALL         Sub Fluke HYDRA Query Response RS-232
  1.032  JMPL         END                          @Abort

  1.033  IF           NOT(ZCMPI(@Response, "2"))
  1.034  MATH         @UUTCommand = "TEMP_CONFIG 2"
  1.035  CALL         Sub Fluke HYDRA Send Command RS-232
  1.036  ENDIF

  1.037  JMPL         END                          @Abort
  1.038  MATH         TempConfig = @Response

  1.039  CALL         Sub Fluke HYDRA Self Test RS-232
  1.040  JMPL         END                          @Abort

# NOTE: The execution order of this verification procedure has been optimized
# to minimize operator intervention, while retaining the correct sequence for
# reported test results.  For more information about the method used, refer
# to this application note, available at www.flukecal.com:
# Application Note 6001075: Preserving Results Order While Optimizing
# Execution Sequence in MET/CAL Procedures.

  1.041  CALL         Sub Fluke HYDRA (1 yr) DC Voltage VER RS-232 /5502
  1.042  JMPL         END                          @Abort

  1.043  CALL         Sub Fluke HYDRA (1 yr) AC Voltage VER RS-232 /5502
  1.044  JMPL         END                          @Abort

  1.045  CALL         Sub Fluke HYDRA (1 yr) Frequency VER RS-232 /5502
  1.046  JMPL         END                          @Abort
  1.047  JMPL         TC_RANGE_ACC

  1.048  LABEL        INTEGRITY
  1.049  CALL         Sub Fluke HYDRA (1 yr) Integrity VER RS-232 /5502
  1.050  JMPL         END                          @Abort
  1.051  JMPL         DIO_INPUT

  1.052  LABEL        TC_RANGE_ACC
  1.053  CALL         Sub Fluke HYDRA (1 yr) TC Range VER RS-232 /5502
  1.054  JMPL         END                          @Abort
  1.055  JMPL         OPEN_TC_RESPONSE

  1.056  LABEL        4W_RESISTANCE
  1.057  CALL         Sub Fluke HYDRA (1 yr) 4 Terminal Ohms VER RS-232 /5502
  1.058  JMPL         END                          @Abort
  1.059  JMPL         INTEGRITY

  1.060  LABEL        TC_TEMPERATURE_ACC
  1.061  CLEAR        -c Sub Set ITS-90 /5502
  1.062  CALL         Sub Fluke HYDRA (1 yr) TC Temp VER RS-232 /5502
  1.063  JMPL         END

  1.064  LABEL        OPEN_TC_RESPONSE
  1.065  CALL         Sub Fluke HYDRA (1 yr) OTC Resp VER RS-232 /5502
  1.066  JMPL         END                          @Abort

  1.067  CALL         Sub Fluke 2635A HYDRA (1 yr) RTD VER RS-232 /5502
  1.068  JMPL         END                          @Abort
  1.069  JMPL         4W_RESISTANCE

  1.070  LABEL        DIO_INPUT
  1.071  CALL         Sub Fluke HYDRA (1 yr) DIO Input VER RS-232 /5502
  1.072  JMPL         END                          @Abort
  1.073  JMPL         TOTALIZER_SENSITIVITY

  1.074  LABEL        TOTALIZER
  1.075  CALL         Sub Fluke HYDRA (1 yr) Totalizer VER RS-232
  1.076  JMPL         END                          @Abort
  1.077  JMPL         TC_TEMPERATURE_ACC

  1.078  LABEL        TOTALIZER_SENSITIVITY
  1.079  CALL         Sub Fluke HYDRA (1 yr) Sensitivity VER RS-232 /5502
  1.080  JMPL         END                          @Abort
  1.081  CALL         Sub Fluke HYDRA (1 yr) DIO Output VER RS-232 /DMM
  1.082  JMPL         END                          @Abort
  1.083  CALL         Sub Fluke HYDRA (1 yr) Alarm Out VER RS-232 /5502,DMM
  1.084  JMPL         END                          @Abort
  1.085  CALL         Sub Fluke HYDRA (1 yr) ExtTrig Input VER RS-232
  1.086  JMPL         END                          @Abort
  1.087  JMPL         TOTALIZER

  1.088  LABEL        END

  1.089  IF           @Abort
  1.090  RSLT         =
  1.091  HEAD         V E R I F I C A T I O N  A B O R T E D !

  1.092  ELSE
  1.093  MATH         @UUTCommand = "*RST"
  1.094  CALL         Sub Fluke HYDRA Send Command RS-232

# Restore the UUT original temperature configuration.
  1.095  IF           ISVAR("TempConfig")
  1.096  MATH         @UUTCommand = "TEMP_CONFIG " & TempConfig
  1.097  CALL         Sub Fluke HYDRA Send Command RS-232
  1.098  ENDIF

  1.099  MATH         @UUTCommand = "LOCS"
  1.100  CALL         Sub Fluke HYDRA Send Command RS-232
  1.101  ENDIF

  1.102  END
