﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke HYDRA (1 yr) Alarm Out VER RS-232 /5502,DMM
DATE:                  2015-11-19 06:32:10
AUTHOR:                Fluke Calibration
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       13
NUMBER OF LINES:       200
CONFIGURATION:         Fluke 5502E
CONFIGURATION:         Digital Multimeter
=============================================================================
#
#  Procedure Author(s):
#        VY, ND
#
#  Model(s) Covered:
#       2620A, 2625A, 2635A HYDRA
#       2620A, 2625A, 2635A HYDRA Series II
#
#  Source(s):
#        Fluke
#
#        HYDRA
#        2620A Data Acquisition Unit
#        2625A Data Logger
#        2635A Data Bucket
#        Service Manual
#        PN 889589, MAY 1991 Rev. 2, 4/93
#
#        HYDRA
#        2620A DATA ACQUISTION UNIT
#        2625A DATA LOGGER
#        2635A DATA BUCKET
#        Service Manual
#        PN 202231
#        February 1997
#
#        2620A/2625A
#        Hydra Series II Data Acquisition Unit
#        Hydra Series II Data Logger
#        Users Manual
#        PN 686675
#        November 1997 *
#
#       * The tolerances used by this procedure were taken from the published
#         specifications table.
#
#  Compatibility:
#        MET/CAL 8.1.4 or later
#
#	Additional Equipment and/or Accessories Required:
#        Specially Configured Input Module
#        Specially Configured Rear Terminals
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  IEEE         [@DMM]
  1.003  ENDIF

  1.004  RSLT         =
  1.005  HEAD         {DEDICATED ALARM OUTPUT}
  1.006  RSLT         =
  1.007  HEAD         -2{Alarm 0}
  1.008  CALL         Sub Initialize /DMM
  1.009  MATH         @DMM_Func = "DC_Voltage"
  1.010  TARGET
  1.011  PIC          55xx_DMM_HYDRA_Alarm_0_Test.jpg
  1.012  CALL         Sub Reset /DMM
  1.013  MATH         @UUTCommand = "*RST"
  1.014  CALL         Sub Fluke HYDRA Send Command RS-232
  1.015  JMPL         END                          @Abort
  1.016  CALL         Sub Measure /DMM
  1.017  EVAL   -e  MEM >= 3.8 : [32] No Alarm: HIGH state

  2.001  MATH         @UUTCommand = "MON 0;FUNC 0,VDC,2;MON 1,0"
  2.002  CALL         Sub Fluke HYDRA Send Command RS-232
  2.003  JMPL         END                          @Abort
  2.004  5502E        +Voltage = 0.9900 V
  2.005  MATH         @UUTCommand = "ALARM_LIMIT 0,1,HI,1.0000;INTVL 0,0,5"
  2.006  CALL         Sub Fluke HYDRA Send Command RS-232
  2.007  JMPL         END                          @Abort
  2.008  MATH         @UUTCommand = "SCAN 1"
  2.009  CALL         Sub Fluke HYDRA Send Command RS-232
  2.010  JMPL         END                          @Abort
  2.011  WAIT         -t 2 Waiting Alarm event...
  2.012  CALL         Sub Measure /DMM
  2.013  EVAL   -e  MEM >= 3.8 : [32] Alarm is not stimulated, HIGH state

  3.001  5502E        +Voltage = 1.1000 V
  3.002  WAIT         -t 2 Waiting Alarm event...
  3.003  CALL         Sub Measure /DMM
  3.004  EVAL   -e  MEM <= 0.8 : [32] Alarm is stimulated: LOW state

  4.001  RSLT         =
  4.002  HEAD         -2{Alarm 1}
  4.003  TARGET
  4.004  PIC          55xx_DMM_HYDRA_Alarm_1_Test.jpg
  4.005  MATH         @UUTCommand = "*RST"
  4.006  CALL         Sub Fluke HYDRA Send Command RS-232
  4.007  JMPL         END                          @Abort
  4.008  CALL         Sub Measure /DMM
  4.009  EVAL   -e  MEM >= 3.8 : [32] No Alarm: HIGH state

  5.001  MATH         @UUTCommand = "MON 0;FUNC 1,VDC,2;MON 1,1"
  5.002  CALL         Sub Fluke HYDRA Send Command RS-232
  5.003  JMPL         END                          @Abort
  5.004  5502E        +Voltage = 0.9900 V
  5.005  MATH         @UUTCommand = "ALARM_LIMIT 1,1,HI,1.0000;INTVL 0,0,5"
  5.006  CALL         Sub Fluke HYDRA Send Command RS-232
  5.007  JMPL         END                          @Abort
  5.008  MATH         @UUTCommand = "SCAN 1"
  5.009  CALL         Sub Fluke HYDRA Send Command RS-232
  5.010  JMPL         END                          @Abort
  5.011  WAIT         -t 2 Waiting Alarm event...
  5.012  CALL         Sub Measure /DMM
  5.013  EVAL   -e  MEM >= 3.8 : [32] Alarm is not stimulated, HIGH state

  6.001  5502E        +Voltage = 1.1000 V
  6.002  WAIT         -t 2 Waiting Alarm event...
  6.003  CALL         Sub Measure /DMM
  6.004  EVAL   -e  MEM <= 0.8 : [32] Alarm is stimulated: LOW state

  7.001  RSLT         =
  7.002  HEAD         -2{Alarm 2}
  7.003  TARGET
  7.004  PIC          55xx_DMM_HYDRA_Alarm_2_Test.jpg
  7.005  MATH         @UUTCommand = "*RST"
  7.006  CALL         Sub Fluke HYDRA Send Command RS-232
  7.007  JMPL         END                          @Abort
  7.008  CALL         Sub Measure /DMM
  7.009  EVAL   -e  MEM >= 3.8 : [32] No Alarm: HIGH state

  8.001  MATH         @UUTCommand = "MON 0;FUNC 2,VDC,2;MON 1,2"
  8.002  CALL         Sub Fluke HYDRA Send Command RS-232
  8.003  JMPL         END                          @Abort
  8.004  5502E        +Voltage = 0.9900 V
  8.005  MATH         @UUTCommand = "ALARM_LIMIT 2,1,HI,1.0000;INTVL 0,0,5"
  8.006  CALL         Sub Fluke HYDRA Send Command RS-232
  8.007  JMPL         END                          @Abort
  8.008  MATH         @UUTCommand = "SCAN 1"
  8.009  CALL         Sub Fluke HYDRA Send Command RS-232
  8.010  JMPL         END                          @Abort
  8.011  WAIT         -t 2 Waiting Alarm event...
  8.012  CALL         Sub Measure /DMM
  8.013  EVAL   -e  MEM >= 3.8 : [32] Alarm is not stimulated, HIGH state

  9.001  5502E        +Voltage = 1.1000 V
  9.002  WAIT         -t 2 Waiting Alarm event...
  9.003  CALL         Sub Measure /DMM
  9.004  EVAL   -e  MEM <= 0.8 : [32] Alarm is stimulated: LOW state

 10.001  RSLT         =
 10.002  HEAD         -2{Alarm 3}
 10.003  TARGET
 10.004  PIC          55xx_DMM_HYDRA_Alarm_3_Test.jpg
 10.005  MATH         @UUTCommand = "*RST"
 10.006  CALL         Sub Fluke HYDRA Send Command RS-232
 10.007  JMPL         END                          @Abort
 10.008  CALL         Sub Measure /DMM
 10.009  EVAL   -e  MEM >= 3.8 : [32] No Alarm: HIGH state

 11.001  MATH         @UUTCommand = "MON 0;FUNC 3,VDC,2;MON 1,3"
 11.002  CALL         Sub Fluke HYDRA Send Command RS-232
 11.003  JMPL         END                          @Abort
 11.004  5502E        +Voltage = 0.9900 V
 11.005  MATH         @UUTCommand = "ALARM_LIMIT 3,1,HI,1.0000;INTVL 0,0,5"
 11.006  CALL         Sub Fluke HYDRA Send Command RS-232
 11.007  JMPL         END                          @Abort
 11.008  MATH         @UUTCommand = "SCAN 1"
 11.009  CALL         Sub Fluke HYDRA Send Command RS-232
 11.010  JMPL         END                          @Abort
 11.011  WAIT         -t 2 Waiting Alarm event...
 11.012  CALL         Sub Measure /DMM
 11.013  EVAL   -e  MEM >= 3.8 : [32] Alarm is not stimulated, HIGH state

 12.001  5502E        +Voltage = 1.1000 V
 12.002  WAIT         -t 2 Waiting Alarm event...
 12.003  CALL         Sub Measure /DMM
 12.004  EVAL   -e  MEM <= 0.8 : [32] Alarm is stimulated: LOW state

 13.001  LABEL        END
 13.002  HEAD         -2
 13.003  5502E        Standby
 13.004  HEAD
 13.005  END
