﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke HYDRA (1 yr) DIO Input VER RS-232 /5502
INSTRUMENT:            Sub Fluke HYDRA (1 yr) Sensitivity VER RS-232 /5502
DATE:                  2015-11-19 06:33:59
AUTHOR:                Fluke Calibration
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       13
NUMBER OF LINES:       196
CONFIGURATION:         Fluke 5502E
=============================================================================
#
#  Procedure Author(s):
#        VY, ND
#
#  Model(s) Covered:
#        2620A, 2625A, 2635A HYDRA
#        2620A, 2625A, 2635A HYDRA Series II
#
#  Source(s):
#        Fluke
#
#        HYDRA
#        2620A Data Acquisition Unit
#        2625A Data Logger
#        2635A Data Bucket
#        Service Manual
#        PN 889589, MAY 1991 Rev. 2, 4/93
#
#        HYDRA
#        2620A DATA ACQUISTION UNIT
#        2625A DATA LOGGER
#        2635A DATA BUCKET
#        Service Manual
#        PN 202231
#        February 1997
#
#        2620A/2625A
#        Hydra Series II Data Acquisition Unit
#        Hydra Series II Data Logger
#        Users Manual
#        PN 686675
#        November 1997 *
#
#       * The tolerances used by this procedure were taken from the published
#         specifications table.
#
#  Compatibility:
#        MET/CAL 8.1.4 or later
#
#  Additional Equipment and/or Accessories Required:
#        Specially Configured Rear Terminals
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         DIGITAL_IO_INPUT             PSUBI("DIO Input")
  1.002  JMPL         TOTALIZER_SENSITIVITY        PSUBI("Sensitivity")
  1.003  DISP         Subprocedure not found!
  1.004  END

  1.005  EVAL   Increment Test Number

# =====  Sub Fluke HYDRA (1 yr) DIO Input VER RS-232 /5502  ==================

  2.001  LABEL        DIGITAL_IO_INPUT
# Enable the automatic reset of calibrator after an evaluation.
  2.002  ASK+       Q

  2.003  RSLT         =
  2.004  HEAD         {DIGITAL INPUT}
  2.005  HEAD         -2 0-7, all HIGH
  2.006  TARGET
  2.007  MATH         @UUTCommand = "*RST"
  2.008  CALL         Sub Fluke HYDRA Send Command RS-232
  2.009  JMPL         END                          @Abort
  2.010  PIC          HYDRA_DIO_In_OPEN_Test.jpg
# Set parameter for Sub Fluke HYDRA Query Measurement RS-232.
  2.011  MATH         @QueryCommand = "DIO_LEVELS?"
  2.012  CALL         Sub Fluke HYDRA Query Measurement RS-232
  2.013  JMPL         END                          @Abort
  2.014  EVAL   -e  MEM == 255 : [32] Inputs 0-7, all HIGH

  3.001  HEAD         -2 1-7 HIGH, 0 LOW
  3.002  TARGET
  3.003  PIC          55xx_HYDRA_DIO_In_0_Test.jpg
  3.004  5502E        +Voltage = 0 V
  3.005  CALL         Sub Fluke HYDRA Query Measurement RS-232
  3.006  JMPL         END                          @Abort
  3.007  EVAL   -e  MEM == 254 : [32] Inputs 1-7 HIGH, input 0 LOW

  4.001  HEAD         -2 0, 2-7 HIGH, 0 LOW
  4.002  TARGET
  4.003  PIC          55xx_HYDRA_DIO_In_1_Test.jpg
  4.004  5502E        +Voltage = 0 V
  4.005  CALL         Sub Fluke HYDRA Query Measurement RS-232
  4.006  JMPL         END                          @Abort
  4.007  EVAL   -e  MEM == 253 : [32] Inputs 0,2-7 HIGH, input 1 LOW

  5.001  HEAD         -2 0-1, 3-7 HIGH, 2 LOW
  5.002  TARGET
  5.003  PIC          55xx_HYDRA_DIO_In_2_Test.jpg
  5.004  5502E        +Voltage = 0 V
  5.005  CALL         Sub Fluke HYDRA Query Measurement RS-232
  5.006  JMPL         END                          @Abort
  5.007  EVAL   -e  MEM == 251 : [32] Inputs 0-1 and 3-7 HIGH, input 2 LOW

  6.001  HEAD         -2 0-2, 4-7 HIGH, 3 LOW
  6.002  TARGET
  6.003  PIC          55xx_HYDRA_DIO_In_3_Test.jpg
  6.004  5502E        +Voltage = 0 V
  6.005  CALL         Sub Fluke HYDRA Query Measurement RS-232
  6.006  JMPL         END                          @Abort
  6.007  EVAL   -e  MEM == 247 : [32] Inputs 0-2 and 4-7 HIGH, input 3 LOW

  7.001  HEAD         -2 0-3, 5-7 HIGH, 4 LOW
  7.002  TARGET
  7.003  PIC          55xx_HYDRA_DIO_In_4_Test.jpg
  7.004  5502E        +Voltage = 0 V
  7.005  CALL         Sub Fluke HYDRA Query Measurement RS-232
  7.006  JMPL         END                          @Abort
  7.007  EVAL   -e  MEM == 239 : [32] Inputs 0-3 and 5-7 HIGH, input 4 LOW

  8.001  HEAD         -2 0-4, 6-7 HIGH, 5 LOW
  8.002  TARGET
  8.003  PIC          55xx_HYDRA_DIO_In_5_Test.jpg
  8.004  5502E        +Voltage = 0 V
  8.005  CALL         Sub Fluke HYDRA Query Measurement RS-232
  8.006  JMPL         END                          @Abort
  8.007  EVAL   -e  MEM == 223 : [32] Inputs 0-4 and 6-7 HIGH, input 5 LOW

  9.001  HEAD         -2 0-5, 7 HIGH, 6 LOW
  9.002  TARGET
  9.003  PIC          55xx_HYDRA_DIO_In_6_Test.jpg
  9.004  5502E        +Voltage = 0 V
  9.005  CALL         Sub Fluke HYDRA Query Measurement RS-232
  9.006  JMPL         END                          @Abort
  9.007  EVAL   -e  MEM == 191 : [32] Inputs 0-5 and 7 HIGH, input 6 LOW

 10.001  HEAD         -2 0-6 HIGH, 7 LOW
 10.002  TARGET
 10.003  PIC          55xx_HYDRA_DIO_In_7_Test.jpg
 10.004  5502E        +Voltage = 0 V
 10.005  CALL         Sub Fluke HYDRA Query Measurement RS-232
 10.006  JMPL         END                          @Abort
 10.007  EVAL   -e  MEM == 127 : [32] Inputs 0-6 HIGH, input 7 LOW

# Disable the automatic reset of calibrator after a test.
 11.001  ASK-       Q

 11.002  HEAD         -2
 11.003  5502E        Standby
 11.004  HEAD
 11.005  END

 11.006  EVAL   Increment Test Number

# =====  Sub Fluke HYDRA (1 yr) Sensitivity VER RS-232 /5502  ================

 12.001  LABEL        TOTALIZER_SENSITIVITY
 12.002  RSLT         =
 12.003  HEAD         TOTALIZER SENSITIVITY
 12.004  TARGET
 12.005  MATH         @UUTCommand = "*RST;LOCS"
 12.006  CALL         Sub Fluke HYDRA Send Command RS-232
 12.007  JMPL         END                          @Abort
 12.008  PIC          55xx_HYDRA_TotalizerSense.jpg
 12.009  DISP         Press UUT TOTAL button to enter the TOTLIZER function.
 12.010  MATH         @UUTCommand = "REMS;TOTAL 0"
 12.011  CALL         Sub Fluke HYDRA Send Command RS-232
 12.012  JMPL         END                          @Abort
 12.013  5502E        +Frequency = 10 Hz; Voltage = 1.5 V
 12.014  MESS         Is the totalizing value incrementing at a 10 count
 12.014  MESS         per second rate?
 12.015  EVAL   -s "TOTALIZER SENSITIVITY" :

 13.001  MESS

 13.002  LABEL        END
 13.003  HEAD         -2
 13.004  5502E        Standby
 13.005  HEAD
 13.006  END
