﻿Copyright (c) (2015) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Fluke HYDRA (1 yr) Integrity VER RS-232 /5502
INSTRUMENT:            Sub Fluke HYDRA (1 yr) TC Temp VER RS-232 /5502
DATE:                  2015-11-20 11:11:17
AUTHOR:                Fluke Calibration
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       4
NUMBER OF LINES:       187
CONFIGURATION:         Fluke 5502E
=============================================================================
#
#  Procedure Author(s):
#        VY, ND
#
#  Model(s) Covered:
#        2620A, 2625A, 2635A HYDRA
#
#  This procedure contains tests whose Test Uncertainty Ratios are less
#  than 4:1, based on 5502E (1 year) specifications.
#
#       TC
#        20 °C; TUR 3.1250
#
#  Source(s):
#        Fluke
#
#        HYDRA
#        2620A Data Acquisition Unit
#        2625A Data Logger
#        2635A Data Bucket
#        Service Manual
#        PN 889589, MAY 1991 Rev. 2, 4/93
#
#        HYDRA
#        2620A DATA ACQUISTION UNIT
#        2625A DATA LOGGER
#        2635A DATA BUCKET
#        Service Manual
#        PN 202231
#        February 1997
#
#        2620A/2625A
#        Hydra Series II Data Acquisition Unit
#        Hydra Series II Data Logger
#        Users Manual
#        PN 686675
#        November 1997 *
#
#       * The tolerances used by this procedure were taken from the published
#         specifications table.
#
#  Compatibility:
#        MET/CAL 8.1.4 or later
#
#	Additional Equipment and/or Accessories Required:
#       Specially Configured Input Module
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         INTEGRITY                         PSUBI("Integrity")
  1.002  JMPL         TC_TEMPERATURE_ACCURACY           PSUBI("TC Temp")
  1.003  DISP         Subprocedure not found!
  1.004  END

  1.005  EVAL   Increment Test Number

# =====  Sub Fluke HYDRA (1 yr) Integrity VER RS-232 /5502  ==================

  2.001  LABEL        INTEGRITY
  2.002  RSLT         =
  2.003  HEAD         {CHANNEL INTEGRITY}
  2.004  MATH         @Chan = 1
  2.005  CALL         Sub HYDRA (1 yr) Ch1,11 Integrity VER RS-232 /5502
  2.006  JMPL         END                          @Abort
  2.007  JMPL         INTEGRITY_CHANNEL_11

  2.008  LABEL        INTEGRITY_CHANNEL_2
  2.009  MATH         @Chan = 2
  2.010  CALL         Sub HYDRA (1 yr) Ch2-20 Integrity VER RS-232 /5502
  2.011  JMPL         END                          @Abort
  2.012  MATH         @Chan = 3
  2.013  CALL         Sub HYDRA (1 yr) Ch2-20 Integrity VER RS-232 /5502
  2.014  JMPL         END                          @Abort
  2.015  MATH         @Chan = 4
  2.016  CALL         Sub HYDRA (1 yr) Ch2-20 Integrity VER RS-232 /5502
  2.017  JMPL         END                          @Abort
  2.018  MATH         @Chan = 5
  2.019  CALL         Sub HYDRA (1 yr) Ch2-20 Integrity VER RS-232 /5502
  2.020  JMPL         END                          @Abort
  2.021  MATH         @Chan = 6
  2.022  CALL         Sub HYDRA (1 yr) Ch2-20 Integrity VER RS-232 /5502
  2.023  JMPL         END                          @Abort
  2.024  MATH         @Chan = 7
  2.025  CALL         Sub HYDRA (1 yr) Ch2-20 Integrity VER RS-232 /5502
  2.026  JMPL         END                          @Abort
  2.027  MATH         @Chan = 8
  2.028  CALL         Sub HYDRA (1 yr) Ch2-20 Integrity VER RS-232 /5502
  2.029  JMPL         END                          @Abort
  2.030  MATH         @Chan = 9
  2.031  CALL         Sub HYDRA (1 yr) Ch2-20 Integrity VER RS-232 /5502
  2.032  JMPL         END                          @Abort
  2.033  MATH         @Chan = 10
  2.034  CALL         Sub HYDRA (1 yr) Ch2-20 Integrity VER RS-232 /5502
  2.035  JMPL         END                          @Abort
  2.036  JMPL         INTEGRITY_CHANNEL_12

  2.037  LABEL        INTEGRITY_CHANNEL_11
  2.038  MATH         @Chan = 11
  2.039  CALL         Sub HYDRA (1 yr) Ch1,11 Integrity VER RS-232 /5502
  2.040  JMPL         END                          @Abort
  2.041  JMPL         INTEGRITY_CHANNEL_2

  2.042  LABEL        INTEGRITY_CHANNEL_12
  2.043  MATH         @Chan = 12
  2.044  CALL         Sub HYDRA (1 yr) Ch2-20 Integrity VER RS-232 /5502
  2.045  JMPL         END                          @Abort
  2.046  MATH         @Chan = 13
  2.047  CALL         Sub HYDRA (1 yr) Ch2-20 Integrity VER RS-232 /5502
  2.048  JMPL         END                          @Abort
  2.049  MATH         @Chan = 14
  2.050  CALL         Sub HYDRA (1 yr) Ch2-20 Integrity VER RS-232 /5502
  2.051  JMPL         END                          @Abort
  2.052  MATH         @Chan = 15
  2.053  CALL         Sub HYDRA (1 yr) Ch2-20 Integrity VER RS-232 /5502
  2.054  JMPL         END                          @Abort
  2.055  MATH         @Chan = 16
  2.056  CALL         Sub HYDRA (1 yr) Ch2-20 Integrity VER RS-232 /5502
  2.057  JMPL         END                          @Abort
  2.058  MATH         @Chan = 17
  2.059  CALL         Sub HYDRA (1 yr) Ch2-20 Integrity VER RS-232 /5502
  2.060  JMPL         END                          @Abort
  2.061  MATH         @Chan = 18
  2.062  CALL         Sub HYDRA (1 yr) Ch2-20 Integrity VER RS-232 /5502
  2.063  JMPL         END                          @Abort
  2.064  MATH         @Chan = 19
  2.065  CALL         Sub HYDRA (1 yr) Ch2-20 Integrity VER RS-232 /5502
  2.066  JMPL         END                          @Abort
  2.067  MATH         @Chan = 20
  2.068  CALL         Sub HYDRA (1 yr) Ch2-20 Integrity VER RS-232 /5502

  2.069  HEAD
  2.070  END

  2.071  EVAL   Increment Test Number

# =====  Sub Fluke HYDRA (1 yr) TC Temp VER RS-232 /5502  ==================

  3.001  LABEL        TC_TEMPERATURE_ACCURACY
  3.002  RSLT         =
  3.003  HEAD         {TC TEMPERATURE ACCURACY: Type K}
  3.004  TARGET       -p
  3.005  MATH         @UUTCommand = "*RST;MON 0;FUNC 1,TEMP,K;MON 1,1"
  3.006  CALL         Sub Fluke HYDRA Send Command RS-232
  3.007  JMPL         END                          @Abort
  3.008  PIC          55xx_UIM_TCTest.jpg
  3.009  WAIT         -t 2:00 Thermal dissipating...
  3.010  5502E        TemperatureScale = IPTS_68
  3.010  5502E        +Temperature = 20.0 degC; TC_Type = K
  3.011  WAIT         -t 2 System settling...
  3.012  TARGET       -m
# Set parameter for Sub Fluke HYDRA Query Measurement RS-232.
  3.013  MATH         @QueryCommand = "MON_VAL?"
  3.014  CALL         Sub Fluke HYDRA Query Measurement RS-232
  3.015  JMPL         END                          @Abort
  3.016  MEMCX        20.0degC       0.50U
#! WARNING: Test Tol 0.5, Sys Tol 0.16 degC, TUR 3.1250 (< 4.00).

  4.001  LABEL        END
  4.002  HEAD         -2
  4.003  5502E        Reset
  4.004  HEAD
  4.005  END
