﻿Copyright (c) (2015) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Fluke HYDRA (1 yr) DC Voltage VER RS-232 /5502
INSTRUMENT:            Sub Fluke HYDRA (1 yr) AC Voltage VER RS-232 /5502
INSTRUMENT:            Sub Fluke HYDRA (1 yr) 4 Terminal Ohms VER RS-232 /5502
INSTRUMENT:            Sub Fluke HYDRA (1 yr) Frequency VER RS-232 /5502
INSTRUMENT:            Sub Fluke HYDRA (1 yr) TC Range VER RS-232 /5502
DATE:                  2015-11-20 11:01:37
AUTHOR:                Fluke Calibration
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       37
NUMBER OF LINES:       517
CONFIGURATION:         Fluke 5502E
=============================================================================
#
#  Procedure Author(s):
#        VY, ND
#
#  Model(s) Covered:
#        2620A, 2625A, 2635A HYDRA
#
#  This procedure contains tests whose Test Uncertainty Ratios are less
#  than 4:1, based on 5502E (1 year) specifications.
#
#       DC VOLTAGE
#          0 mV; TUR 2.3333
#
#       4-TERMINAL RESISTANCE
#         10 MΩ; TUR 2.3140
#
#       THERMOCOUPLE
#          0 mV; TUR 2.3333
#
#  Source(s):
#        Fluke
#
#        HYDRA
#        2620A Data Acquisition Unit
#        2625A Data Logger
#        2635A Data Bucket
#        Service Manual
#        PN 889589, MAY 1991 Rev. 2, 4/93
#
#        HYDRA
#        2620A DATA ACQUISTION UNIT
#        2625A DATA LOGGER
#        2635A DATA BUCKET
#        Service Manual
#        PN 202231
#        February 1997
#
#        2620A/2625A
#        Hydra Series II Data Acquisition Unit
#        Hydra Series II Data Logger
#        Users Manual
#        PN 686675
#        November 1997 *
#
#       * The tolerances used by this procedure were taken from the published
#         specifications table.
#
#  Compatibility:
#        MET/CAL 8.1.4 or later
#
#  Additional Equipment and/or Accessories Required:
#        Specially Configured Input Module
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  MATH         @UUTCommand = "*RST"
  1.002  CALL         Sub Fluke HYDRA Send Command RS-232
  1.003  JMPL         END                          @Abort

# Set parameter for Sub Fluke HYDRA Query Measurement RS-232.
  1.004  MATH         @QueryCommand = "MON_VAL?"

  1.005  JMPL         DC_VOLTAGE                   PSUBI("DC Voltage")
  1.006  JMPL         AC_VOLTAGE                   PSUBI("AC Voltage")
  1.007  JMPL         4_TERMINAL_OHMS              PSUBI("4 Terminal Ohms")
  1.008  JMPL         FREQUENCY                    PSUBI("Frequency")
  1.009  JMPL         THERMOCOUPLE                 PSUBI("TC Range")
  1.010  DISP         Subprocedure not found!
  1.011  END

  1.012  EVAL   Increment Test Number

# =====  Sub Fluke HYDRA (1 yr) DC Voltage VER RS-232 /5502  =================

  2.001  LABEL        DC_VOLTAGE
  2.002  RSLT         =
  2.003  RSLT         =ACCURACY VERIFICATION
  2.004  RSLT         =
  2.005  HEAD         {DC VOLTAGE}

  2.006  IF           ZCMPI(@ModelNum, "2635A")
  2.007  RSLT         =
  2.008  RSLT         = 90 mV Range
  2.009  TARGET       -p
  2.010  HEAD         -2 90 mV Range
  2.011  PIC          55xx_HYDRA_VoltTest.jpg
  2.012  DISP         The next routine operator intervention occurs
  2.012  DISP         in approximately 2 minutes...
  2.013  MATH         @UUTCommand = "MON 0;FUNC 0,VDC,5;MON 1,0"
  2.014  CALL         Sub Fluke HYDRA Send Command RS-232

  2.015  IF           @Abort
  2.016  END
  2.017  ENDIF

  2.018  5502E        +Voltage = 0.000 mV
  2.019  TARGET       -m
  2.020  CALL         Sub Fluke HYDRA Query Measurement RS-232

  2.021  IF           @Abort
  2.022  END
  2.023  ENDIF

  2.024  MATH         MEM = MEM / 1E-3
  2.025  MEMCX  90    0.000mV        0.034% 0.007U
#! WARNING: Test Tol 7e-006, Sys Tol 3e-006 V, TUR 2.3333 (< 4.00).

  3.001  5502E        +Voltage = 90.000 mV
  3.002  TARGET       -m
  3.003  CALL         Sub Fluke HYDRA Query Measurement RS-232

  3.004  IF           @Abort
  3.005  END
  3.006  ENDIF

  3.007  MATH         MEM = MEM / 1E-3
  3.008  MEMCX  90    90.000mV       0.034% 0.007U

  4.001  ENDIF

  4.002  RSLT         =
  4.003  HEAD         -2{300 mV Range}
  4.004  TARGET       -p

  4.005  IF           NOT(ZCMPI(@ModelNum, "2635A"))
  4.006  PIC          55xx_HYDRA_VoltTest.jpg
  4.007  DISP         The next routine operator intervention occurs
  4.007  DISP         in approximately 2½ minutes...
  4.008  ENDIF

  4.009  MATH         @UUTCommand = "MON 0;FUNC 0,VDC,1;MON 1,0"
  4.010  CALL         Sub Fluke HYDRA Send Command RS-232
  4.011  JMPL         END                          @Abort
  4.012  5502E        +Voltage = 0.00 mV
  4.013  TARGET       -m
  4.014  CALL         Sub Fluke HYDRA Query Measurement RS-232
  4.015  JMPL         END                          @Abort
  4.016  MATH         MEM = MEM / 1E-3
  4.017  MEMCX  300   0.00mV         0.031% 0.02U

  5.001  5502E        +Voltage = 150.00 mV
  5.002  TARGET       -m
  5.003  CALL         Sub Fluke HYDRA Query Measurement RS-232
  5.004  JMPL         END                          @Abort
  5.005  MATH         MEM = MEM / 1E-3
  5.006  MEMCX  300   150.00mV       0.031% 0.02U

  6.001  5502E        +Voltage = 290.00 mV
  6.002  TARGET       -m
  6.003  CALL         Sub Fluke HYDRA Query Measurement RS-232
  6.004  JMPL         END                          @Abort
  6.005  MATH         MEM = MEM / 1E-3
  6.006  MEMCX  300   mV             0.031% 0.02U

  7.001  IF           ZCMPI(@ModelNum, "2635A")
  7.002  RSLT         =
  7.003  HEAD         -2{900 mV Range}
  7.004  TARGET       -p
  7.005  MATH         @UUTCommand = "MON 0;FUNC 0,VDC,6;MON 1,0"
  7.006  CALL         Sub Fluke HYDRA Send Command RS-232
  7.007  JMPL         END                          @Abort
  7.008  5502E        +Voltage = 900.00 mV
  7.009  TARGET       -m
  7.010  CALL         Sub Fluke HYDRA Query Measurement RS-232
  7.011  JMPL         END                          @Abort
  7.012  MATH         MEM = MEM / 1E-3
  7.013  MEMCX  900   900.00mV       0.031% 0.021U

  8.001  ENDIF

  8.002  RSLT         =
  8.003  HEAD         -2{3 V Range}
  8.004  TARGET       -p
  8.005  MATH         @UUTCommand = "MON 0;FUNC 0,VDC,2;MON 1,0"
  8.006  CALL         Sub Fluke HYDRA Send Command RS-232
  8.007  JMPL         END                          @Abort
  8.008  5502E        +Voltage = 2.9000 V
  8.009  TARGET       -m
  8.010  CALL         Sub Fluke HYDRA Query Measurement RS-232
  8.011  JMPL         END                          @Abort
  8.012  MEMCX  3     2.9000V        .033% .0002U

  9.001  5502E        +Voltage = -2.9000 V
  9.002  TARGET       -m
  9.003  CALL         Sub Fluke HYDRA Query Measurement RS-232
  9.004  JMPL         END                          @Abort
  9.005  MEMCX  3     -2.9000V       .033% .0002U

 10.001  RSLT         =
 10.002  HEAD         -2{30 V Range}
 10.003  TARGET       -p
 10.004  MATH         @UUTCommand = "MON 0;FUNC 0,VDC,3;MON 1,0"
 10.005  CALL         Sub Fluke HYDRA Send Command RS-232
 10.006  JMPL         END                          @Abort
 10.007  5502E        +Voltage = 29.000 V
 10.008  TARGET       -m
 10.009  CALL         Sub Fluke HYDRA Query Measurement RS-232
 10.010  JMPL         END                          @Abort
 10.011  MEMCX  30    29.000V        0.029% 0.002U

 11.001  RSLT         =
 11.002  HEAD         -2{150/300 V Range}
 11.003  TARGET       -p
 11.004  MATH         @UUTCommand = "MON 0;FUNC 0,VDC,4;MON 1,0"
 11.005  CALL         Sub Fluke HYDRA Send Command RS-232
 11.006  JMPL         END                          @Abort
 11.007  5502E        +Voltage = 150.00 V
 11.008  TARGET       -m
 11.009  CALL         Sub Fluke HYDRA Query Measurement RS-232
 11.010  JMPL         END                          @Abort
 11.011  MEMCX  300   150.00V        0.028% 0.02U

 12.001  5502E        +Voltage = 290.00 V
 12.002  TARGET       -m
 12.003  CALL         Sub Fluke HYDRA Query Measurement RS-232
 12.004  JMPL         END                          @Abort
 12.005  MEMCX  300   290.00V        0.028% 0.02U

 13.001  HEAD         -2
 13.002  5502E        Standby
 13.003  HEAD
 13.004  END

 13.005  EVAL   Increment Test Number

# =====  Sub Fluke HYDRA (1 yr) AC Voltage VER RS-232 /5502  =================

 14.001  LABEL        AC_VOLTAGE
 14.002  RSLT         =
 14.003  HEAD         {AC VOLTAGE}
 14.004  RSLT         =
 14.005  HEAD         -2{300 mV Range}
 14.006  TARGET       -p
 14.007  MATH         @UUTCommand = "MON 0;FUNC 0,VAC,1;MON 1,0"
 14.008  CALL         Sub Fluke HYDRA Send Command RS-232
 14.009  JMPL         END                          @Abort
 14.010  5502E        +Voltage = 20.00 mV; Frequency = 1 kHz
 14.011  TARGET       -m
 14.012  CALL         Sub Fluke HYDRA Query Measurement RS-232
 14.013  JMPL         END                          @Abort
 14.014  MATH         MEM = MEM / 1E-3
 14.015  MEMCX  300   20.00mV        0.17% 0.25U   1kHz

 15.001  5502E        +Voltage = 20.00 mV; Frequency = 100 kHz
 15.002  TARGET       -m
 15.003  CALL         Sub Fluke HYDRA Query Measurement RS-232
 15.004  JMPL         END                          @Abort
 15.005  MATH         MEM = MEM / 1E-3
 15.006  MEMCX  300   20.00mV        5.0% 0.50U    100kHz

 16.001  5502E        +Voltage = 290.00 mV; Frequency = 1 kHz
 16.002  TARGET       -m
 16.003  CALL         Sub Fluke HYDRA Query Measurement RS-232
 16.004  JMPL         END                          @Abort
 16.005  MATH         MEM = MEM / 1E-3
 16.006  MEMCX  300   290.00mV       0.17% 0.25U   1kHz

 17.001  5502E        +Voltage = 290.00 mV; Frequency = 100 kHz
 17.002  TARGET       -m
 17.003  CALL         Sub Fluke HYDRA Query Measurement RS-232
 17.004  JMPL         END                          @Abort
 17.005  MATH         MEM = MEM / 1E-3
 17.006  MEMCX  300   290.00mV       5.0% 0.50U    100kHz

 18.001  RSLT         =
 18.002  HEAD         -2{3 V Range}
 18.003  TARGET       -p
 18.004  MATH         @UUTCommand = "MON 0;FUNC 0,VAC,2;MON 1,0"
 18.005  CALL         Sub Fluke HYDRA Send Command RS-232
 18.006  JMPL         END                          @Abort
 18.007  5502E        +Voltage = 2.9000 V; Frequency = 1 kHz
 18.008  TARGET       -m
 18.009  CALL         Sub Fluke HYDRA Query Measurement RS-232
 18.010  JMPL         END                          @Abort
 18.011  MEMCX  3     2.9000V        0.14% 0.0025U 1kHz

 19.001  RSLT         =
 19.002  HEAD         -2{30 V Range}
 19.003  TARGET       -p
 19.004  MATH         @UUTCommand = "MON 0;FUNC 0,VAC,3;MON 1,0"
 19.005  CALL         Sub Fluke HYDRA Send Command RS-232
 19.006  JMPL         END                          @Abort
 19.007  5502E        +Voltage = 29.000 V; Frequency = 1 kHz
 19.008  TARGET       -m
 19.009  CALL         Sub Fluke HYDRA Query Measurement RS-232
 19.010  JMPL         END                          @Abort
 19.011  MEMCX  30    29.000V        0.15% 0.025U  1kHz

 20.001  RSLT         =
 20.002  HEAD         -2{150/300 V Range}
 20.003  TARGET       -p
 20.004  MATH         @UUTCommand = "MON 0;FUNC 0,VAC,4;MON 1,0"
 20.005  CALL         Sub Fluke HYDRA Send Command RS-232
 20.006  JMPL         END                          @Abort
 20.007  5502E        +Voltage = 150.00 V; Frequency = 1 kHz
 20.008  TARGET       -m
 20.009  CALL         Sub Fluke HYDRA Query Measurement RS-232
 20.010  JMPL         END                          @Abort
 20.011  MEMCX  300   150.00V        0.14% 0.25U   1kHz

 21.001  5502E        +Voltage = 290.00 V; Frequency = 1 kHz
 21.002  TARGET       -m
 21.003  CALL         Sub Fluke HYDRA Query Measurement RS-232
 21.004  JMPL         END                          @Abort
 21.005  MEMCX  300   290.00V        0.14% 0.25U   1kHz

 22.001  HEAD         -2
 22.002  5502E        Standby
 22.003  HEAD
 22.004  END

 22.005  EVAL   Increment Test Number

# =====  Sub Fluke HYDRA (1 yr) 4 Terminal Ohms VER RS-232 /5502  ============

 23.001  LABEL        4_TERMINAL_OHMS
 23.002  RSLT         =
 23.003  HEAD         {4-TERMINAL RESISTANCE}
 23.004  RSLT         =
 23.005  HEAD         -2{300 Ω Range}
 23.006  TARGET       -p
 23.007  MATH         @UUTCommand = "MON 0;FUNC 1,OHMS,1,4;MON 1,1"
 23.008  CALL         Sub Fluke HYDRA Send Command RS-232
 23.009  JMPL         END                          @Abort
 23.010  5502E        +Resistance = 0.00 Ohms; LeadComp = 4Wire
 23.011  WAIT         -t 2 System settling...
 23.012  TARGET       -m
 23.013  CALL         Sub Fluke HYDRA Query Measurement RS-232
 23.014  JMPL         END                          @Abort
 23.015  MEMCX  300   0.00Z          0.060% 0.02U

 24.001  5502E        +Resistance = 290.00 Ohms; LeadComp = 4Wire
 24.002  TARGET       -m
 24.003  CALL         Sub Fluke HYDRA Query Measurement RS-232
 24.004  JMPL         END                          @Abort
 24.005  MEMCX  300   290.00Z        0.060% 0.02U

 25.001  RSLT         =
 25.002  HEAD         -2{3 kΩ Range}
 25.003  TARGET       -p
 25.004  MATH         @UUTCommand = "MON 0;FUNC 1,OHMS,2,4;MON 1,1"
 25.005  CALL         Sub Fluke HYDRA Send Command RS-232
 25.006  JMPL         END                          @Abort
 25.007  5502E        +Resistance = 0.0000 kOhms; LeadComp = 4Wire
 25.008  TARGET       -m
 25.009  CALL         Sub Fluke HYDRA Query Measurement RS-232
 25.010  JMPL         END                          @Abort
 25.011  MATH         MEM = MEM / 1E+3
 25.012  MEMCX  3     0.0000kZ       .057% .0002U

 26.001  5502E        +Resistance = 2.9000 kOhms; LeadComp = 4Wire
 26.002  TARGET       -m
 26.003  CALL         Sub Fluke HYDRA Query Measurement RS-232
 26.004  JMPL         END                          @Abort
 26.005  MATH         MEM = MEM / 1E+3
 26.006  MEMCX  3     2.9000kZ       .057% .0002U

 27.001  RSLT         =
 27.002  HEAD         -2{30 kΩ Range}
 27.003  TARGET       -p
 27.004  MATH         @UUTCommand = "MON 0;FUNC 1,OHMS,3,4;MON 1,1"
 27.005  CALL         Sub Fluke HYDRA Send Command RS-232
 27.006  JMPL         END                          @Abort
 27.007  5502E        +Resistance = 29.000 kOhms; LeadComp = 4Wire
 27.008  TARGET       -m
 27.009  CALL         Sub Fluke HYDRA Query Measurement RS-232
 27.010  JMPL         END                          @Abort
 27.011  MATH         MEM = MEM / 1E+3
 27.012  MEMCX  30    29.000kZ       0.059% 0.002U

 28.001  5502E        Standby

 28.002  RSLT         =
 28.003  HEAD         -2{300 kΩ Range}
 28.004  TARGET       -p
 28.005  PIC          55xx_UIM_CWOhmTest.jpg
 28.006  DISP         The next routine operator intervention occurs
 28.006  DISP         in approximately 1 minute...
 28.007  MATH         @UUTCommand = "MON 0;FUNC 1,OHMS,4,4;MON 1,1"
 28.008  CALL         Sub Fluke HYDRA Send Command RS-232
 28.009  JMPL         END                          @Abort
 28.010  5502E        +Resistance = 290.00 kOhms
 28.011  TARGET       -m
 28.012  CALL         Sub Fluke HYDRA Query Measurement RS-232
 28.013  JMPL         END                          @Abort
 28.014  MATH         MEM = MEM / 1E+3
 28.015  MEMCX  300   290.00kZ       0.057% 0.02U

 29.001  RSLT         =
 29.002  HEAD         -2{3 MΩ Range}
 29.003  TARGET       -p
 29.004  MATH         @UUTCommand = "MON 0;FUNC 1,OHMS,5,4;MON 1,1"
 29.005  CALL         Sub Fluke HYDRA Send Command RS-232
 29.006  5502E        +Resistance = 2.9000 MOhms
 29.007  TARGET       -m
 29.008  CALL         Sub Fluke HYDRA Query Measurement RS-232
 29.009  JMPL         END                          @Abort
 29.010  MATH         MEM = MEM / 1E+6
 29.011  MEMCX  3     2.9000MZ       .063% .0002U

 30.001  RSLT         =
 30.002  HEAD         -2{10 MΩ Range}
 30.003  TARGET       -p
 30.004  MATH         @UUTCommand = "MON 0;FUNC 1,OHMS,6,4;MON 1,1"
 30.005  CALL         Sub Fluke HYDRA Send Command RS-232
 30.006  JMPL         END                          @Abort
 30.007  5502E        +Resistance = 10.000 MOhms
 30.008  TARGET       -m
 30.009  CALL         Sub Fluke HYDRA Query Measurement RS-232
 30.010  JMPL         END                          @Abort
 30.011  MATH         MEM = MEM / 1E+6
 30.012  MEMCX  10    10.000MZ       0.120% 0.002U
#! WARNING: Test Tol 14000, Sys Tol 6050 Ohms, TUR 2.3140 (< 4.00).

 31.001  HEAD         -2
 31.002  5502E        Standby
 31.003  HEAD
 31.004  END

 31.005  EVAL   Increment Test Number

# =====  Sub Fluke HYDRA (1 yr) Frequency VER RS-232 /5502  ==================

 32.001  LABEL        FREQUENCY
 32.002  RSLT         =
 32.003  HEAD         {FREQUENCY}
 32.004  RSLT         =
 32.005  HEAD         -2{90 kHz Range}
 32.006  TARGET       -p
 32.007  MATH         @UUTCommand = "MON 0;FUNC 0,FREQ,3;MON 1,0"
 32.008  CALL         Sub Fluke HYDRA Send Command RS-232
 32.009  JMPL         END                          @Abort
 32.010  5502E        +Frequency = 10.000 kHz; Voltage = 0.707 V
 32.011  TARGET       -m
 32.012  CALL         Sub Fluke HYDRA Query Measurement RS-232
 32.013  JMPL         END                          @Abort
 32.014  MATH         MEM = MEM / 1E+3
 32.015  MEMCX  90    10.000kHz      0.05% 0.001U

 33.001  HEAD         -2
 33.002  5502E        Standby
 33.003  HEAD
 33.004  END

 33.005  EVAL   Increment Test Number

# =====  Sub Fluke HYDRA (1 yr) TC Range VER RS-232 /5502  =================

 34.001  LABEL        THERMOCOUPLE
 34.002  RSLT         =
 34.003  HEAD         {THERMOCOUPLE MEASUREMENT RANGE ACCURACY}
 34.004  RSLT         =
 34.005  HEAD         -2{100 mV Range}
 34.006  TARGET       -p
 34.007  MATH         @UUTCommand = "MON 0;FUNC 0,VDC,I100MV;MON 1,0"
 34.008  CALL         Sub Fluke HYDRA Send Command RS-232
 34.009  JMPL         END                          @Abort
 34.010  5502E        +Voltage = 0.000 mV
 34.011  TARGET       -m
 34.012  CALL         Sub Fluke HYDRA Query Measurement RS-232
 34.013  JMPL         END                          @Abort
 34.014  MATH         MEM = MEM / 1E-3
 34.015  MEMCX  100   0.000mV        0.007U
#! WARNING: Test Tol 7e-006, Sys Tol 3e-006 V, TUR 2.3333 (< 4.00).

 35.001  5502E        +Voltage = 90.000 mV
 35.002  TARGET       -m
 35.003  CALL         Sub Fluke HYDRA Query Measurement RS-232
 35.004  JMPL         END                          @Abort
 35.005  MATH         MEM = MEM / 1E-3
 35.006  MEMCX  100   90.000mV       0.038U

 36.001  RSLT         =
 36.002  HEAD         -2{1000 mV Range}
 36.003  TARGET       -p
 36.004  MATH         @UUTCommand = "MON 0;FUNC 0,VDC,I1V;MON 1,0"
 36.005  CALL         Sub Fluke HYDRA Send Command RS-232
 36.006  JMPL         END                          @Abort
 36.007  5502E        +Voltage = 900.00 mV
 36.008  TARGET       -m
 36.009  CALL         Sub Fluke HYDRA Query Measurement RS-232
 36.010  JMPL         END                          @Abort
 36.011  MATH         MEM = MEM / 1E-3
 36.012  MEMCX  1000  900.00mV       0.22U

 37.001  LABEL        END
 37.002  HEAD         -2
 37.003  HEAD
 37.004  END
