﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke HYDRA Check Acknowledge RS-232
DATE:                  2015-06-18 08:10:08
AUTHOR:                Fluke
REVISION:              $Revision: 12178 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       62
=============================================================================
#
#  Procedure Author:
#        VY, DAC
#
#  Models covered:
#        2620A, 2625A, 2635A HYDRA
#        2620A, 2625A, 2635A HYDRA Series II
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Required Equipment:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  PORT         [I$]
  1.002  MATH         @Abort = NOT(ZCMP(MEM2, "=>"))

  1.003  IF           ZCMP(MEM2, "=>")
  1.004  MATH         @ErrorMessage = ""

  1.005  ELSEIF       ZCMP(MEM2, "?>")
  1.006  DISP         A Command Error was detected. The command was not
  1.006  DISP         executed because it was not understood.

  1.007  ELSEIF       ZCMP(MEM2, "!>")
  1.008  DISP         An Execution Error was detected. The command was
  1.008  DISP         understood but not executed.
  1.008  DISP
  1.008  DISP         Verify the input and connection is correct or not.
  1.008  DISP         If the input is correct and this error always occurs,
  1.008  DISP         the UUT may require repair.

  1.009  ELSE
  1.010  DISP         An Unexpected Error was detected.
  1.011  ENDIF

  1.012  END
