﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke HYDRA (1 yr) DIO Output Test RS-232 /DMM
DATE:                  2015-06-18 08:11:53
AUTHOR:                Fluke
REVISION:              $Revision: 12178 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       3
NUMBER OF LINES:       82
CONFIGURATION:         Digital Multimeter
=============================================================================
#
#  Procedure Author:
#        VY, DAC
#
#  Model(s) Covered:
#        2620A, 2625A, 2635A HYDRA
#        2620A, 2625A, 2635A HYDRA Series II
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Additional Equipment Required:
#        Specially Configured Rear Terminals
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  IEEE         [@DMM]
  1.003  ENDIF

  1.004  RSLT         =
  1.005  HEAD         -2{Output [V @Output]}
  1.006  TARGET

  1.007  IF           @Output == 0
  1.008  PIC          DMM_DIO_Output_0_Test.jpg
  1.009  ELSEIF       @Output == 1
  1.010  PIC          DMM_DIO_Output_1_Test.jpg
  1.011  ELSEIF       @Output == 2
  1.012  PIC          DMM_DIO_Output_2_Test.jpg
  1.013  ELSEIF       @Output == 3
  1.014  PIC          DMM_DIO_Output_3_Test.jpg
  1.015  ELSEIF       @Output == 4
  1.016  PIC          DMM_DIO_Output_4_Test.jpg
  1.017  ELSEIF       @Output == 5
  1.018  PIC          DMM_DIO_Output_5_Test.jpg
  1.019  ELSEIF       @Output == 6
  1.020  PIC          DMM_DIO_Output_6_Test.jpg
  1.021  ELSE
  1.022  PIC          DMM_DIO_Output_7_Test.jpg
  1.023  ENDIF

  1.024  MATH         @UUTCommand = "DO_LEVEL " & @Output & ",0"
  1.025  TARGET
  1.026  CALL         Sub Fluke HYDRA Send Command RS-232
  1.027  JMPL         END                          @Abort
  1.028  CALL         Sub Measure /DMM
  1.029  EVAL   -e  MEM <= 0.8 : [32] LOW state

  2.001  MATH         @UUTCommand = "DO_LEVEL " & @Output & ",1"
  2.002  TARGET
  2.003  CALL         Sub Fluke HYDRA Send Command RS-232
  2.004  JMPL         END                          @Abort
  2.005  CALL         Sub Measure /DMM
  2.006  EVAL   -e  MEM >= 3.8 : [32] HIGH state

  3.001  LABEL        END
  3.002  END
