﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke HYDRA Self Test RS-232
DATE:                  2015-06-18 08:18:38
AUTHOR:                Fluke
REVISION:              $Revision: 12178 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       2
NUMBER OF LINES:       66
=============================================================================
#
#  Procedure Author:
#        VY, DAC
#
#  Models covered:
#        2620A, 2625A, 2635A HYDRA
#        2620A, 2625A, 2635A HYDRA Series II
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Required Equipment:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  RSLT         =
  1.002  HEAD         SELF TEST
  1.003  PORT         *TST?

  1.004  IF           ZCMPI(@ModelNum, "2625A")
  1.005  WAIT         -t 35 Executing Self Test...
  1.006  ELSE
  1.007  WAIT         -t 15 Executing Self Test...
  1.008  ENDIF

  1.009  PORT         [T30000][I]
  1.010  MATH         Error = MEM
  1.011  CALL         Sub Fluke HYDRA Check Acknowledge RS-232
  1.012  EVAL   -e NOT(Error) : SELF TEST

  2.001  MATH         @Abort = FAIL()

  2.002  IF           FAIL()
  2.003  DISP         UUT SELF TEST failed!
  2.003  DISP
  2.003  DISP         The UUT may need to be serviced.
  2.003  DISP
  2.003  DISP         Procedure will be aborted.
  2.004  ENDIF

  2.005  HEAD
  2.006  END
