﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke HYDRA (1 yr) Totalizer VER RS-232
INSTRUMENT:            Sub Fluke HYDRA (1 yr) ExtTrig Input VER RS-232
DATE:                  2015-06-18 08:20:28
AUTHOR:                Fluke
REVISION:              $Revision: 12178 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       8
NUMBER OF LINES:       133
=============================================================================
#
#  Procedure Author:
#        VY, DAC
#
#  Model(s) Covered:
#        2620A, 2625A, 2635A HYDRA
#        2620A, 2625A, 2635A HYDRA Series II
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Additional Equipment Required:
#       Specially Configured Rear Terminals
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         TOTALIZER                    PSUBI("Totalizer")
  1.002  JMPL         EXT_TRIG_INPUT               PSUBI("ExtTrig Input")
  1.003  DISP         Subprocedure not found!
  1.004  END

  1.005  EVAL   Increment step number

# =====  Sub Fluke HYDRA (1 yr) Totalizer VER RS-232  =======================

  2.001  LABEL        TOTALIZER
  2.002  RSLT         =
  2.003  HEAD         {TOTALIZER}
  2.004  TARGET
  2.005  MATH         @UUTCommand = "*RST;LOCS"
  2.006  CALL         Sub Fluke HYDRA Send Command RS-232
  2.007  JMPL         END                     @Abort
  2.008  PIC          HYDRA_DIO_TotalizerTest.jpg
  2.009  DISP         Press UUT TOTAL button to enter the TOTLIZER function.
  2.010  MATH         @UUTCommand = "REMS"
  2.011  CALL         Sub Fluke HYDRA Send Command RS-232
  2.012  JMPL         END                     @Abort
# Set parameter for Sub Fluke HYDRA Query Measurement RS-232.
  2.013  MATH         @QueryCommand = "TOTAL?"
  2.014  CALL         Sub Fluke HYDRA Query Measurement RS-232
  2.015  JMPL         END                     @Abort
  2.016  EVAL   -e MEM == 0 : [32] Counter Reset

  3.001  MATH         @UUTCommand = "TOTAL 0"
  3.002  CALL         Sub Fluke HYDRA Send Command RS-232
  3.003  JMPL         END                     @Abort
  3.004  WAIT         [D1000]
  3.005  MATH         @UUTCommand = "DO_LEVEL 0,0;DO_LEVEL 0,1"
  3.006  CALL         Sub Fluke HYDRA Send Command RS-232
  3.007  WAIT         [D1000]
  3.008  JMPL         END                     @Abort
  3.009  MATH         @UUTCommand = "DO_LEVEL 0,0;DO_LEVEL 0,1"
  3.010  CALL         Sub Fluke HYDRA Send Command RS-232
  3.011  JMPL         END                     @Abort
  3.012  CALL         Sub Fluke HYDRA Query Measurement RS-232
  3.013  JMPL         END                     @Abort
  3.014  EVAL   -e MEM == 2 : [32] Counter Increment

  4.001  MATH         @UUTCommand = "TOTAL 65534"
  4.002  CALL         Sub Fluke HYDRA Send Command RS-232
  4.003  JMPL         END                     @Abort
  4.004  WAIT         [D1000]
  4.005  MATH         @UUTCommand = "DO_LEVEL 0,0;DO_LEVEL 0,1"
  4.006  CALL         Sub Fluke HYDRA Send Command RS-232
  4.007  JMPL         END                     @Abort
  4.008  CALL         Sub Fluke HYDRA Query Measurement RS-232
  4.009  JMPL         END                     @Abort
  4.010  EVAL   -e MEM == 65535 : [32] Counter Full Range

  5.001  WAIT         [D1000]
  5.002  MATH         @UUTCommand = "DO_LEVEL 0,0;DO_LEVEL 0,1"
  5.003  CALL         Sub Fluke HYDRA Send Command RS-232
  5.004  JMPL         END                     @Abort
  5.005  CALL         Sub Fluke HYDRA Query Measurement RS-232
  5.006  JMPL         END                     @Abort
  5.007  EVAL   -e MEM == 1E+9 : [32] Counter Overrun

  6.001  HEAD
  6.002  HEAD         -2
  6.003  END

  6.004  EVAL   Increment step number

# =====  Sub Fluke HYDRA (1 yr) ExtTrig Input VER RS-232  ===================

  7.001  LABEL        EXT_TRIG_INPUT
  7.002  RSLT         =
  7.003  HEAD         EXTERNAL TRIGGER INPUT
  7.004  TARGET
  7.005  MATH         @UUTCommand = "*RST"
  7.006  CALL         Sub Fluke HYDRA Send Command RS-232
  7.007  JMPL         END                     @Abort
  7.008  MATH         @UUTCommand = "FUNC 0,VDC,3;FUNC 1,VDC,3;FUNC 2,VDC,3"
  7.009  CALL         Sub Fluke HYDRA Send Command RS-232
  7.010  JMPL         END                     @Abort
  7.011  MATH         @UUTCommand = "FUNC 3,VDC,3;FUNC 4,VDC,3;FUNC 5,VDC,3"
  7.012  CALL         Sub Fluke HYDRA Send Command RS-232
  7.013  JMPL         END                     @Abort
  7.014  MATH         @UUTCommand = "INTVL 0,0,30;TRIGGER 1;SCAN 1"
  7.015  CALL         Sub Fluke HYDRA Send Command RS-232
  7.016  JMPL         END                     @Abort
  7.017  WAIT         -t 2 Scanning...
  7.018  MATH         ResultText = "EXTERNAL TRIGGER INPUT"
  7.019  PICE         -s ResultText : HYDRA_ExtTriggerTest.jpg

  8.001  LABEL        END
  8.002  HEAD
  8.003  HEAD         -2
  8.004  END
