﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke HYDRA Setup RS-232
INSTRUMENT:            Sub Fluke HYDRA Send Command RS-232
INSTRUMENT:            Sub Fluke HYDRA Query Identification RS-232
INSTRUMENT:            Sub Fluke HYDRA Query Measurement RS-232
INSTRUMENT:            Sub Fluke HYDRA Query Response RS-232
DATE:                  2015-06-18 08:20:57
AUTHOR:                Fluke
REVISION:              $Revision: 12178 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       6
NUMBER OF LINES:       165
=============================================================================
#
#  Procedure Author:
#        VY, DAC
#
#  Models covered:
#        2620A, 2625A, 2635A HYDRA
#        2620A, 2625A, 2635A HYDRA Series II
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Required Equipment:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         SETUP                        PSUBI("Setup")
  1.002  JMPL         SEND_COMMAND                 PSUBI("Send Command")
  1.003  JMPL         QUERY_IDENTIFICATION         PSUBI("Query Id")
  1.004  JMPL         QUERY_MEASUREMENT            PSUBI("Query Measurement")
  1.005  JMPL         QUERY_RESPONSE               PSUBI("Query Response")
  1.006  DISP         Error Fluke HYDRA Utilities:  Subprocedure not found!
  1.007  END

  1.008  EVAL   Increment step number

# =====  Sub Fluke HYDRA Setup RS-232  ======================================

  2.001  LABEL        SETUP
  2.002  HEAD         -2 RS-232 SETUP
  2.003  DISP         Press SHIFT, then LIST to select COMM.
  2.003  DISP
  2.003  DISP         Use the up and down arrow keys to select the following:
  2.003  DISP
  2.003  DISP         [32] Select 9600 baud and press ENTER.
  2.003  DISP         [32] Select no Parity and press ENTER.
  2.003  DISP         [32] Select OFF Echo and press ENTER.
# We found when the UUT receive the first remote command, whatever the command
# is right or not, it always responses with a "!>", so here we discard this
# first response.
  2.004  PORT         [P9600,N,8,1,N][T15000][OTERM CRLF][TERM LF]REMS[I!]
  2.005  MATH         @UUTCommand = "*RST"
  2.006  CALL         Sub Fluke HYDRA Send Command RS-232
  2.007  HEAD         -2
  2.008  END

  2.009  EVAL   Increment step number

# =====  Sub Fluke HYDRA Send Command RS-232  ===============================

  3.001  LABEL        SEND_COMMAND

  3.002  DO
  3.003  PORT         [T15000][V @UUTCommand][D50]
  3.004  CALL         Sub Fluke HYDRA Check Acknowledge RS-232

  3.005  IF           @Abort
  3.006  OPBR         -z Do you wish to retry?
  3.007  MATH         Done = NOT(MEM1)
  3.008  ELSE
  3.009  MATH         Done = 1
  3.010  ENDIF

  3.011  UNTIL        Done

  3.012  END

  3.013  EVAL   Increment step number


# =====  Sub Fluke HYDRA Query Identification RS-232  =======================

  4.001  LABEL        QUERY_IDENTIFICATION

  4.002  DO
  4.003  PORT         [T15000]*IDN?[D50][I$]
  4.004  MATH         QueryResponse = MEM2
  4.005  CALL         Sub Fluke HYDRA Check Acknowledge RS-232

  4.006  IF           @Abort
  4.007  OPBR         -z Do you wish to retry?
  4.008  MATH         Done = NOT(MEM1)
  4.009  ELSE
  4.010  MATH         MEM2 = QueryResponse
  4.011  CALL         Sub IEEE-488.2 Identification Query Parse Response
  4.012  MATH         Done = 1
  4.013  ENDIF

  4.014  UNTIL        Done

  4.015  END

  4.016  EVAL   Increment step number

# =====  Sub Fluke HYDRA Query Measurement RS-232  ==========================

  5.001  LABEL        QUERY_MEASUREMENT
# backup MEM1 for it stands for the nominal of test.
  5.002  MATH         BackupMEM1 = MEM1

  5.003  DO
  5.004  PORT         [T15000][V @QueryCommand][I]
  5.005  CALL         Sub Fluke HYDRA Check Acknowledge RS-232

  5.006  IF           @Abort
  5.007  OPBR         -z Do you wish to retry?
  5.008  MATH         Done = NOT(MEM1)
  5.009  ELSE
  5.010  MATH         Done = 1
  5.011  ENDIF

  5.012  UNTIL        Done

# Restore MEM1.
  5.013  MATH         MEM1 = BackupMEM1
  5.014  END

  5.015  EVAL   Increment step number

# =====  Sub Fluke HYDRA Query Response RS-232  =============================

  6.001  LABEL        QUERY_RESPONSE

  6.002  DO
  6.003  PORT         [T15000][V @QueryCommand][D50][I$]
  6.004  MATH         @Response = MEM2
  6.005  CALL         Sub Fluke HYDRA Check Acknowledge RS-232

  6.006  IF           @Abort
  6.007  OPBR         -z Do you wish to retry?
  6.008  MATH         Done = NOT(MEM1)
  6.009  ELSE
  6.010  MATH         Done = 1
  6.011  ENDIF

  6.012  UNTIL        Done

  6.013  END
