﻿Copyright (c) (2015) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub HYDRA (1 yr) Ch1,11 Integrity VER RS-232 /5502
INSTRUMENT:            Sub HYDRA (1 yr) Ch2-20 Integrity VER RS-232 /5502
DATE:                  2015-11-20 11:11:17
AUTHOR:                Fluke Calibration
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       11
NUMBER OF LINES:       173
CONFIGURATION:         Fluke 5502E
=============================================================================
#
#  Procedure Author:
#        VY, ND
#
#  Model(s) Covered:
#        2620A, 2625A, 2635A HYDRA
#
#  Source(s):
#        Fluke
#
#        HYDRA
#        2620A Data Acquisition Unit
#        2625A Data Logger
#        2635A Data Bucket
#        Service Manual
#        PN 889589, MAY 1991 Rev. 2, 4/93
#
#        HYDRA
#        2620A DATA ACQUISTION UNIT
#        2625A DATA LOGGER
#        2635A DATA BUCKET
#        Service Manual
#        PN 202231
#        February 1997
#
#        2620A/2625A
#        Hydra Series II Data Acquisition Unit
#        Hydra Series II Data Logger
#        Users Manual
#        PN 686675
#        November 1997 *
#
#       * The tolerances used by this procedure were taken from the published
#         specifications table.
#
#  Compatibility:
#        MET/CAL 8.1.4 or later
#
#  Additional Equipment and/or Accessories Required:
#        Specially Configured Input Module
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         CHANNEL_1_11                 PSUBI("Ch1,11")
  1.002  JMPL         CHANNEL_2_TO_10_AND_12_TO_20 PSUBI("Ch2-20")
  1.003  DISP         Subprocedure not found!
  1.004  END

  1.005  EVAL   Increment Test Number

# =====  Sub HYDRA (1 yr) Ch1,11 Integrity VER RS-232 /5502  =================

  2.001  LABEL        CHANNEL_1_11
  2.002  RSLT         =
  2.003  HEAD         -2{ Channel [V @Chan]}
  2.004  MEM2         =*RST;MON 0;FUNC [V @Chan],OHMS,1,2;MON 1,[V @Chan]
  2.005  MATH         @UUTCommand = MEM2
  2.006  TARGET       -p
  2.007  CALL         Sub Fluke HYDRA Send Command RS-232
  2.008  JMPL         END                          @Abort
  2.009  5502E        +Resistance = 0 Ohms
  2.010  TARGET       -m
# Set parameter for Sub Fluke HYDRA Query Measurement RS-232.
  2.011  MATH         @QueryCommand = "MON_VAL?"
  2.012  CALL         Sub Fluke HYDRA Query Measurement RS-232
  2.013  JMPL         END                          @Abort
  2.014  EVAL   -e MEM <= 4 : [32] SHORT (0 Ohms)

  3.001  5502E        Standby

  3.002  TARGET       -m
  3.003  CALL         Sub Fluke HYDRA Query Measurement RS-232
  3.004  JMPL         END                          @Abort
  3.005  EVAL   -e MEM == 1E+9 : [32] OPEN (Overload)

  4.001  MEM2         =MON 0;FUNC [V @Chan],VDC,4;MON 1,[V @Chan]
  4.002  MATH         @UUTCommand = MEM2
  4.003  TARGET       -p
  4.004  CALL         Sub Fluke HYDRA Send Command RS-232
  4.005  JMPL         END                          @Abort
  4.006  5502E        +Voltage = 0.00 V
  4.007  TARGET       -m
  4.008  CALL         Sub Fluke HYDRA Query Measurement RS-232
  4.009  JMPL         END                          @Abort
  4.010  MEMCX  300   V              0.02U

  5.001  5502E        +Voltage = 290.00 V
  5.002  TARGET       -m
  5.003  CALL         Sub Fluke HYDRA Query Measurement RS-232
  5.004  JMPL         END                          @Abort
  5.005  MEMCX  300   V              0.10U

  6.001  JMPL         END

  6.002  EVAL   Increment step number

# =====  Sub HYDRA (1 yr) Ch2-20 Integrity VER RS-232 /5502  =================

  7.001  LABEL        CHANNEL_2_TO_10_AND_12_TO_20
  7.002  RSLT         =
  7.003  HEAD         -2{ Channel [V @Chan]}
  7.004  MEM2         =*RST;MON 0;FUNC [V @Chan],OHMS,1,2;MON 1,[V @Chan]
  7.005  MATH         @UUTCommand = MEM2
  7.006  TARGET       -p

  7.007  IF           @Chan == 2
  7.008  5502E        Standby
  7.009  PIC          55xx_UIM_IntegTestCh2-20.jpg
  7.010  DISP         The next routine operator intervention occurs
  7.010  DISP         in approximately 4½ minutes...
  7.011  ENDIF

  7.012  CALL         Sub Fluke HYDRA Send Command RS-232
  7.013  JMPL         END                          @Abort
  7.014  5502E        +Resistance = 0 Ohms
  7.015  TARGET       -m
  7.016  CALL         Sub Fluke HYDRA Query Measurement RS-232
  7.017  JMPL         END                          @Abort
  7.018  EVAL   -e MEM <= 4 : [32] SHORT (0 Ohms)

  8.001  5502E        Standby

  8.002  TARGET       -m
  8.003  CALL         Sub Fluke HYDRA Query Measurement RS-232
  8.004  JMPL         END                          @Abort
  8.005  EVAL   -e MEM == 1E+9 : [32] OPEN (Overload)

  9.001  MEM2         =MON 0;FUNC [V @Chan],VDC,4;MON 1,[V @Chan]
  9.002  MATH         @UUTCommand = MEM2
  9.003  TARGET       -p
  9.004  CALL         Sub Fluke HYDRA Send Command RS-232
  9.005  JMPL         END                          @Abort
  9.006  5502E        +Voltage = 0.00 V
  9.007  TARGET       -m
  9.008  CALL         Sub Fluke HYDRA Query Measurement RS-232
  9.009  JMPL         END                          @Abort
  9.010  MEMCX  150   V              0.02U

 10.001  5502E        +Voltage = 150.00 V
 10.002  TARGET       -m
 10.003  CALL         Sub Fluke HYDRA Query Measurement RS-232
 10.004  JMPL         END                          @Abort
 10.005  MEMCX  150   V              0.06U

 11.001  LABEL        END
 11.002  HEAD         -2
 11.003  5502E        Standby
 11.004  END
