﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub IEEE-488.2 Identification Query Parse Response
INSTRUMENT:            Sub IEEE-488.2 Identification Query Check Response
DATE:                  2015-04-17 16:43:27
AUTHOR:                Fluke
REVISION:              $Revision: 10907 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       232
=============================================================================
#
#  Procedure Author:   DAC, DFM
#
#  Models covered:     All IEEE-488.2 compatible UUTs
#
#  Compatibility:      MET/CAL 7.20 or later
#
#  Subprocedures:      None
#
#  Required Files:     None
#
#  Required Equipment: None
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         PARSE_RESPONSE               PSUBI("Parse Response")
  1.002  JMPL         CHECK_RESPONSE               PSUBI("Check Response")
  1.003  DISP         Subprocedure not found!
  1.004  MATH         @Abort = 1
  1.005  END

# =====  Sub IEEE-488.2 Identification Query Parse Response  ================

  1.006  LABEL        PARSE_RESPONSE
  1.007  MATH         @Manufacturer = FLD(MEM2, 1, ",")
  1.008  MATH         @ModelNum     = FLD(MEM2, 2, ",")
  1.009  MATH         @SerialNum    = FLD(MEM2, 3, ",")
  1.010  MATH         @FirmwareRev  = FLD(MEM2, 4, ",")

# Some manufacturers pad the fields with a space.
#
# Ex. "Hewlett-Packard, E4401B, US39120213, A.06.00"
#
# Strip leading whitespace from fields.

# Check model field for leading whitespace.
  1.011  IF           ZCMP(SUB(@ModelNum, 1, 1), " ")
  1.012  MATH         @ModelNum = SUB(@ModelNum, 2, LEN(@ModelNum))
  1.013  ENDIF

# IEEE-488.2 allows manufacturers to return "0" in the serial number and
# firmware revision fields if the actual serial number and/or firmware
# revision is not available for the *IDN? response string.

# Check serial number field for "0" or leading whitespace.
  1.014  IF           ZCMP(@SerialNum, "0") || ZCMP(@SerialNum, " 0")
  1.015  MATH         @SerialNum = "Not available"
  1.016  ELSEIF       ZCMP(SUB(@SerialNum, 1, 1), " ")
  1.017  MATH         @SerialNum = SUB(@SerialNum, 2, LEN(@SerialNum))
  1.018  ENDIF

# Check firmware revision field for "0" or leading whitespace.
  1.019  IF           ZCMP(@FirmwareRev, "0") || ZCMP(@FirmwareRev, " 0")
  1.020  MATH         @FirmwareRev = "Not available"
  1.021  ELSEIF       ZCMP(SUB(@FirmwareRev, 1, 1), " ")
  1.022  MATH         @FirmwareRev = SUB(@FirmwareRev, 2, LEN(@FirmwareRev))
  1.023  ENDIF

# Make sure firmware level string is not too big for DISP statement line.
  1.024  MATH         Max = 56 - LEN("Firmware Level:") - 2
  1.025  MATH         LenFirmwareRev = LEN(@FirmwareRev)

  1.026  IF           LenFirmwareRev > Max
  1.027  MATH         Part1 = SUB(@FirmwareRev, 1, Max)
  1.028  MATH         Part2 = SUB(@FirmwareRev, (Max + 1), LenFirmwareRev)
  1.029  DISP         Manufacturer:    [V @Manufacturer]
  1.029  DISP         Model:           [V @ModelNum]
  1.029  DISP         Serial Number:   [V @SerialNum]
  1.029  DISP         Firmware Level:  [V Part1]
  1.029  DISP         [32]                [V Part2]
# Write serial number and firmware revision to results file.
  1.030  RSLT         =
  1.031  RSLT         = Serial Number:   [V @SerialNum]
  1.032  RSLT         = Firmware Level:  [V Part1]
  1.033  RSLT         =[32]                 [V Part2]
  1.034  ELSE
  1.035  DISP         Manufacturer:    [V @Manufacturer]
  1.035  DISP         Model:           [V @ModelNum]
  1.035  DISP         Serial Number:   [V @SerialNum]
  1.035  DISP         Firmware Level:  [V @FirmwareRev]
# Write serial number and firmware revision to results file.
  1.036  RSLT         =
  1.037  RSLT         = Serial Number:   [V @SerialNum]
  1.038  RSLT         = Firmware Level:  [V @FirmwareRev]
  1.039  ENDIF

  1.040  MATH         @Abort = 0
  1.041  END

# =====  Sub IEEE-488.2 Identification Query Check Response  ================

# Example usage (IEEE-488):
#
#  1.001  MATH         @UUT_Manufacturer  = "Agilent Technologies"
#  1.002  MATH         @UUT_Manufacturer2 = "Hewlett-Packard"
#  1.003  MATH         @UUT_Model         = "E4443A"
#  1.004  MATH         @UUT_AssetNum      = UUT()
#
#  1.005  IF           NOT(EMPTY(@UUT_AssetNum))
#  1.006  MATH         @UUT_SerialNum = SN(@UUT_AssetNum)
#  1.007  ENDIF
#
#  1.008  CALL         Sub IEEE-488.2 Identification Query IEEE
#  1.009  CALL         Sub IEEE-488.2 Identification Query Check Response
#
#  1.010  IF           @Abort
#  1.011  END
#  1.012  ENDIF
#
# Example usage (RS-232):
#
#  1.001  PORT         [P9600,N,8,1,X][TERM LF][OTERM LF]
#
#  1.002  MATH         @UUT_Manufacturer  = "FLUKE"
#  1.003  MATH         @UUT_Model         = "45"
#  1.004  MATH         @UUT_AssetNum      = UUT()
#
#  1.005  IF           NOT(EMPTY(@UUT_AssetNum))
#  1.006  MATH         @UUT_SerialNum = SN(@UUT_AssetNum)
#  1.007  ENDIF
#
#  1.008  CALL         Sub IEEE-488.2 Identification Query RS-232 using OTERM
#  Read an discard acknowledge response.
#  1.009  PORT         [I!]
#  1.010  CALL         Sub IEEE-488.2 Identification Query Check Response
#
#  1.011  IF           @Abort
#  1.012  END
#  1.013  ENDIF

  1.042  LABEL        CHECK_RESPONSE
# Verify all required global variables are populated.
  1.043  MATH         @Abort = NOT(ISVAR("@Manufacturer"))

  1.044  IF           @Abort
  1.045  DISP         "@Manufacturer" must contain *IDN? response, field 1,
  1.045  DISP         returned from UUT.
  1.046  END
  1.047  ENDIF

  1.048  MATH         @Abort = NOT(ISVAR("@ModelNum"))

  1.049  IF           @Abort
  1.050  DISP         "@ModelNum" must contain *IDN? response, field 2,
  1.050  DISP         returned from UUT.
  1.051  END
  1.052  ENDIF

  1.053  MATH         @Abort = NOT(ISVAR("@UUT_Manufacturer"))

  1.054  IF           @Abort
  1.055  DISP         "@UUT_Manufacturer" must contain actual manufacturer
  1.055  DISP         name expected.
  1.056  END
  1.057  ENDIF

  1.058  MATH         @Abort = NOT(ISVAR("@UUT_Model"))

  1.059  IF           @Abort
  1.060  DISP         "@UUT_Model" must contain actual manufacturer model
  1.060  DISP         number expected.
  1.061  END
  1.062  ENDIF

  1.063  MATH         L[1] = ZCMPI(@ModelNum, @UUT_Model)
  1.064  MATH         L[2] = ZCMPI(@Manufacturer, @UUT_Manufacturer)

  1.065  IF           ISVAR("@UUT_Manufacturer2")
  1.066  MATH         L[2] = L[2] || ZCMPI(@Manufacturer, @UUT_Manufacturer2)
  1.067  ENDIF

  1.068  IF           ISVAR("@UUT_Manufacturer3")
  1.069  MATH         L[2] = L[2] || ZCMPI(@Manufacturer, @UUT_Manufacturer3)
  1.070  ENDIF

  1.071  MATH         @Abort = NOT(L[1] && L[2])

  1.072  IF           @Abort
  1.073  MATH         L[2] = ISVAR("@UUT_Manufacturer2")
  1.074  MATH         L[3] = ISVAR("@UUT_Manufacturer3")

  1.075  IF           L[2] && L[3]
  1.076  DISP         UUT is a [V @Manufacturer] [V @ModelNum],
  1.076  DISP         not a [V @UUT_Manufacturer] [V @UUT_Model],
  1.076  DISP         [V @UUT_Manufacturer2] [V @UUT_Model], or
  1.076  DISP         or [V @UUT_Manufacturer3] [V @UUT_Model]!
  1.077  ELSEIF       L[2] && NOT(L[3])
  1.078  DISP         UUT is a [V @Manufacturer] [V @ModelNum],
  1.078  DISP         not a [V @UUT_Manufacturer] [V @UUT_Model] or
  1.078  DISP         [V @UUT_Manufacturer2] [V @UUT_Model]!
  1.079  ELSEIF       L[3] && NOT(L[2])
  1.080  DISP         UUT is a [V @Manufacturer] [V @ModelNum],
  1.080  DISP         not a [V @UUT_Manufacturer] [V @UUT_Model] or
  1.080  DISP         [V @UUT_Manufacturer3] [V @UUT_Model]!
  1.081  ELSE
  1.082  DISP         UUT is a [V @Manufacturer] [V @ModelNum],
  1.082  DISP         not a [V @UUT_Manufacturer] [V @UUT_Model]!
  1.083  ENDIF

  1.084  END
  1.085  ENDIF

# Check the serial number if the calling procedure specified a
# serial number and the UUT returned a serial number.
  1.086  IF           ISVAR("@UUT_SerialNum")

  1.087  IF           NOT(ZCMPI(@SerialNum, "Not available"))
  1.088  MATH         @Abort = NOT(ZCMPI(@SerialNum, @UUT_SerialNum))

  1.089  IF           @Abort
  1.090  DISP         UUT serial number is [V @SerialNum].
  1.090  DISP         Expected serial number is [V @UUT_SerialNum]!
  1.091  ENDIF

  1.092  ENDIF

  1.093  ENDIF        ; ISVAR("@UUT_SerialNum")

  1.094  END
