﻿Copyright (c) (2014) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub UUT RS-232 Connection DTE DB9 (m) /5502E
DATE:                  2014-08-20 09:17:54
AUTHOR:                Fluke
REVISION:              $Revision: 8604 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       52
=============================================================================
#
#  Procedure Author:
#        DAC
#
#  Compatibility:
#        MET/CAL 8.0.52 or later
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  MATH         MEM2 = INI("startup", "port")
  1.002  MATH         @Error = ZCMPI(MEM2, "None")

  1.003  IF           @Error
  1.004  DISP         "port = [MEM2]" in the MET/CAL initialization file.
  1.004  DISP
  1.004  DISP         1. Terminate procedure.
  1.004  DISP         2. Select TOOLS=>Configure Default Serial Port...
  1.004  DISP         3. Set "Serial Port" to COM port to which UUT will be
  1.004  DISP         [32]  connected.
  1.005  ELSEIF       ZCMPI(MEM2, "COM5502E")
  1.006  DISP         Connect UUT to port labeled "Serial 2 to UUT" on
  1.006  DISP         rear panel of 5502E, using a DB9 (f) to DB9 (m)
  1.006  DISP         straight through cable.
  1.007  ELSE
  1.008  DISP         Connect UUT to [MEM2] using a DB9 (f) to DB9 (f)
  1.008  DISP         null-modem cable.
  1.009  ENDIF

  1.010  END
