﻿Copyright (c) (2015) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Fluke 39,41B (1 yr) Harmonics VER /5502A
DATE:                  2015-06-18 18:14:12
AUTHOR:                Fluke Calibration
REVISION:              $Revision: 12408 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       25
NUMBER OF LINES:       278
CONFIGURATION:         Fluke 5502A
=============================================================================
#
#  Procedure Author(s):
#        DAC, BHT
#
# Source(s):
#       Fluke 39 Power Meter / 41B Power Harmonics Analyzer
#       Service Manual. PN 601044 October 1995, Rev.1,9/00 *
#
#       * The tolerances used by this procedure were taken from the published
#         specifications table.
#
# Compatibility:
#       MET/CAL version 8.1.4 or later
#
# Additional Equipment and/or Accessories Required:
#       None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  RSLT         =
  1.002  HEAD         {HARMONICS VOLTS}
  1.003  RSLT         =
  1.004  HEAD         -2{1st HARMONIC}
  1.005  TARGET       -p
  1.006  PIC          40_harm
  1.007  PIC          40_volts
  1.008  PIC          40smooth
  1.009  5502A        Mode = DualACV; AuxVolt = 700 mV; Phase = -10 deg
  1.009  5502A        +NormVolt = 7.0 V; Freq = 60 Hz; Harm = 1; Fund = Aux
  1.010  DISP         Move the UUT cursor to the 1st harmonic.
  1.011  TARGET       -m
  1.012  MEMI         Enter UUT reading in volts AC:
  1.013  MEMCX        7.0V           2% 0.2U       60Hz

  2.001  5502A        Mode = DualACV; AuxVolt = 700 mV; NormVolt = 7.0 V
  2.001  5502A        +Phase = -10 deg; Freq = 60 Hz; Harm = 1; Fund = Aux
  2.002  TARGET       -m
  2.003  MEMI         Enter UUT reading in degrees.
  2.004  MEMCX        10deg          2U            60Hz

  3.001  RSLT         =
  3.002  HEAD         -2{3rd HARMONIC}
  3.003  TARGET       -p
  3.004  5502A        Mode = DualACV; AuxVolt = 700 mV; Phase = -20 deg
  3.004  5502A        +NormVolt = 7.0 V; Freq = 60 Hz; Harm = 3; Fund = Aux
  3.005  DISP         Move the UUT cursor to the 3rd harmonic.
  3.006  TARGET       -m
  3.007  MEMI         Enter UUT reading in volts AC:
  3.008  MEMCX        7.0V           2% 0.2U       60Hz

  4.001  5502A        Mode = DualACV; AuxVolt = 700 mV; NormVolt = 7.0 V
  4.001  5502A        +Phase = -20 deg; Freq = 60 Hz; Harm = 3; Fund = Aux
  4.002  TARGET       -m
  4.003  MEMI         Enter UUT reading in degrees.
  4.004  MEMCX        20deg          6U            60Hz

  5.001  RSLT         =
  5.002  HEAD         -2{9th HARMONIC}
  5.003  TARGET       -p
  5.004  5502A        Mode = DualACV; AuxVolt = 700 mV; Phase = -30 deg
  5.004  5502A        +NormVolt = 7.0 V; Freq = 60 Hz; Harm = 9; Fund = Aux
  5.005  DISP         Move the UUT cursor to the 9th harmonic.
  5.006  TARGET       -m
  5.007  MEMI         Enter UUT reading in volts AC:
  5.008  MEMCX        7.0V           2% 0.2U       60Hz

  6.001  5502A        Mode = DualACV; AuxVolt = 700 mV; NormVolt = 7.0 V
  6.001  5502A        +Phase = -30 deg; Freq = 60 Hz; Harm = 9; Fund = Aux
  6.002  TARGET       -m
  6.003  MEMI         Enter UUT reading in degrees.
  6.004  MEMCX        30deg          9U            60Hz

  7.001  RSLT         =
  7.002  HEAD         -2{13th HARMONIC}
  7.003  TARGET       -p
  7.004  5502A        Mode = DualACV; AuxVolt = 700 mV; Phase = -40 deg
  7.004  5502A        +NormVolt = 7.0 V; Freq = 60 Hz; Harm = 13; Fund = Aux
  7.005  DISP         Move the UUT cursor to the 13th harmonic.
  7.006  TARGET       -m
  7.007  MEMI         Enter UUT reading in volts AC:
  7.008  MEMCX        7.0V           2% 0.2U       60Hz

  8.001  5502A        Mode = DualACV; AuxVolt = 700 mV; NormVolt = 7.0 V
  8.001  5502A        +Phase = -40 deg; Freq = 60 Hz; Harm = 13; Fund = Aux
  8.002  TARGET       -m
  8.003  MEMI         Enter UUT reading in degrees.
  8.004  MEMCX        40deg          11U           60Hz

  9.001  RSLT         =
  9.002  HEAD         -2{21st HARMONIC}
  9.003  TARGET       -p
  9.004  5502A        Mode = DualACV; AuxVolt = 700 mV; Phase = -50 deg
  9.004  5502A        +NormVolt = 7.0 V; Freq = 60 Hz; Harm = 21; Fund = Aux
  9.005  DISP         Move the UUT cursor to the 21st harmonic.
  9.006  TARGET       -m
  9.007  MEMI         Enter UUT reading in volts AC:
  9.008  MEMCX        7.0V           5% 0.2U       60Hz

 10.001  5502A        Mode = DualACV; AuxVolt = 700 mV; NormVolt = 7.0 V
 10.001  5502A        +Phase = -50 deg; Freq = 60 Hz; Harm = 21; Fund = Aux
 10.002  TARGET       -m
 10.003  MEMI         Enter UUT reading in degrees.
 10.004  MEMCX        50deg          15U           60Hz

 11.001  RSLT         =
 11.002  HEAD         -2{31st HARMONIC}
 11.003  TARGET       -p
 11.004  5502A        Mode = DualACV; AuxVolt = 700 mV; Phase = -60 deg
 11.004  5502A        +NormVolt = 7.0 V; Freq = 60 Hz; Harm = 31; Fund = Aux
 11.005  DISP         Move the UUT cursor to the 31st harmonic.
 11.006  TARGET       -m
 11.007  MEMI         Enter UUT reading in volts AC:
 11.008  MEMCX        7.0V           8% 0.2U       60Hz

 12.001  5502A        Mode = DualACV; AuxVolt = 700 mV; NormVolt = 7.0 V
 12.001  5502A        +Phase = -60 deg; Freq = 60 Hz; Harm = 31; Fund = Aux
 12.002  MEMI         Enter UUT reading in degrees.
 12.003  MEMCX        60deg          20U           60Hz

 13.001  5502A        Standby

 13.002  RSLT         =
 13.003  HEAD         {HARMONICS AMPS}
 13.004  PIC          40_amps
 13.005  PIC          40_vref
# Test harmonics amps in reverse order because cursor is already at the
# 31st harmonic.  Note however that results will be in statement number order.
 13.006  JMPL         31st_HARMONIC_AMPS

 13.007  LABEL        1st_HARMONIC_AMPS
 13.008  RSLT         =
 13.009  HEAD         -2{1st HARMONIC}: Amps
 13.010  TARGET       -p
 13.011  5502A        Mode = DualACV; NormVolt = 7.0 V; Phase = 10 deg
 13.011  5502A        +AuxVolt = 20.0 mV; Freq = 60 Hz; Harm = 1; Fund = Norm
 13.012  DISP         Move the UUT cursor to the 1st harmonic.
 13.013  ACC          20.0A          L1%
 13.014  TARGET       -m
 13.015  MEMI         Enter UUT reading in amps.
 13.016  MEMCX  A     20.0A          3% 0.3U       60Hz

 14.001  5502A        Mode = DualACV; AuxVolt = 20.0 mV; NormVolt = 7.0 V
 14.001  5502A        +Phase = 10 deg; Freq = 60 Hz; Harm = 1; Fund = Norm
 14.002  TARGET       -m
 14.003  MEMI         Enter UUT reading in degrees:
 14.004  MEMCX        10deg          2U            60Hz

 15.001  JMPL         END

 15.002  LABEL        3rd_HARMONIC_AMPS
 15.003  RSLT         =
 15.004  HEAD         -2{3rd HARMONIC}: Amps
 15.005  TARGET       -p
 15.006  5502A        Mode = DualACV; NormVolt = 7.0 V; Phase = 20 deg
 15.006  5502A        +AuxVolt = 20.0 mV; Freq = 60 Hz; Harm = 3; Fund = Norm
 15.007  DISP         Move the UUT cursor to the 3rd harmonic.
 15.008  ACC          20.0A          L1%
 15.009  TARGET       -m
 15.010  MEMI         Enter UUT reading in amps.
 15.011  MEMCX  A     20.0A          3% 0.3U       60Hz

 16.001  5502A        Mode = DualACV; AuxVolt = 20.0 mV; NormVolt = 7.0 V
 16.001  5502A        +Phase = 20 deg; Freq = 60 Hz; Harm = 3; Fund = Norm
 16.002  TARGET       -m
 16.003  MEMI         Enter UUT reading in degrees:
 16.004  MEMCX        20deg          6U            60Hz
 17.001  JMPL         1st_HARMONIC_AMPS

 17.002  LABEL        9th_HARMONIC_AMPS
 17.003  RSLT         =
 17.004  HEAD         -2{9th HARMONIC}: Amps
 17.005  TARGET       -p
 17.006  5502A        Mode = DualACV; NormVolt = 7.0 V; Phase = 30 deg
 17.006  5502A        +AuxVolt = 20.0 mV; Freq = 60 Hz; Harm = 9; Fund = Norm
 17.007  DISP         Move the UUT cursor to the 9th harmonic.
 17.008  ACC          20.0A          L1%
 17.009  TARGET       -m
 17.010  MEMI         Enter UUT reading in amps.
 17.011  MEMCX  A     20.0A          3% 0.3U       60Hz

 18.001  5502A        Mode = DualACV; AuxVolt = 20.0 mV; NormVolt = 7.0 V
 18.001  5502A        +Phase = 30 deg; Freq = 60 Hz; Harm = 9; Fund = Norm
 18.002  TARGET       -m
 18.003  MEMI         Enter UUT reading in degrees:
 18.004  MEMCX        30deg          9U            60Hz
 19.001  JMPL         3rd_HARMONIC_AMPS

 19.002  LABEL        13th_HARMONIC_AMPS
 19.003  RSLT         =
 19.004  HEAD         -2{13th HARMONIC}: Amps
 19.005  TARGET       -p
 19.006  5502A        Mode = DualACV; NormVolt = 7.0 V; Phase = 40 deg
 19.006  5502A        +AuxVolt = 20.0 mV; Freq = 60 Hz; Harm = 13; Fund = Norm
 19.007  DISP         Move the UUT cursor to the 13th harmonic.
 19.008  ACC          20.0A          L1%
 19.009  TARGET       -m
 19.010  MEMI         Enter UUT reading in amps.
 19.011  MEMCX  A     20.0A          3% 0.3U       60Hz

 20.001  5502A        Mode = DualACV; AuxVolt = 20.0 mV; NormVolt = 7.0 V
 20.001  5502A        +Phase = 40 deg; Freq = 60 Hz; Harm = 13; Fund = Norm
 20.002  TARGET       -m
 20.003  MEMI         Enter UUT reading in degrees:
 20.004  MEMCX        40deg          11U           60Hz
 21.001  JMPL         9th_HARMONIC_AMPS

 21.002  LABEL        21st_HARMONIC_AMPS
 21.003  RSLT         =
 21.004  HEAD         -2{21st HARMONIC}: Amps
 21.005  TARGET       -p
 21.006  5502A        Mode = DualACV; NormVolt = 7.0 V; Phase = 50 deg
 21.006  5502A        +AuxVolt = 20.0 mV; Freq = 60 Hz; Harm = 21; Fund = Norm
 21.007  DISP         Move the UUT cursor to the 21st harmonic.
 21.008  ACC          20.0A          L1%
 21.009  TARGET       -m
 21.010  MEMI         Enter UUT reading in amps.
 21.011  MEMCX  A     20.0A          5% 0.3U       60Hz

 22.001  5502A        Mode = DualACV; AuxVolt = 20.0 mV; NormVolt = 7.0 V
 22.001  5502A        +Phase = 50 deg; Freq = 60 Hz; Harm = 21; Fund = Norm
 22.002  TARGET       -m
 22.003  MEMI         Enter UUT reading in degrees:
 22.004  MEMCX        50deg          15U           60Hz
 23.001  JMPL         13th_HARMONIC_AMPS

 23.002  LABEL        31st_HARMONIC_AMPS
 23.003  RSLT         =
 23.004  HEAD         -2{31st HARMONIC}: Amps
 23.005  TARGET       -p
 23.006  5502A        Mode = DualACV; NormVolt = 7.0 V; Phase = 60 deg
 23.006  5502A        +AuxVolt = 20.0 mV; Freq = 60 Hz; Harm = 31; Fund = Norm
# Get Calibrator AUX output accuracy at 20 mV and convert to a percentage.
# Convert accuracy in base units to non-proportional parts, then to percent.
 23.007  MATH         RefAccPct = REFACC() / MEM1 * 100
# Normalize RefAcc in percent to k=1, then expand to k=2 for the ACC FSC.
 23.008  MATH         L[1] = RefAccPct / CONF(@CalDev) * 2
 23.009  ACC          20.0A          L1%
 23.010  TARGET       -m
 23.011  MEMI         Enter UUT reading in amps.
 23.012  MEMCX  A     20.0A          8% 0.3U       60Hz

 24.001  5502A        Mode = DualACV; AuxVolt = 20.0 mV; NormVolt = 7.0 V
 24.001  5502A        +Phase = 60 deg; Freq = 60 Hz; Harm = 31; Fund = Norm
 24.002  TARGET       -m
 24.003  MEMI         Enter UUT reading in degrees:
 24.004  MEMCX        60deg          20U           60Hz

 25.001  JMPL         21st_HARMONIC_AMPS

 25.002  LABEL        END
 25.003  HEAD         -2
 25.004  5502A        Standby
 25.005  HEAD
 25.006  END
