﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 39,41B (1 yr) Volts DC VER /5502A
INSTRUMENT:            Sub Fluke 39,41B (1 yr) Volts AC VER /5502A
INSTRUMENT:            Sub Fluke 39,41B (1 yr) Amps DC VER /5502A
INSTRUMENT:            Sub Fluke 39,41B (1 yr) Amps AC VER /5502A
INSTRUMENT:            Sub Fluke 39,41B (1 yr) Watts VER /5502A
INSTRUMENT:            Sub Fluke 39,41B (1 yr) Record Mode VER /5502A
DATE:                  2016-02-25 12:13:55
AUTHOR:                Fluke Calibration
REVISION:              $Revision: 15261 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       82
NUMBER OF LINES:       874
CONFIGURATION:         Fluke 5502A
=============================================================================
#
# Procedure Author(s):
#        DAC, BHT
#
# Source(s):
#       Fluke 39 Power Meter / 41B Power Harmonics Analyzer
#       Service Manual. PN 601044 October 1995, Rev.1,9/00 *
#
#       * The tolerances used by this procedure were taken from the published
#         specifications table.
#
# Compatibility:
#       MET/CAL version 8.1.4 or later
#
# Additional Equipment and/or Accessories Required:
#       None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         VOLTS_DC                     PSUBI("Volts DC")
  1.002  JMPL         VOLTS_AC                     PSUBI("Volts AC")
  1.003  JMPL         AMPS_DC                      PSUBI("Amps DC")
  1.004  JMPL         AMPS_AC                      PSUBI("Amps AC")
  1.005  JMPL         WATTS                        PSUBI("Watts")
  1.006  JMPL         RECORD_MODE                  PSUBI("Record Mode")
  1.007  DISP         Subprocedure not found!
  1.008  END

  1.009  EVAL   Increment Test Number

# =====  Sub Fluke 39,41B (1 yr) Volts DC VER /5502A  ========================

  2.001  LABEL        VOLTS_DC
  2.002  RSLT         =
  2.003  HEAD         {VOLTS DC}
  2.004  RSLT         =
  2.005  HEAD         -2{20 V Range}
  2.006  TARGET       -p
  2.007  DISP         Connect the Calibrator to the UUT as follows:
  2.007  DISP         [32] Calibrator NORMAL HI to UUT V Input
  2.007  DISP         [32] Calibrator NORMAL LO to UUT COM Input.
  2.008  PIC          40_text
  2.009  PIC          40_volts
  2.010  PIC          40_vref
  2.011  5502A        +Voltage = 5.0 V
  2.012  TARGET       -m
  2.013  MEMI         Enter UUT reading in volts DC:
  2.014  MEMCX  20    5.0V           2% 0.5U

  3.001  RSLT         =
  3.002  HEAD         -2{50 V Range}
  3.003  TARGET       -p
  3.004  5502A        +Voltage = 15.0 V
  3.005  TARGET       -m
  3.006  MEMI         Enter UUT reading in volts DC:
  3.007  MEMCX  50    15.0V          2% 0.3U

  4.001  RSLT         =
  4.002  HEAD         -2{100 V Range}
  4.003  TARGET       -p
  4.004  5502A        +Voltage = 65.0 V
  4.005  TARGET       -m
  4.006  MEMI         Enter UUT reading in volts DC:
  4.007  MEMCX  100   65.0V          2% 0.3U

  5.001  RSLT         =
  5.002  HEAD         -2{200 V Range}
  5.003  TARGET       -p
  5.004  5502A        +Voltage = 130.0 V
  5.005  TARGET       -m
  5.006  MEMI         Enter UUT reading in volts DC:
  5.007  MEMCX  200   130.0V         2% 0.3U

  6.001  RSLT         =
  6.002  HEAD         -2{500 V Range}
  6.003  TARGET       -p
  6.004  5502A        +Voltage = 208 V
  6.005  TARGET       -m
  6.006  MEMI         Enter UUT reading in volts DC:
  6.007  MEMCX  500   208V           2% 3U

  7.001  5502A        +Voltage = 350 V
  7.002  TARGET       -m
  7.003  MEMI         Enter UUT reading in volts DC:
  7.004  MEMCX  500   350V           2% 3U

  8.001  RSLT         =
  8.002  HEAD         -2{1000 V Range}
  8.003  5502A        +Voltage = 480 V
  8.004  TARGET       -m
  8.005  MEMI         Enter UUT reading in volts DC:
  8.006  MEMCX  1000  480V           2% 3U

  9.001  5502A        +Voltage = 600 V
  9.002  TARGET       -m
  9.003  MEMI         Enter UUT reading in volts DC:
  9.004  MEMCX  1000  600V           2% 3U

 10.001  HEAD         -2
 10.002  5502A        Standby
 10.003  HEAD
 10.004  END

 10.005  EVAL   Increment Test Number

# =====  Sub Fluke 39,41B (1 yr) Volts AC VER /5502A  ========================

 11.001  LABEL        VOLTS_AC
 11.002  RSLT         =
 11.003  HEAD         {VOLTS AC}
 11.004  RSLT         =
 11.005  HEAD         -2{20 V Range}
 11.006  TARGET       -p
 11.007  5502A        +Voltage = 5.0 V; Frequency = 60 Hz
 11.008  TARGET       -m
 11.009  MEMI         Enter UUT reading in volts AC:
 11.010  MEMCX  20    5.0V           0.5% 0.4U     60Hz

 12.001  5502A        +Voltage = 7.1 Vp; Frequency = 60 Hz
 12.002  TARGET       -m
 12.003  MEMI         Enter UUT reading in volts peak AC:
 12.004  MEMCX  20    7.1Vp          2.0% 0.5U     60Hz

 13.001  RSLT         =
 13.002  HEAD         -2{50 V Range}
 13.003  TARGET       -p
 13.004  5502A        +Voltage = 15.0 V; Frequency = 60 Hz
 13.005  TARGET       -m
 13.006  MEMI         Enter UUT reading in volts AC:
 13.007  MEMCX  50    15.0V          0.5% 0.2U     60Hz

 14.001  5502A        +Voltage = 21.3 Vp; Frequency = 60 Hz
 14.002  TARGET       -m
 14.003  MEMI         Enter UUT reading in volts peak AC:
 14.004  MEMCX  50    21.3Vp         2.0% 0.3U     60Hz

 15.001  RSLT         =
 15.002  HEAD         -2{100 V Range}
 15.003  TARGET       -p
 15.004  5502A        +Voltage = 65.0 V; Frequency = 60 Hz
 15.005  TARGET       -m
 15.006  MEMI         Enter UUT reading in volts AC:
 15.007  MEMCX  100   65.0V          0.5% 0.2U     60Hz

 16.001  5502A        +Voltage = 92.0 Vp; Frequency = 60 Hz
 16.002  TARGET       -m
 16.003  MEMI         Enter UUT reading in volts peak AC:
 16.004  MEMCX  100   92.0Vp         2.0% 0.3U     60Hz

 17.001  RSLT         =
 17.002  HEAD         -2{200 V Range}
 17.003  TARGET       -p
 17.004  5502A        +Voltage = 130.0 V; Frequency = 60 Hz
 17.005  TARGET       -m
 17.006  MEMI         Enter UUT reading in volts AC:
 17.007  MEMCX  200   130.0V         0.5% 0.2U     60Hz

 18.001  5502A        +Voltage = 183.9 Vp; Frequency = 60 Hz
 18.002  TARGET       -m
 18.003  MEMI         Enter UUT reading in volts peak AC:
 18.004  MEMCX  200   183.9Vp        2.0% 0.3U     60Hz

 19.001  RSLT         =
 19.002  HEAD         -2{500 V Range}
 19.003  TARGET       -p
 19.004  5502A        +Voltage = 208 V; Frequency = 60 Hz
 19.005  TARGET       -m
 19.006  MEMI         Enter UUT reading in volts AC:
 19.007  MEMCX  500   208V           0.5% 2U       60Hz

 20.001  5502A        +Voltage = 294 Vp; Frequency = 60 Hz
 20.002  TARGET       -m
 20.003  MEMI         Enter UUT reading in volts peak AC:
 20.004  MEMCX  500   294Vp          2.0% 3U       60Hz

 21.001  5502A        +Voltage = 350 V; Frequency = 60 Hz
 21.002  TARGET       -m
 21.003  MEMI         Enter UUT reading in volts AC:
 21.004  MEMCX  500   350V           0.5% 2U       60Hz

 22.001  5502A        +Voltage = 495 Vp; Frequency = 60 Hz
 22.002  TARGET       -m
 22.003  MEMI         Enter UUT reading in volts peak AC:
 22.004  MEMCX  500   495Vp          2.0% 3U       60Hz

 23.001  RSLT         =
 23.002  HEAD         -2{1000 V Range}
 23.003  TARGET       -p
 23.004  5502A        +Voltage = 480 V; Frequency = 60 Hz
 23.005  TARGET       -m
 23.006  MEMI         Enter UUT reading in volts AC:
 23.007  MEMCX  1000  480V           0.5% 2U       60Hz

 24.001  5502A        +Voltage = 679 Vp; Frequency = 60 Hz
 24.002  TARGET       -m
 24.003  MEMI         Enter UUT reading in volts peak AC:
 24.004  MEMCX  1000  679Vp          2.0% 3U       60Hz

 25.001  5502A        +Voltage = 600 V; Frequency = 60 Hz
 25.002  TARGET       -m
 25.003  MEMI         Enter UUT reading in volts AC:
 25.004  MEMCX  1000  600V           0.5% 2U       60Hz

 26.001  5502A        +Voltage = 848 Vp; Frequency = 60 Hz
 26.002  TARGET       -m
 26.003  MEMI         Enter UUT reading in volts peak AC:
 26.004  MEMCX  1000  848Vp          2.0% 3U       60Hz

 27.001  HEAD         -2
 27.002  5502A        Standby
 27.003  HEAD
 27.004  END

 27.005  EVAL   Increment Test Number

# =====  Sub Fluke 39,41B (1 yr) Amps DC VER /5502A  =========================

 28.001  LABEL        AMPS_DC
 28.002  RSLT         =
 28.003  HEAD         {AMPS DC}

 28.004  RSLT         =
 28.005  HEAD         -2{2 A Range}
 28.006  TARGET       -p
 28.007  DISP         Turn off the UUT.
 28.007  DISP
 28.007  DISP         Press the HOLD/ENTER button and turn on the UUT to enter
 28.007  DISP         the Setup screen.
 28.008  DISP         Using the HOLD/ENTER and left and right arrow buttons,
 28.008  DISP         select "OTHER" for Clamp Setting.
 28.009  DISP         Press HOLD/ENTER repeatedly to exit the Setup screen.
 28.010  DISP         Disconnect the Calibrator from the UUT.
 28.011  DISP         Connect the Calibrator to the UUT as follows:
 28.011  DISP         [32] Calibrator NORMAL HI & LO to UUT Current Probe BNC
 28.011  DISP         [32] using a dual banana to BNC adapter.
 28.012  PIC          40_text
 28.013  PIC          40_amps
 28.014  PIC          40_aref
 28.015  5502A        +Voltage = 0.001 V
 28.016  MATH         L[1] = REFACC() / MEM1 * 100
 28.017  ACC          1.00A          L1%
 28.018  TARGET       -m
 28.019  MEMI         Enter UUT reading in amps DC.
 28.020  MEMCX  2     1.00A          2% 0.04U

 29.001  RSLT         =
 29.002  HEAD         -2{10 A Range}
 29.003  TARGET       -p
 29.004  5502A        +Voltage = 0.0067 V
 29.005  MATH         L[1] = REFACC() / MEM1 * 100
 29.006  ACC          6.70A          L1%
 29.007  TARGET       -m
 29.008  MEMI         Enter UUT reading in amps DC.
 29.009  MEMCX  10    6.70A          2% 0.04U

 30.001  RSLT         =
 30.002  HEAD         -2{20 A Range}
 30.003  TARGET       -p
 30.004  5502A        +Voltage = 0.0135 V
 30.005  MATH         L[1] = REFACC() / MEM1 * 100
 30.006  ACC          13.50A         L1%
 30.007  TARGET       -m
 30.008  MEMI         Enter UUT reading in amps DC.
 30.009  MEMCX  20    13.50A         2% 0.04U

 31.001  RSLT         =
 31.002  HEAD         -2{100 A Range}
 31.003  TARGET       -p
 31.004  5502A        +Voltage = 0.067 V
 31.005  ACC          67.0A          L1%
 31.006  TARGET       -m
 31.007  MEMI         Enter UUT reading in amps DC.
 31.008  MEMCX  100   67.0A          2% 0.4U

 32.001  RSLT         =
 32.002  HEAD         -2{200 A Range}
 32.003  TARGET       -p
 32.004  5502A        +Voltage = 0.135 V
 32.005  MATH         L[1] = REFACC() / MEM1 * 100
 32.006  ACC          135.0A         L1%
 32.007  TARGET       -m
 32.008  MEMI         Enter UUT reading in amps DC.
 32.009  MEMCX  200   135.0A         2% 0.4U

 33.001  RSLT         =
 33.002  HEAD         -2{1000 A Range}
 33.003  TARGET       -p
 33.004  5502A        +Voltage = 0.67 V
 33.005  MATH         L[1] = REFACC() / MEM1 * 100
 33.006  ACC          670A           L1%
 33.007  TARGET       -m
 33.008  MEMI         Enter UUT reading in amps DC.
 33.009  MEMCX  1000  670A           2% 4U

 34.001  RSLT         =
 34.002  HEAD         -2{2000 A Range}
 34.003  TARGET       -p
 34.004  5502A        +Voltage = 1 V
 34.005  MATH         L[1] = REFACC() / MEM1 * 100
 34.006  ACC          1000A          L1%
 34.007  TARGET       -m
 34.008  MEMI         Enter UUT reading in amps DC.
 34.009  MEMCX  2000  1000A          2% 4U

 35.001  HEAD         -2
 35.002  5502A        Standby
 35.003  HEAD
 35.004  END

 35.005  EVAL   Increment Test Number

# =====  Sub Fluke 39,41B (1 yr) Amps AC VER /5502A  =========================

 36.001  LABEL        AMPS_AC
 36.002  RSLT         =
 36.003  HEAD         {AMPS AC}
 36.004  RSLT         =
 36.005  HEAD         -2{2 A Range}
 36.006  TARGET       -p
 36.007  5502A        +Voltage = 0.001 V; Frequency = 60 Hz
 36.008  MATH         L[1] = REFACC() / MEM1 * 100
 36.009  ACC          1.00A          L1%
 36.010  TARGET       -m
 36.011  MEMI         Enter UUT reading in amps RMS.
 36.012  MEMCX  2     1.00A          0.5% 0.03U    60Hz

 37.001  5502A        +Voltage = 0.00142 Vp; Frequency = 60 Hz
 37.002  MATH         L[1] = REFACC() / MEM1 * 100
 37.003  ACC          1.42Ap         L1%
 37.004  TARGET       -m
 37.005  MEMI         Enter UUT reading in amps peak.
 37.006  MEMCX  2     1.42Ap         2% 0.04U      60Hz

 38.001  RSLT         =
 38.002  HEAD         -2{10 A Range}
 38.003  TARGET       -p
 38.004  5502A        +Voltage = 0.0067 V; Frequency = 60 Hz
 38.005  MATH         L[1] = REFACC() / MEM1 * 100
 38.006  ACC          6.70A          L1%
 38.007  TARGET       -m
 38.008  MEMI         Enter UUT reading in amps RMS.
 38.009  MEMCX  10    6.70A          0.5% 0.03U    60Hz

 39.001  5502A        +Voltage = 0.00948 Vp; Frequency = 60 Hz
 39.002  MATH         L[1] = REFACC() / MEM1 * 100
 39.003  ACC          9.48Ap         L1%
 39.004  TARGET       -m
 39.005  MEMI         Enter UUT reading in amps peak.
 39.006  MEMCX  10    9.48Ap         2% 0.04U      60Hz

 40.001  RSLT         =
 40.002  HEAD         -2{20 A Range}
 40.003  TARGET       -p
 40.004  5502A        +Voltage = 0.0135 V; Frequency = 60 Hz
 40.005  MATH         L[1] = REFACC() / MEM1 * 100
 40.006  ACC          13.50A         L1%
 40.007  TARGET       -m
 40.008  MEMI         Enter UUT reading in amps RMS.
 40.009  MEMCX  20    13.50A         0.5% 0.03U    60Hz

 41.001  5502A        +Voltage = 0.0191 Vp; Frequency = 60 Hz
 41.002  MATH         L[1] = REFACC() / MEM1 * 100
 41.003  ACC          19.10Ap        L1%
 41.004  TARGET       -m
 41.005  MEMI         Enter UUT reading in amps peak.
 41.006  MEMCX  20    19.10Ap        2% 0.04U      60Hz

 42.001  RSLT         =
 42.002  HEAD         -2{100 A Range}
 42.003  TARGET       -p
 42.004  5502A        +Voltage = 0.067 V; Frequency = 60 Hz
 42.005  MATH         L[1] = REFACC() / MEM1 * 100
 42.006  ACC          67.0A          .04% 200e-4U
 42.007  TARGET       -m
 42.008  MEMI         Enter UUT reading in amps RMS.
 42.009  MEMCX  100   67.0A          0.5% 0.3U     60Hz

 43.001  5502A        +Voltage = 0.0948 Vp; Frequency = 60 Hz
 43.002  MATH         L[1] = REFACC() / MEM1 * 100
 43.003  ACC          94.8Ap         L1%
 43.004  TARGET       -m
 43.005  MEMI         Enter UUT reading in amps peak.
 43.006  MEMCX  100   94.8Ap         2% 0.4U       60Hz

 44.001  RSLT         =
 44.002  HEAD         -2{200 A Range}
 44.003  TARGET       -p
 44.004  5502A        +Voltage = 0.135 V; Frequency = 60 Hz
 44.005  MATH         L[1] = REFACC() / MEM1 * 100
 44.006  ACC          135.0A         L1%
 44.007  TARGET       -m
 44.008  MEMI         Enter UUT reading in amps RMS.
 44.009  MEMCX  200   135.0A         0.5% 0.3U     60Hz

 45.001  5502A        +Voltage = 0.191 Vp; Frequency = 60 Hz
 45.002  MATH         L[1] = REFACC() / MEM1 * 100
 45.003  ACC          191.0Ap        L1%
 45.004  TARGET       -m
 45.005  MEMI         Enter UUT reading in amps peak.
 45.006  MEMCX  200   191.0Ap        2% 0.4U       60Hz

 46.001  RSLT         =
 46.002  HEAD         -2{1000 A Range}
 46.003  TARGET       -p
 46.004  5502A        +Voltage = 0.67 V; Frequency = 60 Hz
 46.005  MATH         L[1] = REFACC() / MEM1 * 100
 46.006  ACC          670A           L1%
 46.007  TARGET       -m
 46.008  MEMI         Enter UUT reading in amps RMS.
 46.009  MEMCX  1000  670A           0.5% 3U       60Hz

 47.001  5502A        +Voltage = 0.948 Vp; Frequency = 60 Hz
 47.002  MATH         L[1] = REFACC() / MEM1 * 100
 47.003  ACC          948Ap          L1%
 47.004  TARGET       -m
 47.005  MEMI         Enter UUT reading in amps peak.
 47.006  MEMCX  1000  948Ap          2% 4U         60Hz

 48.001  RSLT         =
 48.002  HEAD         -2{2000 A Range}
 48.003  TARGET       -p
 48.004  5502A        +Voltage = 1 V; Frequency = 60 Hz
 48.005  MATH         L[1] = REFACC() / MEM1 * 100
 48.006  ACC          1000A          L1%
 48.007  TARGET       -m
 48.008  MEMI         Enter UUT reading in amps RMS.
 48.009  MEMCX  2000  1000A          0.5% 3U       60Hz

 49.001  5502A        +Voltage = 1.414 Vp; Frequency = 60 Hz
 49.002  MATH         L[1] = REFACC() / MEM1 * 100
 49.003  ACC          1414Ap         L1%
 49.004  TARGET       -m
 49.005  MEMI         Enter UUT reading in amps peak.
 49.006  MEMCX  2000  1414Ap         2% 4U         60Hz

 50.001  HEAD         -2
 50.002  5502A        Standby
 50.003  HEAD
 50.004  DISP         Disconnect the Calibrator from the UUT.
 50.005  END

 50.006  EVAL   Increment Test Number

# =====  Sub Fluke 39,41B (1 yr) Watts VER /5502A  ===========================

 51.001  LABEL        WATTS
 51.002  RSLT         =
 51.003  HEAD         {WATTS}
 51.004  RSLT         =
 51.005  RSLT         =5 V, 30 A @ 60 Hz

 51.006  MATH         @AuxVoltage = 30E-3; @PhaseDeg = 0; @Frequency = 60
 51.007  TARGET       -p
 51.008  DISP         Connect the Calibrator to the UUT as follows:
 51.008  DISP
 51.008  DISP         [32] Calibrator       UUT
 51.008  DISP         [32] NORMAL HI    to  V Input
 51.008  DISP         [32] NORMAL LO    to  COM Input
 51.008  DISP         [32] AUX HI & LO  to  Current Probe BNC
 51.008  DISP         [32]   using a dual banana to BNC adapter.
 51.009  PIC          40_watts
 51.010  PIC          40_aref
 51.011  DISP         Press the left or right arrow key to display VAR A LEAD.
 51.012  5502A        AuxVoltage = 30 mV; Phase = 0 deg
 51.012  5502A        +NormalVoltage = 5 V; Frequency = 60 Hz
 51.013  MATH         @NormalVoltage = MEM1; @PowerUnits = "W"
 51.014  CALL         Sub Fluke 55xxA Calculate Sine AC Power Acc (AUX volts)
 51.015  ACC          150W           M1%
 51.016  TARGET       -m
 51.017  MEMI         Enter UUT reading in watts.
 51.018  MEMCX        150W           1% 4U

 52.001  5502A        AuxVoltage = 30 mV; Phase = 0 deg
 52.001  5502A        +NormalVoltage = 5 V; Frequency = 60 Hz
 52.002  MATH         @NormalVoltage = MEM1; @PowerUnits = "VA"
 52.003  CALL         Sub Fluke 55xxA Calculate Sine AC Power Acc (AUX volts)
 52.004  ACC          150VA          M1%
 52.005  TARGET       -m
 52.006  MEMI         Enter UUT reading in volt-amps.
 52.007  MEMCX        150VA          1% 4U

 53.001  5502A        AuxVoltage = 30 mV; Phase = 0 deg
 53.001  5502A        +NormalVoltage = 5 V; Frequency = 60 Hz
 53.002  MATH         @NormalVoltage = MEM1; @PowerUnits = "VAR"
 53.003  CALL         Sub Fluke 55xxA Calculate Sine AC Power Acc (AUX volts)
# Compute system accuracy at 4 VAR because M1P% of 0 VAR is zero.
 53.004  MATH         M[2] = 4 * M[1] * 1E-6
 53.005  ACC          0'VAR'         M2U
 53.006  TARGET       -m
 53.007  MEMI         Enter UUT reading in units of VAR.
 53.008  MEMCX        0'VAR'         1% 4U

 54.001  JMPL         WATTS_8V_30A

 54.002  LABEL        PHASE_5V_30A
 54.003  TARGET       -p
 54.004  5502A        AuxVoltage = 30 mV; NormalVoltage = 5 V
 54.004  5502A        +Phase = 0 deg; Frequency = 60 Hz
 54.005  TARGET       -m
 54.006  MEMI         Enter UUT reading in degrees.
 54.007  MEMCX        0deg           2U

 55.001  JMPL         PHASE_8V_30A

 55.002  LABEL        WATTS_8V_30A
 55.003  RSLT         =
 55.004  RSLT         =8 V, 30 A @ 60 Hz
 55.005  TARGET       -p
 55.006  5502A        AuxVoltage = 30 mV; Phase = 0 deg
 55.006  5502A        +NormalVoltage = 8 V; Frequency = 60 Hz
 55.007  MATH         @NormalVoltage = MEM1; @PowerUnits = "W"
 55.008  CALL         Sub Fluke 55xxA Calculate Sine AC Power Acc (AUX volts)
 55.009  ACC          240W           M1%
 55.010  TARGET       -m
 55.011  MEMI         Enter UUT reading in watts.
 55.012  MEMCX        240W           1% 4U

 56.001  5502A        AuxVoltage = 0.03 V; Phase = 0 deg
 56.001  5502A        +NormalVoltage = 8 V; Frequency = 60 Hz
 56.002  MATH         @NormalVoltage = MEM1; @PowerUnits = "VA"
 56.003  CALL         Sub Fluke 55xxA Calculate Sine AC Power Acc (AUX volts)
 56.004  ACC          240VA          M1%
 56.005  TARGET       -m
 56.006  MEMI         Enter UUT reading in volt-amps.
 56.007  MEMCX        240VA          1% 4U

 57.001  5502A        AuxVoltage = 0.03 V; Phase = 0 deg
 57.001  5502A        +NormalVoltage = 8 V; Frequency = 60 Hz
 57.002  MATH         @NormalVoltage = MEM1; @PowerUnits = "VAR"
 57.003  CALL         Sub Fluke 55xxA Calculate Sine AC Power Acc (AUX volts)
# Compute system accuracy at 4 VAR because M1P% of 0 VAR is zero.
 57.004  MATH         M[2] = 4 * M[1] * 1E-6
 57.005  ACC          0'VAR'         M2U
 57.006  TARGET       -m
 57.007  MEMI         Enter UUT reading in units of VAR.
 57.008  MEMCX        0'VAR'         1% 4U

 58.001  JMPL         WATTS_100V_150A

 58.002  LABEL        PHASE_8V_30A
 58.003  TARGET       -p
 58.004  5502A        AuxVoltage = 30 mV; NormalVoltage = 8 V
 58.004  5502A        +Phase = 0 deg; Frequency = 60 Hz
 58.005  TARGET       -m
 58.006  MEMI         Enter UUT reading in degrees.
 58.007  MEMCX        0deg           2U

 59.001  JMPL         PHASE_100V_150A

 59.002  LABEL        WATTS_100V_150A
 59.003  RSLT         =
 59.004  RSLT         =100 V, 150 A @ 60 Hz
 59.005  MATH         @AuxVoltage = 150E-3; @PhaseDeg = 157
 59.006  TARGET       -p
 59.007  5502A        AuxVoltage = 150 mV; Phase = 157 deg
 59.007  5502A        +NormalVoltage = 100 V; Frequency = 60 Hz
 59.008  MATH         @NormalVoltage = MEM1; @PowerUnits = "W"
 59.009  CALL         Sub Fluke 55xxA Calculate Sine AC Power Acc (AUX volts)
 59.010  ACC          -13.8kW        M1%
 59.011  TARGET       -m
 59.012  MEMI         Enter UUT reading in kilowatts.
 59.013  MEMCX        -13.8kW        1% 0.4U

 60.001  5502A        AuxVoltage = 150 mV; Phase = 157 deg
 60.001  5502A        +NormalVoltage = 100 V; Frequency = 60 Hz
 60.002  MATH         @NormalVoltage = MEM1; @PowerUnits = "VA"
 60.003  CALL         Sub Fluke 55xxA Calculate Sine AC Power Acc (AUX volts)
 60.004  ACC          15.0kVA        M1%
 60.005  TARGET       -m
 60.006  MEMI         Enter UUT reading in kilovolt-amps.
 60.007  MEMCX        15.0kVA        1% 0.4U

 61.001  5502A        AuxVoltage = 150 mV; Phase = 157 deg
 61.001  5502A        +NormalVoltage = 100 V; Frequency = 60 Hz
 61.002  MATH         @NormalVoltage = MEM1; @PowerUnits = "VAR"
 61.003  CALL         Sub Fluke 55xxA Calculate Sine AC Power Acc (AUX volts)
 61.004  ACC          5.9k'VAR'      M1%
 61.005  MEMI         Enter UUT reading in units of kVAR.
 61.006  TARGET       -m
 61.007  MEMCX        5.9k'VAR'      1% 0.4U

 62.001  JMPL         WATTS_100V_360A

 62.002  LABEL        PHASE_100V_150A
 62.003  TARGET       -p
 62.004  5502A        AuxVoltage = 150 mV; NormalVoltage = 100 V
 62.004  5502A        +Phase = 157 deg; Frequency = 60 Hz
 62.005  TARGET       -m
 62.006  MEMI         Enter UUT reading in degrees.
 62.007  MEMCX        157deg         2U

 63.001  JMPL         PHASE_100V_360A

 63.002  LABEL        WATTS_100V_360A
 63.003  RSLT         =
 63.004  RSLT         =100 V, 360 A @ 60 Hz
 63.005  MATH         @AuxVoltage = 360E-3
 63.006  TARGET       -p
 63.007  5502A        AuxVoltage = 0.36 V; Phase = 157 deg
 63.007  5502A        +NormalVoltage = 100 V; Frequency = 60 Hz
 63.008  MATH         @NormalVoltage = MEM1; @PowerUnits = "W"
 63.009  CALL         Sub Fluke 55xxA Calculate Sine AC Power Acc (AUX volts)
 63.010  ACC          -32.5kW        M1%
 63.011  TARGET       -m
 63.012  MEMI         Enter UUT reading in kilowatts.
 63.013  MEMCX        -32.5kW        1% 4U

 64.001  5502A        AuxVoltage = 0.36 V;  Phase = 157 deg
 64.001  5502A        +NormalVoltage = 100 V; Frequency = 60 Hz
 64.002  MATH         @NormalVoltage = MEM1; @PowerUnits = "VA"
 64.003  CALL         Sub Fluke 55xxA Calculate Sine AC Power Acc (AUX volts)
 64.004  ACC          36kVA          L3%
 64.005  TARGET       -m
 64.006  MEMI         Enter UUT reading in kilovolt-amps.
 64.007  MEMCX        36kVA          1% 4U

 65.001  5502A        AuxVoltage = 0.36 V;  Phase = 157 deg
 65.001  5502A        +NormalVoltage = 100 V; Frequency = 60 Hz
 65.002  MATH         @NormalVoltage = MEM1; @PowerUnits = "VAR"
 65.003  CALL         Sub Fluke 55xxA Calculate Sine AC Power Acc (AUX volts)
 65.004  ACC          14.5k'VAR'     M1%
 65.005  TARGET       -m
 65.006  MEMI         Enter UUT reading in units of kVAR.
 65.007  MEMCX        14.5k'VAR'     1% 4U

 66.001  JMPL         WATTS_10V_1300A

 66.002  LABEL        PHASE_100V_360A
 66.003  TARGET       -p
 66.004  5502A        AuxVoltage = 360 mV; NormalVoltage = 100 V
 66.004  5502A        +Phase = 157 deg; Frequency = 60 Hz
 66.005  TARGET       -m
 66.006  MEMI         Enter UUT reading in degrees.
 66.007  MEMCX        157deg         2U

 67.001  JMPL         PHASE_10V_1300A

 67.002  LABEL        WATTS_10V_1300A
 67.003  RSLT         =
 67.004  RSLT         =10 V, 1300 A @ 60 Hz
 67.005  MATH         @AuxVoltage = 1.3; @PhaseDeg = 46
 67.006  TARGET       -p
 67.007  5502A        AuxVoltage = 1.3 V; Phase = 46 deg
 67.007  5502A        +NormalVoltage = 10 V; Frequency = 60 Hz
 67.008  MATH         @NormalVoltage = MEM1; @PowerUnits = "W"
 67.009  CALL         Sub Fluke 55xxA Calculate Sine AC Power Acc (AUX volts)
 67.010  ACC          9.1kW          M1%
 67.011  TARGET       -m
 67.012  MEMI         Enter UUT reading in kilowatts.
 67.013  MEMCX        9.1kW          1% 0.4U

 68.001  5502A        AuxVoltage = 1.3 V; Phase = 46 deg
 68.001  5502A        +NormalVoltage = 10 V ; Frequency = 60 Hz
 68.002  MATH         @NormalVoltage = MEM1; @PowerUnits = "VA"
 68.003  CALL         Sub Fluke 55xxA Calculate Sine AC Power Acc (AUX volts)
 68.004  ACC          13.0kVA        M1%
 68.005  TARGET       -m
 68.006  MEMI         Enter UUT reading in kilovolt-amps.
 68.007  MEMCX        13.0kVA        1% 0.4U

 69.001  5502A        AuxVoltage = 1.3 V; Phase = 46 deg
 69.001  5502A        +NormalVoltage = 10 V ; Frequency = 60 Hz
 69.002  MATH         @NormalVoltage = MEM1; @PowerUnits = "VAR"
 69.003  CALL         Sub Fluke 55xxA Calculate Sine AC Power Acc (AUX volts)
 69.004  ACC          9.4k'VAR'      M1%
 69.005  TARGET       -m
 69.006  MEMI         Enter UUT reading in units of kVAR.
 69.007  MEMCX        9.4k'VAR'      1% 0.4U

 70.001  JMPL         WATTS_100V_1300A

 70.002  LABEL        PHASE_10V_1300A
 70.003  TARGET       -p
 70.004  5502A        AuxVoltage = 1300 mV; NormalVoltage = 10 V
 70.004  5502A        +Phase = 46 deg; Frequency = 60 Hz
 70.005  TARGET       -m
 70.006  MEMI         Enter UUT reading in degrees.
 70.007  MEMCX        46deg          2U

 71.001  JMPL         PHASE_100V_1300A

 71.002  LABEL        WATTS_100V_1300A
 71.003  RSLT         =
 71.004  RSLT         =100 V, 1300 A @ 60 Hz
 71.005  TARGET       -p
 71.006  5502A        AuxVoltage = 1.3 V; Phase = 46 deg
 71.006  5502A        +NormalVoltage = 100 V; Frequency = 60 Hz
 71.007  MATH         @NormalVoltage = MEM1; @PowerUnits = "W"
 71.008  CALL         Sub Fluke 55xxA Calculate Sine AC Power Acc (AUX volts)
 71.009  ACC          91kW           M1%
 71.010  TARGET       -m
 71.011  MEMI         Enter UUT reading in kilowatts.
 71.012  MEMCX        91kW           1% 4U

 72.001  5502A        AuxVoltage = 1.3 V; Phase = 46 deg
 72.001  5502A        +NormalVoltage = 100 V; Frequency = 60 Hz
 72.002  MATH         @NormalVoltage = MEM1; @PowerUnits = "VA"
 72.003  CALL         Sub Fluke 55xxA Calculate Sine AC Power Acc (AUX volts)
 72.004  ACC          130kVA         M1%
 72.005  TARGET       -m
 72.006  MEMI         Enter UUT reading in kilovolt-amps.
 72.007  MEMCX        130kVA         1% 4U

 73.001  5502A        AuxVoltage = 1.3 V; Phase = 46 deg
 73.001  5502A        +NormalVoltage = 100 V; Frequency = 60 Hz
 73.002  MATH         @NormalVoltage = MEM1; @PowerUnits = "VAR"
 73.003  CALL         Sub Fluke 55xxA Calculate Sine AC Power Acc (AUX volts)
 73.004  ACC          94k'VAR'       M1%
 73.005  TARGET       -m
 73.006  MEMI         Enter UUT reading in units of kVAR.
 73.007  MEMCX        94k'VAR'       1% 4U

 74.001  5502A        Standby

 74.002  JMPL         PHASE

 74.003  LABEL        PHASE_100V_1300A
 74.004  TARGET       -p
 74.005  5502A        AuxVoltage = 1300 mV; NormalVoltage = 100 V
 74.005  5502A        +Phase = 46 deg; Frequency = 60 Hz
 74.006  TARGET       -m
 74.007  MEMI         Enter UUT reading in degrees.
 74.008  MEMCX        46deg          2U

 75.001  JMPL         END_WATTS

 75.002  LABEL        PHASE
 75.003  ASK+                        P
 75.004  PIC          40_harm
 75.005  DISP         Phase readout is in the upper right side
 75.005  DISP         of the UUT display.
 75.006  JMPL         PHASE_5V_30A

 75.007  LABEL        END_WATTS
 75.008  HEAD         -2
 75.009  5502A        Standby
 75.010  HEAD
 75.011  END

 75.012  EVAL   Increment Test Number

# =====  Sub Fluke 39,41B (1 yr) Record Mode VER /5502A  =====================

 76.001  LABEL        RECORD_MODE
 76.002  RSLT         =
 76.003  HEAD         {RECORD MODE}
 76.004  MATH         @AuxVoltage = 1.3; @PhaseDeg = 46
 76.005  MATH         @NormalVoltage = 100; @Frequency = 60
 76.006  CALL         Sub Fluke 55xxA Calculate Sine AC Power Acc (AUX volts)
 76.007  PIC          40_text

 76.008  JMPL         RECORD_MODE_TESTS

# Establish target for post test Repeat and Cancel options.
 76.009  LABEL        REPEAT_RECORD_MODE_TESTS
 76.010  TARGET       -p
 76.011  DISP         Press the RECORD button to exit record mode.
 76.011  DISP
 76.011  DISP         Press the HOLD/ENTER button to enable free-run.
 76.011  DISP
 76.011  DISP         Press and hold the RANGE button for about 1 s to select
 76.011  DISP         autorange.

 76.012  LABEL        RECORD_MODE_TESTS
 76.013  5502A        AuxVoltage = 1.3 V; Phase = 46 deg
 76.013  5502A        +NormalVoltage = 100 V; Frequency = 60 Hz
 76.014  DISP         Press and release the RECORD button.
 76.014  DISP
 76.014  DISP         Press and release the HOLD button.
 76.015  5502A        Standby
 76.016  DISP         Press the left arrow key to select the MIN screen.
 76.017  ACC          91kW           M1%
 76.018  TARGET       -m
 76.019  MEMI         Enter UUT reading in kilowatts.
 76.020  MEMCX        91kW           1% 4U         60Hz
 77.001  JMPL         RECORD_MODE_MIN_VA

# If operator selects Repeat or Cancel, we obtain a new recording.
 77.002  TARGET       -p
 77.003  JMPL         REPEAT_RECORD_MODE_TESTS

 77.004  LABEL        RECORD_MODE_MIN_VA
 77.005  RSLT         =
 77.006  RSLT         =MIN
 77.007  ACC          130kVA         M1%
 77.008  TARGET       -m
 77.009  MEMI         Enter UUT reading in kilovolt-amps.
 77.010  MEMCX        130kVA         1% 4U         60Hz
 78.001  JMPL         RECORD_MODE_AVG_W

 78.002  TARGET       -p
 78.003  JMPL         REPEAT_RECORD_MODE_TESTS

 78.004  LABEL        RECORD_MODE_AVG_W
 78.005  RSLT         =
 78.006  RSLT         =AVG
 78.007  DISP         Press the left arrow key to select the AVG screen.
 78.008  ACC          91kW           M1%
 78.009  TARGET       -m
 78.010  MEMI         Enter UUT reading in kilowatts.
 78.011  MEMCX        91kW           1% 4U         60Hz
 79.001  JMPL         RECORD_MODE_AVG_VA

 79.002  TARGET       -p
 79.003  JMPL         REPEAT_RECORD_MODE_TESTS

 79.004  LABEL        RECORD_MODE_AVG_VA
 79.005  ACC          130kVA         M1%
 79.006  TARGET       -m
 79.007  MEMI         Enter UUT reading in kilovolt-amps.
 79.008  MEMCX        130kVA         1% 4U         60Hz
 80.001  JMPL         RECORD_MODE_MAX_W

 80.002  TARGET       -p
 80.003  JMPL         REPEAT_RECORD_MODE_TESTS

 80.004  LABEL        RECORD_MODE_MAX_W
 80.005  RSLT         =
 80.006  RSLT         =MAX
 80.007  DISP         Press the left arrow key to select the MAX screen.
 80.008  ACC          91kW           M1%
 80.009  TARGET       -m
 80.010  MEMI         Enter UUT reading in kilowatts.
 80.011  MEMCX        91kW           1% 4U         60Hz
 81.001  JMPL         RECORD_MODE_MAX_VA

 81.002  TARGET       -p
 81.003  JMPL         REPEAT_RECORD_MODE_TESTS

 81.004  LABEL        RECORD_MODE_MAX_VA
 81.005  ACC          130kVA         M1%
 81.006  TARGET       -m
 81.007  MEMI         Enter UUT reading in kilovolt-amps.
 81.008  MEMCX        130kVA         1% 4U         60Hz

 82.001  HEAD         -2
 82.002  5502A        Standby
 82.003  HEAD
 82.004  DISP         Press the RECORD button to exit record mode.
 82.004  DISP
 82.004  DISP         Press the HOLD/ENTER button to enable free-run.
 82.004  DISP
 82.004  DISP         Press and hold the RANGE button for about 1 s to select
 82.004  DISP         autorange.
 82.005  END
