﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 55xxA Calculate Sine AC Power Acc (AUX volts)
DATE:                  2016-02-25 11:34:25
AUTHOR:                Fluke
REVISION:              $Revision: 2619 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       139
=============================================================================
#
#  Procedure Author:
#        DAC, VY
#
#  Model(s) Covered:
#        5502A, 5520A, 5522A
#
#  Source:
#        5520A Multi-Product Calibrator
#        Operators Manual
#        PN 688739, August 1998 Rev.6, 1/03
#        1-26. Calculating Power Uncertainty
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
#  The procedure applys to the situation of power uncertainty calculation
#  that using Fluke 55xxA Normal terminl voltage output as voltage input,
#  Aux terminal voltage output as current simulation.
#
#  Set in calling procedure
#    @NormalVoltage  55xxA NORMAL terminal voltage amplitude in volts
#    @AuxVoltage     55xxA AUX terminal voltage channel amplitude in volts
#    @Frequency      Frequency in hertz
#    @PhaseDeg       Phase in degrees
#    @PowerUnits     W, VA, or VAR
#
# Set in subprocedure:
#   M[1]         Computed accuracy in percent
#
# Examples:
#
#  1.001  MATH         @PowerUnits = "W"
#  1.002  MATH         @NormalVoltage = 10; @AuxVoltage = 100E-3
#  1.003  MATH         @PhaseDeg = 0; @Frequency = 60
#
#  1.004  5502A        AuxVoltage = 100 mV; Phase = 0 deg
#  1.004  5502A        +NormVoltage = 10 V; Frequency = 60 Hz
#  1.005  CALL         Sub Fluke 55xxA Calculate Sine AC Power Acc (AUX volts)
#  1.006  ACC          2000W          M1%
#  1.007  MEMI         Enter UUT reading in watts:
#  1.008  MEMCX  4000  2000W          80U
#
#  2.001  M5520        100mV          0deg                         SI AX
#  2.002  5520         10V                          60H            SI    S  2W
#  2.003  CALL         Sub Fluke 55xxA Calculate Sine AC Power Acc (AUX volts)
#  2.004  ACC          2000W          M1%
#  2.005  MEMI         Enter UUT reading in watts:
#  2.006  MEMCX  4000  2000W          80U
#
#  3.001  5522A        AuxVoltage = 100 mV; Phase = 0 deg
#  3.001  5522A        +NormVoltage = 10 V; Frequency = 60 Hz
#  3.002  CALL         Sub Fluke 55xxA Calculate Sine AC Power Acc (AUX volts)
#  3.003  ACC          2000W          M1%
#  3.004  MEMI         Enter UUT reading in watts:
#  3.005  MEMCX  4000  2000W          80U
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           NOT(ISVAR("@CalDev"))
  1.002  HEAD         -2 ERROR
  1.003  DISP         @CalDev must be set the the calibrator Instrument Name
  1.003  DISP         prior to calling this subprocedure:
  1.003  DISP
  1.003  DISP         Sub Fluke 55xxA Calculate Sine AC Power Acc (AUX volts)
  1.003  DISP
  1.003  DISP         Example:  MATH @CalDev = "Fluke 5502A"
  1.004  END
  1.005  ENDIF

# Get voltage and current channel accuracy.
  1.006  MATH         Freq = @Frequency
  1.007  MATH         L[1] = ACCV2(@CalDev, "Volts SI", @NormalVoltage, Freq)
  1.008  MATH         L[2] = ACCV2(@CalDev, "Volts SI AX", @AuxVoltage, Freq)

# Convert voltage, current (Aux voltage), and phase accuracy to percent.
  1.009  MATH         L[1] = (L[1] / @NormalVoltage) * 100
  1.010  MATH         L[2] = (L[2] / @AuxVoltage) * 100

  1.011  IF           ZCMPI(@PowerUnits, "VA")
# Compute RSS of voltage and current accuracy in percent.
  1.012  MATH         M[1] = RSS2(L[1], L[2])
  1.013  ELSE

# Compute voltage and current channel phase accuracies in radians.
  1.014  MATH         @PhaseDeg = ABS(@PhaseDeg)

  1.015  MATH         L[5] = ACCV2(@CalDev, "Degrees", @PhaseDeg, @Frequency)
  1.016  MATH         L[5] = RAD(L[5])

# Because here the current input is simulated via 55xxA Aux voltage output,
# so the actual current flow direction is reversed from the simulated current
# direction. therefore, if it is required the refrence phase of current to
# voltage is 0 degree, then the phase of 55xxA Aux to Normal should be 180
# degree.
  1.017  MATH         @PhaseDeg = 180 - @PhaseDeg
  1.018  MATH         L[4] = RAD(@PhaseDeg)

# Compute power uncertainty adder due to phase error in percent.
  1.019  IF           ZCMPI(@PowerUnits, "W") && @PhaseDeg
  1.020  MATH         L[3] = (1 - COS(L[4] + L[5]) / COS(L[4])) * 100
  1.021  ELSEIF       ZCMPI(@PowerUnits, "VAR") && @PhaseDeg
  1.022  MATH         L[3] = (1 - SIN(L[4] + L[5]) / SIN(L[4])) * 100
  1.023  ELSEIF       NOT(@PhaseDeg)
  1.024  MATH         L[3] = 0
  1.025  ELSE
  1.026  HEAD         -2 ERROR
  1.027  DISP         @PowerUnits must be "W", "VA", or "VAR".
  1.028  END
  1.029  ENDIF

# Compute RSS of Normal voltage, Aux voltage, and phase accuracy in percent.
  1.030  MATH         M[1] = RSS3(L[1], L[2], L[3]) / CONF(@CalDev) * 2
  1.031  ENDIF

  1.032  END
