﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Tek RSA3408B (1 yr) Third Order VER /9640,SWPG
DATE:                  2016-06-28 14:30:20
AUTHOR:                Fluke
REVISION:              $Revision: 16429 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       4
NUMBER OF LINES:       150
CONFIGURATION:         Fluke 9640A
CONFIGURATION:         Fluke 9640A-50
CONFIGURATION:         Sweep Generator
=============================================================================
#
# Procedure Author:
#        DFM
#
# Additional Equipment Required:
#        Power Splitter, 500 MHz to 2 GHz, Isolation >18 dB, Insertion loss:
#          loss: <1 dB, Tracking: ±0.15 dB
#
# In the following tests, multiple sweeps are averaged by the UUT. Thus, no
# readings are thrown away (NTHROW = 0).
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  IEEE         [@SWPG]
  1.003  ENDIF

  1.004  CALL         Sub Reset /SWPG

  1.005  RSLT         =
  1.006  HEAD         {3rd ORDER INTERMODULATION DISTORTION TEST}
  1.007  RSLT         =(2 GHz Frequency, +5 dBm Ref Level)
  1.008  HEAD         -2 RF Attenuation: 10 dB
  1.009  TARGET       -p
  1.010  TSET         TDESC = 10 dB RF Attenuation; NTHROW = 0
  1.011  PIC          9640a_swpg_to_rsa_input.jpg
  1.012  SCPI         FREQ:CENTER 2E+9;SPAN 1E+6;:INP:MLEV 5
  1.013  SCPI         INP:ATT:AUTO OFF;:SPEC:BAND:AUTO OFF;:SPEC:BAND:RES 2E+3
  1.014  SCPI         SPEC:AVER:COUN 50;STAT ON
  1.015  SCPI         INIT:CONT OFF
  1.016  MATH         @SWPG_Freq = "2000.15MHz"; @SWPG_Ampl = "0dBm"
  1.017  CALL         Sub Apply /SWPG
  1.018  MATH         @RefLvl = -10; @TestLvl = 0; @Gap = 0.05
  1.019  CALL         Sub Tek RSA Set Reference Level (dBm) /SWPG
  1.020  CALL         Sub Tek RSA Take Sweep (MKPK)
  1.021  SCPI         CALC:MARK:Y?[I]
  1.022  MATH         @CarrierRefLvl = MEM
  1.023  CALL         Sub Output Off /SWPG
  1.024  9640         +Level = 0 dBm; Freq = 1999.85 MHz; OutputImp = 50 Ohms
  1.025  MATH         @CenterFreq = 1999.85E+6
  1.026  CALL         Sub Tek RSA Set Reference Level (dBm) /9640
  1.027  HEAD         -2 10 dB RF Attenuation
  1.028  CALL         Sub Apply /SWPG
  1.029  SCPI         INP:ATT 10
  1.030  TARGET       -m
  1.031  CALL         Sub Tek RSA Take Sweep Only
  1.032  SCPI         CALC:MARK:MODE POS;X 1.99955E+9
  1.033  SCPI         CALC:MARK:Y?[I]
  1.034  MATH         LowDistAmpl = MEM
  1.035  SCPI         CALC:MARK:X 2.00045E+9
  1.036  SCPI         CALC:MARK:Y?[I]
  1.037  MATH         HighDistAmpl = MEM

# Select worst-case results from displayed upper and lower sidebands.
  1.038  IF           LowDistAmpl > HighDistAmpl
  1.039  MATH         WorstDist = LowDistAmpl
  1.040  ELSE
  1.041  MATH         WorstDist = HighDistAmpl
  1.042  ENDIF

  1.043  HEAD         -2
  1.044  MATH         MEM = WorstDist
# Uncertainty in ACC FSC taken from manufacturer's manual...
  1.045  ACC          dBc            0.2U
  1.046  MEMCX        -78.0dBc       -17.0U

  2.001  HEAD         -2 RF Attenuation: 15 dB
  2.002  TSET         TDESC = 15 dB RF Attenuation; NTHROW = 0
  2.003  SCPI         INP:ATT 15
  2.004  9640         OutputImpedance = 50 Ohms
  2.004  9640         +Level = [V @TestLvl] dBm; Freq = 1999.85 MHz
  2.005  CALL         Sub Apply /SWPG
  2.006  TARGET       -m
  2.007  CALL         Sub Tek RSA Take Sweep Only
  2.008  SCPI         CALC:MARK:MODE POS;X 1.99955E+9
  2.009  SCPI         CALC:MARK:Y?[I]
  2.010  MATH         LowDistAmpl = MEM
  2.011  SCPI         CALC:MARK:X 2.00045E+9
  2.012  SCPI         CALC:MARK:Y?[I]
  2.013  MATH         HighDistAmpl = MEM

  2.014  IF           LowDistAmpl > HighDistAmpl
  2.015  MATH         WorstDist = LowDistAmpl
  2.016  ELSE
  2.017  MATH         WorstDist = HighDistAmpl
  2.018  ENDIF

  2.019  HEAD         -2
  2.020  MATH         MEM = WorstDist
  2.021  ACC          dBc            0.2U
  2.022  MEMCX        -78.0dBc       -17.0U

  3.001  HEAD         -2 RF Attenuation: 20 dB
  3.002  TSET         TDESC = 20 dB RF Attenuation; NTHROW = 0
  3.003  SCPI         INP:ATT 20
  3.004  9640         OutputImpedance = 50 Ohms
  3.004  9640         +Level = [V @TestLvl] dBm; Freq = 1999.85 MHz
  3.005  CALL         Sub Apply /SWPG
  3.006  TARGET       -m
  3.007  CALL         Sub Tek RSA Take Sweep Only
  3.008  SCPI         CALC:MARK:MODE POS;X 1.99955E+9
  3.009  SCPI         CALC:MARK:Y?[I]
  3.010  MATH         LowDistAmpl = MEM
  3.011  SCPI         CALC:MARK:X 2.00045E+9
  3.012  SCPI         CALC:MARK:Y?[I]
  3.013  MATH         HighDistAmpl = MEM

  3.014  IF           LowDistAmpl > HighDistAmpl
  3.015  MATH         WorstDist = LowDistAmpl
  3.016  ELSE
  3.017  MATH         WorstDist = HighDistAmpl
  3.018  ENDIF

  3.019  HEAD         -2
  3.020  MATH         MEM = WorstDist
  3.021  ACC          dBc            0.2U
  3.022  MEMCX        -78.0dBc       -17.0U

  4.001  HEAD         -2
  4.002  HEAD
  4.003  9640         Reset
  4.004  CALL         Sub Reset /SWPG
  4.005  SCPI         *RST
  4.006  END
