﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Tek RSA3408B (1 yr) Frequency Readout VER /SWPG,X
INSTRUMENT:            Sub Tek RSA3408B (1 yr) Spurious Response VER /SWPG
DATE:                  2016-06-28 14:31:27
AUTHOR:                Fluke
REVISION:              $Revision: 16429 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       10
NUMBER OF LINES:       196
CONFIGURATION:         Sweep Generator
=============================================================================
#
# Procedure Author:
#        DFM
#
# Additional Equipment Required:
#        Frequency Standard (Frequency Readout test only)
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  IEEE         [@SWPG]
  1.003  ENDIF

  1.004  CALL         Sub Reset /SWPG

  1.005  JMPL         FREQUENCY_READOUT            PSUBI("Readout")
  1.006  JMPL         SPURIOUS                     PSUBI("Spurious")
  1.007  DISP         Subprocedure Not Found!
  1.008  END

  1.009  EVAL   Increment Test Number

# ====== Sub Tek RSA3408B (1 yr) Frequency Readout VER /SWPG,X =============

  2.001  LABEL        FREQUENCY_READOUT

  2.002  RSLT         =
  2.003  HEAD         {FREQUENCY READOUT TEST}
  2.004  HEAD         -2 Baseband: 10 MHz
  2.005  TARGET       -p
  2.006  TSET         TDESC = 10 MHz
  2.007  PIC          swpg_to_rsa_input.jpg
  2.008  MATH         @SWPG_Freq = "10MHz"; @SWPG_Ampl = "-10dBm"
  2.009  MATH         @SWPG_ROSC = "Ext"
  2.010  CALL         Sub Apply /SWPG
  2.011  SCPI         FREQ:CENTER 10E+6;SPAN 1E+6;:INIT:CONT OFF
  2.012  TARGET       -m
  2.013  CALL         Sub Tek RSA Take Sweep (MKPK)
  2.014  SCPI         CALC:MARK:X?[I]
# Retrieve accuracy for external frequency reference.
  2.015  MATH         L[1] = (ACCV(@FreqRef, "Timebase", MEM)) / 1E+6
  2.016  MATH         MEM = MEM / 1E+6
  2.017  ACC          MHz            L1U
# Baseband Specification = ±(RefError * MarkerFreq + 0.001 * Span + 0.2) Hz
# 0.2 Hz floor represents the UUT residual FM.
  2.018  TOL          0.2P% 1E-3U 2E-7U
  2.019  MEMCX        10.0000000MHz  TOL

  3.001  HEAD         -2 RF1 band: 2 GHz
  3.002  TSET         TDESC = 2 GHz
  3.003  MATH         @SWPG_Freq = "2GHz"
  3.004  CALL         Sub Apply /SWPG
  3.005  SCPI         FREQ:CENTER 2E+9
  3.006  TARGET       -m
  3.007  CALL         Sub Tek RSA Take Sweep (MKPK)
  3.008  SCPI         CALC:MARK:X?[I]
  3.009  MATH         L[1] = (ACCV(@FreqRef, "Timebase", MEM)) / 1E+9
  3.010  MATH         MEM = MEM / 1E+9
  3.011  ACC          GHz            L1U
# RF1-3 Specifications = ±(RefError * MarkerFreq + 0.001 * Span + 2) Hz
# 2 Hz floor represents the UUT residual FM.
  3.012  TOL          0.2P% 1E-6U 2E-9U
  3.013  MEMCX        2.000000000GHz TOL

  4.001  HEAD         -2 RF2 band: 5 GHz
  4.002  TSET         TDESC = 5 GHz
  4.003  MATH         @SWPG_Freq = "5GHz"
  4.004  CALL         Sub Apply /SWPG
  4.005  SCPI         FREQ:CENTER 5E+9
  4.006  TARGET       -m
  4.007  CALL         Sub Tek RSA Take Sweep (MKPK)
  4.008  SCPI         CALC:MARK:X?[I]
  4.009  MATH         L[1] = (ACCV(@FreqRef, "Timebase", MEM)) / 1E+9
  4.010  MATH         MEM = MEM / 1E+9
  4.011  ACC          GHz            L1U
  4.012  MEMCX        5.000000000GHz TOL

  5.001  HEAD         -2 RF3 band: 7 GHz
  5.002  TSET         TDESC = 7 GHz
  5.003  MATH         @SWPG_Freq = "7GHz"
  5.004  CALL         Sub Apply /SWPG
  5.005  SCPI         FREQ:CENTER 7E+9
  5.006  TARGET       -m
  5.007  CALL         Sub Tek RSA Take Sweep (MKPK)
  5.008  SCPI         CALC:MARK:X?[I]
  5.009  MATH         L[1] = (ACCV(@FreqRef, "Timebase", MEM)) / 1E+9
  5.010  MATH         MEM = MEM / 1E+9
  5.011  ACC          GHz            L1U
  5.012  MEMCX        7.000000000GHz TOL

  6.001  HEAD         -2
  6.002  HEAD
  6.003  MATH         @SWPG_ROSC = "Int"
  6.004  CALL         Sub Apply /SWPG

  6.005  DISP         Disconnect the [V @FreqRef] 10 MHz OUT from the
  6.005  DISP         [V @SWPG_DevName] [V @SWPG_RefIn].
  6.005  DISP
  6.005  DISP         (The [V @SWPG_DevName] [V @SWPG_Output] remains
  6.005  DISP         connected to the UUT INPUT 50 Ohms at this time.)

  6.006  CALL         Sub Reset /SWPG
  6.007  SCPI         *RST
  6.008  END

  6.009  EVAL   Increment Test Number

# ====== Sub Tek RSA3408B (1 yr) Spurious Response VER /SWPG ===============

  7.001  LABEL        SPURIOUS

  7.002  HEAD         SPURIOUS RESPONSE TEST
  7.003  HEAD         -2 RF1 band: 2 GHz

  7.004  DISP         Ensure the [V @FreqRef] 10 MHz OUT is disconnected
  7.004  DISP         from the [V @SWPG_DevName] [V @SWPG_RefIn].

  7.005  TSET         TDESC = RF1 Band
  7.006  SCPI         FREQ:CENTER 2E+9;SPAN 10E+6
  7.007  SCPI         SPEC:BAND:AUTO OFF;RES 50E+3
  7.008  SCPI         SPEC:AVER:COUN 50;STAT ON;:INIT:CONT OFF
  7.009  MATH         @SWPG_Freq = "2GHz"; @SWPG_Ampl = "-5dBm"
  7.010  CALL         Sub Apply /SWPG
  7.011  TARGET       -m
  7.012  SCPI         CALC:MARK:AOFF
  7.013  CALL         Sub Tek RSA Take Sweep (MKPK)
  7.014  SCPI         CALC:MARK:Y?[I]
  7.015  MATH         RefLvl = MEM
  7.016  SCPI         CALC:MARK:PEAK:LOW
  7.017  SCPI         CALC:MARK:Y?[I]
  7.018  MATH         MEM = MEM - RefLvl
  7.019  ACC          dBc            0.2U                                  +DW
  7.020  MEMCX        -73.0dBc       -27.0U

  8.001  HEAD         -2 RF2 band: 5 GHz
  8.002  TSET         TDESC = RF2 Band
  8.003  SCPI         FREQ:CENTER 5E+9
  8.004  MATH         @SWPG_Freq = "5GHz"
  8.005  CALL         Sub Apply /SWPG
  8.006  TARGET       -m
  8.007  SCPI         CALC:MARK:AOFF
  8.008  CALL         Sub Tek RSA Take Sweep (MKPK)
  8.009  SCPI         CALC:MARK:Y?[I]
  8.010  MATH         RefLvl = MEM
  8.011  SCPI         CALC:MARK:PEAK:LOW
  8.012  SCPI         CALC:MARK:Y?[I]
  8.013  MATH         MEM = MEM - RefLvl
  8.014  ACC          dBc            0.2U                                  +DW
  8.015  MEMCX        -70.0dBc       -30.0U

  9.001  HEAD         -2 RF3 band: 7 GHz
  9.002  TSET         TDESC = RF3 Band
  9.003  SCPI         FREQ:CENTER 7E+9
  9.004  MATH         @SWPG_Freq = "7GHz"
  9.005  CALL         Sub Apply /SWPG
  9.006  TARGET       -m
  9.007  SCPI         CALC:MARK:AOFF
  9.008  CALL         Sub Tek RSA Take Sweep (MKPK)
  9.009  SCPI         CALC:MARK:Y?[I]
  9.010  MATH         RefLvl = MEM
  9.011  SCPI         CALC:MARK:PEAK:LOW
  9.012  SCPI         CALC:MARK:Y?[I]
  9.013  MATH         MEM = MEM - RefLvl
  9.014  ACC          dBc            0.2U                                  +DW
  9.015  MEMCX        -70.0dBc       -30.0U

 10.001  HEAD         -2
 10.002  HEAD
 10.003  CALL         Sub Reset /SWPG
 10.004  SCPI         *RST
 10.005  END
