﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Tek RSA3408B (1 yr) Absolute Amplitude VER /9640
INSTRUMENT:            Sub Tek RSA3408B (1 yr) Input Attenuator VER /9640
INSTRUMENT:            Sub Tek RSA3408B (1 yr) Level Linearity VER /9640
INSTRUMENT:            Sub Tek RSA3408B (1 yr) Spurious Response VER /9640
DATE:                  2016-06-28 14:32:53
AUTHOR:                Fluke
REVISION:              $Revision: 16429 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       24
NUMBER OF LINES:       364
CONFIGURATION:         Fluke 9640A
CONFIGURATION:         Fluke 9640A-50
=============================================================================
#
# Procedure Author:
#        DFM
#
# Additional Equipment Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         ABSOLUTE_AMPLITUDE           PSUBI("Absolute")
  1.002  JMPL         INPUT_ATTENUATOR             PSUBI("Attenuator")
  1.003  JMPL         LEVEL_LINEARITY              PSUBI("Linearity")
  1.004  JMPL         SPURIOUS                     PSUBI("Spurious")
  1.005  DISP         Subprocedure Not Found!
  1.006  END

  1.007  EVAL   Increment Test Number

# ====== Sub Tek RSA3408B (1 yr) Absolute Amplitude VER /9640 ==============

  2.001  LABEL        ABSOLUTE_AMPLITUDE

  2.002  RSLT         =
  2.003  HEAD         {ABSOLUTE AMPLITUDE ACCURACY TEST}
  2.004  TARGET       -p
  2.005  HEAD         -2 Baseband Test: 25 MHz
  2.006  TSET         TDESC = 25 MHz
  2.007  9640         +Level = -10 dBm; Freq = 25 MHz; OutputImp = 50 Ohms
  2.008  SCPI         FREQ:CENTER 25E+6;SPAN 10E+6;:INIT:CONT OFF
  2.009  SCPI         CAL:RF?[I!]
  2.010  SCPI         INP:ALEV
  2.011  TARGET       -m
  2.012  CALL         Sub Tek RSA Take Sweep (MKPK)
  2.013  SCPI         CALC:MARK:Y?[I]
  2.014  MEMCX        -10.00dBm      0.30U

  3.001  HEAD         -2 RF Test: 100 MHz
  3.002  TSET         TDESC = 100 MHz
  3.003  9640         +Level = -20 dBm; Freq = 100 MHz; OutputImp = 50 Ohms
  3.004  SCPI         FREQ:CENTER 100E+6;:INP:ATT:AUTO OFF;:INP:ATT 0
  3.005  SCPI         CAL:RF?[I!]
  3.005  SCPI         INP:ALEV
  3.006  TARGET       -m
  3.007  CALL         Sub Tek RSA Take Sweep (MKPK)
  3.008  SCPI         CALC:MARK:Y?[I]
  3.009  MEMCX        -20.00dBm      0.50U

  4.001  HEAD         -2
  4.002  HEAD
  4.003  9640         Reset
  4.004  SCPI         *RST
  4.005  END

  4.006  EVAL   Increment Test Number

# ====== Sub Tek RSA3408B (1 yr) Input Attenuator VER /9640 ================

  5.001  LABEL        INPUT_ATTENUATOR

  5.002  RSLT         =
  5.003  HEAD         {INPUT ATTENUATOR SETTING UNCERTAINTY TEST}
  5.004  TARGET       -p
  5.005  HEAD         -2 Reference: 0 dB
  5.006  9640         +Level = -25 dBm; Freq = 100 MHz; OutputImp = 50 Ohms
  5.007  MATH         Model = "Fluke 9640A"; Mode = "Atten dB 50 Abs"
  5.008  MATH         RefUnc = ACCV2(Model, Mode, -25, 100E+6)
  5.009  SCPI         FREQ:CENTER 100E+6;SPAN 10E+6;:INP:MLEV -20
  5.010  SCPI         INP:ATT:AUTO OFF;:INP:ATT 0;:INIT:CONT OFF
# Because the 9640A output remains constant through 30 dB attenuation, the
# UUT measuring the same level throughout, the source of uncertainty is the
# floor (repeatability of the UUT. Since the floor is not explicitly stated,
# ±1 LSD is used.
  5.011  ACC          0.00dB         0.01U                                 +DW
  5.012  TARGET       -m
  5.013  CALL         Sub Tek RSA Take Sweep (MKPK)
  5.014  SCPI         CALC:MARK:Y?[I]
  5.015  MATH         RefLvl = MEM

  5.016  HEAD         -2 Attenuation: 5 dB
  5.017  TSET         TDESC = 5 dB
  5.018  SCPI         INP:ATT 5
  5.019  CALL         Sub Tek RSA Take Sweep (MKPK)
  5.020  SCPI         CALC:MARK:Y?[I]
  5.021  MATH         MEM = MEM - RefLvl
  5.022  MEMCX        0.00dB         0.20U

  6.001  HEAD         -2 Attenuation: 10 dB
  6.002  TSET         TDESC = 10 dB
  6.003  SCPI         INP:ATT 10
  6.004  9640         +Level = -25 dBm; Freq = 100 MHz; OutputImp = 50 Ohms
  6.005  ACC          0.00dB         0.01U                                 +DW
  6.006  TARGET       -m
  6.007  CALL         Sub Tek RSA Take Sweep (MKPK)
  6.008  SCPI         CALC:MARK:Y?[I]
  6.009  MATH         MEM = MEM - RefLvl
  6.010  MEMCX        0.00dB         0.20U

  7.001  HEAD         -2 Attenuation: 15 dB
  7.002  TSET         TDESC = 15 dB
  7.003  SCPI         INP:ATT 15
  7.004  9640         +Level = -25 dBm; Freq = 100 MHz; OutputImp = 50 Ohms
  7.005  ACC          0.00dB         0.01U                                 +DW
  7.006  TARGET       -m
  7.007  CALL         Sub Tek RSA Take Sweep (MKPK)
  7.008  SCPI         CALC:MARK:Y?[I]
  7.009  MATH         MEM = MEM - RefLvl
  7.010  MEMCX        0.00dB         0.20U

  8.001  HEAD         -2 Attenuation: 20 dB
  8.002  TSET         TDESC = 20 dB
  8.003  SCPI         INP:ATT 20
  8.004  9640         +Level = -25 dBm; Freq = 100 MHz; OutputImp = 50 Ohms
  8.005  ACC          0.00dB         0.01U                                 +DW
  8.006  TARGET       -m
  8.007  CALL         Sub Tek RSA Take Sweep (MKPK)
  8.008  SCPI         CALC:MARK:Y?[I]
  8.009  MATH         MEM = MEM - RefLvl
  8.010  MEMCX        0.00dB         0.20U

  9.001  HEAD         -2 Attenuation: 25 dB
  9.002  TSET         TDESC = 25 dB
  9.003  SCPI         INP:ATT 25
  9.004  9640         +Level = -25 dBm; Freq = 100 MHz; OutputImp = 50 Ohms
  9.005  ACC          0.00dB         0.01U                                 +DW
  9.006  TARGET       -m
  9.007  CALL         Sub Tek RSA Take Sweep (MKPK)
  9.008  SCPI         CALC:MARK:Y?[I]
  9.009  MATH         MEM = MEM - RefLvl
  9.010  MEMCX        0.00dB         0.20U

 10.001  HEAD         -2 Attenuation: 30 dB
 10.002  TSET         TDESC = 30 dB
 10.003  SCPI         INP:ATT 30
 10.004  9640         +Level = -25 dBm; Freq = 100 MHz; OutputImp = 50 Ohms
 10.005  ACC          0.00dB         0.01U                                 +DW
 10.006  TARGET       -m
 10.007  CALL         Sub Tek RSA Take Sweep (MKPK)
 10.008  SCPI         CALC:MARK:Y?[I]
 10.009  MATH         MEM = MEM - RefLvl
 10.010  MEMCX        0.00dB         0.20U

 11.001  HEAD         -2 Reference: -30 dB
 11.002  TSET         TDESC = 35 dB
 11.003  SCPI         INP:MLEV 0;ATT 30
 11.004  9640         +Level = -5 dBm; Freq = 100 MHz; OutputImp = 50 Ohms
 11.005  MATH         RefUnc2 = ACCV2(Model, Mode, -5, 100E+6)
 11.006  MATH         L[1] = RSS2(RefUnc, RefUnc2)
# The UUT is re-referenced at 30 dB RF attenuation, necessitating an output
# level change in the 9640A. Thus, the attenuation uncertainty of the 9640A
# becomes an additional uncertainty component.
 11.007  ACC          0.00dB         0.01U L1U                             +DW
 11.008  TARGET       -m
 11.009  CALL         Sub Tek RSA Take Sweep (MKPK)
 11.010  SCPI         CALC:MARK:Y?[I]
 11.011  MATH         RefLvl = MEM

 11.012  HEAD         -2 Attenuation: 35 dB
 11.013  SCPI         INP:ATT 35
 11.014  9640         +Level = -5 dBm; Freq = 100 MHz; OutputImp = 50 Ohms
 11.015  ACC          0.00dB         0.01U L1U                             +DW
 11.016  TARGET       -m
 11.017  CALL         Sub Tek RSA Take Sweep (MKPK)
 11.018  SCPI         CALC:MARK:Y?[I]
 11.019  MATH         MEM = MEM - RefLvl
 11.020  MEMCX        0.00dB         0.20U

 12.001  HEAD         -2 Attenuation: 40 dB
 12.002  TSET         TDESC = 40 dB
 12.003  SCPI         INP:ATT 40
 12.004  9640         +Level = -5 dBm; Freq = 100 MHz; OutputImp = 50 Ohms
 12.005  ACC          0.00dB         0.01U L1U                             +DW
 12.006  TARGET       -m
 12.007  CALL         Sub Tek RSA Take Sweep (MKPK)
 12.008  SCPI         CALC:MARK:Y?[I]
 12.009  MATH         MEM = MEM - RefLvl
 12.010  MEMCX        0.00dB         0.20U

 13.001  HEAD         -2 Attenuation: 45 dB
 13.002  TSET         TDESC = 45 dB
 13.003  SCPI         INP:ATT 45
 13.004  9640         +Level = -5 dBm; Freq = 100 MHz; OutputImp = 50 Ohms
 13.005  ACC          0.00dB         0.01U L1U                             +DW
 13.006  TARGET       -m
 13.007  CALL         Sub Tek RSA Take Sweep (MKPK)
 13.008  SCPI         CALC:MARK:Y?[I]
 13.009  MATH         MEM = MEM - RefLvl
 13.010  MEMCX        0.00dB         0.20U

 14.001  HEAD         -2 Attenuation: 50 dB
 14.002  TSET         TDESC = 50 dB
 14.003  SCPI         INP:ATT 50
 14.004  9640         +Level = -5 dBm; Freq = 100 MHz; OutputImp = 50 Ohms
 14.005  ACC          0.00dB         0.01U L1U                             +DW
 14.006  TARGET       -m
 14.007  CALL         Sub Tek RSA Take Sweep (MKPK)
 14.008  SCPI         CALC:MARK:Y?[I]
 14.009  MATH         MEM = MEM - RefLvl
 14.010  MEMCX        0.00dB         0.20U

 15.001  HEAD         -2 Attenuation: 55 dB
 15.002  TSET         TDESC = 55 dB
 15.003  SCPI         INP:ATT 55
 15.004  9640         +Level = -5 dBm; Freq = 100 MHz; OutputImp = 50 Ohms
 15.005  ACC          0.00dB         0.01U L1U                             +DW
 15.006  TARGET       -m
 15.007  CALL         Sub Tek RSA Take Sweep (MKPK)
 15.008  SCPI         CALC:MARK:Y?[I]
 15.009  MATH         MEM = MEM - RefLvl
 15.010  MEMCX        0.00dB         0.20U

 16.001  HEAD         -2
 16.002  HEAD
 16.003  9640         Reset
 16.004  SCPI         *RST
 16.005  END

 16.006  EVAL   Increment Test Number

# ====== Sub Tek RSA3408B (1 yr) Level Linearity VER /9640 =================

 17.001  LABEL        LEVEL_LINEARITY

 17.002  RSLT         =
 17.003  HEAD         {LEVEL LINEARITY TEST (+10 dBm Reference)}
 17.004  TARGET       -p
 17.005  HEAD         -2 Reference: +10 dBm
 17.006  9640         +Level = +10 dBm; Freq = 100 MHz; OutputImp = 50 Ohms
# Specify Instrument Name, Mode String for use in subsequent ACCV2 statements.
 17.007  MATH         Model = "Fluke 9640A"; Mode = "Atten dB 50 Abs"
 17.008  MATH         RefUnc = ACCV2(Model, Mode, MEM1, 100E+6)
 17.009  SCPI         FREQ:CENTER 100E+6;SPAN 5E+6;:INP:MLEV 10
 17.010  SCPI         INP:ATT:AUTO OFF;:INP:ATT 20
 17.011  SCPI         SPEC:AVER:COUN 50;STAT ON;:INIT:CONT OFF
 17.012  TARGET       -m
 17.013  CALL         Sub Tek RSA Take Sweep (MKPK)
 17.014  SCPI         CALC:MARK:Y?[I]
# Compute offset from nominal.
 17.015  MATH         Offset = MEM - 10

 17.016  HEAD         -2 Amplitude: 0 dBm
 17.017  TSET         TDESC = 0 dBm
 17.018  9640         +Level = 0 dBm; Freq = 100 MHz; OutputImp = 50 Ohms
 17.019  MATH         TestUnc = ACCV2(Model, Mode, MEM1, 100E+6)
 17.020  MATH         L[1] = RSS2(RefUnc, TestUnc)
 17.021  ACC          0.00dBm        L1U
 17.022  TARGET       -m
 17.023  CALL         Sub Tek RSA Take Sweep (MKPK)
 17.024  SCPI         CALC:MARK:Y?[I]
 17.025  MATH         MEM = MEM - Offset
 17.026  MEMCX        0.00dBm        0.20U

 18.001  HEAD         -2 Amplitude: -10 dBm
 18.002  TSET         TDESC = -10 dBm
 18.003  9640         +Level = -10 dBm; Freq = 100 MHz; OutputImp = 50 Ohms
 18.004  MATH         TestUnc = ACCV2(Model, Mode, MEM1, 100E+6)
 18.005  MATH         L[1] = RSS2(RefUnc, TestUnc)
 18.006  ACC          -10.00dBm      L1U
 18.007  TARGET       -m
 18.008  CALL         Sub Tek RSA Take Sweep (MKPK)
 18.009  SCPI         CALC:MARK:Y?[I]
 18.010  MATH         MEM = MEM - Offset
 18.011  MEMCX        -10.00dBm      0.20U

 19.001  HEAD         -2 Amplitude: -20 dBm
 19.002  TSET         TDESC = -20 dBm
 19.003  9640         +Level = -20 dBm; Freq = 100 MHz; OutputImp = 50 Ohms
 19.004  MATH         TestUnc = ACCV2(Model, Mode, MEM1, 100E+6)
 19.005  MATH         L[1] = RSS2(RefUnc, TestUnc)
 19.006  ACC          -20.00dBm      L1U
 19.007  TARGET       -m
 19.008  CALL         Sub Tek RSA Take Sweep (MKPK)
 19.009  SCPI         CALC:MARK:Y?[I]
 19.010  MATH         MEM = MEM - Offset
 19.011  MEMCX        -20.00dBm      0.20U

 20.001  HEAD         -2 Amplitude: -30 dBm
 20.002  TSET         TDESC = -30 dBm
 20.003  9640         +Level = -30 dBm; Freq = 100 MHz; OutputImp = 50 Ohms
 20.004  MATH         TestUnc = ACCV2(Model, Mode, MEM1, 100E+6)
 20.005  MATH         L[1] = RSS2(RefUnc, TestUnc)
 20.006  ACC          -30.00dBm      L1U
 20.007  TARGET       -m
 20.008  CALL         Sub Tek RSA Take Sweep (MKPK)
 20.009  SCPI         CALC:MARK:Y?[I]
 20.010  MATH         MEM = MEM - Offset
 20.011  MEMCX        -30.00dBm      0.20U

 21.001  HEAD         -2 Amplitude: -40 dBm
 21.002  TSET         TDESC = -40 dBm
 21.003  9640         +Level = -40 dBm; Freq = 100 MHz; OutputImp = 50 Ohms
 21.004  MATH         TestUnc = ACCV2(Model, Mode, MEM1, 100E+6)
 21.005  MATH         L[1] = RSS2(RefUnc, TestUnc)
 21.006  ACC          -40.00dBm      L1U
 21.007  TARGET       -m
 21.008  CALL         Sub Tek RSA Take Sweep (MKPK)
 21.009  SCPI         CALC:MARK:Y?[I]
 21.010  MATH         MEM = MEM - Offset
 21.011  MEMCX        -40.00dBm      0.20U

 22.001  HEAD         -2
 22.002  HEAD
 22.003  9640         Reset
 22.004  SCPI         *RST
 22.005  END

 22.006  EVAL   Increment Test Number

# ====== Sub Tek RSA3408B (1 yr) Spurious Response VER /9640 ===============

 23.001  LABEL        SPURIOUS

 23.002  RSLT         =
 23.003  HEAD         {SPURIOUS RESPONSE TEST}
 23.004  HEAD         -2 Baseband: 25 MHz
 23.005  TARGET       -p
 23.006  TSET         TDESC = Baseband
 23.007  SCPI         FREQ:CENTER 25E+6;SPAN 10E+6
 23.008  SCPI         SPEC:BAND:AUTO OFF;RES 50E+3
 23.009  SCPI         SPEC:AVER:COUN 50;STAT ON;:INIT:CONT OFF
 23.010  9640         Freq = 25 MHz; +Level = -5 dBm; OutputImp = 50 Ohms
 23.011  TARGET       -m
 23.012  SCPI         CALC:MARK:AOFF
 23.013  CALL         Sub Tek RSA Take Sweep (MKPK)
 23.014  SCPI         CALC:MARK:Y?[I]
 23.015  MATH         RefLvl = MEM
 23.016  SCPI         CALC:MARK:PEAK:LOW
 23.017  SCPI         CALC:MARK:Y?[I]
 23.018  MATH         MEM = MEM - RefLvl
 23.019  ACC          dBc            0.2U                                  +DW
 23.020  MEMCX        -73.0dBc       -27.0U

 24.001  HEAD         -2
 24.002  HEAD
 24.003  9640         Reset
 24.004  SCPI         *RST
 24.005  END
