﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Tek RSA Set Reference Level (dBm) /9640
DATE:                  2016-06-28 14:28:53
AUTHOR:                Fluke
REVISION:              $Revision: 16429 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       65
CONFIGURATION:         Fluke 9640A
CONFIGURATION:         Fluke 9640A-50
=============================================================================
#
# Procedure Author:
#        DFM
#
# Additional Equipment Required:
#        None
#
# The necessary parameters for this procedure are passed from the calling
# procedure.
#
#    @CenterFreq : The 9640A output frequency
#    @RefLvl     : The desired reference level as measured by the UUT.
#    @TestLvl    : The 9640A output level required to generate the specified
#                  reference level.
#    @Gap        : The desired size of the setting aperture.
#
# Example:
# 1.001  MATH         @CenterFreq = 2E+9; @RefLvl = 0; @TestLvl = 0
# 1.002  MATH         @Gap = 0.05
# 1.003  CALL         Sub Tek RSA Set Reference Level (dBm) /9640
#
# Note: The @RefLvl and @TestLvl values MUST be stated in dBm.
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  CALL         Sub Tek RSA Take Sweep (MKPK)
  1.002  SCPI         CALC:MARK:Y?[I]

  1.003  WHILE        (MEM <= (@RefLvl - @Gap)) || (MEM >= (@RefLvl + @Gap))
  1.004  HEAD         -2 Setting [V @RefLvl] dBm Reference Level (9640A)...
  1.005  MATH         Delta = (@RefLvl - MEM)
  1.006  MATH         @TestLvl = @TestLvl + Delta
  1.007  9640         OutputImp = 50 Ohms
  1.007  9640         +Level = [V @TestLvl] dBm; Freq = [V @CenterFreq] Hz
  1.008  CALL         Sub Tek RSA Take Sweep (MKPK)
  1.009  SCPI         CALC:MARK:Y?[I]
  1.010  ENDW

  1.011  HEAD         -2
  1.012  END
