﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Tek RSA Set Reference Level (dBm) /SWPG
DATE:                  2016-06-28 14:29:19
AUTHOR:                Fluke
REVISION:              $Revision: 16429 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       69
CONFIGURATION:         Sweep Generator
=============================================================================
#
# Procedure Author:
#        DFM
#
# Additional Equipment Required:
#        None
#
# The necessary parameters for this procedure are passed from the calling
# procedure.
#
#    @RefLvl     : The desired reference level as measured by the UUT.
#    @TestLvl    : The SWPG output level required to generate the specified
#                  reference level.
#    @Gap        : The desired size of the setting aperture.
#
#                (The SWPG output frequency is previously set in the calling
#                 procedure.)
#
# Example:
# 1.001  MATH         @RefLvl = -10; @TestLvl = -4; @Gap
# 1.002  CALL         Sub Tek RSA Set Reference Level (dBm) /SWPG
#
# Note: The @RefLvl and @TestLvl values MUST be stated in dBm.
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  IEEE         [@SWPG]
  1.003  ENDIF

  1.004  CALL         Sub Tek RSA Take Sweep (MKPK)
  1.005  SCPI         CALC:MARK:Y?[I]

  1.006  WHILE        (MEM <= (@RefLvl - @Gap)) || (MEM >= (@RefLvl + @Gap))
  1.007  HEAD         -2 Setting [V @RefLvl] dBm Reference Level (SWPG)...
  1.008  MATH         Delta = (@RefLvl - MEM)
  1.009  MATH         @TestLvl = @TestLvl + Delta
  1.010  MATH         @SWPG_Ampl = @TestLvl & "dBm"
  1.011  CALL         Sub Apply /SWPG
  1.012  CALL         Sub Tek RSA Take Sweep (MKPK)
  1.013  SCPI         CALC:MARK:Y?[I]
  1.014  ENDW

  1.015  HEAD         -2
  1.016  END
