﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Tek RSA Take Sweep Only
INSTRUMENT:            Sub Tek RSA Take Sweep (MKF)
INSTRUMENT:            Sub Tek RSA Take Sweep (MKCF)
INSTRUMENT:            Sub Tek RSA Take Sweep (MKPK)
INSTRUMENT:            Sub Tek RSA Take Sweep (MKPK, MKCF)
DATE:                  2016-06-28 14:29:57
AUTHOR:                Fluke
REVISION:              $Revision: 16429 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       6
NUMBER OF LINES:       179
=============================================================================
#
#  Procedure Author:
#        DFM
#
#  Additional Equipment Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

# Set number of sweeps.
  1.001  MATH         Sweeps = 2

  1.002  JMPL         SWEEP                        PSUBI("Only")
  1.003  JMPL         MKF                          PSUBI("(MKF)")
  1.004  JMPL         MKCF                         PSUBI("(MKCF)")
  1.005  JMPL         MKPK                         PSUBI("(MKPK)")
  1.006  JMPL         MKPK_MKCF                    PSUBI("(MKPK, MKCF)")
  1.007  DISP         Subprocedure not found!
  1.008  END

  1.009  EVAL   Increment Test Number

# ====== Sub Tek RSA Take Sweep Only =======================================
#
# This sub takes two sweeps and does not alter the marker, center frequency,
# or any other UUT settings.
#
#  Example:
# 1.001  SCPI         INIT:CONT OFF
# 1.002  CALL         Sub Tek RSA Take Sweep

  2.001  LABEL        SWEEP

  2.002  WHILE        Sweeps > 0
  2.003  SCPI         [T60000]INIT:IMM
# Decrement sweep counter by one.
  2.004  MATH         Sweeps = Sweeps - 1
  2.005  ENDW

  2.006  END

  2.007  EVAL   Increment Test Number

# ====== Sub Tek RSA Take Sweep (MKF) ======================================
#
# This sub takes two sweeps, placing the active marker at a frequency passed
# by the calling procedure after the second sweep.
#
#  Example:
# 1.001  SCPI         INIT:CONT OFF
# 1.002  MATH         @MarkerFreq = 1E+6
# 1.003  CALL         Sub Tek RSA Take Sweep (MKF)

  3.001  LABEL        MKF

  3.002  WHILE        Sweeps > 0
  3.003  SCPI         [T60000]INIT:IMM
# Decrement sweep counter by one.
  3.004  MATH         Sweeps = Sweeps - 1
  3.005  ENDW

# Set UUT marker to specified frequency in Hertz.
  3.006  SCPI         CALC:MARK:X [V @MarkerFreq]

  3.007  END

  3.008  EVAL   Increment Test Number

# ====== Sub Tek RSA Take Sweep (MKCF) =====================================
#
# This sub takes two sweeps, placing the active marker at center frequency
# on the display after each sweep. Note that the active marker may be the
# "delta" marker, if previously specified in the calling procedure.
#
#  Example:
# 1.001  SCPI         INIT:CONT OFF
# 1.002  CALL         Sub Tek RSA Take Sweep (MKCF)

  4.001  LABEL        MKCF

  4.002  WHILE        Sweeps > 0
  4.003  SCPI         [T60000]INIT:IMM
# Set UUT marker to (highest) peak.
  4.004  SCPI         CALC:MARK:CENT

# Decrement sweep counter by one.
  4.005  MATH         Sweeps = Sweeps - 1
  4.006  ENDW

  4.007  END

  4.008  EVAL   Increment Test Number

# ====== Sub Tek RSA Take Sweep (MKPK) =====================================
#
# This sub takes two sweeps, placing the active marker at the highest peak
# present on the display after each sweep. Note that the active marker may
# be the "delta" marker, if previously specified in the calling procedure.
#
#  Example:
# 1.001  SCPI         INIT:CONT OFF
# 1.002  CALL         Sub Tek RSA Take Sweep (MKPK)

  5.001  LABEL        MKPK

  5.002  WHILE        Sweeps > 0
  5.003  SCPI         [T60000]INIT:IMM
# Set UUT marker to (highest) peak.
  5.004  SCPI         CALC:MARK:MAX

# Decrement sweep counter by one.
  5.005  MATH         Sweeps = Sweeps - 1
  5.006  ENDW

  5.007  END

  5.008  EVAL   Increment Test Number

# ====== Sub Tek RSA Take Sweep (MKPK, MKCF) ===============================
#
# This sub takes two sweeps, placing the active marker at the highest peak
# present on the display, then moving the marker to the center frequency after
# each sweep. Note that the active marker may be the "delta" marker, if
# specified previously in the calling procedure.
#
#  Example:
# 1.002  SCPI         INIT:CONT OFF
# 1.001  CALL         Sub Tek RSA Take Sweep (MKPK, MKCF)
#
# Note that this sub does NOT turn the UUT signal tracking on; that must be
# done, if desired, explicitly. In that case, it is preferred to accomplish
# the task as follows:
#
# 1.001  IEEE         MKTRACK ON;
# 1.002  CALL         Sub Tek RSA Take Sweep (MKPK)
#
# Turning signal tracking on will automatically place the marker at the UUT
# center frequency, in addition to keeping it there if the UUT local
# oscillator drifts.

  6.001  LABEL        MKPK_MKCF

  6.002  WHILE        Sweeps > 0
  6.003  SCPI         [T60000]INIT:IMM
# Set UUT marker to (highest) peak; move marker to center frequency.
  6.004  SCPI         CALC:MARK:MAX;:CALC:MARK:CENTER

# Decrement sweep counter by one.
  6.005  MATH         Sweeps = Sweeps - 1
  6.006  ENDW

  6.007  END
