﻿Copyright (c) (2014) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Fluke 1654B: (1 year) CAL VER RS-232 /5320+VLC,ResBox
DATE:                  2014-03-24 13:19:19
AUTHOR:                Fluke
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       194
CONFIGURATION:         Fluke 5320A (VLC)
STANDARD:              Decade "R" Box
=============================================================================
#
#  Procedure Author:
#        DAC
#
#  Model Covered:
#        1651B w/Firmware: UI >= V3.14, Analog >= V3.13
#
#  This procedure contains the following tests whose Test Uncertainty Ratio
#  are less than 4:1.
#
#        Insulation
#                     -  18 MΩ,  250 V;    TUR 3.3333
#                     - 180 MΩ,  250 V;    TUR 3.3333
#                     -  18 MΩ,  500 V;    TUR 3.3333
#                     - 180 MΩ,  500 V;    TUR 3.3333
#                     - 180 MΩ, 1000 V;    TUR 2.0833
#        Continuity
#                     -   2 Ω;             TUR 3.7500
#        Loop
#                     -   50 Ω;  Comp;     TUR 3.3333
#                     -  180 Ω;  Comp;     TUR 3.6000
#
#  Source:
#        Fluke 1652C/1653B/1654B
#        Electrical Installation Tester
#        Calibration Manual
#        March 2011
#
#        Manual Supplement
#        Manual Title: 1652C/1653B/1654B Calibration Supplement Issue: 2
#        Part Number:  Web-Only
#        Issue Date:   1/12
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Additional Equipment Required:
#        Decade Resistor Box
#          Resistance: 18, 180, & 1800 Ohms
#          Accuracy:   0.75 % or better
#          Power:      0.5 W minimum
#        Fluke IR Adapter-Serial Cable, Part No. 2043365
#        Fluke-165xB, Zero Adapter, Part No. 3301338
#        Fluke PN 1884378
#
#  The Procedure was tested using:
#
#        Model No.     : 1654B
#        Serial No.    : Pilot Unit
#        Options       : NA
#        Firmware Rev. : V3.13/3.12
#
#  The average run time during testing was 11 minutes.
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Calibration.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  5320         +Voltage = 250.0 V; Freq = 50 Hz
  1.003  STD          Decade "R" Box
  1.004  ENDIF

  1.005  ASK-   R   Q N              P                            F        V

  1.006  IF           NOT(VERSIONCHECK("8.0"))
  1.007  END
  1.008  ENDIF

# ASK- L must be used to avoid RS-232 communication sequencing errors.
  1.009  ASK-                                                        L

  1.010  HEAD         PRELIMINARY INSTRUCTIONS
  1.011  CALL         Sub Display Copyright
  1.012  CALL         Sub High Voltage Safety Warning
  1.013  CALL         Sub Select Failed Test Mode
  1.014  CALL         Sub Select Guardbanding & Ver Method (No NTHROW)

# Limit NMEAS to 1 to prevent overheating 5320A resistors.
  1.015  IF           @NMeas > 1
  1.016  VSET         NMEAS = 1
  1.017  ENDIF

  1.018  HEAD         EQUIPMENT REQUIREMENTS
  1.019  OPBR         -z Do you want to REVIEW the list of additional
  1.019  OPBR         equipment and/or accessories required?

  1.020  IF           MEM1
  1.021  DISP         Additional equipment/accessories required:
  1.021  DISP
  1.021  DISP         - Decade Resistor Box
  1.021  DISP         [32]   Resistance: 18, 180, & 1800 Ohms
  1.021  DISP         [32]   Accuracy:   0.75 % or better
  1.021  DISP         [32]   Power:      0.5 W minimum
  1.021  DISP
  1.021  DISP         - Fluke IR Adapter-Serial Cable, Part No. 2043365
  1.021  DISP
  1.021  DISP         - Fluke-165xB, Zero Adapter, Part No. 3301338
  1.022  ENDIF

  1.023  DISP         Ambient temperature: 18 °C - 28 °C.
  1.023  DISP         Relative humidity: less than 80 %.

  1.024  DISP         Press green button to turn UUT on.

  1.025  TARGET
  1.026  CALL         Sub Fluke 165XB Setup RS-232
  1.027  CALL         Sub Fluke 165xB Get ID RS-232

  1.028  IF           NOT(ZCMP(@ModelNum, "1654B"))
  1.029  DISP         UUT is a [V @ModelNum], not a 1654B!
  1.030  END
  1.031  ENDIF

  1.032  IF           (@UI_Version < 3.14) || (@AnalogVersion < 3.13)
  1.033  DISP         Installed firmware is: [V @FirmwareRev]
  1.033  DISP
  1.033  DISP         This procedure requires V3.14/V3.13 or later.
  1.034  END
  1.035  ENDIF

# Set "Wait for Beep" timeout to 5 s.
  1.036  MATH         @WaitForBeepTimeout = 5000

  1.037  CALL         Sub Fluke 165xB Battery Check RS-232
  1.038  JMPL         ABORT                        @Error
  1.039  DISP         Press green button to turn UUT off.
  1.040  CALL         Sub Fluke 1654B Display Test
  1.041  CALL         Sub Fluke 165xB Backlight Test RS-232
  1.042  JMPL         ABORT                        @Error
  1.043  CALL         Sub Fluke 165xB Input Jack Sense Test RS-232
  1.044  JMPL         ABORT                        @Error
  1.045  CALL         Sub Fluke 165xB Touch Pad Sensing Test RS-232 /5320+VLC
  1.046  JMPL         ABORT                        @Error
  1.047  CALL         Sub Fluke 1653B/54B Memory Test RS-232 /5320+VLC
  1.048  JMPL         ABORT                        @Error

# Note, the complete UUT setup must be sent for each individual test.
# This is because the RESET FSC for the UUT takes the UUT out of local
# lockout and the UUT assumes the function of front panel rotary switch,
# which in most cases is NOT the desired function.

  1.049  CALL         Sub Fluke 165xB (1 yr) Voltage VER RS-232 /5320+VLC
  1.050  JMPL         ABORT                        @Error
  1.051  RSLT         =
  1.052  RSLT         =INSULATION TESTS
  1.053  CALL         Sub Fluke 165xB (1 yr) Ins Button VER RS-232 /5320+VLC
  1.054  JMPL         ABORT                        @Error
  1.055  CALL         Sub Fluke 165xB (1 yr) Insulation VER RS-232 /5320
  1.056  JMPL         ABORT                        @Error
  1.057  DISP         Remove all connections.
  1.058  CALL         Sub Fluke 165xB (1 yr) Continuity VER RS-232 /5320
  1.059  JMPL         ABORT                        @Error
  1.060  CALL         Sub Fluke 165xB (1 yr) Loop VER RS-232 /5320+VLC,ResBox
  1.061  JMPL         ABORT                        @Error
  1.062  CALL         Sub Fluke 165xB (1 yr) Loop Hi Curr VER RS-232/5320+VLC
  1.063  JMPL         ABORT                        @Error
  1.064  CALL         Sub Fluke 165xB (1 yr) RCD VER RS-232 /5320
  1.065  JMPL         ABORT                        @Error
  1.066  CALL         Sub Fluke 1653B (1 yr) Earth VER RS-232 /5320
  1.067  JMPL         ABORT                        @Error
  1.068  JMPL         END

  1.069  LABEL        ABORT
  1.070  RSLT         =
  1.071  HEAD         {V E R I F I C A T I O N   A B O R T E D}

  1.072  LABEL        END
  1.073  MATH         @Command = @FactoryTest
  1.074  CALL         Sub Fluke 165xB Send Command RS-232
  1.075  END
