﻿Copyright (c) (2014) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Fluke 165xB (1 yr) Loop VER RS-232 /5320+VLC,ResBox
DATE:                  2014-03-24 13:09:15
AUTHOR:                Fluke
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       4
NUMBER OF LINES:       178
CONFIGURATION:         Fluke 5320A (VLC)
STANDARD:              Decade "R" Box
=============================================================================
#
#  Procedure Author:
#        DAC
#
#  Model Covered:
#        1651B, 1652B, 1652C, 1653B, & 1654B
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Additional Equipment Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Calibration.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  RSLT         =
  1.002  HEAD         {LOOP TESTS}
  1.003  STD          Decade "R" Box
  1.004  MEMI         Enter Decade "R" Box accuracy (%).
  1.005  MATH         MEM = MEM / 100
  1.006  MATH         ResBoxAcc18_Ohms   = MEM * 18
  1.007  MATH         ResBoxAcc180_Ohms  = MEM * 180
  1.008  MATH         ResBoxAcc1800_Ohms = MEM * 1800
  1.009  DISP         [32]                  Warning
  1.009  DISP         To prevent possible electric shock, fire, or personal
  1.009  DISP         injury, do not touch the L or N input jacks while
  1.009  DISP         performing the following tests.  These input jacks have
  1.009  DISP         line voltage on them during the test.
  1.010  DISP         [32]                  Caution
  1.010  DISP         To prevent Decade Resistor Damage, the following tests
  1.010  DISP         must be performed in the LOOP Zi NO TRIP function only.
  1.010  DISP         Setting the 165XB function switch to LOOP Z HI CURRENT
  1.010  DISP         function will result in damage to the Decade Resistor
  1.010  DISP         Box when "Test" is pressed.

  1.011  RSLT         =
  1.012  HEAD         LOOP TESTS: {L-PE, No Trip}
  1.013  RSLT         =
  1.014  HEAD         -2{20 Ω Range}
  1.015  TARGET       -p
  1.016  MATH         @Command = @FactoryTest
  1.017  CALL         Sub Fluke 165xB Send Command RS-232
  1.018  JMPL         ABORT                        @Error
# Set function before displaying connection picture.
  1.019  MATH         @Command = @SetFunction & " " & @FuncLoopL_PE_NoTrip_PFC
  1.020  CALL         Sub Fluke 165xB Send Command RS-232
  1.021  JMPL         ABORT                        @Error
  1.022  PIC          165x_L_PE_N_165XB-ZeroAdapter
# Resend function command for each iteration of NMEAS loop.  This is necessary
# because the UUT assumes the function of the rotary switch position, when
# each zero operation in the NMEAS loop completes.
  1.023  MATH         @Command = @SetFunction & " " & @FuncLoopL_PE_NoTrip_PFC
  1.024  CALL         Sub Fluke 165xB Send Command RS-232
  1.025  JMPL         ABORT                        @Error
  1.026  MATH         ZeroPressed = 0
# Query beeper to clear register.
  1.027  CALL         Sub Fluke 165xB Query Beeper RS-232

# If no error, press ZERO.
  1.028  IF           NOT(@Error)
  1.029  MATH         @Command = @PressKey & @KeyZero
  1.030  CALL         Sub Fluke 165xB Send Command RS-232
  1.031  MATH         ZeroPressed = NOT(@Error)
  1.032  ENDIF

# If no error, wait for 1st beep.
  1.033  IF           NOT(@Error)
  1.034  CALL         Sub Fluke 165xB Wait for Beep RS-232
  1.035  ENDIF

# If no error, wait for 2nd beep.
  1.036  IF           NOT(@Error)
  1.037  CALL         Sub Fluke 165xB Wait for Beep RS-232
  1.038  ENDIF

# If ZERO was successfully pressed, release it.
  1.039  IF           ZeroPressed
  1.040  MATH         L[1] = @Error; L[2] = @Repeat
  1.041  MATH         @Command = @ReleaseKey & @KeyZero
  1.042  CALL         Sub Fluke 165xB Send Command RS-232
  1.043  ENDIF

  1.044  IF           NOT(@Error)
  1.045  MATH         ZeroPressed = 0
  1.046  MATH         @Error = L[1]; @Repeat = L[2]
  1.047  ENDIF

  1.048  MATH         @Command = @SetFunction & " " & @FuncLoopL_PE_NoTrip_PFC
  1.049  CALL         Sub Fluke 165xB Send Command RS-232
  1.050  JMPL         ABORT                        @Error

  1.051  TSET         CPT = 18.00 Ohms; UUT_RES = 0.01
  1.052  5320         Mode = Loop; SerialRes = 0 Ohm; ResImpCorr = Comp
  1.052  5320         +Res = 0.025 Ohms; Setup
  1.053  PIC          5320_ResBox_165x_LoopNoTrip
  1.054  DISP         Set "Decade R Value" for 18 Ohms.
  1.055  5320         Mode = Loop; SerialRes = 0 Ohm; ResImpCorr = Comp
  1.055  5320         +Res = 0.025 Ohms; Operate
# Calculate total resistance accuracy in percent.
  1.056  MATH         ResAcc = REFACC() + ResBoxAcc18_Ohms
  1.057  MATH         L[1] = ResAcc / (MEM1 + 18) * 100
  1.058  MATH         MEM = MEM1 + 18
  1.059  ACC    18    Z              L1%
  1.060  TARGET       -m
  1.061  WAIT         [D500]
  1.062  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
  1.063  MEMCX  20    Z              3% 0.06U

  2.001  5320         Standby

  2.002  RSLT         =
  2.003  HEAD         -2{200 Ω Range}
  2.004  TARGET       -p
  2.005  TSET         CPT = 180.0 Ohms; UUT_RES = 0.1
  2.006  5320         Mode = Loop; SerialRes = 0 Ohm; ResImpCorr = Comp
  2.006  5320         +Res = 0.025 Ohms; Setup
  2.007  DISP         Set "Decade R Value" for 180 Ohms.
  2.008  5320         Mode = Loop; SerialRes = 0 Ohm; ResImpCorr = Comp
  2.008  5320         +Res = 0.025 Ohms; Operate
  2.009  MATH         ResAcc = REFACC() + ResBoxAcc180_Ohms
  2.010  MATH         L[1] = ResAcc / (MEM1 + 180) * 100
  2.011  MATH         MEM = MEM1 + 180
  2.012  ACC    180   Z              L1%
  2.013  TARGET       -m
  2.014  WAIT         [D500]
  2.015  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
  2.016  MEMCX  200   Z              3%

  3.001  5320         Standby

  3.002  RSLT         =
  3.003  HEAD         -2{2000 Ω Range}
  3.004  TARGET       -p
  3.005  TSET         CPT = 1800 Ohms; UUT_RES = 1
  3.006  5320         Mode = Loop; SerialRes = 0 Ohm; ResImpCorr = Comp
  3.006  5320         +Res = 0.025 Ohms; Setup
  3.007  DISP         Set "Decade R Value" for 1800 Ohms.
  3.008  5320         Mode = Loop; SerialRes = 0 Ohm; ResImpCorr = Comp
  3.008  5320         +Res = 0.025 Ohms; Operate
  3.009  MATH         ResAcc = REFACC() + ResBoxAcc1800_Ohms
  3.010  MATH         L[1] = ResAcc / (MEM1 + 1800) * 100
  3.011  MATH         MEM = MEM1 + 1800
  3.012  ACC    1800  Z              L1%
  3.013  TARGET       -m
  3.014  WAIT         [D500]
  3.015  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
  3.016  MEMCX  2000  Z              3%

  4.001  LABEL        ABORT
  4.002  HEAD
  4.003  HEAD         -2
  4.004  5320         Reset
  4.005  END
