﻿Copyright (c) (2014) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Fluke 165xB (1 yr) Insulation VER RS-232 /5320
INSTRUMENT:            Sub Fluke 165xB (1 yr) Continuity VER RS-232 /5320
INSTRUMENT:            Sub Fluke 165xB (1 yr) RCD VER RS-232 /5320
INSTRUMENT:            Sub Fluke 1653B (1 yr) Earth VER RS-232 /5320
DATE:                  2014-03-24 13:05:48
AUTHOR:                Fluke
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       51
NUMBER OF LINES:       751
CONFIGURATION:         Fluke 5320A
=============================================================================
#
#  Procedure Author:
#        DAC
#
#  Model Covered:
#        1651B, 1652B, 1652C, 1653B, & 1654B
#
#  This procedure contains the following tests whose Test Uncertainty Ratio
#  are less than 4:1.
#
#        Insulation
#                     -  18 Mâ„¦,  250 V;    TUR 3.3333
#                     - 180 Mâ„¦,  250 V;    TUR 3.3333
#                     -  18 Mâ„¦,  500 V;    TUR 3.3333
#                     - 180 Mâ„¦,  500 V;    TUR 3.3333
#                     - 180 Mâ„¦, 1000 V;    TUR 2.0833
#        Continuity
#                     -   2 â„¦;             TUR 3.7500
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Additional Equipment Required:
#        None
#
#  This procedure is intended for use with MET/CALÂ® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Calibration.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         INSULATION_TESTS              PSUBI("Insulation")
  1.002  JMPL         CONTINUITY_TESTS              PSUBI("Continuity")
  1.003  JMPL         RCD_TESTS                     PSUBI("RCD")
  1.004  JMPL         EARTH_TESTS                   PSUBI("Earth")
  1.005  DISP         Subprocedure not found!
  1.006  END

  1.007  EVAL   Increment test number

# =====  Sub Fluke 165xB (1 yr) Insulation VER RS-232 /5320  ================

  2.001  LABEL        INSULATION_TESTS

  2.002  IF           ZCMP(@ModelNum, "1653B") || ZCMP(@ModelNum, "1654B")
  2.003  RSLT         =
  2.004  HEAD         INSULATION TESTS: {50 Volts}
  2.005  RSLT         =
  2.006  HEAD         -2{50 Mâ„¦ Range}
  2.007  TARGET       -p
  2.008  MATH         @Command = @FactoryTest
  2.009  CALL         Sub Fluke 165xB Send Command RS-232
  2.010  JMPL         ABORT                        @Error
  2.011  MATH         @Command = @SetFunction & " " & @FuncInsulation50V
  2.012  CALL         Sub Fluke 165xB Send Command RS-232
  2.013  JMPL         ABORT                        @Error
  2.014  5320         Mode = HR; +Res = 2.50 MOhm; TestVoltage = 50 V
  2.015  TARGET       -m
  2.016  WAIT         [D500]
  2.017  MATH         SafeOn("UUT", "50V", "")
  2.018  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
  2.019  JMPL         ABORT                        @Error
  2.020  MATH         SafeOff("UUT")
  2.021  MEMCX  50    MZ             3% 0.03U

  3.001  5320         Mode = HR; +Res = 45.00 MOhms; TestVoltage = 50 V
  3.002  TARGET       -m
  3.003  WAIT         [D500]
  3.004  MATH         SafeOn("UUT", "50V", "")
  3.005  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
  3.006  JMPL         ABORT                        @Error
  3.007  MATH         SafeOff("UUT")
  3.008  MEMCX  50    MZ             3% 0.03U

  4.001  5320         Standby

  4.002  RSLT         =
  4.003  HEAD         INSULATION TESTS: {100 Volts}
  4.004  RSLT         =
  4.005  HEAD         -2{20 Mâ„¦ Range}
  4.006  TARGET       -p
  4.007  MATH         @Command = @SetFunction & " " & @FuncInsulation100V
  4.008  CALL         Sub Fluke 165xB Send Command RS-232
  4.009  JMPL         ABORT                        @Error
  4.010  5320         Mode = HR; +Res = 0.10 MOhms; TestVoltage = 100 V
  4.011  TARGET       -m
  4.012  WAIT         [D500]
  4.013  MATH         SafeOn("UUT", "100V", "")
  4.014  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
  4.015  JMPL         ABORT                        @Error
  4.016  MATH         SafeOff("UUT")
  4.017  MEMCX  20    MZ             3% 0.03U

  5.001  5320         Mode = HR; +Res = 1.00 MOhms; TestVoltage = 100 V
  5.002  TARGET       -m
  5.003  WAIT         [D500]
  5.004  MATH         SafeOn("UUT", "100V", "")
  5.005  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
  5.006  JMPL         ABORT                        @Error
  5.007  MATH         SafeOff("UUT")
  5.008  MEMCX  20    MZ             3% 0.03U

  6.001  5320         Mode = HR; +Res = 18.00 MOhms; TestVoltage = 100 V
  6.002  TARGET       -m
  6.003  WAIT         [D500]
  6.004  MATH         SafeOn("UUT", "100V", "")
  6.005  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
  6.006  JMPL         ABORT                        @Error
  6.007  MATH         SafeOff("UUT")
  6.008  MEMCX  20    MZ             3% 0.03U

  7.001  RSLT         =
  7.002  HEAD         -2{100 Mâ„¦ Range}
  7.003  TARGET       -p
  7.004  5320         Mode = HR; +Res = 22.0 MOhms; TestVoltage = 100 V
  7.005  TARGET       -m
  7.006  WAIT         [D500]
  7.007  MATH         SafeOn("UUT", "100V", "")
  7.008  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
  7.009  JMPL         ABORT                        @Error
  7.010  MATH         SafeOff("UUT")
  7.011  MEMCX  100   MZ             3% 0.3U

  8.001  5320         Mode = HR; +Res = 90.0 MOhms; TestVoltage = 100 V
  8.002  TARGET       -m
  8.003  WAIT         [D500]
  8.004  MATH         SafeOn("UUT", "100V", "")
  8.005  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
  8.006  JMPL         ABORT                        @Error
  8.007  MATH         SafeOff("UUT")
  8.008  MEMCX  100   MZ             3% 0.3U

  9.001  5320         Standby
  9.002  ENDIF        ; ZCMP(@ModelNum, "1653B") || ZCMP(@ModelNum, "1654B")

  9.003  RSLT         =
  9.004  HEAD         INSULATION TESTS: {250 Volts}
  9.005  RSLT         =
  9.006  HEAD         -2{20 Mâ„¦ Range}
  9.007  TARGET       -p
  9.008  MATH         @Command = @SetFunction & " " & @FuncInsulation250V
  9.009  CALL         Sub Fluke 165xB Send Command RS-232
  9.010  JMPL         ABORT                        @Error
  9.011  5320         Mode = HR; +Res = 0.04 MOhm; TestVoltage = 250 V
  9.012  TARGET       -m
  9.013  WAIT         [D500]
  9.014  MATH         SafeOn("UUT", "250V", "")
  9.015  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
  9.016  JMPL         ABORT                        @Error
  9.017  MATH         SafeOff("UUT")
  9.018  MEMCX  20    MZ             1.5% 0.03U

 10.001  5320         Mode = HR; +Res = 1.00 MOhm; TestVoltage = 250 V
 10.002  TARGET       -m
 10.003  WAIT         [D500]
 10.004  MATH         SafeOn("UUT", "250V", "")
 10.005  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 10.006  JMPL         ABORT                        @Error
 10.007  MATH         SafeOff("UUT")
 10.008  MEMCX  20    MZ             1.5% 0.03U

 11.001  5320         Mode = HR; +Res = 18.00 MOhm; TestVoltage = 250 V
 11.002  TARGET       -m
 11.003  WAIT         [D500]
 11.004  MATH         SafeOn("UUT", "250V", "")
 11.005  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 11.006  JMPL         ABORT                        @Error
 11.007  MATH         SafeOff("UUT")
 11.008  MEMCX  20    MZ             1.5% 0.03U
#! WARNING: Test Tol 3e+005, Sys Tol 90000 Ohms, TUR 3.3333 (< 4.00).

 12.001  RSLT         =
 12.002  HEAD         -2{200 Mâ„¦ Range}
 12.003  TARGET       -p
 12.004  5320         Mode = HR; +Res = 22.0 MOhm; TestVoltage = 250 V
 12.005  TARGET       -m
 12.006  WAIT         [D500]
 12.007  MATH         SafeOn("UUT", "250V", "")
 12.008  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 12.009  JMPL         ABORT                        @Error
 12.010  MATH         SafeOff("UUT")
 12.011  MEMCX  200   MZ             1.5% 0.3U

 13.001  5320         Mode = HR; +Res = 180.0 MOhms; TestVoltage = 250 V
 13.002  TARGET       -m
 13.003  WAIT         [D500]
 13.004  MATH         SafeOn("UUT", "250V", "")
 13.005  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 13.006  JMPL         ABORT                        @Error
 13.007  MATH         SafeOff("UUT")
 13.008  MEMCX  200   MZ             1.5% 0.3U
#! WARNING: Test Tol 3e+006, Sys Tol 9e+005 Ohms, TUR 3.3333 (< 4.00).

 14.001  5320         Standby

 14.002  RSLT         =
 14.003  HEAD         INSULATION TESTS: {500 Volts}
 14.004  RSLT         =
 14.005  HEAD         -2{20 Mâ„¦ Range}
 14.006  TARGET       -p
 14.007  MATH         @Command = @SetFunction & " " & @FuncInsulation500V
 14.008  CALL         Sub Fluke 165xB Send Command RS-232
 14.009  JMPL         ABORT                        @Error
 14.010  5320         Mode = HR; +Res = 0.10 MOhms; TestVoltage = 500 V
 14.011  TARGET       -m
 14.012  WAIT         [D500]
 14.013  MATH         SafeOn("UUT", "500V", "")
 14.014  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 14.015  JMPL         ABORT                        @Error
 14.016  MATH         SafeOff("UUT")
 14.017  MEMCX  20    MZ             1.5% 0.03U

 15.001  5320         Mode = HR; +Res = 2.00 MOhm; TestVoltage = 500 V
 15.002  TARGET       -m
 15.003  WAIT         [D500]
 15.004  MATH         SafeOn("UUT", "500V", "")
 15.005  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 15.006  JMPL         ABORT                        @Error
 15.007  MATH         SafeOff("UUT")
 15.008  MEMCX  20    MZ             1.5% 0.03U

 16.001  5320         Mode = HR; +Res = 18.00 MOhm; TestVoltage = 500 V
 16.002  TARGET       -m
 16.003  WAIT         [D500]
 16.004  MATH         SafeOn("UUT", "500V", "")
 16.005  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 16.006  JMPL         ABORT                        @Error
 16.007  MATH         SafeOff("UUT")
 16.008  MEMCX  20    MZ             1.5% 0.03U
#! WARNING: Test Tol 3e+005, Sys Tol 90000 Ohms, TUR 3.3333 (< 4.00).

 17.001  RSLT         =
 17.002  HEAD         -2{200 Mâ„¦ Range}
 17.003  TARGET       -p
 17.004  5320         Mode = HR; +Res = 22.0 MOhm; TestVoltage = 500 V
 17.005  TARGET       -m
 17.006  WAIT         [D500]
 17.007  MATH         SafeOn("UUT", "500V", "")
 17.008  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 17.009  JMPL         ABORT                        @Error
 17.010  MATH         SafeOff("UUT")
 17.011  MEMCX  200   MZ             1.5% 0.3U

 18.001  5320         Mode = HR; +Res = 180.0 MOhms; TestVoltage = 500 V
 18.002  TARGET       -m
 18.003  WAIT         [D500]
 18.004  MATH         SafeOn("UUT", "500V", "")
 18.005  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 18.006  JMPL         ABORT                        @Error
 18.007  MATH         SafeOff("UUT")
 18.008  MEMCX  200   MZ             1.5% 0.3U
#! WARNING: Test Tol 3e+006, Sys Tol 9e+005 Ohms, TUR 3.3333 (< 4.00).

 19.001  RSLT         =
 19.002  HEAD         -2{500 Mâ„¦ Range}
 19.003  TARGET       -p
 19.004  5320         Mode = HR; +Res = 220 MOhms; TestVoltage = 500 V
 19.005  TARGET       -m
 19.006  WAIT         [D500]
 19.007  MATH         SafeOn("UUT", "500V", "")
 19.008  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 19.009  JMPL         ABORT                        @Error
 19.010  MATH         SafeOff("UUT")
 19.011  MEMCX  500   MZ             10%

 20.001  5320         Mode = HR; +Res = 450 MOhms; TestVoltage = 500 V
 20.002  TARGET       -m
 20.003  WAIT         [D500]
 20.004  MATH         SafeOn("UUT", "500V", "")
 20.005  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 20.006  JMPL         ABORT                        @Error
 20.007  MATH         SafeOff("UUT")
 20.008  MEMCX  500   MZ             10%

 21.001  RSLT         =
 21.002  HEAD         INSULATION TESTS: {1000 Volts}
 21.003  RSLT         =
 21.004  HEAD         -2{200 Mâ„¦ Range}
 21.005  TARGET       -p
 21.006  MATH         @Command = @SetFunction & " " & @FuncInsulation1000V
 21.007  CALL         Sub Fluke 165xB Send Command RS-232
 21.008  JMPL         ABORT                        @Error
 21.009  5320         Mode = HR; +Res = 1.0 MOhms; TestVoltage = 1000 V
 21.010  TARGET       -m
 21.011  WAIT         [D500]
 21.012  MATH         SafeOn("UUT", "1000V", "")
 21.013  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 21.014  JMPL         ABORT                        @Error
 21.015  MATH         SafeOff("UUT")
 21.016  MEMCX  200   MZ             1.5% 0.3U

 22.001  5320         Mode = HR; +Res = 180.0 MOhms; TestVoltage = 1000 V
 22.002  TARGET       -m
 22.003  WAIT         [D500]
 22.004  MATH         SafeOn("UUT", "1000V", "")
 22.005  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 22.006  JMPL         ABORT                        @Error
 22.007  MATH         SafeOff("UUT")
 22.008  MEMCX  200   MZ             1.5% 0.3U
#! WARNING: Test Tol 3e+006, Sys Tol 1.44e+006 Ohms, TUR 2.0833 (< 4.00).

 23.001  RSLT         =
 23.002  HEAD         -2{1000 Mâ„¦ Range}
 23.003  TARGET       -p
 23.004  5320         Mode = HR; +Res = 220 MOhms; TestVoltage = 1000 V
 23.005  TARGET       -m
 23.006  WAIT         [D500]
 23.007  MATH         SafeOn("UUT", "1000V", "")
 23.008  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 23.009  JMPL         ABORT                        @Error
 23.010  MATH         SafeOff("UUT")
 23.011  MEMCX  1000  MZ             10%

 24.001  5320         Mode = HR; +Res = 900 MOhms; TestVoltage = 1000 V
 24.002  TARGET       -m
 24.003  WAIT         [D500]
 24.004  MATH         SafeOn("UUT", "1000V", "")
 24.005  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 24.006  JMPL         ABORT                        @Error
 24.007  MATH         SafeOff("UUT")
 24.008  MEMCX  1000  MZ             10%

 25.001  HEAD
 25.002  HEAD         -2
 25.003  5320         Reset
 25.004  END

 25.005  EVAL   Increment test number

# =====  Sub Fluke 165xB (1 yr) Continuity VER RS-232 /5320  ================

 26.001  LABEL        CONTINUITY_TESTS
 26.002  RSLT         =
 26.003  HEAD         {CONTINUITY TESTS}
 26.004  RSLT         =
 26.005  HEAD         -2{20 â„¦ Range}
 26.006  MATH         @KeyCode = @KeyTest
 26.007  TARGET       -p
 26.008  MATH         @Command = @FactoryTest
 26.009  CALL         Sub Fluke 165xB Send Command RS-232
 26.010  JMPL         ABORT                        @Error
 26.011  MATH         @Command = @SetFunction & " " & @FuncContinuity;
 26.012  CALL         Sub Fluke 165xB Send Command RS-232
 26.013  JMPL         ABORT                        @Error
 26.014  DISP         Short the PE and L jack together at the UUT.
 26.015  CALL         Sub Fluke 165xB Press ZERO, Wait for Beep RS-232
 26.016  JMPL         ABORT                        @Error
 26.017  MATH         @Command = @SetFunction & " " & @FuncContinuity;
 26.018  CALL         Sub Fluke 165xB Send Command RS-232
 26.019  JMPL         ABORT                        @Error
 26.020  TARGET       -m
 26.021  CALL         Sub Fluke 165xB Press Test, Query Measurement RS-232
 26.022  JMPL         ABORT                        @Error
 26.023  MEMCX  20    0.00Z          1.5% 0.03U

 27.001  5320         Mode = LR; +Resistance = 2.00 Ohms; Sense = 4W; Setup
 27.002  PIC          5320_165x_Continuity_4w.jpg
 27.003  5320         Mode = LR; +Resistance = 2.00 Ohms; Sense = 4W; Operate
 27.004  WAIT         [D500]
 27.005  TARGET       -m
 27.006  CALL         Sub Fluke 165xB Press Test, Query Measurement RS-232
 27.007  JMPL         ABORT                        @Error
 27.008  MEMCX  20    Z              1.5% 0.03U
#! WARNING: Test Tol 0.06, Sys Tol 0.016 Ohms, TUR 3.7500 (< 4.00).

 28.001  5320         Mode = LR; +Resistance = 18.00 Ohms; Sense = 4W
 28.002  WAIT         [D500]
 28.003  TARGET       -m
 28.004  CALL         Sub Fluke 165xB Press Test, Query Measurement RS-232
 28.005  JMPL         ABORT                        @Error
 28.006  MEMCX  20    Z              1.5% 0.03U

 29.001  RSLT         =
 29.002  HEAD         -2{200 â„¦ Range}
 29.003  TARGET       -p
 29.004  5320         Mode = LR; +Resistance = 22.0 Ohms; Sense = 4W
 29.005  WAIT         [D500]
 29.006  TARGET       -m
 29.007  CALL         Sub Fluke 165xB Press Test, Query Measurement RS-232
 29.008  JMPL         ABORT                        @Error
 29.009  MEMCX  200   Z              1.5% 0.3U

 30.001  5320         Mode = LR; +Resistance = 180.0 Ohms; Sense = 4W
 30.002  WAIT         [D500]
 30.003  TARGET       -m
 30.004  CALL         Sub Fluke 165xB Press Test, Query Measurement RS-232
 30.005  JMPL         ABORT                        @Error
 30.006  MEMCX  200   Z              1.5% 0.3U

 31.001  RSLT         =
 31.002  HEAD         -2{2000 â„¦ Range}
 31.003  TARGET       -p
 31.004  5320         Mode = LR; +Resistance = 220 Ohms; Sense = 4W
 31.005  WAIT         [D500]
 31.006  TARGET       -m
 31.007  CALL         Sub Fluke 165xB Press Test, Query Measurement RS-232
 31.008  JMPL         ABORT                        @Error
 31.009  MEMCX  2000  Z              1.5% 3U

 32.001  5320         Mode = LR; +Resistance = 1800 Ohms; Sense = 4W
 32.002  WAIT         [D500]
 32.003  TARGET       -m
 32.004  CALL         Sub Fluke 165xB Press Test, Query Measurement RS-232
 32.005  JMPL         ABORT                        @Error
 32.006  MEMCX  2000  Z              1.5% 3U

 33.001  HEAD
 33.002  HEAD         -2
 33.003  5320         Reset
 33.004  END

 33.005  EVAL   Increment test number

# =====  Sub Fluke 165xB (1 yr) RCD VER RS-232 /5320  =======================

 34.001  LABEL        RCD_TESTS
 34.002  RSLT         =
 34.003  HEAD         {RCD TESTS}
 34.004  RSLT         =
 34.005  HEAD         RCD TESTS: {Trip Current} 10 mA, xÂ½, AC, 0Â°
 34.006  VSET         GB_OVERFLOW = LIMIT
 34.007  MATH         @KeyCode = @KeyTest
 34.008  TARGET       -p
 34.009  TSET         TDESC = 10 mA, xÂ½, AC, 0Â°
 34.010  MATH         @Command = @FactoryTest
 34.011  CALL         Sub Fluke 165xB Send Command RS-232
 34.012  JMPL         ABORT                        @Error
 34.013  MATH         @Command = @SetFunction & " " & @FuncRCDTimeACx0_5_10mA
 34.014  CALL         Sub Fluke 165xB Send Command RS-232
 34.015  JMPL         ABORT                        @Error
 34.016  5320         Mode = RCDC; TripCurrent = 5 mA
 34.016  5320         +MaxCurrent = 5.00 mA; Setup
 34.017  PIC          5320_165x_LoopRCD.jpg
 34.018  TARGET       -m
 34.019  5320         Mode = RCDC; TripCurrent = 5 mA
 34.019  5320         +MaxCurrent = 5.00 mA; Operate
 34.020  WAIT         [D1000]
 34.021  CALL         Sub Fluke 165xB Press/Release Key RS-232
 34.022  JMPL         ABORT                        @Error
 34.023  5320         Mode = RCDC; TripCurrent = 5 mA
 34.023  5320         +MaxCurrent = 5.00 mA; Read
 34.024  MEMC   1000  5.00mA         +10%

 35.001  HEAD         RCD TESTS: Trip Current 10 mA, xÂ½, A, 0Â°
 35.002  TARGET       -p
 35.003  TSET         TDESC = 10 mA, xÂ½, A, 0Â°
 35.004  MATH         @Command = @SetFunction & " " & @FuncRCDTimeAx0_5_10mA
 35.005  CALL         Sub Fluke 165xB Send Command RS-232
 35.006  JMPL         ABORT                        @Error
 35.007  5320         Mode = RCDC; TripCurrent = 3.5 mA
 35.007  5320         +MaxCurrent = 3.50 mA; Setup
 35.008  TARGET       -m
 35.009  5320         Mode = RCDC; TripCurrent = 3.5 mA
 35.009  5320         +MaxCurrent = 3.50 mA; Operate
 35.010  WAIT         [D1000]
 35.011  CALL         Sub Fluke 165xB Press/Release Key RS-232
 35.012  JMPL         ABORT                        @Error
 35.013  5320         Mode = RCDC; TripCurrent = 3.5 mA
 35.013  5320         +MaxCurrent = 3.50 mA; Read
 35.014  MEMC   1000  3.50mA         +10%

 36.001  HEAD         RCD TESTS: Trip Current 10 mA, x5, AC, 0Â°
 36.002  TARGET       -p
 36.003  TSET         TDESC = 10 mA, x5, AC, 0Â°
 36.004  MATH         @Command = @SetFunction & " " & @FuncRCDTimeACx5_10mA
 36.005  CALL         Sub Fluke 165xB Send Command RS-232
 36.006  JMPL         ABORT                        @Error
 36.007  5320         Mode = RCDC; TripCurrent = 50 mA
 36.007  5320         +MaxCurrent = 50.0 mA; Setup
 36.008  TARGET       -m
 36.009  5320         Mode = RCDC; TripCurrent = 50 mA
 36.009  5320         +MaxCurrent = 50.0 mA; Operate
 36.010  WAIT         [D1000]
 36.011  CALL         Sub Fluke 165xB Press/Release Key RS-232
 36.012  JMPL         ABORT                        @Error
 36.013  5320         Mode = RCDC; TripCurrent = 50 mA
 36.013  5320         +MaxCurrent = 50.0 mA; Read
 36.014  MEMC   1000  50.0mA         -10%

 37.001  HEAD         RCD TESTS: Trip Current 30 mA, x1, AC, 0Â°
 37.002  TARGET       -p
 37.003  TSET         TDESC = 30 mA, x1, AC, 0Â°
 37.004  MATH         @Command = @SetFunction & " " & @FuncRCDTimeACx1_30mA
 37.005  CALL         Sub Fluke 165xB Send Command RS-232
 37.006  JMPL         ABORT                        @Error
 37.007  5320         Mode = RCDC; TripCurrent = 30 mA
 37.007  5320         +MaxCurrent = 30.0 mA; Setup
 37.008  TARGET       -m
 37.009  5320         Mode = RCDC; TripCurrent = 30 mA
 37.009  5320         +MaxCurrent = 30.0 mA; Operate
 37.010  WAIT         [D1000]
 37.011  CALL         Sub Fluke 165xB Press/Release Key RS-232
 37.012  JMPL         ABORT                        @Error
 37.013  5320         Mode = RCDC; TripCurrent = 30 mA
 37.013  5320         +MaxCurrent = 30.0 mA; Read
 37.014  MEMC   1000  30.0mA         -10%

 38.001  HEAD         RCD TESTS: Trip Current 30 mA, x1, AC, 180Â°
 38.002  TARGET       -p
 38.003  TSET         TDESC = 30 mA, x1, AC, 180Â°
 38.004  MATH         @Command = @SetFunction & " " & @FuncRCDTimeACx1_30mA180
 38.005  CALL         Sub Fluke 165xB Send Command RS-232
 38.006  JMPL         ABORT                        @Error
 38.007  5320         Mode = RCDC; TripCurrent = 30 mA
 38.007  5320         +MaxCurrent = 30.0 mA; Setup
 38.008  TARGET       -m
 38.009  5320         Mode = RCDC; TripCurrent = 30 mA
 38.009  5320         +MaxCurrent = 30.0 mA; Operate
 38.010  WAIT         [D1000]
 38.011  CALL         Sub Fluke 165xB Press/Release Key RS-232
 38.012  JMPL         ABORT                        @Error
 38.013  5320         Mode = RCDC; TripCurrent = 30 mA
 38.013  5320         +MaxCurrent = 30.0 mA; Read
 38.014  MEMC   1000  30.0mA         -10%

 39.001  HEAD         RCD TESTS: Trip Current 30 mA, x1, A, 0Â°
 39.002  TARGET       -p
 39.003  TSET         TDESC = 30 mA, x1, A, 0Â°
 39.004  MATH         @Command = @SetFunction & " " & @FuncRCDTimeAx1_30mA
 39.005  CALL         Sub Fluke 165xB Send Command RS-232
 39.006  JMPL         ABORT                        @Error
 39.007  5320         Mode = RCDC; TripCurrent = 42.4 mA
 39.007  5320         +MaxCurrent = 42.4 mA; Setup
 39.008  TARGET       -m
 39.009  5320         Mode = RCDC; TripCurrent = 42.4 mA
 39.009  5320         +MaxCurrent = 42.4 mA; Operate
 39.010  WAIT         [D1000]
 39.011  CALL         Sub Fluke 165xB Press/Release Key RS-232
 39.012  JMPL         ABORT                        @Error
 39.013  5320         Mode = RCDC; TripCurrent = 42.4 mA
 39.013  5320         +MaxCurrent = 42.4 mA; Read
 39.014  MEMC   1000  42.4mA         -10%

 40.001  HEAD         RCD TESTS: Trip Current 30 mA, xÂ½, AC, 0Â°
 40.002  TARGET       -p
 40.003  TSET         TDESC = 30 mA, xÂ½, AC, 0Â°
 40.004  MATH         @Command = @SetFunction & " " & @FuncRCDTimeACx0_5_30mA
 40.005  CALL         Sub Fluke 165xB Send Command RS-232
 40.006  JMPL         ABORT                        @Error
 40.007  5320         Mode = RCDC; TripCurrent = 15 mA
 40.007  5320         +MaxCurrent = 15.0 mA; Setup
 40.008  TARGET       -m
 40.009  5320         Mode = RCDC; TripCurrent = 15 mA
 40.009  5320         +MaxCurrent = 15.0 mA; Operate
 40.010  WAIT         [D1000]
 40.011  CALL         Sub Fluke 165xB Press/Release Key RS-232
 40.012  JMPL         ABORT                        @Error
 40.013  5320         Mode = RCDC; TripCurrent = 15 mA
 40.013  5320         +MaxCurrent = 15.0 mA; Read
 40.014  MEMC   1000  15.0mA         +10%

 41.001  IF           ZCMP(@ModelNum, "1654B")
 41.002  HEAD         RCD TESTS: Trip Current 30 mA, x1, B, 0Â°
 41.003  TARGET       -p
 41.004  TSET         TDESC = 30 mA, x1, B, 0Â°
 41.005  MATH         @Command = @SetFunction & " " & @FuncRCDTimeBx1_30mA
 41.006  CALL         Sub Fluke 165xB Send Command RS-232
 41.007  JMPL         ABORT                        @Error
 41.008  5320         Mode = RCDC; TripCurrent = 60 mA
 41.008  5320         +MaxCurrent = 60.0 mA; Setup
 41.009  TARGET       -m
 41.010  5320         Mode = RCDC; TripCurrent = 60 mA
 41.010  5320         +MaxCurrent = 60.0 mA; Operate
 41.011  WAIT         [D1000]
 41.012  CALL         Sub Fluke 165xB Press/Release Key RS-232
 41.013  JMPL         ABORT                        @Error
 41.014  WAIT         -t 5 Waiting for measurement to complete...
 41.015  5320         Mode = RCDC; TripCurrent = 60 mA
 41.015  5320         +MaxCurrent = 60.0 mA; Read
 41.016  MEMC   1000  60.0mA         -10%

 42.001  HEAD         RCD TESTS: Trip Current 30 mA, x1, B, 180Â°
 42.002  TARGET       -p
 42.003  TSET         TDESC = 30 mA, x1, B, 180Â°
 42.004  MATH         @Command = @SetFunction & " " & @FuncRCDTimeBx1_30mA180
 42.005  CALL         Sub Fluke 165xB Send Command RS-232
 42.006  JMPL         ABORT                        @Error
 42.007  5320         Mode = RCDC; TripCurrent = 60 mA
 42.007  5320         +MaxCurrent = 60.0 mA; Setup
 42.008  TARGET       -m
 42.009  5320         Mode = RCDC; TripCurrent = 60 mA
 42.009  5320         +MaxCurrent = 60.0 mA; Operate
 42.010  WAIT         [D1000]
 42.011  CALL         Sub Fluke 165xB Press/Release Key RS-232
 42.012  JMPL         ABORT                        @Error
 42.013  WAIT         -t 5 Waiting for measurement to complete...
 42.014  5320         Mode = RCDC; TripCurrent = 60 mA
 42.014  5320         +MaxCurrent = 60.0 mA; Read
 42.015  MEMC   1000  60.0mA         -10%

 43.001  HEAD         RCD TESTS: Trip Current 300 mA, x1, B, 0Â°
 43.002  TARGET       -p
 43.003  TSET         TDESC = 300 mA, x1, B, 0Â°
 43.004  MATH         @Command = @SetFunction & " " & @FuncRCDTimeBx1_300mA
 43.005  CALL         Sub Fluke 165xB Send Command RS-232
 43.006  JMPL         ABORT                        @Error
 43.007  5320         Mode = RCDC; TripCurrent = 600 mA
 43.007  5320         +MaxCurrent = 600.0 mA; Setup
 43.008  TARGET       -m
 43.009  5320         Mode = RCDC; TripCurrent = 600 mA
 43.009  5320         +MaxCurrent = 600.0 mA; Operate
 43.010  WAIT         [D1000]
 43.011  CALL         Sub Fluke 165xB Press/Release Key RS-232
 43.012  JMPL         ABORT                        @Error
 43.013  WAIT         -t 5 Waiting for measurement to complete...
 43.014  5320         Mode = RCDC; TripCurrent = 600 mA
 43.014  5320         +MaxCurrent = 600.0 mA; Read
 43.015  MEMC   1000  600.0mA        -10%
 44.001  ENDIF

 44.002  HEAD         RCD TESTS: Trip Current 1000 mA, x1, AC, 0Â°
 44.003  TARGET       -p
 44.004  TSET         TDESC = 1000 mA, x1, AC, 0Â°
 44.005  MATH         @Command = @SetFunction & " " & @FuncRCDTimeACx1_1000mA
 44.006  CALL         Sub Fluke 165xB Send Command RS-232
 44.007  JMPL         ABORT                        @Error
 44.008  5320         Mode = RCDC; TripCurrent = 1000 mA
 44.008  5320         +MaxCurrent = 1000.0 mA; Setup
 44.009  TARGET       -m
 44.010  5320         Mode = RCDC; TripCurrent = 1000 mA
 44.010  5320         +MaxCurrent = 1000.0 mA; Operate
 44.011  WAIT         [D1000]
 44.012  CALL         Sub Fluke 165xB Press/Release Key RS-232
 44.013  JMPL         ABORT                        @Error
 44.014  5320         Mode = RCDC; TripCurrent = 1000 mA
 44.014  5320         +MaxCurrent = 1000.0 mA; Read
 44.015  MEMC   1000  1000.0mA       -10%

 45.001  VSET         GB_OVERFLOW = *

 45.002  RSLT         =
 45.003  HEAD         RCD TESTS: {Trip Time} 30 ms, 30 mA, x1, AC
 45.004  TARGET       -p
 45.005  TSET         TDESC = 30 ms, 30 mA, x1, AC
 45.006  MATH         @Command = @SetFunction & " " & @FuncRCDTimeACx1_30mA
 45.007  CALL         Sub Fluke 165xB Send Command RS-232
 45.008  JMPL         ABORT                        @Error
 45.009  5320         Mode = RCDT; TripCurrent = 30 mA; TripCurrentMult = 1
 45.009  5320         +TripTime = 30.0 ms; Setup
 45.010  TARGET       -m
 45.011  5320         Mode = RCDT; TripCurrent = 30 mA; TripCurrentMult = 1
 45.011  5320         +TripTime = 30.0 ms; Operate
 45.012  WAIT         [D1000]
# 45.013  CALL         Sub Fluke 165xB Press Test, Query Measurement RS-232
 45.013  CALL         Sub Fluke 165xB Press/Release Key RS-232
 45.014  WAIT         [D1000]
 45.015  CALL         Sub Fluke 165xB Query Measurement RS-232
 45.016  JMPL         ABORT                        @Error
 45.017  MEMCX  100   30.0ms         1% 1.0U

 46.001  HEAD         RCD TESTS: Trip Time 300 ms, 30 mA, x1, AC
 46.002  TARGET       -p
 46.003  TSET         TDESC = 300 ms, 30 mA, x1, AC
 46.004  MATH         @Command = @SetFunction & " " & @FuncRCDTimeACx1_30mA
 46.005  CALL         Sub Fluke 165xB Send Command RS-232
 46.006  JMPL         ABORT                        @Error
 46.007  5320         Mode = RCDT; TripCurrent = 30 mA; TripCurrentMult = 1
 46.007  5320         +TripTime = 300.0 ms; Setup
 46.008  TARGET       -m
 46.009  5320         Mode = RCDT; TripCurrent = 30 mA; TripCurrentMult = 1
 46.009  5320         +TripTime = 300.0 ms; Operate
 46.010  WAIT         [D1000]
# 46.011  CALL         Sub Fluke 165xB Press Test, Query Measurement RS-232
 46.011  CALL         Sub Fluke 165xB Press/Release Key RS-232
 46.012  WAIT         [D1000]
 46.013  CALL         Sub Fluke 165xB Query Measurement RS-232

 46.014  JMPL         ABORT                        @Error
 46.015  MEMCX  100   300.0ms        1% 1.0U

 47.001  HEAD         RCD TESTS: Trip Time 500 ms, 30 mA, x1, AC S
 47.002  MATH         @KeyCode = @KeyTest
 47.003  TARGET       -p
 47.004  TSET         TDESC = 500 ms, 30 mA, x1, AC S
 47.005  MATH         @Command = @SetFunction & " " & @FuncRCDTimeAC_Sx1_30mA
 47.006  CALL         Sub Fluke 165xB Send Command RS-232
 47.007  JMPL         ABORT                        @Error
 47.008  5320         Mode = RCDT; TripCurrent = 30 mA; TripCurrentMult = 1
 47.008  5320         +TripTime = 500.0 ms; Setup
 47.009  TARGET       -m
 47.010  5320         Mode = RCDT; TripCurrent = 30 mA; TripCurrentMult = 1
 47.010  5320         +TripTime = 500.0 ms; Operate
 47.011  WAIT         [D1000]
 47.012  CALL         Sub Fluke 165xB Press/Release Key RS-232
 47.013  JMPL         ABORT                        @Error
 47.014  WAIT         -t 30 Waiting the specified UUT delay...
 47.015  WAIT         [D1000]
 47.016  CALL         Sub Fluke 165xB Query Measurement RS-232
 47.017  JMPL         ABORT                        @Error
 47.018  MEMCX  100   500.0ms        1% 1U

 48.001  5320         Reset
 48.002  END

 48.003  EVAL   Increment test number

# =====  Sub Fluke 1653B (1 yr) Earth VER RS-232 /5320  =====================

 49.001  LABEL        EARTH_TESTS
 49.002  RSLT         =
 49.003  HEAD         {EARTH TESTS}
 49.004  MATH         @KeyCode = @KeyTest
 49.005  TARGET       -p
 49.006  MATH         @Command = @FactoryTest
 49.007  CALL         Sub Fluke 165xB Send Command RS-232
 49.008  JMPL         ABORT                        @Error
 49.009  MATH         @Command = @SetFunction & " " & @FuncEarth;
 49.010  CALL         Sub Fluke 165xB Send Command RS-232
 49.011  JMPL         ABORT                        @Error
 49.012  5320         Mode = LR +Resistance = 2.0 Ohm; Setup
 49.013  PIC          5320_1653_EarthTest.jpg
 49.014  5320         Mode = LR +Resistance = 2.0 Ohm; Operate
 49.015  WAIT         [D1000]
 49.016  TARGET       -m
 49.017  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 49.018  JMPL         ABORT                        @Error
 49.019  MEMCX  200   Z              2% 0.5U

 50.001  5320         Mode = LR +Resistance = 1800 Ohms
 50.002  WAIT         [D1000]
 50.003  TARGET       -m
 50.004  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 50.005  JMPL         ABORT                        @Error
 50.006  MEMCX  2000  Z              3.5% 10U

 51.001  LABEL        ABORT
 51.002  5320         Reset
 51.003  END
