﻿Copyright (c) (2014) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Fluke 165xB (1 yr) Voltage VER RS-232 /5320+VLC
INSTRUMENT:            Sub Fluke 165xB (1 yr) Ins Button VER RS-232 /5320+VLC
INSTRUMENT:            Sub Fluke 165xB (1 yr) Loop Hi Curr VER RS-232/5320+VLC
DATE:                  2014-03-24 13:12:17
AUTHOR:                Fluke
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       22
NUMBER OF LINES:       313
CONFIGURATION:         Fluke 5320A (VLC)
=============================================================================
#
#  Procedure Author:
#        DAC
#
#  Model Covered:
#        1651B, 1652B, 1652C, 1653B, & 1654B
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Additional Equipment Required:
#        Fluke-165xB, Zero Adapter, Part No. 3301338
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Calibration.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         VOLTAGE_TESTS                 PSUBI("Voltage")
  1.002  JMPL         INSULATION_PUSH_BUTTON_TEST   PSUBI("Ins Button")
  1.003  JMPL         LOOP_TESTS                    PSUBI("Loop")
  1.004  DISP         Subprocedure not found!
  1.005  END

  1.006  EVAL   Increment step number

# =====  Sub Fluke 165x (1 yr) Voltage VER RS-232 /5320+VLC  ================

  2.001  LABEL        VOLTAGE_TESTS
  2.002  RSLT         =
  2.003  HEAD         {VOLTAGE TESTS}
  2.004  TARGET       -p
  2.005  MATH         @Command = @FactoryTest
  2.006  CALL         Sub Fluke 165xB Send Command RS-232
  2.007  JMPL         ABORT                        @Error
  2.008  MATH         @Command = @SetFunction & " " & @FuncVoltsL_PE
  2.009  CALL         Sub Fluke 165xB Send Command RS-232
  2.010  JMPL         ABORT                        @Error

  2.011  MATH         L[1] = ZCMP(@ModelNum, "1653B")
  2.012  MATH         L[1] = ZCMP(@ModelNum, "1654B") || L[1]

  2.013  IF           NOT(L[1])
  2.014  PIC          5320_165x_VoltInsulation
  2.015  ENDIF

  2.016  5320         +Voltage = 25.0 V; Freq = 50 Hz
  2.017  WAIT         [D500]
  2.018  TARGET       -m
  2.019  CALL         Sub Fluke 165xB Query Measurement RS-232
  2.020  JMPL         ABORT                        @Error
  2.021  MEMCX  500   25.0V          0.8% 0.3U     50Hz

  3.001  5320         +Voltage = 250.0 V; Freq = 50 Hz
  3.002  WAIT         [D500]
  3.003  TARGET       -m
  3.004  CALL         Sub Fluke 165xB Query Measurement RS-232
  3.005  JMPL         ABORT                        @Error
  3.006  MEMCX  500   250.0V         0.8% 0.3U     50Hz

  4.001  5320         +Voltage = 475.0 V; Freq = 50 Hz
  4.002  WAIT         [D500]
  4.003  TARGET       -m
  4.004  CALL         Sub Fluke 165xB Query Measurement RS-232
  4.005  JMPL         ABORT                        @Error
  4.006  MEMCX  500   475.0V         0.8% 0.3U     50Hz

  5.001  5320         Reset
  5.002  END

  5.003  EVAL   Increment step number

# =====  Sub Fluke 165x (1 yr) Ins Button VER RS-232 /5320+VLC  ==============

  6.001  LABEL        INSULATION_PUSH_BUTTON_TEST
  6.002  HEAD         INSULATION TESTS: Push Button
  6.003  RSLT         =
  6.004  TARGET
  6.005  MATH         @Command = @FactoryTest
  6.006  CALL         Sub Fluke 165xB Send Command RS-232
  6.007  JMPL         ABORT                        @Error
  6.008  MATH         @Command = @SetFunction & " " & @FuncInsulation500V
  6.009  CALL         Sub Fluke 165xB Send Command RS-232
  6.010  JMPL         ABORT                        @Error
  6.011  5320         Mode = Volt; +Volt = 34 V
  6.012  WAIT         [D500]
  6.013  MATH         @Parameter = "0"
  6.014  CALL         Sub Fluke 165xB Query Data RS-232
  6.015  JMPL         ABORT                        @Error
  6.016  MATH         MEM2 = "Is UUT displaying lightning bolt"
  6.017  MATH         MEM2 = MEM2 & " and approximately 34 VDC?"
  6.018  EVAL   -s "Push Button" : [MEM2]

  7.001  5320         Reset
  7.002  END

  7.003  EVAL   Increment step number

# =====  Sub Fluke 165x (1 yr) Loop VER RS-232 /5320+VLC  ====================

  8.001  LABEL        LOOP_TESTS
  8.002  RSLT         =
  8.003  HEAD         LOOP TESTS:{L-PE, Hi Current}
  8.004  RSLT         =
  8.005  HEAD         -2{20 Ω Range}
  8.006  TARGET       -p
  8.007  MATH         @Command = @FactoryTest
  8.008  CALL         Sub Fluke 165xB Send Command RS-232
  8.009  JMPL         ABORT                        @Error
# Set function before displaying connection picture.
  8.010  MATH         @Command = @SetFunction & " " & @FuncLoopL_PE_Trip
  8.011  CALL         Sub Fluke 165xB Send Command RS-232
  8.012  JMPL         ABORT                        @Error
  8.013  PIC          165x_L_PE_N_165XB-ZeroAdapter
# Resend function command for each iteration of NMEAS loop.  This is necessary
# because the UUT assumes the function of the rotary switch position, when
# each zero operation in the NMEAS loop completes.
  8.014  MATH         @Command = @SetFunction & " " & @FuncLoopL_PE_Trip
  8.015  CALL         Sub Fluke 165xB Send Command RS-232
  8.016  JMPL         ABORT                        @Error
  8.017  MATH         ZeroPressed = 0
# Query beeper to clear register.
  8.018  CALL         Sub Fluke 165xB Query Beeper RS-232

# If no error, press ZERO.
  8.019  IF           NOT(@Error)
  8.020  MATH         @Command = @PressKey & @KeyZero
  8.021  CALL         Sub Fluke 165xB Send Command RS-232
  8.022  MATH         ZeroPressed = NOT(@Error)
  8.023  ENDIF

# If no error, wait for 1st beep.
  8.024  IF           NOT(@Error)
  8.025  CALL         Sub Fluke 165xB Wait for Beep RS-232
  8.026  ENDIF

# If no error, wait for 2nd beep.
  8.027  IF           NOT(@Error)
  8.028  CALL         Sub Fluke 165xB Wait for Beep RS-232
  8.029  ENDIF

# If ZERO was successfully pressed, release it.
  8.030  IF           ZeroPressed
  8.031  MATH         L[1] = @Error; L[2] = @Repeat
  8.032  MATH         @Command = @ReleaseKey & @KeyZero
  8.033  CALL         Sub Fluke 165xB Send Command RS-232
  8.034  ENDIF

  8.035  IF           NOT(@Error)
  8.036  MATH         ZeroPressed = 0
  8.037  MATH         @Error = L[1]; @Repeat = L[2]
  8.038  ENDIF

  8.039  MATH         @Command = @SetFunction & " " & @FuncLoopL_PE_Trip
  8.040  CALL         Sub Fluke 165xB Send Command RS-232
  8.041  JMPL         ABORT                        @Error

  8.042  PIC          5320_165x_LoopRCD
  8.043  5320         Mode = Loop; SerialRes = 0 Ohm; ResImpCorr = Comp
  8.043  5320         +Res = 0.33 Ohms
# Throw away first reading after zero.
  8.044  WAIT         [D1000]
  8.045  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
  8.046  TARGET       -m
  8.047  WAIT         [D1000]
  8.048  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
  8.049  MEMCX  20    Z              2% 0.04U

  9.001  5320         Mode = Loop; SerialRes = 0 Ohm; ResImpCorr = Comp
  9.001  5320         +Res = 1.80 Ohms
  9.002  TARGET       -m
  9.003  WAIT         [D1000]
  9.004  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
  9.005  MEMCX  20    Z              2% 0.04U

 10.001  5320         Mode = Loop; SerialRes = 0 Ohm; ResImpCorr = Comp
 10.001  5320         +Res = 18.00 Ohms
 10.002  TARGET       -m
 10.003  WAIT         [D1000]
 10.004  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 10.005  MEMCX  20    Z              2% 0.04U

 11.001  RSLT         =
 11.002  HEAD         -2{200 Ω Range}
 11.003  TARGET       -p
 11.004  5320         Mode = Loop; SerialRes = 0 Ohm; ResImpCorr = Comp
 11.004  5320         +Res = 50.0 Ohms
 11.005  TARGET       -m
 11.006  WAIT         [D1000]
 11.007  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 11.008  MEMCX  200   Z              2%

 12.001  5320         Mode = Loop; SerialRes = 0 Ohm; ResImpCorr = Comp
 12.001  5320         +Res = 180.0 Ohms
 12.002  TARGET       -m
 12.003  WAIT         [D1000]
 12.004  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 12.005  MEMCX  200   Z              2%

 13.001  RSLT         =
 13.002  HEAD         -2{2000 Ω Range}

 13.003  TARGET       -p
 13.004  5320         Mode = Loop; SerialRes = 0 Ohm; ResImpCorr = Comp
 13.004  5320         +Res = 500 Ohms
 13.005  TARGET       -m
 13.006  WAIT         [D1000]
 13.007  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 13.008  MEMCX  2000  Z              6%

 14.001  5320         Mode = Loop; SerialRes = 0 Ohm; ResImpCorr = Comp
 14.001  5320         +Res = 1800 Ohms
 14.002  TARGET       -m
 14.003  WAIT         [D1000]
 14.004  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 14.005  MEMCX  2000  Z              6%

 15.001  5320         Standby

 15.002  RSLT         =
 15.003  HEAD         LOOP TESTS:{L-N, Hi Current}
 15.004  RSLT         =
 15.005  HEAD         -2{20 Ω Range}
 15.006  TARGET       -p
 15.007  MATH         @Command = @SetFunction & " " & @FuncLoopL_N_Trip
 15.008  CALL         Sub Fluke 165xB Send Command RS-232
 15.009  JMPL         ABORT                        @Error
 15.010  5320         Mode = Line; SerialRes = 0 Ohm; ResImpCorr = Comp
 15.010  5320         +Res = 0.33 Ohms
# Throw away first reading after zero.
 15.011  WAIT         [D1000]
 15.012  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 15.013  TARGET       -m
 15.014  WAIT         [D1000]
 15.015  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 15.016  MEMCX  20    Z              2% 0.04U

 16.001  5320         Mode = Line; SerialRes = 0 Ohm; ResImpCorr = Comp
 16.001  5320         +Res = 1.80 Ohms
 16.002  TARGET       -m
 16.003  WAIT         [D1000]
 16.004  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 16.005  MEMCX  20    Z              2% 0.04U

 17.001  5320         Mode = Line; SerialRes = 0 Ohm; ResImpCorr = Comp
 17.001  5320         +Res = 18.00 Ohms
 17.002  TARGET       -m
 17.003  WAIT         [D1000]
 17.004  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 17.005  MEMCX  20    Z              2% 0.04U

 18.001  RSLT         =
 18.002  HEAD         -2{200 Ω Range}
 18.003  TARGET       -p
 18.004  5320         Mode = Line; SerialRes = 0 Ohm; ResImpCorr = Comp
 18.004  5320         +Res = 50.0 Ohms
 18.005  TARGET       -m
 18.006  WAIT         [D1000]
 18.007  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 18.008  MEMCX  200   Z              2%

 19.001  5320         Mode = Line; SerialRes = 0 Ohm; ResImpCorr = Comp
 19.001  5320         +Res = 180.0 Ohms
 19.002  TARGET       -m
 19.003  WAIT         [D1000]
 19.004  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 19.005  MEMCX  200   Z              2%

 20.001  RSLT         =
 20.002  HEAD         -2{2000 Ω Range}
 20.003  TARGET       -p
 20.004  5320         Mode = Line; SerialRes = 0 Ohm; ResImpCorr = Comp
 20.004  5320         +Res = 500 Ohms
 20.005  TARGET       -m
 20.006  WAIT         [D1000]
 20.007  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 20.008  MEMCX  2000  Z              6%

 21.001  5320         Mode = Line; SerialRes = 0 Ohm; ResImpCorr = Comp
 21.001  5320         +Res = 1800 Ohms
 21.002  TARGET       -m
 21.003  WAIT         [D1000]
 21.004  CALL         Sub Fluke 165xB Press Test, Beep, Query Meas RS-232
 21.005  MEMCX  2000  Z              6%

 22.001  LABEL        ABORT
 22.002  HEAD
 22.003  HEAD         -2
 22.004  5320         Reset
 22.005  END
