﻿Copyright (c) (2014) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Fluke 165xB Battery Check RS-232
INSTRUMENT:            Sub Fluke 165xB Backlight Test RS-232
INSTRUMENT:            Sub Fluke 165xB Input Jack Sense Test RS-232
DATE:                  2014-03-24 13:08:22
AUTHOR:                Fluke
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       7
NUMBER OF LINES:       148
=============================================================================
#
#  Procedure Author(s):
#        DAC
#
#  Model(s) Covered:
#        1651B, 1652B, & 1653B
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  The copyright for this procedure is owned by Fluke Calibration.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         BATTERY_CHECK                PSUBI("Battery Check")
  1.002  JMPL         BACKLIGHT_TEST               PSUBI("Backlight")
  1.003  JMPL         INPUT_JACK_SENSE             PSUBI("Input Jack Sense")
  1.004  DISP         Subprocedure not found!
  1.005  END

  1.006  EVAL   Increment test number

# =====  Sub Fluke 165xB Battery Check RS-232  ==============================

  2.001  LABEL        BATTERY_CHECK
  2.002  MATH         @Command = @FactoryTest
  2.003  CALL         Sub Fluke 165xB Send Command RS-232
  2.004  JMPL         ERROR                        @Error
  2.005  MATH         @Command = @SetFunction & " " & @FuncVoltsL_PE
  2.006  CALL         Sub Fluke 165xB Send Command RS-232
  2.007  JMPL         ERROR                        @Error
  2.008  MATH         @Command = @PressKey & @KeyF3
  2.009  CALL         Sub Fluke 165xB Send Command RS-232
  2.010  JMPL         ERROR                        @Error
  2.011  WAIT         [D1000]
  2.012  MATH         @Command = @GetVariable & "0"
  2.013  CALL         Sub Fluke 165xB Send Command RS-232
  2.014  JMPL         ERROR                        @Error
  2.015  PORT         [I$]
# Second comma delimited field is battery voltage with assume decimal point.
  2.016  MATH         MEM = FLD(MEM2, 2, ",") / 100
  2.017  MATH         BatteryVoltage = MEM
  2.018  MATH         MEM2 = FMT(MEM, "%3.1f")
  2.019  RSLT         =
  2.020  RSLT         =Battery Voltage: [MEM2] V
  2.021  MATH         @Command = @ReleaseKey & @KeyF3
  2.022  CALL         Sub Fluke 165xB Send Command RS-232
  2.023  JMPL         ERROR                        @Error

  2.024  IF           BatteryVoltage < 6.0
  2.025  DISP         Press the green button to turn the UUT off.
  2.025  DISP
  2.025  DISP         Remove the battery door by using a standard-blade
  2.025  DISP         screwdriver to turn the battery door screws (3)
  2.025  DISP         one-quarter turn counterclockwise.
  2.025  DISP
  2.025  DISP         Press the release latch and slide the battery holder
  2.025  DISP         out of the tester.
  2.025  DISP
  2.025  DISP         Replace the batteries and the battery door.
  2.025  DISP
  2.025  DISP         Secure the door by turning the screws one-quarter turn
  2.025  DISP         clockwise.
  2.026  ENDIF

  2.027  END

  2.028  EVAL   Increment test number

# =====  Sub Fluke 165xB Backlight Test RS-232  =============================

  3.001  LABEL        BACKLIGHT_TEST
  3.002  RSLT         =
  3.003  HEAD         BACKLIGHT TEST
  3.004  MATH         @KeyCode = @KeyBacklight
  3.005  TARGET
  3.006  MATH         @Command = @FactoryTest
  3.007  CALL         Sub Fluke 165xB Send Command RS-232
  3.008  JMPL         ERROR                        @Error
  3.009  CALL         Sub Fluke 165xB Press/Release Key RS-232
  3.010  JMPL         ERROR                        @Error
  3.011  OPBR         -z Is backlight on?
  3.012  MATH         On = MEM1
  3.013  CALL         Sub Fluke 165xB Press/Release Key RS-232
  3.014  JMPL         ERROR                        @Error
  3.015  OPBR         -z Is backlight off?
  3.016  MATH         Off = MEM1
  3.017  EVAL   -e On && Off : BACKLIGHT TEST

  4.001  END

  4.002  EVAL   Increment test number

# =====  Sub Fluke 165xB Input Jack Sense Test RS-232  =======================

  5.001  LABEL        INPUT_JACK_SENSE
  5.002  RSLT         =
  5.003  HEAD         {INPUT JACK SENSE}
  5.004  TARGET
  5.005  MATH         @Command = @FactoryTest
  5.006  CALL         Sub Fluke 165xB Send Command RS-232
  5.007  JMPL         ERROR                        @Error
  5.008  MATH         @Command = @SetFunction & " " & @FuncLoopL_PE_NoTrip_PFC
  5.009  CALL         Sub Fluke 165xB Send Command RS-232
  5.010  JMPL         ERROR                       @Error
  5.011  DISP         Insert test leads into PE and L jacks.
  5.012  WAIT         [D500]
  5.013  CALL         Sub Fluke 165xB Check Lead RS-232
  5.014  JMPL         ERROR                       @Error
  5.015  MATH         Off = NOT(ZCMP(@Lead, "LEAD"))

  5.016  DISP         Remove test lead from PE jack.
  5.017  WAIT         [D500]
  5.018  CALL         Sub Fluke 165xB Check Lead RS-232
  5.019  JMPL         ERROR                       @Error
  5.020  MATH         On = ZCMP(@Lead, "LEAD")
  5.021  EVAL   -e Off && On : [32] "PE" Jack

  6.001  DISP         Reinsert test lead into PE jack.
  6.002  WAIT         [D500]
  6.003  MATH         @Command = @SetFunction & " " & @FuncLoopL_PE_NoTrip_PFC
  6.004  CALL         Sub Fluke 165xB Send Command RS-232
  6.005  JMPL         ERROR                       @Error
  6.006  CALL         Sub Fluke 165xB Check Lead RS-232
  6.007  JMPL         ERROR                       @Error
  6.008  MATH         Off = NOT(ZCMP(@Lead, "LEAD"))

  6.009  DISP         Remove test lead from L jack.
  6.010  WAIT         [D500]
  6.011  CALL         Sub Fluke 165xB Check Lead RS-232
  6.012  JMPL         ERROR                       @Error
  6.013  MATH         On = ZCMP(@Lead, "LEAD")
  6.014  EVAL   -e Off & On : [32] "L" Jack

  7.001  LABEL        ERROR
  7.002  END
