﻿Copyright (c) (2014) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Fluke 165xB Get ID RS-232
INSTRUMENT:            Sub Fluke 165xB Query Data RS-232
INSTRUMENT:            Sub Fluke 165xB Query Measurement RS-232
INSTRUMENT:            Sub Fluke 165xB Press/Release Key RS-232
INSTRUMENT:            Sub Fluke 165xB Press TEST, Wait for Beep RS-232
INSTRUMENT:            Sub Fluke 165xB Press ZERO, Wait for Beep RS-232
DATE:                  2014-03-24 13:07:29
AUTHOR:                Fluke Corporation
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       7
NUMBER OF LINES:       261
=============================================================================
#
#  Procedure Author(s):
#        DAC
#
#  Model(s) Covered:
#        1651B, 1652B, & 1653B
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  The copyright for this procedure is owned by Fluke Calibration.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         GET_ID                       PSUBI("Get ID")
  1.002  JMPL         QUERY_DATA                   PSUBI("Query Data")
  1.003  JMPL         QUERY_MEASUREMENT            PSUBI("Query Measurement")
  1.004  JMPL         PRESS_RELEASE_KEY            PSUBI("Press/Release Key")
  1.005  JMPL         PRESS_TEST_WAIT_FOR_BEEP     PSUBI("Press TEST, Wait")
  1.006  JMPL         PRESS_ZERO_WAIT_FOR_BEEP     PSUBI("Press ZERO, Wait")
  1.007  DISP         Subprocedure not found!
  1.008  END

  1.009  EVAL   Increment test number

# =====  Sub Fluke 165xB Get ID RS-232  =====================================

# Read and parse identification string.
#
# Response: <manufacturer model,<firmware revision>,<serial number>
#
# Example:  FLUKE 1653B,V2.13/2.17,9766078

  2.001  LABEL        GET_ID
  2.002  MATH         @Command = @FactoryTest
  2.003  CALL         Sub Fluke 165xB Send Command RS-232

# If no error, send identification query.
  2.004  IF           NOT(@Error)
  2.005  MATH         @Command = @Identification
  2.006  CALL         Sub Fluke 165xB Send Command RS-232

# ID response is:
#
#   "FLUKE <model number>,V<UI version>/<analog version>,<serial number><CR>"
#
# where <UI version> and <analog version> are D.DD
  2.007  IF           NOT(@Error)
  2.008  PORT         [I$]
  2.009  MATH         UUT            = FLD(MEM2, 1, ",")
  2.010  MATH         @Manufacturer  = FLD(UUT,  1, " ")
  2.011  MATH         @ModelNum      = FLD(UUT,  2, " ")
  2.012  MATH         @FirmwareRev   = FLD(MEM2, 2, ",")
  2.013  MATH         @SerialNum     = FLD(MEM2, 3, ",")
  2.014  MATH         @UI_Version    = FLD(@FirmwareRev, 1, "/")
  2.015  MATH         @AnalogVersion = FLD(@FirmwareRev, 2, "/")
  2.016  RSLT         =
  2.017  RSLT         = Serial Number:     [V @SerialNum]
  2.018  RSLT         = Firmware Revision: [V @FirmwareRev]
  2.019  ENDIF

  2.020  ENDIF

  2.021  END

  2.022  EVAL   Increment test number

# =====  Sub Fluke 165xB Query Data RS-232  =================================

  3.001  LABEL        QUERY_DATA
  3.002  MATH         @Command = @QueryData & " 0"
  3.003  CALL         Sub Fluke 165xB Send Command RS-232

# If no error, read data.
  3.004  IF           NOT(@Error)
  3.005  PORT         [I$]

  3.006  IF           ISVAR("@Debug")
  3.007  MATH         Set       = FLD(MEM2, 1, ",")
  3.008  MATH         Subset    = FLD(MEM2, 2, ",")
  3.009  MATH         Test      = FLD(MEM2, 3, ",")
  3.010  MATH         PriNum    = FLD(MEM2, 4, ",")
  3.011  MATH         PriDec    = FLD(MEM2, 5, ",")
  3.012  MATH         SecNum    = FLD(MEM2, 6, ",")
  3.013  MATH         SecDec    = FLD(MEM2, 7, ",")
  3.014  MATH         TestSetup = FLD(MEM2, 8, ",")
  3.015  MATH         Var       = FLD(MEM2, 9, ",")
  3.016  MATH         Time      = FLD(MEM2, 10, ",")
  3.017  DISP         Sub Fluke 165xB Query Data RS-232
  3.017  DISP
  3.017  DISP         Set       = [V Set]
  3.017  DISP         Subset    = [V Subset]
  3.017  DISP         Test      = [V Test]
  3.017  DISP         PriNum    = [V PriNum]
  3.017  DISP         PriDec    = [V PriDec]
  3.017  DISP         SecNum    = [V SecNum]
  3.017  DISP         SecDec    = [V SecDec]
  3.017  DISP         TestSetup = [V TestSetup]
  3.017  DISP         Var       = [V Var]
  3.017  DISP         Time      = [V Time]
  3.018  ENDIF

  3.019  ENDIF

  3.020  END

  3.021  EVAL   Increment test number

# =====  Sub Fluke 165xB Query Measurement RS-232  ==========================

  4.001  LABEL        QUERY_MEASUREMENT
  4.002  MATH         @Command = @QueryMeasurement
  4.003  CALL         Sub Fluke 165xB Send Command RS-232

# If no error, read measurement.
  4.004  IF           NOT(@Error)
  4.005  PORT         [I$]

  4.006  IF           ISVAR("@Debug")
  4.007  DISP         Sub Fluke 165xB Query Measurement RS-232
  4.007  DISP
  4.007  DISP         MEM2 = "[MEM2]"
  4.008  ENDIF

# Second comma delimited field is primary reading.
  4.009  MATH         Meas = FLD(MEM2, 2, ",")

  4.010  IF           NOT(IS_NUM_LEAD(Meas))
  4.011  MATH         MEM = +9.99E+12
  4.012  ELSE
  4.013  MATH         MEM = Meas
  4.014  ENDIF

  4.015  ENDIF

  4.016  END

  4.017  EVAL   Increment test number

# =====  Sub Fluke 165xB Press/Release Key RS-232  ==========================

  5.001  LABEL        PRESS_RELEASE_KEY
  5.002  MATH         @Command = @PressKey & @KeyCode
  5.003  CALL         Sub Fluke 165xB Send Command RS-232

# If no error, wait 1 s and release key.
  5.004  IF           NOT(@Error)
  5.005  WAIT         [D1000]
  5.006  MATH         @Command = @ReleaseKey & @KeyCode
  5.007  CALL         Sub Fluke 165xB Send Command RS-232
  5.008  ENDIF

  5.009  WAIT         [D100]
  5.010  END

  5.011  EVAL   Increment test number

# =====  Sub Fluke 165xB Press TEST, Wait for Beep RS-232  ==================

  6.001  LABEL        PRESS_TEST_WAIT_FOR_BEEP
  6.002  MATH         @Repeat = 0

  6.003  DO
  6.004  MATH         TestPressed = 0
  6.005  CALL         Sub Fluke 165xB Query Beeper RS-232

# If no error, press TEST.
  6.006  IF           NOT(@Error)
  6.007  MATH         @Command = @PressKey & @KeyTest
  6.008  CALL         Sub Fluke 165xB Send Command RS-232
  6.009  MATH         TestPressed = NOT(@Error)
  6.010  ENDIF

# If no error, wait for 1st beep.
  6.011  IF           NOT(@Error)
  6.012  CALL         Sub Fluke 165xB Wait for Beep RS-232
  6.013  ENDIF

# If no error, wait for 2nd beep.
  6.014  IF           NOT(@Error)
  6.015  CALL         Sub Fluke 165xB Wait for Beep RS-232
  6.016  ENDIF

# If TEST was successfully pressed, wait 100 ms and release it, regardless
# of whether an error occurred.
  6.017  IF           TestPressed
  6.018  WAIT         [D100]
  6.019  MATH         L[1] = @Error; L[2] = @Repeat
  6.020  MATH         @Command = @ReleaseKey & @KeyTest
  6.021  CALL         Sub Fluke 165xB Send Command RS-232

  6.022  IF           NOT(@Error)
  6.023  MATH         TestPressed = 0
  6.024  MATH         @Error = L[1]; @Repeat = L[2]
  6.025  ENDIF

  6.026  ENDIF        ; IF TestPressed

  6.027  UNTIL        NOT(@Error) || (@Error && NOT(@Repeat))

  6.028  END

  6.029  EVAL   Increment test number

# =====  Sub Fluke 165xB Press ZERO, Wait for Beep RS-232  ==================

  7.001  LABEL        PRESS_ZERO_WAIT_FOR_BEEP
  7.002  MATH         @Repeat = 0

  7.003  DO
  7.004  MATH         ZeroPressed = 0
  7.005  CALL         Sub Fluke 165xB Query Beeper RS-232

# If no error, press ZERO.
  7.006  IF           NOT(@Error)
  7.007  MATH         @Command = @PressKey & @KeyZero
  7.008  CALL         Sub Fluke 165xB Send Command RS-232
  7.009  MATH         ZeroPressed = NOT(@Error)
  7.010  ENDIF

# If no error, wait for 1st beep.
  7.011  IF           NOT(@Error)
  7.012  CALL         Sub Fluke 165xB Wait for Beep RS-232
  7.013  ENDIF

# Make sure zero completes.
  7.014  WAIT         [D500]

# If ZERO was successfully pressed, wait 100 ms and release it, regardless
# of whether an error occurred.
  7.015  IF           ZeroPressed
  7.016  WAIT         [D100]
  7.017  MATH         L[1] = @Error; L[2] = @Repeat
  7.018  MATH         @Command = @ReleaseKey & @KeyZero
  7.019  CALL         Sub Fluke 165xB Send Command RS-232

  7.020  IF           NOT(@Error)
  7.021  MATH         ZeroPressed = 0
  7.022  MATH         @Error = L[1]; @Repeat = L[2]
  7.023  ENDIF

  7.024  ENDIF        ; IF ZeroPressed

  7.025  UNTIL        NOT(@Error) || (@Error && NOT(@Repeat))

  7.026  END
