﻿Copyright (c) (2014) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Fluke 165xB Check Lead RS-232
INSTRUMENT:            Sub Fluke 165xB Wait for Beep RS-232
INSTRUMENT:            Sub Fluke 165xB Query Beeper RS-232
INSTRUMENT:            Sub Fluke 165xB Send Command RS-232
DATE:                  2014-03-24 13:09:32
AUTHOR:                Fluke Corporation
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       5
NUMBER OF LINES:       130
=============================================================================
#
#  Procedure Author(s):
#        DAC
#
#  Model(s) Covered:
#        1651B, 1652B, & 1653B
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  The copyright for this procedure is owned by Fluke Calibration.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         CHECK_LEAD                   PSUBI("Check Lead")
  1.002  JMPL         WAIT_FOR_BEEP                PSUBI("Wait for Beep")
  1.003  JMPL         QUERY_BEEPER                 PSUBI("Query Beeper")
  1.004  JMPL         SEND_COMMAND                 PSUBI("Send Command")
  1.005  DISP         Subprocedure not found!
  1.006  END

  1.007  EVAL   Increment test number

# =====  Sub Fluke 165xB Check Lead RS-232  =================================

  2.001  LABEL        CHECK_LEAD
  2.002  MATH         @Command = @QueryMeasurement
  2.003  CALL         Sub Fluke 165xB Send Command RS-232

  2.004  IF           NOT(@Error)
# Read measurement.
  2.005  PORT         [I$]
# Second comma delimited field contains "LEAd" indicator, if present.
  2.006  MATH         @Lead = SUB(MEM2, 4, 4)
  2.007  ENDIF

  2.008  END

  2.009  EVAL   Increment test number

# =====  Sub Fluke 165xB Wait for Beep RS-232  ==============================

  3.001  LABEL        WAIT_FOR_BEEP
  3.002  MATH         ElapsedTime = 0; @Beep = 0

  3.003  DO
  3.004  CALL         Sub Fluke 165xB Query Beeper RS-232

  3.005  IF           FINDI(@ModelNum, "B", 0)
  3.006  WAIT         [D50]
  3.007  MATH         ElapsedTime = ElapsedTime + 50
  3.008  ELSE
  3.009  WAIT         [D200]
  3.010  MATH         ElapsedTime = ElapsedTime + 200
  3.011  ENDIF

  3.012  MATH         Timeout = (ElapsedTime > @WaitForBeepTimeout)
  3.013  UNTIL        @Beep || @Error || Timeout

  3.014  IF           Timeout && NOT(@Beep) && NOT(@Error)
# Backup MEM1, because OPBR overwrites it.
  3.015  MATH         L[1] = MEM1
  3.016  OPBR         -z Timeout waiting for beep.
  3.016  OPBR
  3.016  OPBR         Do you wish to try again?
  3.017  MATH         @Error = 1; @Repeat = MEM1
# Restore MEM1.
  3.018  MATH         MEM1 = L[1]
  3.019  ELSE
  3.020  MATH         @Error = 0; @Repeat = 0
  3.021  ENDIF

  3.022  END

  3.023  EVAL   Increment test number

# =====  Sub Fluke 165xB Query Beeper RS-232  ===============================

  4.001  LABEL        QUERY_BEEPER
  4.002  MATH         @Command = @QueryBeeper
  4.003  CALL         Sub Fluke 165xB Send Command RS-232

  4.004  IF           NOT(@Error)
  4.005  PORT         [I]
  4.006  MATH         @Beep = MEM
  4.007  ENDIF

  4.008  END

  4.009  EVAL   Increment test number

# =====  Sub Fluke 165xB Send Command RS-232  ===============================

  5.001  LABEL        SEND_COMMAND

  5.002  DO
  5.003  PORT         [T10000][V @Command][I]
  5.004  MATH         @Error = (MEM > 0)

  5.005  IF           @Error
# Backup MEM1, because OPBR overwrites it.
  5.006  MATH         L[1] = MEM1
  5.007  OPBR         -z "[V @Command]" sent to UUT.
  5.007  OPBR
  5.007  OPBR         RS-232 acknowledge response indicated an error.
  5.007  OPBR
  5.007  OPBR         Do you wish to send the command again?
  5.008  MATH         Abort = NOT(MEM1)
# Restore MEM1.
  5.009  MATH         MEM1 = L[1]
  5.010  ELSE
  5.011  MATH         Abort = 0
  5.012  ENDIF

  5.013  UNTIL        NOT(@Error) || Abort

  5.014  END
