﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Scope Connection /O_CAL
INSTRUMENT:            Sub Scope Connection (50 Ω feedthrough) /O_CAL
DATE:                  2015-06-11 08:25:51
AUTHOR:                Fluke
REVISION:              $Revision: 12100 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       3
NUMBER OF LINES:       137
=============================================================================
#
#  Procedure Author:
#        DAC
#
#  Models Covered:
#        All 2 and 4 channel oscilloscopes with input connections labelled
#        "CH 1", "CH 2", "CH 3", and "CH 4".
#
#  Compatibility:
#        MET/CAL version 8.1.4 or later
#
#  Global Variables:
#        @CalDev  = <System Instrument Name>
#          Example: "Fluke 5820A"
#
#        @CalMultiChan = <boolean>
#          1   58xxA w/5 Channel Option
#          0   58xxA w/o 5 Channel Option, 5080A, 55xxA
#
#        @NumChan = <number of UUT input channels>
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         50_Ω_FEEDTHROUGH             PSUBI("50 Ω feedthrough")

  1.002  IF           0
  1.003  EVAL   Increment test number
  2.001  ENDIF

# =====  Sub Scope Connection /O_CAL  =======================================

  2.002  LABEL        STRAIGHT_THROUGH
  2.003  IF           @CalMultiChan

  2.004  IF           @Chan == 1

  2.005  IF           @NumChan == 2
  2.006  DISP         Connect [V @CalDev] to the UUT as follows:
  2.006  DISP
  2.006  DISP         [32] OUTPUT    UUT
  2.006  DISP         [32] CHAN 1 to CH 1
  2.006  DISP         [32] CHAN 2 to CH 2
  2.007  ELSE
  2.008  DISP         Connect [V @CalDev] to the UUT as follows:
  2.008  DISP
  2.008  DISP         [32] OUTPUT    UUT
  2.008  DISP         [32] CHAN 1 to CH 1
  2.008  DISP         [32] CHAN 2 to CH 2
  2.008  DISP         [32] CHAN 3 to CH 3
  2.008  DISP         [32] CHAN 4 to CH 4
  2.009  ENDIF

  2.010  ENDIF        ; @Chan == 1

  2.011  ELSE         ; 58xxA w/o 5 Channel Option, 5080A, and 55xxA

  2.012  IF           FINDI(@CalDev, "5800A", 0) || FINDI(@CalDev, "5820A", 0)
  2.013  MATH         CalPort = "CHAN 1"
  2.014  ELSEIF       FINDI(@CalDev, "5500A", 0)
  2.015  MATH         CalPort = "SCOPE"
  2.016  ELSE
  2.017  MATH         CalPort = "SCOPE OUT"
  2.018  ENDIF

  2.019  DISP         Connect [V @CalDev] [V CalPort] to UUT CH [V @Chan].
  2.019  DISP
  2.020  ENDIF        ; @CalMultiChan

  2.021  END

  2.022  EVAL   Increment test number

# =====  Sub Scope Connection (50 Ω feedthrough) /O_CAL  ====================

  3.001  LABEL        50_Ω_FEEDTHROUGH

  3.002  IF           @CalMultiChan

  3.003  IF           @Chan == 1

  3.004  IF           @NumChan == 2
  3.005  DISP         Connect [V @CalDev] to the UUT as follows:
  3.005  DISP
  3.005  DISP         [32] OUTPUT to UUT
  3.005  DISP         [32] CHAN 1 to CH 1 using a 50 Ω feedthrough.
  3.005  DISP         [32] CHAN 2 to CH 2 using a 50 Ω feedthrough.
  3.006  ELSE
  3.007  DISP         Connect [V @CalDev] to the UUT as follows:
  3.007  DISP
  3.007  DISP         [32] OUTPUT    UUT
  3.007  DISP         [32] CHAN 1 to CH 1 using a 50 Ω feedthrough.
  3.007  DISP         [32] CHAN 2 to CH 2 using a 50 Ω feedthrough.
  3.007  DISP         [32] CHAN 3 to CH 3 using a 50 Ω feedthrough.
  3.007  DISP         [32] CHAN 4 to CH 4 using a 50 Ω feedthrough.
  3.008  ENDIF

  3.009  ENDIF        ; @Chan == 1

  3.010  ELSE         ; 58xxA w/o 5 Channel Option, 5080A, and 55xxA

  3.011  IF           FINDI(@CalDev, "5800A", 0) || FINDI(@CalDev, "5820A", 0)
  3.012  MATH         CalPort = "CHAN 1"
  3.013  ELSEIF       FINDI(@CalDev, "5500A", 0)
  3.014  MATH         CalPort = "SCOPE"
  3.015  ELSE
  3.016  MATH         CalPort = "SCOPE OUT"
  3.017  ENDIF

  3.018  DISP         Connect [V @CalDev] [V CalPort] to UUT CH [V @Chan]
  3.018  DISP         using a 50 Ω feedthrough.
  3.019  ENDIF        ; @CalMultiChan

  3.020  END
