﻿Copyright (c) (2013) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Tek MDO/MSO/DPO Clear Menu VISA
DATE:                  2013-07-23 12:31:14
AUTHOR:                Fluke
REVISION:              $Revision: 3802 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       62
=============================================================================
#
#  Procedure Author:
#        DAC
#
#  Models Covered:
#        MDO/MSO/DPO
#
#  Compatibility:
#        MET/CAL 7.3.38 or later
#
#  Additional Equipment Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  MATH         LeadingDigit = SUB(@ModelNum, 4, 1)

  1.002  MATH         L[1] = ZCMP(LeadingDigit, "2")
  1.003  MATH         L[1] = ZCMP(LeadingDigit, "3") || L[1]
  1.004  MATH         L[1] = ZCMP(LeadingDigit, "4") || L[1]

# MSO/DPO2000, MSO/DPO2000B, MSO/DPO3000, MSO/DPO4000B, MDO4000
  1.005  IF           L[1]
  1.006  VISA         CLEARM

# MSO/DPO5000, DPO7000, MSO/DPO/DSA70000
  1.007  ELSEIF       ZCMP(LeadingDigit, "5") || ZCMP(LeadingDigit, "7")
  1.008  VISA         FPANEL:PRESS MENUOFF
  1.009  ELSE
  1.010  DISP         Sub Tek MDO/MSO/DPO Clear Menu VISA
  1.010  DISP
  1.010  DISP         Unrecognized model number "[V @ModelNum]".
  1.011  MATH         @Abort = 1
  1.012  END
  1.013  ENDIF

  1.014  CALL         Sub Tek MDO/MSO/DPO Wait for OPC VISA

  1.015  END
