﻿Copyright (c) (2013) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Tek MDO/MSO/DPO Self-Test VISA
INSTRUMENT:            Sub Tek MDO/MSO/DPO Signal Path Comp Cal VISA
INSTRUMENT:            Sub Tek MDO/MSO/DPO Select Channel VISA
DATE:                  2013-07-24 09:38:35
AUTHOR:                Fluke
REVISION:              $Revision: 3802 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       6
NUMBER OF LINES:       190
=============================================================================
#
#  Procedure Author:
#        DAC, CAD
#
#  Models Covered:
#        MDO/MSO/DPO
#
#  Compatibility:
#        MET/CAL 7.3.38 or later
#
#  Additional Equipment Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         SELF_TEST                    PSUBI("Self-Test")
  1.002  JMPL         SIGNAL_PATH_COMPENSATION     PSUBI("Signal Path Comp")
  1.003  JMPL         SELECT_CHANNEL               PSUBI("Select Channel")
  1.004  DISP         Subprocedure not found!
  1.005  END

  1.006  EVAL   Increment test number

# =====  Sub Tek MDO/MSO/DPO Self-Test VISA  =================================

  2.001  LABEL        SELF_TEST
  2.002  RSLT         =
  2.003  HEAD         SELF TEST
  2.004  TARGET
  2.005  MATH         @Abort = 0
  2.006  DISP         Remove all input signals from the UUT.
# Select all available diagnostics (by model) and start self-test.
  2.007  MATH         LeadingDigit = SUB(@ModelNum, 4, 1)

  2.008  MATH         L[1] = ZCMP(LeadingDigit, "2")
  2.009  MATH         L[1] = ZCMP(LeadingDigit, "3") || L[1]
  2.010  MATH         L[1] = ZCMP(LeadingDigit, "4") || L[1]

# MSO/DPO2000, MSO/DPO2000B, MSO/DPO3000, MSO/DPO4000B, MDO4000
  2.011  IF           L[1]
  2.012  VISA         [T5000]DIA:SEL ALL;LOOP:OPT ONCE;:DIA:STATE EXECUTE

# MSO/DPO5000, DPO7000, MSO/DPO/DSA70000
  2.013  ELSEIF       ZCMP(LeadingDigit, "5") || ZCMP(LeadingDigit, "7")
  2.014  VISA         [T5000]DIA:SEL:ALL ALL;:DIA:STATE EXECUTE

  2.015  ELSE
  2.016  DISP         Sub Tek MDO/MSO/DPO Self-Test VISA
  2.016  DISP
  2.016  DISP         Unrecognized model number "[V @ModelNum]".
  2.016  DISP
  2.016  DISP         Select "Advance" to abort this procedure.
  2.017  MATH         @Abort = 1
  2.018  END
  2.019  ENDIF

  2.020  WAIT         [D2000]
  2.021  DISP         The UUT self-test routine has started.
  2.021  DISP
  2.021  DISP         Select "Advance" when the UUT self-test routine has
  2.021  DISP         finished.

  2.022  IF           L[1]
  2.023  VISA         [T5000]DIA:RESU:FLAG?[I$]
  2.024  ELSEIF       ZCMP(LeadingDigit, "5") || ZCMP(LeadingDigit, "7")
  2.025  VISA         [T5000]DIA:RES?[I$]
  2.026  ELSE
  2.027  END
  2.028  ENDIF

  2.029  EVAL   -e FINDI(MEM2, "Pass", 1) : SELF TEST

  3.001  IF           FAIL()
  3.002  DISP         The UUT SELF-TEST failed!
  3.002  DISP
  3.002  DISP         The UUT may need to be serviced.
  3.002  DISP
  3.002  DISP         Select "Advance" to terminate this procedure.
  3.003  MATH         @Abort = 1
  3.004  ENDIF

  3.005  HEAD
  3.006  CALL         Sub Tek MDO/MSO/DPO Clear Menu VISA
  3.007  END

  3.008  EVAL   Increment test number

# =====  Sub Tek MDO/MSO/DPO Signal Path Comp Cal VISA  ======================

  4.001  LABEL        SIGNAL_PATH_COMPENSATION
  4.002  MATH         @Abort = 0
  4.003  OPBR         -z You must perform Signal Path Compensation (SPC)
  4.003  OPBR         before proceeding.
  4.003  OPBR
  4.003  OPBR         Has SPC been performed? [NO]

  4.004  IF           NOT(MEM1)
  4.005  RSLT         =
  4.006  HEAD         SIGNAL PATH COMPENSATION
  4.007  TARGET
  4.008  DISP         Ensure that all input signals have been removed from
  4.008  DISP         the UUT.
  4.009  VISA         [T5000]CAL:INTERN:STAR

  4.010  WAIT         [D2000]
  4.011  DISP         The UUT Signal Path Compensation (SPC) routine has
  4.011  DISP         started.
  4.011  DISP
  4.011  DISP         Select "Advance" when the UUT SPC routine has
  4.011  DISP         finished.

  4.012  VISA         [T5000]CAL:RES:SPC?[I$]
  4.013  EVAL   -e FINDI(MEM2, "PASS", 1) : SIGNAL PATH COMPENSATION

  5.001  IF           FAIL()
  5.002  DISP         UUT SIGNAL PATH COMPENSATION FAILED!
  5.002  DISP
  5.002  DISP         The UUT may need to be serviced.
  5.002  DISP
  5.002  DISP         Select "Advance" to terminate this procedure.
  5.003  MATH         @Abort = 1
  5.004  ENDIF

  5.005  HEAD
  5.006  CALL         Sub Tek MDO/MSO/DPO Clear Menu VISA
  5.007  ENDIF

  5.008  END

  5.009  EVAL   Increment test number

# =====  Sub Tek MDO/MSO/DPO Select Channel VISA  ============================

  6.001  LABEL        SELECT_CHANNEL
  6.002  VISA         *RST;*OPC?[I!]
  6.003  VISA         HEADER OFF

# Select ON/OFF based on whether UUT is 2 or 4 channel.
  6.004  IF           @NumChan < 4

  6.005  IF           @Chan == 1
  6.006  VISA         SELECT:CH1 ON;CH2 OFF
  6.007  ELSE
  6.008  VISA         SELECT:CH1 OFF;CH2 ON
  6.009  ENDIF

  6.010  ELSE

  6.011  IF           @Chan == 1
  6.012  VISA         SELECT:CH1 ON;CH2 OFF;CH3 OFF;CH4 OFF
  6.013  ELSEIF       @Chan == 2
  6.014  VISA         SELECT:CH1 OFF;CH2 ON;CH3 OFF;CH4 OFF
  6.015  ELSEIF       @Chan == 3
  6.016  VISA         SELECT:CH1 OFF;CH2 OFF;CH3 ON;CH4 OFF
  6.017  ELSE
  6.018  VISA         SELECT:CH1 OFF;CH2 OFF;CH3 OFF;CH4 ON
  6.019  ENDIF

  6.020  ENDIF

  6.021  CALL         Sub Tek MDO/MSO/DPO Wait for OPC VISA
  6.022  WAIT         [D1000]

  6.023  LABEL        END
  6.024  END
